/*
 * DRET-IPv6	An implementation of the TCP/IP protocol suite for the LINUX
 *		operating system.  INET6 is implemented using the BSD Socket
 *		interface as the means of communication with the user level.
 *
 * Contacts:	
 *              INRIA      <Christophe.Diot@sophia.inria.fr>
 *              MASI       <Eric.Horlait@masi.ibp.fr>
 *              This software has been developped with the financial support
 *              of DRET (French Military Research Agency).
 *
 * Version:    $Id: ipv6.h,v 1.5 1997/03/06 10:34:47 pan Exp $ 
 *	
 * Authors:	
 *	        name	<E_mail>
 *
 *
 * Fixes:
 *
 *
 * Description:
 *
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *              This notice must be copied with the distributed package.
 *
 *		Portions of the software are derived from  various 
 *		networking code publicly available, mainly:
 *			NRL IPv6 code 
 *			NetBSD code from INRIA (Francis.Dupont@inria.fr)
 *			Pedro Roque's Linux version (Roque@di.fc.up.pt)
 *
 */				
#ifndef _NET_IPV6_H
#define _NET_IPV6_H

#include <linux/config.h>

#ifdef CONFIG_NET_IPV6_DIM

#include <linux/types.h>
#include <linux/socket.h>
#include <linux/netdevice.h>
#include <linux/ip.h>		/* struct options */

#include <net/route.h>
#include <net/sock.h>	

#include <linux/dret/ipv6.h>
#include <linux/dret/flow6.h>


#ifndef _SNMP_H
#include <net/snmp.h>
#endif

/*
 * Functions provided in ip_input.c
 */
extern int    ipv6_rcv(struct sk_buff *skb, 
		       struct device *dev, 
		       struct packet_type *pt);

extern void   ipv6_raw_deliver(struct sk_buff *skb, 
			       __u8 next_hdr, 
			       struct sock ** raw_sk);

extern int    ipv6_proto_deliver(struct sk_buff *skb, 
				 __u8 next_hdr, 
				 struct sock *raw_sk);
/*
 * Functions provided in ip_output.c
 */
extern void   ipv6_init(void);

extern int    ipv6_flow_xmit(struct sock *sk, /* ipv6_output.c */
                              void getfrag (const void *,
                                           struct in6_addr *, 
                                           char *, 
                                           unsigned int, 
                                           unsigned int),
                              const void *frag,
			      unsigned short int length,
			      struct flowlist *fl,
			      int flags,
			      int protocol,
			      int noblock);

extern int    ipv6_build_xmit(struct sock *sk, /* ipv6_output.c */
                              void getfrag (const void *,
                                           struct in6_addr *, 
                                           char *, 
                                           unsigned int, 
                                           unsigned int),
                              const void *frag,
			      unsigned short int length,
			      struct in6_addr *d,       
			      struct in6_addr *us,
			      struct options * opt,
			      int flags,
			      int protocol,
			      int noblock);

extern void   ipv6_queue_xmit(struct sock *sk, 
			      struct sk_buff *skb, 
			      int free);

extern int    ipv6_xmit(struct sock *sk, 
                        struct sk_buff *skb, 
                        struct in6_addr *saddr,
	                struct in6_addr *daddr, 
	                struct options *opt, 
	                int proto);
	      
	      
extern int __inline__ ipv6_build_mac_header(struct sk_buff *skb,
                                            struct neighbor *n, 
                                            int len);

extern int build_header_from_neigh(struct sk_buff *skb, 
				   struct device *dev,
				   struct neighbor *neigh,
				   struct in6_addr *s, 
				   struct in6_addr *d,
				   int proto, 
				   int len, 
				   int priority);

extern struct ip_mib	ip6_statistics;    /* statistics related to IPv6 */

/*
 *	Functions provided by ip_forward.c
 */
extern int ipv6_fwd(struct sk_buff *skb, 
		    struct device *dev, 
		    int is_frag, 
		    struct in6_addr *a,
		    __u8 flags);
/*
 *	Functions provided by ip6_options.c
 */
/*
 *	Functions provided by sockopt6.c
 */
extern int ipv6_setsockopt(struct sock *sk, 
			   int level, 
			   int optname, 
			   char *optval, 
			   int optlen);

extern int ipv6_getsockopt(struct sock *sk, 
			   int level, 
			   int optname, 
			   char *optval, 
			   int *optlen);

#endif /* CONFIG_NET_IPV6_DIM */
#endif	/* _NET_IPV6_H */









