/*
 * DRET-IPv6	An implementation of the TCP/IP protocol suite for the LINUX
 *		operating system.  INET6 is implemented using the BSD Socket
 *		interface as the means of communication with the user level.
 *
 * Contacts:	
 *              INRIA      <Christophe.Diot@sophia.inria.fr>
 *              MASI       <Eric.Horlait@masi.ibp.fr>
 *              This software has been developped with the financial support
 *              of DRET (French Military Research Agency).
 *
 * Version:    $Id: icmpv6.h,v 1.3 1997/03/04 11:42:09 eh Exp $ 
 *	
 * Authors:	
 *	        name	<E_mail>
 *
 *
 * Fixes:
 *
 *
 * Description:
 *
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *              This notice must be copied with the distributed package.
 *
 *		Portions of the software are derived from  various 
 *		networking code publicly available, mainly:
 *			NRL IPv6 code 
 *			NetBSD code from INRIA (Francis.Dupont@inria.fr)
 *			Pedro Roque's Linux version (Roque@di.fc.up.pt)
 *
 */				
#ifndef _ICMP6_H
#define	_ICMP6_H

#include <linux/config.h>

#ifdef CONFIG_NET_IPV6_DIM
#include <linux/skbuff.h>
#include <linux/dret/icmpv6.h>

#include <net/sock.h>
#include <net/dret/protocol6.h>


/*
extern struct icmp_err icmp_err_convert[];  
extern struct icmp_mib icmp_statistics;
TOHANDLE */
extern void	icmpv6_send(struct sk_buff *skb_in,  
                            int            type, 
                            int            code,
			    unsigned long  info, 
                            struct device  *dev);

extern void     icmpv6_send_error(struct sk_buff *skb, 
			      __u8           type, 
			      __u8           code,
			      __u32          info,
		              struct device  *dev);

extern int	icmpv6_rcv(struct sk_buff      *skb, 
                           struct device       *dev,			    
                           struct in6_addr     *saddr,
			   struct in6_addr     *daddr,
			   struct options      *opt,
			   unsigned short       len, 
			   int                 redo, 
                           struct inet6_protocol *protocol);

extern int	icmpv6_ioctl(struct sock   *sk, 
                             int           cmd,
			     unsigned long arg);

extern void	icmpv6_init(struct net_proto_family *);

extern int      icmpv6_err_convert(int type, int code, int *err);

#endif

#endif	/* _ICMPV6_H */







