/*
 * DRET-IPv6	An implementation of the TCP/IP protocol suite for the LINUX
 *		operating system.  INET6 is implemented using the BSD Socket
 *		interface as the means of communication with the user level.
 *
 * Contacts:	
 *              INRIA      <Christophe.Diot@sophia.inria.fr>
 *              MASI       <Eric.Horlait@masi.ibp.fr>
 *              This software has been developped with the financial support
 *              of DRET (French Military Research Agency).
 *
 * Version:    $Id: af_inet6.h,v 1.4 1997/03/25 19:59:51 pan Exp $ 
 *	
 * Authors:	
 *	        Anelli	<E_mail>
 *
 *
 * Fixes:
 *
 *
 * Description:
 *
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *              This notice must be copied with the distributed package.
 *
 *		Portions of the software are derived from  various 
 *		networking code publicly available, mainly:
 *			NRL IPv6 code 
 *			NetBSD code from INRIA (Francis.Dupont@inria.fr)
 *			Pedro Roque's Linux version (Roque@di.fc.up.pt)
 *
 */		
#ifndef _AF_INET6_H
#define _AF_INET6_H


#ifdef __KERNEL__

extern struct sock *get_sock6(struct proto *prot, 
		       unsigned short num,  struct in6_addr *raddr,
		       unsigned short rnum, struct in6_addr *laddr);
		       
extern void put_sock6(unsigned short num, 
                      struct sock *sk);

#endif
		       
#endif	/* _AF_INET6_H */
	
