/*
 * DRET-IPv6	An implementation of the TCP/IP protocol suite for the LINUX
 *		operating system.  INET6 is implemented using the BSD Socket
 *		interface as the means of communication with the user level.
 *
 * Contacts:	
 *              INRIA      <Christophe.Diot@sophia.inria.fr>
 *              MASI       <Eric.Horlait@masi.ibp.fr>
 *              This software has been developped with the financial support
 *              of DRET (French Military Research Agency).
 *
 * Version:    $Id: addrconf.h,v 1.1 1997/02/12 14:37:21 eh Exp $ 
 *	
 * Authors:	
 *	        name	<E_mail>
 *
 *
 * Fixes:
 *
 *
 * Description:
 *
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *              This notice must be copied with the distributed package.
 *
 *		Portions of the software are derived from  various 
 *		networking code publicly available, mainly:
 *			NRL IPv6 code 
 *			NetBSD code from INRIA (Francis.Dupont@inria.fr)
 *			Pedro Roque's Linux version (Roque@di.fc.up.pt)
 *
 */				
/* P.Roque */
#ifndef _ADDRCONF_H
#define _ADDRCONF_H

#include <linux/config.h>

#ifdef CONFIG_NET_IPV6_DIM

#include <linux/in.h>
#include <linux/netdevice.h> 

#define VALID_ADDR6      0x00
#define TENTATIVE_ADDR6  0x01

#define DAD_COMPLETE	0x00
#define DAD_INCOMPLETE	0x01

#ifdef __KERNEL__

extern struct inet6_ifaddr      *inet6_addr_lst[16];

extern struct ipv6_mc_list      *inet6_mcast_lst[16];

extern struct inet6_dev         *inet6_dev_lst;

extern struct destination           *lo_route;

/*
 *      address and device management prototypes
 */
extern int                    addrconf_notify(struct notifier_block *this, 
                                           unsigned long event, void * data);

extern void                   ipv6_addr_init(void);

extern struct inet6_dev    *  ipv6_add_dev(struct device *dev);

extern struct inet6_ifaddr *  ipv6_add_addr(struct inet6_dev *idev, 
                                           struct in6_addr *addr, 
					   int scope, int plen);

extern int                    ipv6_del_addr(struct inet6_dev *idev, 
					    struct in6_addr *addr);

extern int                    check_host_addr6(struct in6_addr *a);

extern struct inet6_ifaddr *  get_ifaddr6(struct in6_addr *a);

extern struct inet6_ifaddr *  ipv6_get_saddr(struct device *dev, 
                                               struct in6_addr *daddr);

/*
 *      multicast prototypes (igmpv6.c)
 */
extern int  ipv6_sock_join_group(struct sock *sk, struct device *dev, 
                                                  struct in6_addr *addr);

extern int  ipv6_sock_leave_group(struct sock *sk, struct device *dev, 
                                                  struct in6_addr *addr);

extern int  ipv6_dev_mc_inc(struct device *dev,struct in6_addr *addr);

extern int  ipv6_dev_mc_dec(struct device *dev,struct in6_addr *addr);

extern int  ipv6_chk_mcast_addr(struct device *dev, struct in6_addr *addr);

extern int  ipv6_mc_drop_device(struct device *dev);

extern void ipv6_mc_sock_drop(struct sock *sk);

extern void ipv6_mc_init(struct device *dev);

extern int  find_addr6_mcast(struct device *dev, struct in6_addr *addr);


/*
 *      Hash function taken from net_alias.c
 */
static __inline__ __u8 ipv6_addr_hash(struct in6_addr *addr)
{       
        __u32 word;
        unsigned tmp;

        /* 
         * We perform the hash function over the last 64 bits of the address
         * This will include the IEEE address token on links that support it.
         */
        word = addr->s6_addr[2] ^ addr->s6_addr32[3];
        tmp  = word ^ (word>>16);
        tmp ^= (tmp >> 8);
        return ((tmp ^ (tmp >> 4)) & 0x0f);
}

#define IFA_HOST        1
#define IFA_LINK        2
#define IFA_SITE        3
#define IFA_GLOBAL      4


/*--START FUNCTION--(ipv6_addr_scope)----------------------------------------
|
|
|
-----------------------------------------------------------------------------*/
extern __inline__ __u8 ipv6_addr_scope(struct in6_addr *addr)
{
if IS_LINKLADDR6(*addr)
    return IFA_LINK;
if IS_SITELADDR6(*addr)
    return IFA_SITE;
if IS_LOOPADDR6(*addr) 
    return IFA_HOST;
else
    return IFA_GLOBAL;      
}
/*--END FUNCTION--(ipv6_addr_scope)------------------------------------------*/


#endif /*__KERNEL__*/
#endif /* CONFIG_NET_IPV6_DIM */
#endif /*_ADDRCONF_H*/














