/*
 * $Header: rm_class.h,v 1.2 95/08/09 18:58:26 van Exp $ (LBL)
 *
 * Copyright (c) 1995 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 * 	This product includes software developed by the Network Research
 * 	Group at Lawrence Berkeley National Laboratory.
 * 4. Neither the name of the University nor of the Laboratory may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#define RM_MAXPRIO 7		/* priorities run 0..7 */
#define RM_FILTER_GAIN 5	/* log2 of gain, e.g., 5 => 31/32 */

/* added by Martin */
#define new_kmem_zalloc(size,flag) kmalloc(size,GFP_KERNEL)
#define kmem_free(x,size) kfree(x)

#define KMEM_SLEEP 0x0001       /* instead M_NOWAIT */
/* end add*/

struct rm_class {
	struct sk_buff *tail;		/* tail of circularly linked output q */
	struct timeval	last;		/* time last packet sent */
	struct timeval	undertime;	/* time can next send */
	int	sleeping;		/* != 0 if delaying */
	int	qcnt;			/* # packets in queue */
	int	avgidle;

	int	npackets;		/* packets sent in this class */
	int	nbytes;			/* bytes sent in this class */
	int	over;			/* # times went over limit */
	int	borrows;		/* # times tried to borrow */
	int	drops;			/* # times dropped packets */
	int	overactions;		/* # times invoked overlimit action */

	struct rm_class *peer;
	struct rm_class *borrow;
	struct rm_class *parent;
	struct rm_ifdat *ifdat;
	int	priority;
	int	maxidle;
	int	offtime;
	int	qmax;
	void	(*overlimit)();
	int	len2time[1536];		/*XXX - should be based on if mtu */
};

struct rm_ifdat {
	int	queued;		/* # packets queued downstream */
	int	csum;
	struct rm_class *class;	/* class we're currently sending */
	int	curlen;		/* size of packet we're sending */
	struct rm_class *defaultclass;  /* added by Martin */ 
        struct rm_class *rootclass;     /* Rootclass */
	struct device *dev;
	void	(*restart)();
	int	maxqueued;	/* max packets we can queue downstream */
	struct rm_class *classlist[RM_MAXPRIO];
	int	activecnt[RM_MAXPRIO];
	struct rm_class *classes[RM_MAXPRIO];
};

extern u_char rmc_mask2pri[];

extern struct rm_class *rmc_newclass();
extern void rmc_init();
extern int rmc_under_limit();
extern struct sk_buff *rmc_dequeue_next();
extern void rmc_queue_packet();
extern void rmc_update_util();
extern void rmc_drop_action();
extern void rmc_delay_action();
extern void rmc_restart();
extern struct rm_class *rmc_find_class();
