#ifndef _LINUX_TABLE_H_
#define _LINUX_TABLE_H_
struct table_node {
   struct table_node *t_parent;
   struct table_node *t_left;
   struct table_node *t_right;
   struct in6_addr   t_key;       
   struct table_leaf *t_leaf;
   __u16             t_bit;      /* bit key */
   __u16             t_flags;
};
extern struct table_node routing_root, nd_root, flow_root;

struct table_leaf {
   struct table_node *tl_node;
   struct table_leaf *tl_next;
   __u32             tl_len;
   void              *tl_data;
};

struct gen_table {
   struct table_node *gt_root;
   struct table_leaf *gt_default;
   struct wait_queue *gt_wait;
   atomic_t          gt_count;
   atomic_t          gt_entries;
   atomic_t          gt_lock;
};

extern struct gen_table routing_table, nd_table, flow_table;
extern struct gen_table *ipv6_tables[8];

#endif
