/*
 * DRET-IPv6	An implementation of the TCP/IP protocol suite for the LINUX
 *		operating system.  INET6 is implemented using the BSD Socket
 *		interface as the means of communication with the user level.
 *
 * Contacts:	
 *              INRIA      <Christophe.Diot@sophia.inria.fr>
 *              MASI       <Eric.Horlait@masi.ibp.fr>
 *              This software has been developped with the financial support
 *              of DRET (French Military Research Agency).
 *
 * Version:    $Id: netdevice6.h,v 1.1 1997/02/12 14:33:55 eh Exp $ 
 *	
 * Authors:	
 *	        name	<E_mail>
 *
 *
 * Fixes:
 *
 *
 * Description:
 *
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *              This notice must be copied with the distributed package.
 *
 *		Portions of the software are derived from  various 
 *		networking code publicly available, mainly:
 *			NRL IPv6 code 
 *			NetBSD code from INRIA (Francis.Dupont@inria.fr)
 *			Pedro Roque's Linux version (Roque@di.fc.up.pt)
 *
 */		
#ifndef _LINUX_NETDEVICE6_H
#define _LINUX_NETDEVICE6_H

#include <linux/config.h>

#ifdef CONFIG_NET_IPV6_DIM

#include <asm/atomic.h>
#include <linux/sched.h>
#include <linux/dret/in6.h>
#include <linux/dret/flow6.h>

struct inet6_ifaddr {
  struct in6_addr     addr;
  int                 plen;
  __u32               lifetime;
  __u8                status;
  __u8                scope;
  struct inet6_dev    *idev;
  struct inet6_ifaddr *lst_next; /* next address in addr_lst  */
  struct inet6_ifaddr *if_next;     /* next address in inet6_dev */
  struct flowlist     *fl[16];
};

struct ipv6_mc_socklist{
  struct in6_addr addr;
  struct device   *dev;
  struct ipv6_mc_socklist *next;
};


struct ipv6_mc_list {
  struct in6_addr     addr;
  struct device       *dev;
  struct ipv6_mc_list *next;                    /* Global list */
  struct ipv6_mc_list *if_next;                 /* Device list */
  struct timer_list   timer;
  int                 tm_running;
  atomic_t            users;
};


struct router_conf {             /* 6.2.1 */
   struct rtf {
#if defined(__BIG_ENDIAN_BITFIELD)
     __u8   AdvSendAdvertisements:1,
            AdvManageFlag        :1,
            AdvOtherConfigFlag   :1,
            Unused               :5;
#elif defined(__LITTLE_ENDIAN_BITFIELD)
     __u8   Unused               :5,
            AdvOtherConfigFlag   :1,
            AdvManageFlag        :1,
            AdvSendAdvertisements:1;
#endif
   } flags;
   unsigned short MaxRtrAdvInterval;
   unsigned short MinRtrAdvInterval;
   unsigned long  AdvLinkMTU;
   unsigned long  AdvReachableTime;    /* Reachable Time field */
   unsigned long  AdvRetransTimer;     /* Retrans Timer field */   
   __u8           AdvCurHopLimit;               
   unsigned long  AdvDefaultLifetime;
   struct prefix  *AdvPrefixList;
   struct timer_list timer;   
   __u16 counter;                       /* Mcast advertisement sent */
};  

struct inet6_dev {
  struct device       *dev;
  struct inet6_ifaddr *addr_list;
  struct in6_addr     p2p_addr6;
  struct ipv6_mc_list *mc_list;
  __u8   router; 
  struct router_conf  *router1;        
  struct inet6_dev    *next;
};

/*--START FUNCTION--(ipv6_mc_map)----------------------------------------
 |
 | Map an ipv6 address into a link layer ethernet multicast address
 |
 ------------------------------------------------------------------------*/
extern __inline__ void ipv6_mc_map(struct in6_addr *addr, char *buf)
{
  /*
   * Ethernet address is 6-byte long.
   * 33:33:in6_addr[12]:in6_addr[13]:in6_addr[14]:in6_addr[15]
   *
   */
   buf[0]= 0x33; 
   buf[1]= 0x33;
   memcpy((buf+2), &addr->s6_addr32[3], sizeof(__u32));
}

/*struct device *dev_get_index(const unsigned int index);*/

#endif
#endif
