/*
 * DRET-IPv6	An implementation of the TCP/IP protocol suite for the LINUX
 *		operating system.  INET6 is implemented using the BSD Socket
 *		interface as the means of communication with the user level.
 *
 * Contacts:	
 *              INRIA      <Christophe.Diot@sophia.inria.fr>
 *              MASI       <Eric.Horlait@masi.ibp.fr>
 *              This software has been developped with the financial support
 *              of DRET (French Military Research Agency).
 *
 * Version:    $Id: ipv6.h,v 1.3 1997/03/04 11:42:06 eh Exp $ 
 *	
 * Authors:	
 *	        name	<E_mail>
 *
 *
 * Fixes:
 *
 *
 * Description:
 *
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *              This notice must be copied with the distributed package.
 *
 *		Portions of the software are derived from  various 
 *		networking code publicly available, mainly:
 *			NRL IPv6 code 
 *			NetBSD code from INRIA (Francis.Dupont@inria.fr)
 *			Pedro Roque's Linux version (Roque@di.fc.up.pt)
 *
 */	
#ifndef _LINUX_IPV6_H
#define _LINUX_IPV6_H

#include <linux/config.h>

#ifdef CONFIG_NET_IPV6_DIM

#include <linux/dret/in6.h>             /* definition of in6_addr structure */ 

struct ipv6hdr {
        __u32 vrprflow;           /* ipv6 version, priority and flow label */
	__u16 payload;
	__u8  next_hdr;         
	__u8  hop_limit;
	struct in6_addr saddr,    /* ipv6 source address */
                        daddr;    /* ipv6 destination address */
};


struct options { /* FIXME */
   void *             opt_base;
   unsigned int       opt_len;
   struct opt6_hdr    *opt_hbh;
   struct opt6_hdr    *opt_dst1;
   struct ipv6_rt_hdr *opt_srcrt; /* Routing Header */
   struct opt6_hdr    *opt_frag;
   struct opt6_hdr    *opt_dst2;
   __u8               opt_hbh_len;
   __u8               opt_srcrt_len;
   __u8               opt_dst1_len;
   __u8               opt_dst2_len;
   __u8               opt_frag_len;
};

#define IPV6_MTU 576

#endif /* CONFIG_NET_IPV6_DIM */

#endif	/* _LINUX_IPV6_H */




