/*
 * DRET-IPv6	An implementation of the TCP/IP protocol suite for the LINUX
 *		operating system.  INET6 is implemented using the BSD Socket
 *		interface as the means of communication with the user level.
 *
 * Contacts:	
 *              INRIA      <Christophe.Diot@sophia.inria.fr>
 *              MASI       <Eric.Horlait@masi.ibp.fr>
 *              This software has been developped with the financial support
 *              of DRET (French Military Research Agency).
 *
 * Version:    $Id: icmpv6.h,v 1.4 1997/03/10 16:10:04 pan Exp $ 
 *	
 * Authors:	
 *	        name	<E_mail>
 *
 *
 * Fixes:
 *
 *
 * Description:
 *
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *              This notice must be copied with the distributed package.
 *
 *		Portions of the software are derived from  various 
 *		networking code publicly available, mainly:
 *			NRL IPv6 code 
 *			NetBSD code from INRIA (Francis.Dupont@inria.fr)
 *			Pedro Roque's Linux version (Roque@di.fc.up.pt)
 *
 */				
/*      NetBSD: ip_icmp.c,v 1.10 1994/06/29 06:38:16 cgd Exp              */
#ifndef _LINUX_DRET_ICMPV6_H
#define	_LINUX_DRET_ICMPV6_H

#include <linux/dret/ipv6.h>

/*
 * Structure of an ICMPv6 header.
 */

struct icmpv6_hdr {
   __u8 type;
   __u8 code;
   __u16 csum;
};

struct icmpv6_error {
   struct icmpv6_hdr head;
   __u32 unused;
};

struct icmpv6 {
        /* header - first 32bit word */
        __u8        icmp6_type;     /* type of message, see below */
        __u8        icmp6_code;     /* type sub code */
        __u16       icmp6_cksum;    /* checksum */
        /* header - second 32bit word - 6 possibilities */
        union {
            __u32       pmtu;          /* next MTU (for discovery) */
            __u32       pptr;          /* bad parameter pointer */
            __u32       flags;         /* reserved/flags field */
            struct id_seq {         /* echo */
                __u16   id;        
                __u16   seq;
            } id_seq;
            struct grp_msh {        /* group membership */
                __u16   mxdel;      /* maximum response delay 4.3 */       
                __u16   unused;
            } grp_msh;
            struct nd_msg {         /* neighbor discovery icmp header */
                __u8  cur_hlim;
                __u8  flags;
                __u16 rt_lftime;
            } nd_msg;
        } icmp6_2w;
#define icmp6_pmtu      icmp6_2w.pmtu
#define icmp6_pptr      icmp6_2w.pptr
#define icmp6_flags     icmp6_2w.flags
#define icmp6_id        icmp6_2w.id_seq.id
#define icmp6_seq       icmp6_2w.id_seq.seq
#define icmp6_mrd       icmp6_2w.grp_msh.mxdel
#define icmp6_unu       icmp6_2w.grp_msh.unused
#define icmp6_cur_hlim  icmp6_2w.nd_msg.cur_hlim
#define icmp6_ndflag    icmp6_2w.nd_msg.flags
#define icmp6_life      icmp6_2w.nd_msg.rt_ltime
        /* header - following words -  possibilities */
        union {
            struct in6_addr id6_grp;        /* group management */
#ifndef ND6_DRAFT2
            struct id6_addr {
                struct in6_addr  id6_tgt;     /* target address */
                struct in6_addr  id6_rdst;    /* (redirect) destination */
            } id6_addr;
#else
            struct id6_raddr {
                struct in6_addr  id6_rtgt;     /* target address */
                struct in6_addr  id6_rdst;    /* (redirect) destination */
            } id6_raddr;
            struct id6_saddr {
                struct in6_addr  id6_ssnd;     /* sender address */
                struct in6_addr  id6_stgt;     /* target address */
            } id6_saddr;
#endif
            struct id6_nud {                  /* router adv. msg. */
                __u32        id6_reach;   /* reachable time */
                __u32        id6_retrans; /* retrans timer */
            } id6_nud;
            struct ipv6hdr   id6_ip;         /* header of packet in error */
            char             id6_data[1];    /* echo packet data */
        } icmp6_dun;
#define icmp6_grp       icmp6_dun.id6_grp
#ifndef ND6_DRAFT2
#define icmp6_tgt       icmp6_dun.id6_addr.id6_tgt
#define icmp6_rdst      icmp6_dun.id6_addr.id6_rdst
#else
#define icmp6_tgt       icmp6_dun.id6_grp
#define icmp6_rtgt      icmp6_dun.id6_raddr.id6_rtgt
#define icmp6_rdst      icmp6_dun.id6_raddr.id6_rdst
#define icmp6_ssnd      icmp6_dun.id6_saddr.id6_ssnd
#define icmp6_stgt      icmp6_dun.id6_saddr.id6_stgt
#endif
#define icmp6_reach     icmp6_dun.id6_nud.id6_reach
#define icmp6_retrans   icmp6_dun.id6_nud.id6_retrans
#define icmp6_ip        icmp6_dun.id6_ip
#define icmp6_data      icmp6_dun.id6_data
};

#define ICMP6_MINLEN    8               /* abs minimum */
#define ICMP6_GRPLEN    24              /* group stuff */
#define ICMP6_RSLEN     8               /* router solicitation */
#define ICMP6_RALEN     16              /* router advertisement */
#ifndef ND6_DRAFT2
#define ICMP6_NSLEN     24              /* neighbor solicitation */
#else
#define ICMP6_NSLEN     40              /* neighbor solicitation */
#endif
#define ICMP6_NALEN     24              /* neighbor advertisement */
#define ICMP6_RDLEN     40              /* redirect */

/*
 * Definition of type and code field values.
 */
#define  ICMP6_UNREACH            1      /* dest unreachable, codes: */
   #define  ICMP6_UNREACH_NOROUTE    0      /* no route to destination */
   #define  ICMP6_UNREACH_ADMIN      1      /* administratively prohibited */
   #define  ICMP6_UNREACH_RTFAIL     2      /* not a neighbor */
   #define  ICMP6_UNREACH_ADDRESS    3      /* address unreachable */
   #define  ICMP6_UNREACH_PORT       4      /* port unreachable */
#define  ICMP6_PKTTOOBIG         2       /* packet too big */
#define  ICMP6_TIMXCEED          3       /* time exceeded, code: */
   #define  ICMP6_TIMXCEED_INTRANS   0      /* ttl==0 in transit */
   #define  ICMP6_TIMXCEED_REASS     1      /* ttl==0 in reass */
#define  ICMP6_PARAMPROB         4       /* ip header bad */
   #define  ICMP6_PARAMPROB_HDR      0      /* erroneous header field */
   #define  ICMP6_PARAMPROB_NH       1      /* unrecognized next header */
   #define  ICMP6_PARAMPROB_OPT      2      /* unrecognized option */
#ifndef ND6_DRAFT2
#define ICMP6_OLDREDIRECT       5       /* old redirect */
#else
#define ICMP6_REDIRECT          5       /* redirect */
#endif

#define ICMP6_ECHO              128     /* echo service */
#define ICMP6_ECHOREPLY         129     /* echo reply */
#define ICMP6_GROUPMEM_QUERY    130     /* group membership query */
#define ICMP6_GROUPMEM_REPORT   131     /* group membership report */
#define ICMP6_GROUPMEM_TERM     132     /* group membership termination */
#define ICMP6_SOLICITATION_RT   133     /* router solicitation */
#define ICMP6_ADVERTISMENT_RT   134     /* router advertisment */
#define ICMP6_SOLICITATION_ND   135     /* neighbor solicitation */
#define ICMP6_ADVERTISMENT_ND   136     /* neighbor advertisment */
#ifndef ND6_DRAFT2
#define ICMP6_REDIRECT          137     /* redirect */
#endif

#define ICMP6_INFOTYPE(type)    ((type) >= ICMP6_ECHO)

#ifndef ND6_DRAFT2
#define ICMP6_ND_HOPS           255     /* hop count for ND */
#define ICMP6_ND_PRIORITY       IPV6_PRIORITY_15
#else
#define ICMP6_ND_HOPS           1       /* hop count for ND */
#define ICMP6_ND_PRIORITY       IPV6_PRIORITY_UNCHARACTERIZED
#endif

/*#if defined(_KERNEL) && defined(INET6)
#define ICMP6_TIMER_SCALE       1000
#define ICMP6_TIMER2HZ(mrd)     (ntohs(mrd) * PR_FASTHZ / ICMP6_TIMER_SCALE)
*/
/*
 * Macro to compute a random timer value between 1 and its argument
 * in countdown period units.  We assume that the routine random()
 * is defined somewhere (and that it returns a positive number).
 */
/*#define ICMP6_RANDOM_DELAY(maxdelay)    (random() % (maxdelay) + 1)
#define ICMP6_DEFAULT_DELAY()           (random() % (9 * PR_FASTHZ) + 1)

#define ICMP6_MAX_RATE          10

#endif
*/

/*
struct icmp_err {
  int		errno;
  unsigned	fatal:1;
};
*/

#endif	/* _LINUX_ICMPV6_H */


