#ifndef _LINUX_FLOW_TABLE_H
#define _LINUX_FLOW_TABLE_H

struct flow_stats {
   /* Stats */
   __u32 fs_timestamp;
   __u32 fs_count;
   __u32 fs_bytes;
   __u32 fs_jitter;
};

struct flow_opt {
   __u32 fo_flags;
#define FO_HOPOPTS   0x01
#define FO_DSTOPTS1  0x02
#define FO_SRCRT     0x04
/* Fragmentation may appear or not on a packet basis */
#define FO_DSTOPTS2  0x08
#define FO_AH        0x10
#define FO_ESP       0x20
};


struct flow_entry {
   __u32               fe_timestamp;
   __u32               fe_label;
   struct flow_stats   fe_stats;
   struct flow_opt     fe_opt;
   struct destination *fe_dest;
   struct device      *fe_dev;
   struct flow_entry  *fe_next;
   /* backlog */
   __u32              fe_flags;
#define FE_DEST 0x1
};
   
struct flow {
   atomic_t            fl_ref;
   atomic_t            fl_use;
   struct in6_addr     fl_src;
   struct flow_entry  *fl_fa[16];
};   
#endif
