/*
 * DRET-IPv6	An implementation of the TCP/IP protocol suite for the LINUX
 *		operating system.  INET6 is implemented using the BSD Socket
 *		interface as the means of communication with the user level.
 *
 * Contacts:	
 *              INRIA      <Christophe.Diot@sophia.inria.fr>
 *              MASI       <Eric.Horlait@masi.ibp.fr>
 *              This software has been developped with the financial support
 *              of DRET (French Military Research Agency).
 *
 * Version:    $Id: route6.h,v 1.1 1997/02/12 14:33:55 eh Exp $ 
 *	
 * Authors:	
 *	        name	<E_mail>
 *
 *
 * Fixes:
 *
 *
 * Description:
 *
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *              This notice must be copied with the distributed package.
 *
 *		Portions of the software are derived from  various 
 *		networking code publicly available, mainly:
 *			NRL IPv6 code 
 *			NetBSD code from INRIA (Francis.Dupont@inria.fr)
 *			Pedro Roque's Linux version (Roque@di.fc.up.pt)
 *
 */				
 
#ifndef _LINUX_ROUTE6_H_
#define _LINUX_ROUTE6_H_

#include <linux/config.h>

#ifdef CONFIG_NET_IPV6_DIM

#include <asm/atomic.h>
#include <linux/wait.h>

extern struct rt_dest *default_routes;
extern struct wait_queue *table_wait;

struct in6_rtmsg {
       __u32                   rtmsg_type;
       struct in6_addr         rtmsg_dst;      
       struct in6_addr         rtmsg_gateway;
       __u16                   rtmsg_prefixlen;
       __u16                   rtmsg_metric;
       __u32                   rtmsg_mss;
       __u32                   rtmsg_window;
       char                    rtmsg_device[16];
        __u16                  rtmsg_flags;
};

struct rt_node {
       struct rt_node        *parent;
       struct rt_node        *left;
       struct rt_node        *right;

       struct rt_dest        *leaf;

       __u16                 rn_bit;      /* bit key */
       __u16                 rn_flags;
};
extern struct rt_node rt_root;

struct rt_dest {
       struct rt_node        *route;     /* radix node it depends on */
       struct rt_dest        *next;

       struct in6_addr       rd;
       atomic_t              refcnt;
       atomic_t              rt_use;

       struct neighbor       *neigh;
       struct device         *dev;

       __u16                 rt_metric;      
       __u16                 rt_prefixlen;
       __u16                 rt_flags;  
       __u16                 rt_pmtu;
};
extern struct rt_dest null_entry;
/*-------------------------------------------------------------
|      Destination cache entry
|      
--------------------------------------------------------------*/
struct destination {
        struct rt_dest          route;
        __u32                   tstamp;
       
        atomic_t                refcnt;       
        __u16                   pmtu;
        __u16                   irtt;
        __u32                   window;
        __u8                    flags;  
#define dneigh route.neigh
#define ddev   route.dev
};

/*
 *     move this one to linux/route.h where the rest of the 
 *     RTF flags are defined
 */
#define RTF_INVALID    0x1000
#define RTF_DCACHE     0x2000
#define RTN_ROOT       0x0001          /* Root node */
#define RTN_BACKTRACK  0x0002          /* Backtrack point */


/*
 *     routing header
 */
struct ipv6_rt_hdr {
       __u8            nexthdr;
       __u8            hdrlen;
       __u8            type;
       __u8            segments_left;
       /*
        *      type specific data
        *      variable length field
        */
};

#define RTHDR_TYPE0    0
#define RTHDR_TYPE0_LEN        8
/*
 *     Values for destination cache garbage colection
 *     These are wild guesses for now...
 */

#define        DC_WATER_MARK           512
#define DC_SHORT_TIMEOUT       (5*HZ)
#define DC_LONG_TIMEOUT                (15*HZ)

#define DC_INVALID             0x1

#define DC_TIME_RUN            (5*HZ)
#define DC_TIME_RETRY          HZ
#define DCF_PMTU       0x0001          /* dest cache has valid PMTU info */

#endif

#endif
