/* atmarp.h - ATM ARP protocol and kernel-demon interface definitions */
 
/* Written 1995,1996 by Werner Almesberger, EPFL LRC */
 

#ifndef _LINUX_ATMARP_H
#define _LINUX_ATMARP_H

#include <linux/socket.h>
#include <linux/atm.h>
#include <linux/atmioc.h>


/* RFC 1577 ATM ARP header */

struct atmarphdr {
	unsigned short	ar_hrd;	/* Hardware type */
	unsigned short	ar_pro;	/* Protocol type */
	unsigned char	ar_shtl;/* Type & length of source ATM number (q) */
	unsigned char	ar_sstl;/* Type & length of source ATM subaddress (r) */
	unsigned short	ar_op;	/* Operation code (request, reply, or NAK) */
	unsigned char	ar_spln;/* Length of source protocol address (s) */
	unsigned char	ar_thtl;/* Type & length of target ATM number (x) */
	unsigned char	ar_tstl;/* Type & length of target ATM subaddress (y) */
	unsigned char	ar_tpln;/* Length of target protocol address (z) */
	/* ar_sha, at_ssa, ar_spa, ar_tha, ar_tsa, ar_tpa */
	unsigned char data[1];
};

#define	TL_LEN	0x3f	/* ATMARP Type/Length field structure */
#define	TL_E164	0x40


#define ATF_NULL	0x040	/* use NULL encapsulation */
#define ATF_ARPSRV	0x080	/* entry describes ARP server */
#define ATF_DEFQOS	0x100	/* entry defines default QOS */


#define MAX_ATMARP_SIZE (sizeof(struct atmarphdr)-1+2*(ATM_E164_LEN+ \
			ATM_ESA_LEN+4))

#define ATMARP_RETRY_DELAY 30		/* request next resolution or forget
					   NAK after 30 sec - should go into
					   atmclip.h */

/* These really ought to go into include/linux/if_arp.h */

/* ARP protocol HARDWARE identifiers. */
#define ARPHRD_ATM	19		/* ATM Forum			*/

/* ARP protocol opcodes. */
#define ARPOP_InREQUEST	8		/* InARP request		*/
#define ARPOP_InREPLY	9		/* InARP reply			*/
#define ARPOP_NAK	10		/* (ATM)ARP NAK			*/


#define ATMARPD_CTRL	_IO('a',ATMIOC_CLIP+1)	/* become atmarpd ctrl sock */
#define ATMARP_MKIP	_IO('a',ATMIOC_CLIP+2)	/* attach socket to IP */
#define ATMARP_SETENTRY	_IO('a',ATMIOC_CLIP+3)	/* fill or hide ARP entry */
#define ATMARP_ENCAP	_IO('a',ATMIOC_CLIP+5)	/* change encapsulation */

/* ATMARP ioctl request. */
struct atmarpreq {
	struct sockaddr		arp_pa;		/* protocol address */
	struct sockaddr_atmsvc	arp_ha;		/* PVC or SVC address */
	struct atm_qos		arp_qos;	/* requested QOS */
	int			arp_flags;	/* flags */
};


struct atmarp_arpsioc {
	struct sockaddr		pa;	/* protocol address */
	int			aa_len;	/* size of ATM address */
	struct sockaddr_atmsvc	aa;	/* SVC address */
};


#define ATMARP_CTRL_MAGIC	0xac	/* put this into the magic byte */

enum atmarp_ctrl_type {
	act_invalid,		/* catch uninitialized structures */
	act_need,		/* need address resolution */
	act_create,		/* interface has been created */
	act_up,			/* interface is coming up */
	act_down,		/* interface is going down */
	act_ioctl,		/* ioctl follows */
	act_complete		/* demon indicates completion */
};

struct atmarp_ctrl {
	unsigned char		magic;	/* constant */
	enum atmarp_ctrl_type	type;	/* message type */
	volatile int		*reply;	/* reply address, NULL is asynch */
	int			itf_num;/* interface number (if present) */
	unsigned long		arg;	/* argument, e.g. IP address */
	unsigned char		data[1];/*optional data */
};

#endif
