/* arequipa.h - Arequipa interface definitions */
 
/* Written 1996 by Jean-Michel Pittet and Werner Almesberger, EPFL LRC */
 

#ifndef _LINUX_AREQUIPA_H
#define _LINUX_AREQUIPA_H

#include <linux/atmioc.h>


#define AREQUIPA_PRESET		_IO('a',ATMIOC_AREQUIPA)
#define AREQUIPA_INCOMING	_IO('a',ATMIOC_AREQUIPA+1)
#define AREQUIPA_EXPECT		_IO('a',ATMIOC_AREQUIPA+2)
#define AREQUIPA_CLOSE		_IO('a',ATMIOC_AREQUIPA+3)
#define AREQUIPA_CTRL		_IO('a',ATMIOC_AREQUIPA+4)
#define AREQUIPA_CLS3RD		_IO('a',ATMIOC_AREQUIPA+5)


#ifdef __KERNEL__

#include <linux/net.h>
#include <linux/netdevice.h>
#include <net/sock.h>
#include <net/route.h>


extern struct atm_vcc *aqd; /* for net/atm/proc.c */
/* extern struct rtable arequipa_rt; - not needed */
extern struct device *arequipa_dev;

int atm_init_arequipa(void);
int arequipa_attach(struct socket *lower,struct sock *upper,
    unsigned long generation);

int arequipa_preset(struct socket *lower,struct sock *upper);
int arequipa_expect(struct sock *upper,int on);
int arequipa_incoming(struct socket *lower);
int arequipa_close(struct sock *upper);

int arequipad_attach(struct atm_vcc *vcc);
void arequipa_close_vcc(struct atm_vcc *vcc);

#endif /* __KERNEL__ */
#endif
