# 1 "setup.S"
!
!	setup.S		Copyright (C) 1991, 1992 Linus Torvalds
!
! setup.s is responsible for getting the system data from the BIOS,
! and putting them into the appropriate places in system memory.
! both setup.s and system has been loaded by the bootblock.
!
! This code asks the bios for memory/disk/other parameters, and
! puts them in a "safe" place: 0x90000-0x901FF, ie where the
! boot-block used to be. It is then up to the protected mode
! system to read them from there before the area is overwritten
! for buffer-blocks.
!
! Move PS/2 aux init code to psaux.c
! (troyer@saifr00.cfsat.Honeywell.COM) 03Oct92
!
! some changes and additional features by Christoph Niemann,
! March 1993/June 1994 (Christoph.Niemann@1.org)
!
! add APM BIOS checking by Stephen Rothwell, May 1994
! (Stephen.Rothwell@pd.necisa.oz.au)
!
! High load stuff, initrd support and position independency
! by Hans Lermen & Werner Almesberger, February 1996
! <lermen@elserv.ffm.fgan.de>, <almesber@lrc.epfl.ch>
!
! Video handling moved to video.S by Martin Mares, March 1996
! <mj@k332.feld.cvut.cz>

! NOTE! These had better be the same as in bootsect.s!

# 1 "/1/Production/LinuxLsp/include/linux/config.h" 1



# 1 "/1/Production/LinuxLsp/include/linux/autoconf.h" 1






















































































































































































































































# 4 "/1/Production/LinuxLsp/include/linux/config.h" 2








































# 32 "setup.S" 2

# 1 "/1/Production/LinuxLsp/include/asm/segment.h" 1










# 33 "setup.S" 2

# 1 "/1/Production/LinuxLsp/include/linux/version.h" 1


# 34 "setup.S" 2

# 1 "/1/Production/LinuxLsp/include/linux/compile.h" 1






# 35 "setup.S" 2


! Signature words to ensure LILO loaded us right



INITSEG  = 0x9000	! 0x9000, we move boot here - out of the way
SYSSEG   = 0x1000	! 0x1000, system loaded at 0x10000 (65536).
SETUPSEG = 0x9020	! 0x9020, this is the current segment
			! ... and the former contents of CS
DELTA_INITSEG = SETUPSEG - INITSEG ! 0x0020

.globl begtext, begdata, begbss, endtext, enddata, endbss
.text
begtext:
.data
begdata:
.bss
begbss:
.text

entry start
start:
	jmp	start_of_setup
! ------------------------ start of header --------------------------------
!
! SETUP-header, must start at CS:2 (old 0x9020:2)
!
		.ascii	"HdrS"		! Signature for SETUP-header
		.word	0x0201		! Version number of header format
					! (must be >= 0x0105
					! else old loadlin-1.5 will fail)
realmode_swtch:	.word	0,0		! default_switch,SETUPSEG
start_sys_seg:	.word	SYSSEG
		.word	kernel_version	! pointing to kernel version string
  ! note: above part of header is compatible with loadlin-1.5 (header v1.5),
  !        must not change it

type_of_loader:	.byte	0		! = 0, old one (LILO, Loadlin,
					!      Bootlin, SYSLX, bootsect...)
					! else it is set by the loader:
					! 0xTV: T=0 for LILO
					!	T=1 for Loadlin
					!	T=2 for bootsect-loader
					!	T=3 for SYSLX
					!	T=4 for ETHERBOOT
					!       V = version
loadflags:	.byte	0	! unused bits =0 (reserved for future development)
LOADED_HIGH	= 1		! bit within loadflags,
				! if set, then the kernel is loaded high
CAN_USE_HEAP	= 0x80		! if set, the loader also has set heap_end_ptr
				! to tell how much space behind setup.S
				| can be used for heap purposes.
				! Only the loader knows what is free!
setup_move_size: .word  0x8000	! size to move, when we (setup) are not
				! loaded at 0x90000. We will move ourselves
				! to 0x90000 then just before jumping into
				! the kernel. However, only the loader
				! know how much of data behind us also needs
				! to be loaded.
code32_start:	.long	0x1000		! here loaders can put a different
					! start address for 32-bit code.
					!   0x1000 = default for zImage
					! 0x100000 = default for big kernel
ramdisk_image:	.long	0	! address of loaded ramdisk image
				! Here the loader (or kernel generator) puts
				! the 32-bit address were it loaded the image.
				! This only will be interpreted by the kernel.
ramdisk_size:	.long	0	! its size in bytes
bootsect_kludge:
		.word   bootsect_helper,SETUPSEG
heap_end_ptr:	.word	modelist+1024	! space from here (exclusive) down to
				! end of setup code can be used by setup
				! for local heap purposes.
! ------------------------ end of header ----------------------------------

start_of_setup:
! Bootlin depends on this being done early
	mov	ax,#0x01500
	mov	dl,#0x81
	int	0x13








! set DS=CS, we know that SETUPSEG == CS at this point
	mov	ax,cs		! aka #SETUPSEG
	mov	ds,ax

! Check signature at end of setup
	cmp	setup_sig1,#0xAA55
	jne	bad_sig
	cmp	setup_sig2,#0x5A5A
	jne	bad_sig
	jmp	good_sig1

! Routine to print asciiz-string at DS:SI

prtstr:	lodsb
	and	al,al
	jz	fin
	call	prtchr
	jmp	prtstr
fin:	ret

! Space printing

prtsp2:	call	prtspc		! Print double space
prtspc:	mov	al,#0x20	! Print single space (fall-thru!)

! Part of above routine, this one just prints ascii al

prtchr:	push	ax
	push	cx
	xor	bh,bh
	mov	cx,#0x01
	mov	ah,#0x0e
	int	0x10
	pop	cx
	pop	ax
	ret

beep:	mov	al,#0x07
	jmp	prtchr
	
no_sig_mess:	.ascii	"No setup signature found ..."
		db	0x00

good_sig1:
	jmp	good_sig

! We now have to find the rest of the setup code/data
bad_sig:
	mov	ax,cs		! aka #SETUPSEG
	sub	ax,#DELTA_INITSEG ! aka #INITSEG
	mov	ds,ax
	xor	bh,bh
	mov	bl,[497]	! get setup sects from boot sector
	sub	bx,#4		! LILO loads 4 sectors of setup
	shl	bx,#8		! convert to words
	mov	cx,bx
	shr	bx,#3		! convert to segment
	add	bx,#SYSSEG
	seg cs
	mov	start_sys_seg,bx

! Move rest of setup code/data to here
	mov	di,#2048	! four sectors loaded by LILO
	sub	si,si
	mov	ax,cs		! aka #SETUPSEG
	mov	es,ax
	mov	ax,#SYSSEG
	mov	ds,ax
	rep
	movsw

	mov	ax,cs		! aka #SETUPSEG
	mov	ds,ax
	cmp	setup_sig1,#0xAA55
	jne	no_sig
	cmp	setup_sig2,#0x5A5A
	jne	no_sig
	jmp	good_sig

no_sig:
	lea	si,no_sig_mess
	call	prtstr
no_sig_loop:
	jmp	no_sig_loop

good_sig:
	mov	ax,cs		! aka #SETUPSEG
	sub	ax,#DELTA_INITSEG ! aka #INITSEG
	mov	ds,ax

! check if an old loader tries to load a big-kernel
	seg cs
	test	byte ptr loadflags,#LOADED_HIGH ! have we a big kernel ?
	jz	loader_ok	! NO, no danger even for old loaders
				! YES, we have a big-kernel
	seg cs
	cmp	byte ptr type_of_loader,#0 ! have we one of the new loaders ?
	jnz	loader_ok	! YES, ok
				! NO, we have an old loader, must give up
	push    cs
	pop	ds
	lea	si,loader_panic_mess
	call	prtstr
	jmp	no_sig_loop
loader_panic_mess: 
	.ascii	"Wrong loader, giving up..."
	db	0

loader_ok:
! Get memory size (extended mem, kB)






	push	ax
	push	cx
	push	dx
	mov	ax,#0xe801
	int	0x15
	jc	oldstylemem

! memory size is (ax+(64*bx)) * 1024; we store bx+(ax/64)

	mov	[2],bx		! store extended memory size
	xor	dx,dx
	mov	cx,#64		! convert lower memory size from K into
	div	cx		! 64k chunks.

	add	[2],ax		! add lower memory into total size.
	jmp	gotmem

oldstylemem:
	mov	ah,#0x88
	int	0x15
	mov	cx,#64		! got memory size in kbytes, so we need to
	xor	dx,dx		! adjust to 64k chunks for the system.
	div	cx
	mov	[2],ax
gotmem:
	pop	dx
	pop	cx
	pop	ax


! Set the keyboard repeat rate to the max

	mov	ax,#0x0305
	xor	bx,bx		! clear bx
	int	0x16

! Check for video adapter and its parameters and allow the
! user to browse video modes.

	call	video	! NOTE: we need DS pointing to bootsector

! Get hd0 data

	xor	ax,ax		! clear ax
	mov	ds,ax
	lds	si,[4*0x41]
	mov	ax,cs		! aka #SETUPSEG
	sub	ax,#DELTA_INITSEG ! aka #INITSEG
	push	ax
	mov	es,ax
	mov	di,#0x0080
	mov	cx,#0x10
	push	cx
	cld
	rep
	movsb

! Get hd1 data

	xor	ax,ax		! clear ax
	mov	ds,ax
	lds	si,[4*0x46]
	pop	cx
	pop	es
	mov	di,#0x0090
	rep
	movsb

! Check that there IS a hd1 :-)

	mov	ax,#0x01500
	mov	dl,#0x81
	int	0x13
	jc	no_disk1
	cmp	ah,#3
	je	is_disk1
no_disk1:
	mov	ax,cs		! aka #SETUPSEG
	sub	ax,#DELTA_INITSEG ! aka #INITSEG
	mov	es,ax
	mov	di,#0x0090
	mov	cx,#0x10
	xor	ax,ax		! clear ax
	cld
	rep
	stosb
is_disk1:

! check for Micro Channel (MCA) bus
	mov ax,cs		! aka #SETUPSEG
	sub ax,#DELTA_INITSEG	! aka #INITSEG
	mov ds,ax
	mov ds,ax
	xor ax,ax
	mov [0x220], ax		! set table length to 0
	mov ah, #0xc0
	stc
	int 0x15		! puts feature table at es:bx
	jc no_mca
	push ds
	mov ax,es
	mov ds,ax
	mov ax,cs		! aka #SETUPSEG
	sub ax, #DELTA_INITSEG	! aka #INITSEG
	mov es,ax
	mov si,bx
	mov di,#0x220
	mov cx,(si)
	add cx,#2		! table length is a short
	rep
	movsb
	pop ds

no_mca:

! Check for PS/2 pointing device

	mov	ax,cs		! aka #SETUPSEG
	sub	ax,#DELTA_INITSEG ! aka #INITSEG
	mov	ds,ax
	mov	[0x1ff],#0	! default is no pointing device
	int	0x11		! int 0x11: equipment determination
	test	al,#0x04	! check if pointing device installed
	jz	no_psmouse
	mov	[0x1ff],#0xaa	! device present
no_psmouse:

# 407 "setup.S"


! Now we want to move to protected mode ...

	seg cs
	cmp	realmode_swtch,#0
	jz	rmodeswtch_normal
	seg cs
	callf	far * realmode_swtch
	jmp	rmodeswtch_end
rmodeswtch_normal:
        push	cs
	call	default_switch
rmodeswtch_end:

! we get the code32 start address and modify the below 'jmpi'
! (loader may have changed it)
	seg cs
	mov	eax,code32_start
	seg cs
	mov	code32,eax

! Now we move the system to its rightful place
! ...but we check, if we have a big-kernel.
! in this case we *must* not move it ...
	seg cs
	test	byte ptr loadflags,#LOADED_HIGH
	jz	do_move0	! we have a normal low loaded zImage
				! we have a high loaded big kernel
	jmp	end_move	! ... and we skip moving

do_move0:
	mov	ax,#0x100	! start of destination segment
	mov	bp,cs		! aka #SETUPSEG
	sub	bp,#DELTA_INITSEG ! aka #INITSEG
	seg cs
	mov	bx,start_sys_seg	! start of source segment
	cld			! 'direction'=0, movs moves forward
do_move:
	mov	es,ax		! destination segment
	inc	ah		! instead of add ax,#0x100
	mov	ds,bx		! source segment
	add	bx,#0x100
	sub	di,di
	sub	si,si
	mov 	cx,#0x800
	rep
	movsw
	cmp	bx,bp		! we assume start_sys_seg > 0x200,
				! so we will perhaps read one page more then
				! needed, but never overwrite INITSEG because
				! destination is minimum one page below source
	jb	do_move

! then we load the segment descriptors

end_move:
	mov	ax,cs ! aka #SETUPSEG	! right, forgot this at first. didn't work :-)
	mov	ds,ax

! If we have our code not at 0x90000, we need to move it there now.
! We also then need to move the params behind it (commandline)
! Because we would overwrite the code on the current IP, we move
! it in two steps, jumping high after the first one.
	mov	ax,cs
	cmp	ax,#SETUPSEG
	je	end_move_self
	cli	! make sure we really have interrupts disabled !
		! because after this the stack should not be used
	sub	ax,#DELTA_INITSEG ! aka #INITSEG
	mov	dx,ss
	cmp	dx,ax
	jb	move_self_1
	add	dx,#INITSEG
	sub	dx,ax		! this will be SS after the move
move_self_1:
	mov	ds,ax
	mov	ax,#INITSEG	! real INITSEG
	mov	es,ax
	seg cs
	mov	cx,setup_move_size
	std		! we have to move up, so we use direction down
			! because the areas may overlap
	mov	di,cx
	dec	di
	mov	si,di
	sub	cx,#move_self_here+0x200
	rep
	movsb
	jmpi	move_self_here,SETUPSEG ! jump to our final place
move_self_here:
	mov	cx,#move_self_here+0x200
	rep
	movsb
	mov	ax,#SETUPSEG
	mov	ds,ax
	mov	ss,dx
			! now we are at the right place
end_move_self:

	lidt	idt_48		! load idt with 0,0
	lgdt	gdt_48		! load gdt with whatever appropriate

! that was painless, now we enable A20

	call	empty_8042
	mov	al,#0xD1		! command write
	out	#0x64,al
	call	empty_8042
	mov	al,#0xDF		! A20 on
	out	#0x60,al
	call	empty_8042

! make sure any possible coprocessor is properly reset..

	xor	ax,ax
	out	#0xf0,al
	call	delay
	out	#0xf1,al
	call	delay

! well, that went ok, I hope. Now we have to reprogram the interrupts :-(
! we put them right after the intel-reserved hardware interrupts, at
! int 0x20-0x2F. There they won't mess up anything. Sadly IBM really
! messed this up with the original PC, and they haven't been able to
! rectify it afterwards. Thus the bios puts interrupts at 0x08-0x0f,
! which is used for the internal hardware interrupts as well. We just
! have to reprogram the 8259's, and it isn't fun.

	mov	al,#0x11		! initialization sequence
	out	#0x20,al		! send it to 8259A-1
	call	delay
	out	#0xA0,al		! and to 8259A-2
	call	delay
	mov	al,#0x20		! start of hardware int's (0x20)
	out	#0x21,al
	call	delay
	mov	al,#0x28		! start of hardware int's 2 (0x28)
	out	#0xA1,al
	call	delay
	mov	al,#0x04		! 8259-1 is master
	out	#0x21,al
	call	delay
	mov	al,#0x02		! 8259-2 is slave
	out	#0xA1,al
	call	delay
	mov	al,#0x01		! 8086 mode for both
	out	#0x21,al
	call	delay
	out	#0xA1,al
	call	delay
	mov	al,#0xFF		! mask off all interrupts for now
	out	#0xA1,al
	call	delay
	mov	al,#0xFB		! mask all irq's but irq2 which
	out	#0x21,al		! is cascaded

! Well, that certainly wasn't fun :-(. Hopefully it works, and we don't
! need no steenking BIOS anyway (except for the initial loading :-).
! The BIOS-routine wants lots of unnecessary data, and it's less
! "interesting" anyway. This is how REAL programmers do it.
!
! Well, now's the time to actually move into protected mode. To make
! things as simple as possible, we do no register set-up or anything,
! we let the gnu-compiled 32-bit programs do that. We just jump to
! absolute address 0x1000 (or the loader supplied one),
! in 32-bit protected mode.
!
! Note that the short jump isn't strictly needed, although there are
! reasons why it might be a good idea. It won't hurt in any case.
!
	mov	ax,#1		! protected mode (PE) bit
	lmsw	ax		! This is it!
	jmp	flush_instr
flush_instr:
	xor	bx,bx		! Flag to indicate a boot

! NOTE: For high loaded big kernels we need a
!	jmpi    0x100000,0x10
!
!	but we yet haven't reloaded the CS register, so the default size 
!	of the target offset still is 16 bit.
!       However, using an operant prefix (0x66), the CPU will properly
!	take our 48 bit far pointer. (INTeL 80386 Programmer's Reference
!	Manual, Mixing 16-bit and 32-bit code, page 16-6)
	db	0x66,0xea	! prefix + jmpi-opcode
code32:	dd	0x1000		! will be set to 0x100000 for big kernels
	dw	0x10


kernel_version:	.ascii	"2.1.23"
		.ascii	" ("
		.ascii	"lpautet"
		.ascii	"@"
		.ascii	"pelvoux"
		.ascii	") "
		.ascii	"#37 Wed Feb 4 10:34:14 MET 1998"
		db	0

! This is the default real mode switch routine.
! to be called just before protected mode transition

default_switch:
	cli			! no interrupts allowed !
	mov	al,#0x80	! disable NMI for the bootup sequence
	out	#0x70,al
	retf

! This routine only gets called, if we get loaded by the simple
! bootsect loader _and_ have a bzImage to load.
! Because there is no place left in the 512 bytes of the boot sector,
! we must emigrate to code space here.
!
bootsect_helper:
	seg cs
	cmp	word ptr bootsect_es,#0
	jnz	bootsect_second
	seg cs
	mov	byte ptr type_of_loader,#0x20
	mov	ax,es
	shr	ax,#4
	seg	cs
	mov	byte ptr bootsect_src_base+2,ah
	mov	ax,es
	seg cs
	mov	bootsect_es,ax
	sub	ax,#SYSSEG
	retf			! nothing else to do for now
bootsect_second:
	push	cx
	push	si
	push	bx
	test	bx,bx	! 64K full ?
	jne	bootsect_ex
	mov	cx,#0x8000	! full 64K move, INT15 moves words
	push	cs
	pop	es
	mov	si,#bootsect_gdt
	mov	ax,#0x8700
	int	0x15
	jc	bootsect_panic	! this, if INT15 fails
	seg cs
	mov	es,bootsect_es	! we reset es to always point to 0x10000
	seg cs
	inc	byte ptr bootsect_dst_base+2
bootsect_ex:
	seg cs
	mov	ah, byte ptr bootsect_dst_base+2
	shl	ah,4	! we now have the number of moved frames in ax
	xor	al,al
	pop	bx
	pop	si
	pop	cx
	retf

bootsect_gdt:
	.word	0,0,0,0
	.word	0,0,0,0
bootsect_src:
	.word	0xffff
bootsect_src_base:
	.byte	0,0,1			! base = 0x010000
	.byte	0x93			! typbyte
	.word	0			! limit16,base24 =0
bootsect_dst:
	.word	0xffff
bootsect_dst_base:
	.byte	0,0,0x10		! base = 0x100000
	.byte	0x93			! typbyte
	.word	0			! limit16,base24 =0
	.word	0,0,0,0			! BIOS CS
	.word	0,0,0,0			! BIOS DS
bootsect_es:
	.word	0

bootsect_panic:
	push	cs
	pop	ds
	cld
	lea	si,bootsect_panic_mess
	call	prtstr
bootsect_panic_loop:
	jmp	bootsect_panic_loop
bootsect_panic_mess:
	.ascii	"INT15 refuses to access high mem, giving up..."
	db	0

! This routine checks that the keyboard command queue is empty
! (after emptying the output buffers)
!
! No timeout is used - if this hangs there is something wrong with
! the machine, and we probably couldn't proceed anyway.
empty_8042:
	call	delay
	in	al,#0x64	! 8042 status port
	test	al,#1		! output buffer?
	jz	no_output
	call	delay
	in	al,#0x60	! read it
	jmp	empty_8042
no_output:
	test	al,#2		! is input buffer full?
	jnz	empty_8042	! yes - loop
	ret

!
! Read the cmos clock. Return the seconds in al
!
gettime:
	push	cx
	mov	ah,#0x02
	int	0x1a
	mov	al,dh			! dh contains the seconds
	and	al,#0x0f
	mov	ah,dh
	mov	cl,#0x04
	shr	ah,cl
	aad
	pop	cx
	ret

!
! Delay is needed after doing I/O
!
delay:
	.word	0x00eb			! jmp $+2
	ret

!
! Descriptor tables
!

gdt:
	.word	0,0,0,0		! dummy

	.word	0,0,0,0		! unused

	.word	0xFFFF		! 4Gb - (0x100000*0x1000 = 4Gb)
	.word	0x0000		! base address=0
	.word	0x9A00		! code read/exec
	.word	0x00CF		! granularity=4096, 386 (+5th nibble of limit)

	.word	0xFFFF		! 4Gb - (0x100000*0x1000 = 4Gb)
	.word	0x0000		! base address=0
	.word	0x9200		! data read/write
	.word	0x00CF		! granularity=4096, 386 (+5th nibble of limit)

idt_48:
	.word	0			! idt limit=0
	.word	0,0			! idt base=0L

gdt_48:
	.word	0x800		! gdt limit=2048, 256 GDT entries
	.word	512+gdt,0x9	! gdt base = 0X9xxxx

!
! Include video setup & detection code
!

# 1 "video.S" 1
!
!	Display adapter & video mode setup, version 2.10 (11-Nov-96)
!
!	Copyright (C) 1995, 1996 Martin Mares <mj@k332.feld.cvut.cz>
!	Based on the original setup.S code (C) Linus Torvalds and Mats Anderson
!

! Enable autodetection of SVGA adapters and modes


! Enable autodetection of VESA modes


! Enable compacting of mode table


! Retain screen contents when switching modes


! Enable local mode list


! Force 400 scan lines for standard modes (hack to fix bad behaviour
! of certain broken BIOS'es -- don't use unless needed)


! A special hack allowing to force specific BIOS mode ID along with specific
! dimensions. Especially useful for certain X-Window graphics mode hacks
! (e.g., 800x600 modes on IBM ThinkPad).





! This code uses an extended set of video mode numbers. These include:
! Aliases for standard modes
!	0xffff (-1)
!	0xfffe (-2)
!	0xfffd (-3)
! Video modes numbered by menu position -- NOT RECOMMENDED because of lack
! of compatibility when extending the table. These are between 0x00 and 0xff.

! Standard BIOS video modes (BIOS number + 0x0100)

! VESA BIOS video modes (VESA number + 0x0200)

! Video7 special modes (BIOS number + 0x0900)

! Special video modes











! Video modes given by resolution


! The "recalculate timings" flag


! Positions of various video parameters passed to the kernel









! Define DO_STORE according to 






!
! This is the main entry point called by setup.S
!
! Input:
!	DS pointing to the bootsector

video:	push	ds		! We use different segments
	push	ds		! FS contains original DS
	pop	fs
	push	cs		! DS is equal to CS
	pop	ds
	push	cs		! ES is equal to CS
	pop	es
	xor	ax,ax
	mov	gs,ax		! GS is zero
	cld
	call	basic_detect	! Basic adapter type testing (EGA/VGA/MDA/CGA)

	seg	fs		! User-selected video mode
	mov	ax,[0x01fa]
	cmp	ax,#0xfffd	! Bring up the menu
	jz	vid2
	call	mode_set	! Set the mode
	jc	vid1
	lea	si,badmdt	! Invalid mode ID
	call	prtstr
vid2:	call	mode_menu
vid1:

	call	restore_screen	! Restore screen contents


	call	mode_params	! Store mode parameters
	pop	ds		! Restore original DS
	ret

!
! Detect if we have CGA, MDA, EGA or VGA and pass it to the kernel.
!

basic_detect:
	seg	fs		! Default is no VGA
	movb	[15],#0

	mov	ah,#0x12	! Check EGA/VGA
	mov	bl,#0x10
	int	0x10
	seg	fs
	mov	[10],bx	! Used for identification of EGA in the kernel
	cmp	bl,#0x10	! No, this is a CGA/MDA/HGA card.
	je	basret
	incb	[adapter]

	mov	ax,#0x1a00	! Check for EGA/VGA discrimination
	int	0x10
	cmp	al,#0x1a	! 1a means VGA, anything else EGA
	jne	basret
	seg	fs
	incb	[15]	! We've detected a VGA
	incb	[adapter]

basret:	ret

!
! Store the video mode parameters for later usage by the kernel.
! This is done by asking the BIOS except for the rows/columns
! parameters in the default 80x25 mode -- these are set directly,
! because some very obscure BIOSes supply insane values.
!

mode_params:
	mov	ah,#0x03	! Read cursor position
	xor	bh,bh
	int	0x10
	seg	fs
	mov	[0],dx

	mov	ah,#0x0f	! Read page/mode/width
	int	0x10
	seg	fs
	mov	[4],bx
	seg	fs
	mov	[6],ax	! Video mode and screen width
	cmp	al,#7			! MDA/HGA => segment differs
	jnz	mopar0
	mov	[video_segment],#0xb000
mopar0:	seg	gs			! Font size
	mov	ax,[0x485]
	seg	fs
	mov	[16],ax	! (valid only on EGA/VGA)

	mov	ax,[force_size]	! Forced size?
	or	ax,ax
	jz	mopar1
	seg	fs
	mov	[7],ah
	seg	fs
	mov	[14],al
	ret

mopar1:	mov	al,#25
	cmpb	[adapter],#0	! If we are on CGA/MDA/HGA, the screen must
	jz	mopar2		! have 25 lines.
	seg	gs		! On EGA/VGA, use the EGA+ BIOS variable
	mov	al,[0x484]	! containing maximal line number.
	inc	al
mopar2:	seg	fs
	movb	[14],al
	ret



!
! The video mode menu
!

mode_menu:
	lea	si,keymsg	! "Return/Space/Timeout" message
	call	prtstr
	call	flush
nokey:	call	getkt
	cmp	al,#0x0d	! ENTER ?
	je	listm		! yes - manual mode selection
	cmp	al,#0x20	! SPACE ?
	je	defmd1		! no - repeat
	call 	beep
	jmp	nokey
defmd1:	ret			! No mode selected => use the 80x25 default

listm:	call	mode_table	! We need a mode table to be listed
listm0:	lea	si,name_bann	! Print adapter name
	call	prtstr
	mov	si,[card_name]
	or	si,si
	jnz	an2
	mov	al,[adapter]
	lea	si,old_name
	or	al,al
	jz	an1
	lea	si,ega_name
	dec	al
	jz	an1
	lea	si,vga_name
	jmp	an1
an2:	call	prtstr
	lea	si,svga_name
an1:	call	prtstr
	lea	si,listhdr	! Table header
	call	prtstr
	mov	dl,#0x30	! DL holds mode number
	lea	si,modelist
lm1:	cmp	(si),#0xfffd	! End?
	jz	lm2
	mov	al,dl		! Menu selection number
	call	prtchr
	call	prtsp2
	lodsw
	call	prthw		! Mode ID
	call	prtsp2
	mov	al,(si+1)
	call	prtdec		! Rows
	mov	al,#0x78	! 'x'
	call	prtchr
	lodsw
	call	prtdec		! Columns
	mov	al,#0x0d	! New line
	call	prtchr
	mov	al,#0x0a
	call	prtchr
	inc	dl		! Next character
	cmp	dl,#0x3a
	jnz	lm1
	mov	dl,#0x61
	jmp	lm1

lm2:	lea	si,prompt	! Mode prompt
	call	prtstr
	lea	di,edit_buf	! Editor buffer
lm3:	call	getkey
	cmp	al,#0x0d	! Enter?
	jz	lment
	cmp	al,#0x08	! Backspace?
	jz	lmbs
	cmp	al,#0x20	! Printable?
	jc	lm3
	cmp	di,#edit_buf+4	! Enough space?
	jz	lm3
	stosb
	call	prtchr
	jmp	lm3

lmbs:	cmp	di,#edit_buf	! Backspace
	jz	lm3
	dec	di
	mov	al,#0x08
	call	prtchr
	call	prtspc
	mov	al,#0x08
	call	prtchr
	jmp	lm3

lment:	movb	(di),#0
	lea	si,crlft
	call	prtstr
	lea	si,edit_buf
	cmpb	(si),#0		! Empty string => use default mode
	jz	lmdef
	cmpb	(si+1),#0	! One character => menu selection
	jz	mnusel
	cmp	(si),#0x6373	! "scan" => mode scanning
	jnz	lmhx
	cmp	(si+2),#0x6e61
	jz	lmscan
lmhx:	xor	bx,bx		! Else => mode ID in hex
lmhex:	lodsb
	or	al,al
	jz	lmuse1
	sub	al,#0x30
	jc	lmbad
	cmp	al,#10
	jc	lmhx1
	sub	al,#7
	and	al,#0xdf
	cmp	al,#10
	jc	lmbad
	cmp	al,#16
	jnc	lmbad
lmhx1:	shl	bx,#4
	or	bl,al
	jmp	lmhex
lmuse1:	mov	ax,bx
	jmp	lmuse

mnusel:	lodsb			! Menu selection
	xor	ah,ah
	sub	al,#0x30
	jc	lmbad
	cmp	al,#10
	jc	lmuse
	cmp	al,#0x61-0x30
	jc	lmbad
	sub	al,#0x61-0x30-10
	cmp	al,#36
	jnc	lmbad
lmuse:	call	mode_set
	jc	lmdef
lmbad:	lea	si,unknt
	call	prtstr
	br	lm2

lmscan:	cmpb	[adapter],#0	! Scanning supported only on EGA/VGA
	jz	lmbad
	mov	[mt_end],#0	! Scanning of modes: done as new autodetection
	movb	[scanning],#1
	call	mode_table
	br	listm0

lmdef:	ret

!
! Additional parts of mode_set... (relative jumps, you know)
!

setv7:				! Video7 extended modes
	call store_screen
	sub	bh,#0x0900>>8
	mov	ax,#0x6f05
	int	0x10
	stc
	ret

_setrec:	br	setrec	! Ugly...

!
! Aliases for backward compatibility.
!

setalias:
	mov	ax,#0x0f00
	inc	bx
	jz	mode_set
	mov	al,#0x0f01-0x0f00
	inc	bx
	jnz	setbad

	! Fall-thru !

!
! Setting of user mode (AX=mode ID) => CF=success
!

mode_set:
	mov	bx,ax
	cmp	ah,#0xff
	jz	setalias
	test	ah,#0x8000>>8
	jnz	_setrec
	cmp	ah,#0x1000>>8
	jnc	setres
	cmp	ah,#0x0f00>>8
	jz	setspc
	cmp	ah,#0x0900>>8
	jz	setv7
	cmp	ah,#0x0200>>8
	jnc	setvesa
	or	ah,ah
	jz	setmenu
	dec	ah
	jz	setbios
setbad:	clc
	movb	[do_restore],#0	! The screen needn't be restored
	ret

setvesa:
	call store_screen
	sub	bh,#0x0200>>8
	mov	ax,#0x4f02	! VESA BIOS mode set call
	int	0x10
	cmp	ax,#0x004f	! AL=4f if implemented, AH=0 if OK
	jnz	setbad
	stc
	ret

setbios:
	call store_screen
	int	0x10		! Standard BIOS mode set call
	push	bx
	mov	ah,#0x0f	! Check if really set
	int	0x10
	pop	bx
	cmp	al,bl
	jnz	setbad
	stc
	ret

setspc:	xor	bh,bh		! Set special mode
	cmp	bl,#0x0f09-0x0f00
	jnc	setbad
	add	bx,bx
	.word	0xa7ff, spec_inits	! JMP [BX+spec_inits]

setmenu:
	or	al,al		! 80x25 is an exception
	jz	set_80x25
	push	bx		! Set mode chosen from menu
	call	mode_table	! Build the mode table
	pop	ax
	shl	ax,#2
	add	si,ax
	cmp	si,di
	jnc	setbad
	mov	ax,(si)		! Fetch mode ID
_m_s:	jmp	mode_set

setres:
	push	bx		! Set mode chosen by its resolution
	call	mode_table
	pop	bx
	xchg	bh,bl
setr1:	lodsw
	cmp	ax,#0xfffd	! End of the list?
	jz	setbad
	lodsw
	cmp	ax,bx
	jnz	setr1
	mov	ax,(si-4)	! Fetch mode ID
	jmp	_m_s

!
! Recalculate vertical display end registers -- this fixes various
! inconsistencies of extended modes on many adapters. Called when
! the 0x8000 flag is set in the mode ID.
!

setrec:	sub	ah,#0x8000>>8	! Set the base mode
	call	mode_set
	jnc	rct3
	seg	gs			! Font size in pixels
	mov	ax,[0x485]
	seg	gs			! Number of rows
	mov	bl,[0x484]
	inc	bl
	mul	bl			! Number of visible
	dec	ax			! scan lines - 1
	mov	dx,#0x3d4
	mov	bx,ax
	mov	al,#0x12		! Lower 8 bits
	mov	ah,bl
	out	dx,ax
	mov	al,#0x07		! Bits 8 and 9 in the overflow register
	call	inidx
	xchg	ah,al
	and	ah,#0xbd
	shr	bh,#1
	jnc	rct1
	or	ah,#0x02
rct1:	shr	bh,#1
	jnc	rct2
	or	ah,#0x40
rct2:	mov	al,#0x07
	out	dx,ax
	stc
rct3:	ret

!
! Table of routines for setting of the special modes.
!

spec_inits:
	.word	set_80x25
	.word	set_8pixel
	.word	set_80x43
	.word	set_80x28
	.word	set_current
	.word	set_80x30
	.word	set_80x34
	.word	set_80x60
	.word	set_gfx

!
! Set the 80x25 mode. If already set, do nothing.
!

set_80x25:
	mov	[force_size],#0x5019	! Override possibly broken BIOS vars
use_80x25:





	mov	ah,#0x0f	! Get current mode ID
	int	0x10
	cmp	ax,#0x5007	! Mode 7 (80x25 mono) is the only one available
	jz	st80		! on CGA/MDA/HGA and is also available on EGAM
	cmp	ax,#0x5003	! Unknown mode => force 80x25 color
	jnz	force3
st80:	cmpb	[adapter],#0	! CGA/MDA/HGA => mode 3/7 is always 80x25
	jz	set80
	seg	gs		! This is EGA+ -- beware of 80x50 etc.
	mov	al,[0x0484]
	or	al,al		! Some buggy BIOS'es set 0 rows
	jz	set80
	cmp	al,#24		! It's hopefully correct
	jz	set80

force3:	call store_screen
	mov	ax,#0x0003	! Forced set
	int	0x10
set80:	stc
	ret

!
! Set the 80x50/80x43 8-pixel mode. Simple BIOS calls.
!

set_8pixel:
	call store_screen
	call	use_80x25	! The base is 80x25
set_8pt:
	mov	ax,#0x1112	! Use 8x8 font
	xor	bl,bl
	int	0x10
	mov	ax,#0x1200	! Use alternate print screen
	mov	bl,#0x20
	int	0x10
	mov	ax,#0x1201	! Turn off cursor emulation
	mov	bl,#0x34
	int	0x10
	mov	ah,#0x01	! Define cursor (scan lines 6 to 7)
	mov	cx,#0x0607
	int	0x10
set_current:
	stc
	ret

!
! Set the 80x28 mode. This mode works on all VGA's, because it's a standard
! 80x25 mode with 14-point fonts instead of 16-point.
!

set_80x28:
	call store_screen
	call	use_80x25	! The base is 80x25
set14:	mov	ax,#0x1111	! Use 9x14 font
	xor	bl,bl
	int	0x10
	mov	ah,#0x01	! Define cursor (scan lines 11 to 12)
	mov	cx,#0x0b0c
	int	0x10
	stc
	ret

!
! Set the 80x43 mode. This mode is works on all VGA's.
! It's a 350-scanline mode with 8-pixel font.
!

set_80x43:
	call store_screen
	mov	ax,#0x1201	! Set 350 scans
	mov	bl,#0x30
	int	0x10
	mov	ax,#0x0003	! Reset video mode
	int	0x10
	jmp	set_8pt		! Use 8-pixel font

!
! Set the 80x30 mode (all VGA's). 480 scanlines, 16-pixel font.
!

set_80x30:
	call	use_80x25	! Start with real 80x25
	call store_screen
	mov	dx,#0x3cc	! Get CRTC port
	in	al,dx
	mov	dl,#0xd4
	ror	al,#1		! Mono or color?
	jc	set48a
	mov	dl,#0xb4
set48a:	mov	ax,#0x0c11	! Vertical sync end (also unlocks CR0-7)
 	call	outidx
	mov	ax,#0x0b06	! Vertical total
 	call	outidx
	mov	ax,#0x3e07	! (Vertical) overflow
 	call	outidx
	mov	ax,#0xea10	! Vertical sync start
 	call	outidx
	mov	ax,#0xdf12	! Vertical display end
	call	outidx
	mov	ax,#0xe715	! Vertical blank start
 	call	outidx
	mov	ax,#0x0416	! Vertical blank end
 	call	outidx
	push	dx
	mov	dl,#0xcc	! Misc output register (read)
 	in	al,dx
 	mov	dl,#0xc2	! (write)
 	and	al,#0x0d	! Preserve clock select bits and color bit
 	or	al,#0xe2	! Set correct sync polarity
 	out	dx,al
	pop	dx
	mov	[force_size],#0x501e
	stc			! That's all.
	ret

!
! Set the 80x34 mode (all VGA's). 480 scans, 14-pixel font.
!

set_80x34:
	call	set_80x30	! Set 480 scans
	call	set14		! And 14-pt font
	mov	ax,#0xdb12	! VGA vertical display end
	mov	[force_size],#0x5022
setvde:	call	outidx
	stc
	ret

!
! Set the 80x60 mode (all VGA's). 480 scans, 8-pixel font.
!

set_80x60:
	call	set_80x30	! Set 480 scans
	call	set_8pt		! And 8-pt font
	mov	ax,#0xdf12	! VGA vertical display end
	mov	[force_size],#0x503c
	jmp	setvde

!
! Special hack for ThinkPad graphics
!

set_gfx:







	ret



!
! Store screen contents to temporary buffer.
!

store_screen:
	cmpb	[do_restore],#0		! Already stored?
	jnz	stsr
	testb	[loadflags],#CAN_USE_HEAP	! Have we space for storing?
	jz	stsr
	push	ax
	push	bx
	push	[force_size]		! Don't force specific size
	mov	[force_size],#0
	call	mode_params		! Obtain params of current mode
	pop	[force_size]

	seg	fs
	mov	ah,[14]
	seg	fs
	mov	al,[7]
	mov	bx,ax			! BX=dimensions
	mul	ah
	mov	cx,ax			! CX=number of characters to store
	add	ax,ax			! Calculate image size
	add	ax,#modelist+1024+4
	cmp	ax,[heap_end_ptr]
	jnc	sts1			! Unfortunately, out of memory

	seg	fs			! Store mode params
	mov	ax,[0]
	lea	di,modelist+1024
	stosw
	mov	ax,bx
	stosw

	push	ds			! Store the screen
	mov	ds,[video_segment]
	xor	si,si
	rep
	movsw
	pop	ds
	incb	[do_restore]		! Screen will be restored later
sts1:	pop	bx
	pop	ax
stsr:	ret

!
! Restore screen contents from temporary buffer.
!

restore_screen:
	cmpb	[do_restore],#0		! Has the screen been stored?
	jz	res1
	call	mode_params		! Get parameters of current mode
	seg	fs
	mov	cl,[14]
	seg	fs
	mov	ch,[7]
	lea	si,modelist+1024	! Screen buffer
	lodsw				! Set cursor position
	mov	dx,ax
	cmp	dh,cl
	jc	res2
	mov	dh,cl
	dec	dh
res2:	cmp	dl,ch
	jc	res3
	mov	dl,ch
	dec	dl
res3:	mov	ah,#0x02
	mov	bh,#0x00
	int	0x10
	lodsw				! Display size
	mov	dl,ah			! DL=number of lines
	mov	ah,#0			! BX=physical length of orig. line
	mov	bx,ax
	cmp	dl,cl			! Too many?
	jc	res4
	push	ax
	mov	al,dl
	sub	al,cl
	mul	bl
	add	si,ax
	add	si,ax
	pop	ax
	mov	dl,cl
res4:	cmp	al,ch			! Too wide?
	jc	res5
	mov	al,ch			! AX=width of src. line
res5:	mov	cl,#0
	xchg	cl,ch
	mov	bp,cx			! BP=width of dest. line
	push	es
	mov	es,[video_segment]
	xor	di,di			! Move the data
	add	bx,bx			! Convert BX and BP to _bytes_
	add	bp,bp
res6:	push	si
	push	di
	mov	cx,ax
	rep
	movsw
	pop	di
	pop	si
	add	di,bp
	add	si,bx
	dec	dl
	jnz	res6
	pop	es			! Done
res1:	ret



!
! Write to indexed VGA register (AL=index, AH=data, DX=index reg. port)
!

outidx:	out	dx,al
	push	ax
	mov	al,ah
	inc	dx
	out	dx,al
	dec	dx
	pop	ax
	ret

!
! Build the table of video modes (stored after the setup.S code at the
! `modelist' label. Each video mode record looks like:
!	.word	MODE-ID		(our special mode ID (see above))
!	.byte	rows		(number of rows)
!	.byte	columns		(number of columns)
! Returns address of the end of the table in DI, the end is marked
! with a 0xfffd ID.
!

mode_table:
	mov	di,[mt_end]	! Already filled?
	or	di,di
	jnz	mtab1x
	lea	di,modelist	! Store standard modes:

	mov	eax,#0x0f00 + 0x50190000	! The 80x25 mode (ALL)
	stosd
	mov	al,[adapter]	! CGA/MDA/HGA -- no more modes
	or	al,al
	jz	mtabe
	dec	al
	jnz	mtabv
	mov	eax,#0x0f01 + 0x502b0000	! The 80x43 EGA mode
	stosd
	jmp	mtabe
mtab1x:	jmp	mtab1

mtabv:	lea	si,vga_modes			! All modes for std VGA
	mov	cx,#vga_modes_end-vga_modes
	rep	! I'm unable to use movsw as I don't know how to store a half
	movsb	! of the expression above to cx without using explicit shr.

	cmpb	[scanning],#0			! Mode scan requested?
	jz	mscan1
	call	mode_scan
mscan1:





	call	vesa_modes			! Detect VESA VGA modes


	cmpb	[scanning],#0			! Bypass when scanning
	jnz	mscan2
	call	svga_modes			! Detect SVGA cards & modes
mscan2:


mtabe:


	lea	si,modelist	! Compact video mode list if requested.
	mov	dx,di
	mov	di,si
cmt1:	cmp	si,dx		! Scan all modes
	jz	cmt2
	lea	bx,modelist	! Find in previous entries
	mov	cx,(si+2)
cmt3:	cmp	si,bx
	jz	cmt4
	cmp	cx,(bx+2)	! Found => don't copy this entry
	jz	cmt5
	add	bx,#4
	jmp	cmt3

cmt4:	movsd			! Copy entry
	jmp	cmt1

cmt5:	add	si,#4		! Skip entry
	jmp	cmt1

cmt2:


	mov	(di),#0xfffd	! End marker
	mov	[mt_end],di
mtab1:	lea	si,modelist	! Returning: SI=mode list, DI=list end
ret0:	ret

! Modes usable on all standard VGAs

vga_modes:
	.word	0x0f01
	.word	0x5032		! 80x50
	.word	0x0f02
	.word	0x502b		! 80x43
	.word	0x0f03
	.word	0x501c		! 80x28
	.word	0x0f05
	.word	0x501e		! 80x30
	.word	0x0f06
	.word	0x5022		! 80x34
	.word	0x0f07
	.word	0x503c		! 80x60




vga_modes_end:

!
! Detect VESA modes.
!



vesa_modes:
	cmpb	[adapter],#2	! VGA only
	jnz	ret0
	mov	bp,di		! BP=original mode table end
	add	di,#0x200	! Buffer space
	mov	ax,#0x4f00	! VESA Get card info call
	int	#0x10
	mov	di,bp
	cmp	ax,#0x004f	! Successful?
	jnz	ret0
	cmp	(di+0x200),#0x4556
	jnz	ret0
	cmp	(di+0x202),#0x4153
	jnz	ret0
	mov	[card_name],#vesa_name	! Set name to "VESA VGA"
	push	gs
	lgs	si,(di+0x20e)	! GS:SI=mode list
	mov	cx,#128		! Iteration limit
vesa1:	seg	gs		! Get next mode in the list
	lodsw
	cmp	ax,#0xffff	! End of the table?
	jz	vesar
	cmp	ax,#0x0080	! Check validity of mode ID
	jc	vesa2
	or	ah,ah		! Valid ID's are 0x0000-0x007f and 0x0100-0x07ff
	jz	vesan		! [Certain BIOSes erroneously report 0x80-0xff]
	cmp	ax,#0x0800
	jnc	vesae
vesa2:	push	cx
	mov	cx,ax		! Get mode information structure
	mov	ax,#0x4f01
	int	0x10
	mov	bx,cx		! BX=mode number
	add	bh,#0x0200>>8
	pop	cx
	cmp	ax,#0x004f
	jnz	vesan		! Don't report errors (buggy BIOSES :-[ )
	mov	al,(di)		! Check capabilities. We require
	and	al,#0x19	! a color text mode.
	cmp	al,#0x09
	jnz	vesan
	cmp	(di+8),#0xb800	! Standard video memory address required
	jnz	vesan
	testb	(di),#2		! Mode characteristics supplied?
	mov	(di),bx		! Store mode number
	jz	vesa3
	xor	dx,dx
	mov	bx,(di+0x12)	! Width
	or	bh,bh
	jnz	vesan
	mov	(di+3),bl
	mov	ax,(di+0x14)	! Height
	or	ah,ah
	jnz	vesan
	mov	(di+2),al
	mul	bl
	cmp	ax,#8193	! Small enough for Linux console driver?
	jnc	vesan
	jmp	vesaok

vesa3:	sub	bx,#0x8108	! This mode has no detailed info specified,
	jc	vesan		! so it must be a standard VESA mode.
	cmp	bx,#5
	jnc	vesan
	mov	ax,(bx+vesa_text_mode_table)
	mov	(di+2),ax
vesaok:	add	di,#4		! The mode is valid. Store it.
vesan:	loop	vesa1		! Next mode. Limit exceeded => error
vesae:	lea	si,vesaer
	call	prtstr
	mov	di,bp		! Discard already found modes.
vesar:	pop	gs
	ret

!
! Dimensions of standard VESA text modes
!

vesa_text_mode_table:
	db	60, 80		! 0108
	db	25, 132		! 0109
	db	43, 132		! 010A
	db	50, 132		! 010B
	db	60, 132		! 010C



!
! Scan for video modes. A bit dirty, but should work.
!

mode_scan:
	mov	cx,#0x0100	! Start with mode 0
scm1:	mov	ah,#0		! Test the mode
	mov	al,cl
	int	0x10
	mov	ah,#0x0f
	int	0x10
	cmp	al,cl
	jnz	scm2		! Mode not set
	mov	dx,#0x3c0	! Test if it's a text mode
	mov	al,#0x10		! Mode bits
	call	inidx
	and	al,#0x03
	jnz	scm2
	mov	dl,#0xce		! Another set of mode bits
	mov	al,#0x06
	call	inidx
	shr	al,#1
	jc	scm2
	mov	dl,#0xd4		! Cursor location
	mov	al,#0x0f
	call	inidx
	or	al,al
	jnz	scm2
	mov	ax,cx		! OK, store the mode
	stosw
	seg	gs		! Number of rows
	mov	al,[0x484]
	inc	al
	stosb
	seg	gs		! Number of columns
	mov	ax,[0x44a]
	stosb
scm2:	inc	cl
	jns	scm1
	mov	ax,#0x0003	! Return back to mode 3
	int	0x10
	ret

tstidx:	out	dx,ax		! OUT DX,AX and inidx
inidx:	out	dx,al		! Read from indexed VGA register
	inc	dx		! AL=index, DX=index reg port -> AL=data
	in	al,dx
	dec	dx
	ret

!
! Try to detect type of SVGA card and supply (usually approximate) video
! mode table for it.
!



svga_modes:
	lea	si,svga_table	! Test all known SVGA adapters
dosvga:	lodsw
	mov	bp,ax		! Default mode table
	or	ax,ax
	jz	didsv1
	lodsw			! Pointer to test routine
	push	si
	push	di
	push	es
	mov	bx,#0xc000
	mov	es,bx
	call	ax		! Call test routine
	pop	es
	pop	di
	pop	si
	or	bp,bp
	jz	dosvga
	mov	si,bp		! Found, copy the modes
	mov	ah,[svga_prefix]
cpsvga:	lodsb
	or	al,al
	jz	didsv
	stosw
	movsw
	jmp	cpsvga

didsv:	mov	[card_name],si	! Store pointer to card name
didsv1:	ret

!
! Table of all known SVGA cards. For each card, we store a pointer to
! a table of video modes supported by the card and a pointer to a routine
! used for testing of presence of the card. The video mode table is always
! followed by the name of the card or the chipset.
!

svga_table:
	.word	ati_md, ati_test
	.word	oak_md, oak_test
	.word	paradise_md, paradise_test
	.word	realtek_md, realtek_test
	.word	s3_md, s3_test
	.word	chips_md, chips_test
	.word	video7_md, video7_test
	.word	cirrus5_md, cirrus5_test
	.word	cirrus6_md, cirrus6_test
	.word	cirrus1_md, cirrus1_test
	.word	ahead_md, ahead_test
	.word	everex_md, everex_test
	.word	genoa_md, genoa_test
	.word	trident_md, trident_test
	.word	tseng_md, tseng_test
	.word	0

!
! Test routines and mode tables:
!

! S3 - The test algorithm was taken from the SuperProbe package
! for XFree86 1.2.1. Report bugs to Christoph.Niemann@1.org

s3_test:
	mov	cx,#0x0f35	! we store some constants in cl/ch
	mov	dx,#0x03d4
	movb	al,#0x38
	call	inidx
	mov	bh,al		! store current value of CRT-register 0x38
	mov	ax,#0x0038
	call	outidx		! disable writing to special regs
	movb	al,cl		! check whether we can write special reg 0x35
	call	inidx
	movb	bl,al		! save the current value of CRT reg 0x35
	andb	al,#0xf0	! clear bits 0-3
	movb	ah,al
	movb	al,cl		! and write it to CRT reg 0x35
	call	outidx
	call	inidx		! now read it back
	andb	al,ch		! clear the upper 4 bits
	jz	s3_2		! the first test failed. But we have a
	movb	ah,bl		! second chance
	mov	al,cl
	call	outidx
	jmp	s3_1		! do the other tests
s3_2:	mov	ax,cx		! load ah with 0xf and al with 0x35
	orb	ah,bl		! set the upper 4 bits of ah with the orig value
	call	outidx		! write ...
	call	inidx		! ... and reread 
	andb	al,cl		! turn off the upper 4 bits
	push	ax
	movb	ah,bl		! restore old value in register 0x35
	movb	al,cl
	call	outidx
	pop	ax
	cmp	al,ch		! setting lower 4 bits was successful => bad
	je	no_s3		! writing is allowed => this is not an S3
s3_1:	mov	ax,#0x4838	! allow writing to special regs by putting
	call	outidx		! magic number into CRT-register 0x38
	movb	al,cl		! check whether we can write special reg 0x35
	call	inidx
	movb	bl,al
	andb	al,#0xf0
	movb	ah,al
	movb	al,cl
	call	outidx
	call	inidx
	andb	al,ch
	jnz	no_s3		! no, we can't write => no S3
	mov	ax,cx
	orb	ah,bl
	call	outidx
	call	inidx
	andb	al,ch
	push	ax
	movb	ah,bl		! restore old value in register 0x35
	movb	al,cl
	call	outidx
	pop	ax
	cmp	al,ch
	jne	no_s31		! writing not possible => no S3
	movb	al,#0x30
	call	inidx		! now get the S3 id ...
	lea	di,idS3
	mov	cx,#0x10
	repne
	scasb
	je	no_s31
	movb	ah,bh
	movb	al,#0x38
	jmp	s3rest
no_s3:	movb	al,#0x35	! restore CRT register 0x35
	movb	ah,bl
	call	outidx
no_s31:	xor	bp,bp		! Detection failed
s3rest:	movb	ah,bh
	movb	al,#0x38	! restore old value of CRT register 0x38
	br	outidx

idS3:	.byte	0x81, 0x82, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95
	.byte	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa8, 0xb0

s3_md:	.byte	0x54, 0x2b, 0x84
	.byte	0x55, 0x19, 0x84
	.byte	0
	.ascii	"S3"
	.byte	0

! ATI cards.

ati_test:
	lea 	si,idati
	mov	di,#0x31
	mov 	cx,#0x09
	repe
	cmpsb
	je	atiok
	xor	bp,bp
atiok:	ret

idati:	.ascii	"761295520"

ati_md:	.byte	0x23, 0x19, 0x84
	.byte	0x33, 0x2c, 0x84
	.byte	0x22, 0x1e, 0x64
	.byte	0x21, 0x19, 0x64
	.byte	0x58, 0x21, 0x50
	.byte	0x5b, 0x1e, 0x50
	.byte	0
	.ascii	"ATI"
	.byte	0

! AHEAD

ahead_test:
	mov	ax,#0x200f
	mov	dx,#0x3ce
	out	dx,ax
	inc	dx
	in	al,dx
	cmp	al,#0x20
	je	isahed
	cmp	al,#0x21
	je	isahed
	xor	bp,bp
isahed:	ret

ahead_md:
	.byte	0x22, 0x2c, 0x84
	.byte	0x23, 0x19, 0x84
	.byte	0x24, 0x1c, 0x84
	.byte	0x2f, 0x32, 0xa0
	.byte	0x32, 0x22, 0x50
	.byte	0x34, 0x42, 0x50
	.byte	0
	.ascii	"Ahead"
	.byte	0

! Chips & Tech.

chips_test:
	mov	dx,#0x3c3
	in	al,dx
	or	al,#0x10
	out	dx,al
	mov	dx,#0x104		
	in	al,dx
	mov	bl,al
	mov	dx,#0x3c3
	in	al,dx
	and	al,#0xef
	out	dx,al
	cmp	bl,#0xa5
	je	cantok
	xor	bp,bp
cantok:	ret

chips_md:
	.byte	0x60, 0x19, 0x84
	.byte	0x61, 0x32, 0x84
	.byte	0
	.ascii	"Chips & Technologies"
	.byte	0

! Cirrus Logic 5X0

cirrus1_test:
	mov	dx,#0x3d4
	mov	al,#0x0c
	out	dx,al
	inc	dx
	in	al,dx
	mov	bl,al
	xor	al,al
	out	dx,al
	dec	dx
	mov	al,#0x1f
	out	dx,al
	inc	dx
	in	al,dx
	mov	bh,al
	xor	ah,ah
	shl	al,#4
	mov	cx,ax
	mov	al,bh
	shr	al,#4
	add	cx,ax
	shl	cx,#8
	add	cx,#6
	mov	ax,cx
	mov	dx,#0x3c4
	out	dx,ax
	inc	dx
	in	al,dx
	and	al,al
	jnz	nocirr
	mov	al,bh
	out	dx,al
	in	al,dx
	cmp	al,#0x01
	je	iscirr
nocirr:	xor	bp,bp
iscirr: mov	dx,#0x3d4
	mov	al,bl
	xor	ah,ah
	shl	ax,#8
	add	ax,#0x0c
	out	dx,ax
	ret

cirrus1_md:
	.byte	0x1f, 0x19, 0x84
	.byte	0x20, 0x2c, 0x84
	.byte	0x22, 0x1e, 0x84
	.byte	0x31, 0x25, 0x64
	.byte	0
	.ascii	"Cirrus Logic 5X0"
	.byte	0

! Cirrus Logic 54XX

cirrus5_test:
	mov	dx,#0x3c4
	mov	al,#6
	call	inidx
	mov	bl,al			! BL=backup
	mov	ax,#6
	call	tstidx
	cmp	al,#0x0f
	jne	c5fail
	mov	ax,#0x1206
	call	tstidx
	cmp	al,#0x12
	jne	c5fail
	mov	al,#0x1e
	call	inidx
	mov	bh,al
	mov	ah,bh
	and	ah,#0xc0
	mov	al,#0x1e
	call	tstidx
	and	al,#0x3f
	jne	c5xx
	mov	al,#0x1e
	mov	ah,bh
	or	ah,#0x3f
	call	tstidx
	xor	al,#0x3f
	and	al,#0x3f
c5xx:	pushf
	mov	al,#0x1e
	mov	ah,bh
	out	dx,ax
	popf
	je	c5done
c5fail:	xor	bp,bp
c5done:	mov	al,#6
	mov	ah,bl
	out	dx,ax
	ret

cirrus5_md:
	.byte	0x14, 0x19, 0x84
	.byte	0x54, 0x2b, 0x84
	.byte	0
	.ascii	"Cirrus Logic 54XX"
	.byte	0

! Cirrus Logic 64XX -- no known extra modes, but must be identified, because
! it's misidentified by the Ahead test.

cirrus6_test:
	mov	dx,#0x3ce
	mov	al,#0x0a
	call	inidx
	mov	bl,al			! BL=backup
	mov	ax,#0xce0a
	call	tstidx
	or	al,al
	jne	c2fail
	mov	ax,#0xec0a
	call	tstidx
	cmp	al,#0x01
	jne	c2fail
	mov	al,#0xaa
	call	inidx	! 4X, 5X, 7X and 8X are valid 64XX chip ID's
	shr	al,#4
	sub	al,#4
	jz	c6done
	dec	al
	jz	c6done
	sub	al,#2
	jz	c6done
	dec	al
	jz	c6done
c2fail:	xor	bp,bp
c6done:	mov	al,#0x0a
	mov	ah,bl
	out	dx,ax
	ret

cirrus6_md:
	.byte	0
	.ascii	"Cirrus Logic 64XX"
	.byte	0

! Everex / Trident

everex_test:
	mov	ax,#0x7000
	xor	bx,bx
	int	0x10
	cmp	al,#0x70
	jne	noevrx
	shr	dx,#4
	cmp	dx,#0x678
	je	evtrid
	cmp	dx,#0x236
	jne	evrxok
evtrid:	lea	bp,trident_md
evrxok:	ret

noevrx:	xor	bp,bp
	ret

everex_md:
	.byte	0x03, 0x22, 0x50
	.byte	0x04, 0x3c, 0x50
	.byte	0x07, 0x2b, 0x64
	.byte	0x08, 0x4b, 0x64
	.byte	0x0a, 0x19, 0x84
	.byte	0x0b, 0x2c, 0x84
	.byte	0x16, 0x1e, 0x50
	.byte	0x18, 0x1b, 0x64
	.byte	0x21, 0x40, 0xa0
	.byte	0x40, 0x1e, 0x84
	.byte	0
	.ascii	"Everex/Trident"
	.byte	0

! Genoa.

genoa_test:
	lea	si,idgenoa		! Check Genoa 'clues'
	xor 	ax,ax
	seg es
	mov	al,[0x37]
	mov	di,ax
	mov	cx,#0x04
	dec	si
	dec	di
l1:	inc	si
	inc	di
	mov	al,(si)
	test	al,al
	jz	l2
	seg es
	cmp	al,(di)
l2:	loope 	l1
	or	cx,cx
	je	isgen
	xor	bp,bp
isgen:	ret

idgenoa: .byte	0x77, 0x00, 0x99, 0x66

genoa_md:
	.byte	0x58, 0x20, 0x50
	.byte	0x5a, 0x2a, 0x64
	.byte	0x60, 0x19, 0x84
	.byte	0x61, 0x1d, 0x84
	.byte	0x62, 0x20, 0x84
	.byte	0x63, 0x2c, 0x84
	.byte	0x64, 0x3c, 0x84
	.byte	0x6b, 0x4f, 0x64
	.byte	0x72, 0x3c, 0x50
	.byte	0x74, 0x42, 0x50
	.byte	0x78, 0x4b, 0x64
	.byte	0
	.ascii	"Genoa"
	.byte	0

! OAK

oak_test:
	lea	si,idoakvga
	mov	di,#0x08
	mov	cx,#0x08
	repe
	cmpsb
	je	isoak
	xor	bp,bp
isoak:	ret

idoakvga: .ascii  "OAK VGA "

oak_md: .byte	0x4e, 0x3c, 0x50
	.byte	0x4f, 0x3c, 0x84
	.byte	0x50, 0x19, 0x84
	.byte	0x51, 0x2b, 0x84
	.byte	0
	.ascii	"OAK"
	.byte	0

! WD Paradise.

paradise_test:
	lea	si,idparadise
	mov	di,#0x7d
	mov	cx,#0x04
	repe
	cmpsb
	je	ispara
	xor	bp,bp
ispara:	ret

idparadise:	.ascii	"VGA="

paradise_md:
	.byte	0x41, 0x22, 0x50
	.byte	0x47, 0x1c, 0x84
	.byte	0x55, 0x19, 0x84
	.byte	0x54, 0x2c, 0x84
	.byte	0
	.ascii	"Paradise"
	.byte	0

! Trident.

trident_test:
	mov	dx,#0x3c4
	mov	al,#0x0e
	out	dx,al
	inc	dx
	in	al,dx
	xchg	ah,al
	xor	al,al
	out	dx,al
	in	al,dx
	xchg	al,ah
	mov	bl,al		! Strange thing ... in the book this wasn't
	and	bl,#0x02	! necessary but it worked on my card which
	jz	setb2		! is a trident. Without it the screen goes
	and	al,#0xfd	! blurred ...
	jmp	clrb2		!
setb2:	or	al,#0x02	!
clrb2:	out	dx,al
	and	ah,#0x0f
	cmp	ah,#0x02
	je	istrid
	xor	bp,bp
istrid:	ret

trident_md:
	.byte	0x50, 0x1e, 0x50
	.byte	0x51, 0x2b, 0x50
	.byte	0x52, 0x3c, 0x50
	.byte	0x57, 0x19, 0x84
	.byte	0x58, 0x1e, 0x84
	.byte	0x59, 0x2b, 0x84
	.byte	0x5a, 0x3c, 0x84
	.byte	0
	.ascii	"Trident"
	.byte	0

! Tseng.

tseng_test:
	mov	dx,#0x3cd
	in	al,dx			! Could things be this simple ! :-)
	mov	bl,al
	mov	al,#0x55
	out	dx,al
	in	al,dx
	mov	ah,al
	mov	al,bl
	out	dx,al
	cmp	ah,#0x55
 	je	istsen
isnot:	xor	bp,bp
istsen:	ret

tseng_md:
	.byte	0x26, 0x3c, 0x50
	.byte	0x2a, 0x28, 0x64
	.byte	0x23, 0x19, 0x84
	.byte	0x24, 0x1c, 0x84
	.byte	0x22, 0x2c, 0x84
	.byte	0x21, 0x3c, 0x84
	.byte	0
	.ascii	"Tseng"
	.byte	0

! Video7.

video7_test:
	mov	dx,#0x3cc
	in	al,dx
	mov	dx,#0x3b4
	and	al,#0x01
	jz	even7
	mov	dx,#0x3d4
even7:	mov	al,#0x0c
	out	dx,al
	inc	dx
	in	al,dx
	mov	bl,al
	mov	al,#0x55
	out	dx,al
	in	al,dx
	dec	dx
	mov	al,#0x1f
	out	dx,al
	inc	dx
	in	al,dx
	mov	bh,al
	dec	dx
	mov	al,#0x0c
	out	dx,al
	inc	dx
	mov	al,bl
	out	dx,al
	mov	al,#0x55
	xor	al,#0xea
	cmp	al,bh
	jne	isnot
	movb	[svga_prefix],#0x0900>>8	! Use special mode switching
	ret

video7_md:
	.byte	0x40, 0x2b, 0x50
	.byte	0x43, 0x3c, 0x50
	.byte	0x44, 0x3c, 0x64
	.byte	0x41, 0x19, 0x84
	.byte	0x42, 0x2c, 0x84
	.byte	0x45, 0x1c, 0x84
	.byte	0
	.ascii	"Video 7"
	.byte	0

! Realtek VGA

realtek_test:
	lea	si,idrtvga
	mov	di,#0x45
	mov	cx,#0x0b
	repe
	cmpsb
	je	isrt
	xor	bp,bp
isrt:	ret

idrtvga:	.ascii	"REALTEK VGA"

realtek_md:
	.byte	0x1a, 0x3c, 0x50
	.byte	0x1b, 0x19, 0x84
	.byte	0x1c, 0x1e, 0x84
	.byte	0x1d, 0x2b, 0x84
	.byte	0x1e, 0x3c, 0x84
	.byte	0
	.ascii	"REALTEK"
	.byte	0



!
! User-defined local mode table (VGA only)
!

# 1704 "video.S"


!
! Read a key and return the ASCII code in al, scan code in ah
!

getkey:	xor	ah,ah
	int	0x16
	ret

!
! Read a key with a timeout of 30 seconds. The hardware clock is used to get
! the time.
!

getkt:	call	gettime
	add	al,#30		! Wait 30 seconds
	cmp	al,#60
	jl	lminute
	sub	al,#60
lminute:
	mov	cl,al
again:	mov	ah,#0x01
	int	0x16
	jnz	getkey		! key pressed, so get it
	call	gettime
	cmp	al,cl
	jne	again
	mov	al,#0x20	! timeout, return default char `space'
	ret

!
! Flush the keyboard buffer
!

flush:	mov	ah,#0x01
	int	0x16
	jz	empty
	xor	ah,ah
	int	0x16
	jmp	flush
empty:	ret

!
! Print hexadecimal number.
!

prthw:	push	ax
	mov	al,ah
	call	prthb
	pop	ax
prthb:	push	ax
	shr	al,#4
	call	prthn
	pop	ax
	and	al,#0x0f
prthn:	cmp	al,#0x0a
	jc	prth1
	add	al,#0x07
prth1:	add	al,#0x30
	br	prtchr

!
! Print decimal number (AL).
!

prtdec:	push	ax
	push	cx
	xor	ah,ah		! Clear ah
	mov	cl,#0x0a
	idiv	cl
	cmp	al,#0x09
	jbe	lt100
	call	prtdec
	jmp	skip10
lt100:	add	al,#0x30
	call	prtchr
skip10:	mov	al,ah
	add	al,#0x30
	call	prtchr	
	pop	cx
	pop	ax
	ret

!
! VIDEO_SELECT-only variables
!

mt_end:		.word	0	! End of video mode table if built
edit_buf:	.space	6	! Line editor buffer
card_name:	.word	0	! Pointer to adapter name
scanning:	.byte	0	! Performing mode scan
do_restore:	.byte	0	! Screen contents altered during mode change
svga_prefix:	.byte	0x0100>>8	! Default prefix for BIOS modes

!
! Messages:
!

keymsg:		.ascii	"Press <RETURN> to see video modes available, "
		.ascii	"<SPACE> to continue or wait 30 secs"
		db	0x0d, 0x0a, 0
listhdr:	db	0x0d, 0x0a
		.ascii	"Mode:    COLSxROWS:"
crlft:		db	0x0d, 0x0a, 0
prompt:		db	0x0d, 0x0a
		.ascii	"Enter mode number: "
		db	0
unknt:		.ascii	"Unknown mode ID. Try again."
		db	0
badmdt:		.ascii	"You passed an undefined mode number to setup."
		db	0x0d, 0x0a, 0
vesaer:		.ascii	"Error: Scanning of VESA modes failed. Please "
		.ascii	"report to <mj@k332.feld.cvut.cz>."
		db	0x0d, 0x0a, 0
old_name:	.ascii	"CGA/MDA/HGA"
		db	0
ega_name:	.ascii	"EGA"
		db	0
svga_name:	.ascii	" "
vga_name:	.ascii	"VGA"
		db	0
vesa_name:	.ascii	"VESA"
		db	0
name_bann:	.ascii	"Video adapter: "
		db	0



!
! Other variables:
!

adapter:	.byte	0	! Video adapter: 0=CGA/MDA/HGA,1=EGA,2=VGA
video_segment:	.word	0xb800	! Video memory segment
force_size:	.word	0	! Use this size instead of the one in BIOS vars
# 766 "setup.S" 2


!
! Setup signature -- must be last
!

setup_sig1:	.word	0xAA55
setup_sig2:	.word	0x5A5A

!
! After this point, there is some free space which is used by the video mode
! handling code to store the temporary mode table (not used by the kernel).
!

modelist:

.text
endtext:
.data
enddata:
.bss
endbss:
