

#include <linux/ioctl.h>
#include <linux/sockios.h>
#include <linux/socket.h>
#include <linux/if.h>
#include <linux/stddef.h>
#include "BIND/include/arpa/inet.h"
#include <errno.h>
#include <stdio.h>
#include <netdb.h>

#include "net/tc_global.h"
/* global variables */
int kern_socket = -1;

int 
get_interface_names()
{
   char          ifbuf[5000];
   struct ifreq *ifr;
   struct ifconf ifc;
   int           cnt = 1;
   char         *cifr, *cifrlim, *res;
   
   ifc.ifc_buf = ifbuf;
   ifc.ifc_len = sizeof(ifbuf);
   if (ioctl(kern_socket, SIOCGIFCONF, (char *) &ifc) < 0) {
      printf("ioctl SIOCGIFCONF %i \n",errno);
      exit(1);
   }

   ifr = ifc.ifc_req;
   cifr = (char *)ifr;
   cifrlim = cifr + ifc.ifc_len;
   
   while(cifr < cifrlim) {
      if (!strcmp(ifr->ifr_name, "lo0"))
	 goto eek;
      if (ifr->ifr_addr.sa_family != AF_INET)
	 goto eek;
      printf("name: %s \n", ifr->ifr_name);
      
eek:
      cifr += sizeof(struct ifreq);
      ifr = (struct ifreq *)cifr;
   }
   return (0);
}

long gethostaddr(name)
char *name;
{
        unsigned long   addr;
        register struct hostent *hp;
 
        if ((addr = inet_addr (name)) != -1)
                return (addr);
 
        hp = (struct hostent *)gethostbyname(name);
        if (hp != NULL)
                return (*(long *) hp->h_addr);
        else
                return (0);
}

void 
main(int argc, char *argv[])
{
   
   int error = 0;
   struct tcreq *tc;
   struct ifreq ifr;
   int cnt;
  
   
   if ((kern_socket = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
      printf("fehler\n");
      exit(-1);
   }
   error = get_interface_names(); 
   
   tc = (struct tcreq *) malloc (sizeof(struct tcreq));
   tc->iq_function = atoi(argv[2]);
   switch (tc->iq_function) {
   case IF_ENABLE:
      printf("IF_ENABLE\n");
      break;
   case IF_DISABLE:
      printf("IF_DISABLE\n");
      break;
   case IF_ADDSHARE:
      printf("IF_ADDSHARE\n");
      break;
   case IF_ADDFLOW:
      printf("IF_ADDFLOW\n");
      break;
   case IF_DELFLOW:
      printf("IF_DELFLOW\n");
      break;
   case IF_ADDFILT:
      printf("IF_ADDFILT\n");
      break;
   case IF_DELFILT:
      printf("IF_DELFILT\n");
      break;
   case IF_ASKSTATE:
      printf("IF_ASKSTATE\n");
      break;
   default:
      printf("unknown command\n");
   }
      
   tc->iq_flags = atoi(argv[3]);
   switch (tc->iq_flags) {
   case TC_CBQ:
      printf("TC_CBQ\n");
      break;
   case TC_WFQ:
      printf("TC_WFQ\n");
      break;
   case TC_TEST:
      printf("TC_TEST\n");
      break;
   default:
      printf("unknown scheduler\n");
   }
   
   if ((tc->iq_function == IF_ADDSHARE) && (tc->iq_flags == TC_CBQ)) {
      tc->iq_clval.tc_prio = atoi(argv[4]);
      printf("ADDSHARE: Priority = %d\n", tc->iq_clval.tc_prio);
      tc->iq_clval.tc_bandwidth = atoi(argv[5]);
      printf("ADDSHARE: Bandwidth in b/s = %d\n", tc->iq_clval.tc_bandwidth);
   }
      
   if ((tc->iq_function == IF_ADDFLOW) && (tc->iq_flags == TC_CBQ)) {
      tc->iq_fs.fs_tos = atoi(argv[4]);
      printf("ADDFLOW: TOS = %d\n", tc->iq_clval.tc_prio);
      tc->iq_fs.fs_tspec.ts_tb.tbf_rate = atoi(argv[5]);
      printf("ADDFLOW: Rate = %d\n",tc->iq_fs.fs_tspec.ts_tb.tbf_rate);
      tc->iq_fs.fs_rspec.rs_p.p_dly = atoi(argv[6]);
      printf("ADDFLOW: Delay = %d\n", tc->iq_fs.fs_rspec.rs_p.p_dly);
      tc->iq_fs.fs_tspec.ts_tb.tbf_bkt = atoi(argv[7]);
      printf("ADDFLOW: Burst = %d\n",tc->iq_fs.fs_tspec.ts_tb.tbf_bkt);
      tc->iq_fs.fs_tspec.ts_tb.tbf_bkt = 10;
   }
   if ((tc->iq_function == IF_ADDFILT) || (tc->iq_function == IF_DELFILT)) {
     switch (atoi(argv[4])) {
     case 4:
       tc->iq_filt.f_pf=PF_INET;
       if ((tc->iq_function == IF_ADDFILT) && (tc->iq_flags == TC_CBQ)) {      
	 tc->iq_filt.f_ipv4_srcaddr = gethostaddr(argv[5]);
	 printf("ADDFILT: saddr = %d\n", tc->iq_filt.f_ipv4_srcaddr);
	 tc->iq_filt.f_ipv4_destaddr = gethostaddr(argv[6]);
	 printf("ADDFILT: daddr = %d\n", tc->iq_filt.f_ipv4_destaddr);
	 tc->iq_filt.f_ipv4_srcport = htons(atoi(argv[7]));
	 tc->iq_filt.f_ipv4_destport = htons(atoi(argv[8]));
	 printf("ADDFILT: ports = s=%d d=%d\n",tc->iq_filt.f_ipv4_srcport, tc->iq_filt.f_ipv4_destport );
	 tc->iq_handle = atoi(argv[9]);
	 printf("ADDFILT: filter handle=%d\n",tc->iq_handle);
       }      
       if ((tc->iq_function == IF_DELFILT) && (tc->iq_flags == TC_CBQ)) {      
	 tc->iq_filt.f_ipv4_srcaddr = gethostaddr(argv[5]);
	 printf("DELFILT: saddr = %d\n", tc->iq_filt.f_ipv4_srcaddr);
	 tc->iq_filt.f_ipv4_destaddr = gethostaddr(argv[6]);
	 printf("DELFILT: daddr = %d\n", tc->iq_filt.f_ipv4_destaddr);
	 tc->iq_filt.f_ipv4_srcport = htons(atoi(argv[7]));
	 tc->iq_filt.f_ipv4_destport = htons(atoi(argv[8]));
	 printf("DELFILT: ports = s=%d d=%d\n",tc->iq_filt.f_ipv4_srcport, tc->iq_filt.f_ipv4_destport );
	 tc->iq_handle = atoi(argv[9]);
	 printf("DELFILT: filter handle=%d\n",tc->iq_handle);
       }
       break;
     case 6:
       tc->iq_filt.f_pf=PF_INET6;
       if ((tc->iq_function == IF_ADDFILT) && (tc->iq_flags == TC_CBQ)) {   	 
         inet_pton(AF_INET6,argv[5],&(tc->iq_filt.f_ipv6_srcaddr));
	 inet_pton(AF_INET6,argv[6],&(tc->iq_filt.f_ipv6_destaddr));
	 printf ("-- Flow Id set to Zero --\n");
	 tc->iq_filt.f_ipv6_vrprflow=(__u32) 0x60;
	 tc->iq_handle = atoi(argv[7]);
	 printf("ADDFILT(6): filter handle=%d\n",tc->iq_handle);
       }                   
       if ((tc->iq_function == IF_DELFILT) && (tc->iq_flags == TC_CBQ)) {   	 
         inet_pton(AF_INET6,argv[5],&(tc->iq_filt.f_ipv6_srcaddr));
	 inet_pton(AF_INET6,argv[6],&(tc->iq_filt.f_ipv6_destaddr));
	 printf ("-- Flow Id set to Zero --\n");
	 tc->iq_filt.f_ipv6_vrprflow=(__u32) 0x60;
	 tc->iq_handle = atoi(argv[7]);
	 printf("DELFILT(6): filter handle=%d\n",tc->iq_handle);
       }     
       break;
     default:
       printf ("IPv%d does not exist !!\n",atoi(argv[4]));
       return;
       break;
     }
   }
   memset(&ifr, 0, sizeof(struct ifreq));
   
   strncpy( ifr.ifr_name, argv[1], sizeof(argv[1]));
   strncpy( tc->iq_name , argv[1], sizeof(argv[1]));
   ifr.ifr_data = tc;

   printf("sock %d  name %s  len %d\n",kern_socket,ifr.ifr_name,sizeof(ifr.ifr_name));

   if (error = ioctl(kern_socket,SIOCSIFTC, &ifr) < 0) {
      printf("fehler isps ioctl %d %d\n", errno, error);
      exit(0);
   }
   
   printf(" Ende!\n");
}
   
   






