
#ifndef EBDHDL
/* should be in <sys/errno.h>.
 * Note that TC system calls may also return other unix error codes.
 * Notably, EINVAL indicates an invalid parameter or non-isps interface
 */
#define ETCBASE	130		/* fraudulent error		*/
/* These indicate errors in the caller's use of TC */
#define EBDHDL          ETCBASE+0     /* bad handle			*/
#define EEXCLS          ETCBASE+1     /* class already exists		*/
#define ENOCLS          ETCBASE+2     /* no such class		*/
#define ENOTMT          ETCBASE+3     /* class still has flows	*/
/* These indicate admission control errors */
#define EDELAY          ETCBASE+4     /* delay bound violation	*/
#define ENOBWD          ETCBASE+5     /* insufficient bandwidth	*/
/* These indicate that the caller made a potentially valid request
   which this implementation of TC does not support (currently
   EBADFILT will be returned for -any- unsupported filter, potentially
   legal or not. sorry.. */
#define EBADRSPEC	ETCBASE+6	/* illegal RSPEC param		*/
#define EBADTSPEC	ETCBASE+7	/* illegal TSPEC param		*/
#define EBADFILT	ETCBASE+8	/* illegal filter		*/
#define ETCMAX	EBADFILT
#endif
