#ifndef	__rsvp_trans_h__
#define	__rsvp_trans_h__

/*
 * @(#) $Id: rsvp_trans.h,v 4.11 1997/11/20 17:07:10 lindell Exp $
 */

/*********************** rsvp_trans.h ********************************
 *                                                                   *
 *    System Independent Interface to Network and Transport Layers   *
 *                                                                   *
 *********************************************************************/

/****************************************************************************

            RSVPD -- ReSerVation Protocol Daemon

                USC Information Sciences Institute
                Marina del Rey, California

		Original Version: Shai Herzog, Nov. 1993.
		Current Version:  Bob Lindell, July 1997.

  Copyright (c) 1997 by the University of Southern California
  All rights reserved.

  Permission to use, copy, modify, and distribute this software and its
  documentation in source and binary forms for any purpose and without
  fee is hereby granted, provided that both the above copyright notice
  and this permission notice appear in all copies, and that any
  documentation, advertising materials, and other materials related to
  such distribution and use acknowledge that the software was developed
  in part by the University of Southern California, Information
  Sciences Institute.  The name of the University may not be used to
  endorse or promote products derived from this software without
  specific prior written permission.

  THE UNIVERSITY OF SOUTHERN CALIFORNIA makes no representations about
  the suitability of this software for any purpose.  THIS SOFTWARE IS
  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  Other copyrights might apply to parts of this software and are so
  noted when applicable.

********************************************************************/

#ifdef	USE_IPV6
extern int net_init(int pu,int pup,struct in_addr *g,struct in6_addr *g6,
	int async);
#else	/* USE_IPV6 */
extern int net_init(int pu,int pup,struct in_addr *g,int async);
#endif	/* USE_IPV6 */
extern int net_init_udp_only(net_addr *);
extern int net_final();
extern int net_send(net_addr *to,net_addr *from,void *msg,
	int len,net_if *inf,u_char hops,int ra);
extern int net_recv(net_addr *from,void *msg,int len,net_if *inf);
extern int net_add_interfaces(int n,net_if *inf);
extern int net_del_interfaces(int n,net_if *inf);
extern int net_poll_list(fd_set *);
extern int net_has_rawmode();

/*
 *	User supplied error handling function.
 */

typedef enum {
	NET_ERROR_SYSTEM,
	NET_ERROR_USER,
} net_error_type;

extern void net_error(net_error_type,char *);

#endif	/* __rsvp_trans_h__ */
