/*
 * @(#) $Id: rsvp_objs2.c,v 4.2 1997/09/15 19:48:05 lindell Exp $
 */

/************************ rsvp_objs.c ********************************
 *                                                                   *
 *    Protocol Independent RSVP Object Manipulation                  *
 *                                                                   *
 *********************************************************************/

/****************************************************************************

            RSVPD -- ReSerVation Protocol Daemon

                USC Information Sciences Institute
                Marina del Rey, California

		Original Version: Shai Herzog, Nov. 1993.
		Current Version:  Bob Lindell, July 1997.

  Copyright (c) 1997 by the University of Southern California
  All rights reserved.

  Permission to use, copy, modify, and distribute this software and its
  documentation in source and binary forms for any purpose and without
  fee is hereby granted, provided that both the above copyright notice
  and this permission notice appear in all copies, and that any
  documentation, advertising materials, and other materials related to
  such distribution and use acknowledge that the software was developed
  in part by the University of Southern California, Information
  Sciences Institute.  The name of the University may not be used to
  endorse or promote products derived from this software without
  specific prior written permission.

  THE UNIVERSITY OF SOUTHERN CALIFORNIA makes no representations about
  the suitability of this software for any purpose.  THIS SOFTWARE IS
  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  Other copyrights might apply to parts of this software and are so
  noted when applicable.

********************************************************************/

#include "rsvp_daemon.h"
#include "rsvp_api.h"

int
session_if(SESSION *session)
{
	net_addr addr;

	if (Obj_Class(session) != class_SESSION)
		return(-1);
	switch(Obj_CType(session)) {
		case ctype_SESSION_ipv4:
		case ctype_SESSION_ipv4GPI:
			NET_SET_ADDR_IPv4(&addr,session->sess4_addr);
			return(map_if(&addr));
#ifdef	USE_IPV6
		case ctype_SESSION_ipv6:
		case ctype_SESSION_ipv6GPI:
			NET_SET_ADDR_IPv6(&addr,session->sess6_addr);
			return(map_if(&addr));
#endif	/* USE_IPV6 */
		default:
			return(-1);
	}
}

int
confirm_if(CONFIRM *confirm)
{
	net_addr addr;

	if (Obj_Class(confirm) != class_CONFIRM)
		return(0);
	switch(Obj_CType(confirm)) {
		case ctype_CONFIRM_ipv4:
			NET_SET_ADDR_IPv4(&addr,confirm->conf4_addr);
			return(map_if(&addr));
#ifdef	USE_IPV6
		case ctype_CONFIRM_ipv6:
			NET_SET_ADDR_IPv6(&addr,confirm->conf6_addr);
			return(map_if(&addr));
#endif	/* USE_IPV6 */
		default:
			return(0);
	}
}
