#ifndef	__rsvp_objs_h__
#define	__rsvp_objs_h__

/*
 * @(#) $Id: rsvp_objs.h,v 4.3 1997/10/07 00:15:31 lindell Exp $
 */

/************************ rsvp_objs.h ********************************
 *                                                                   *
 *    Protocol Independent RSVP Object Manipulation                  *
 *                                                                   *
 *********************************************************************/

/****************************************************************************

            RSVPD -- ReSerVation Protocol Daemon

                USC Information Sciences Institute
                Marina del Rey, California

		Original Version: Shai Herzog, Nov. 1993.
		Current Version:  Bob Lindell, July 1997.

  Copyright (c) 1997 by the University of Southern California
  All rights reserved.

  Permission to use, copy, modify, and distribute this software and its
  documentation in source and binary forms for any purpose and without
  fee is hereby granted, provided that both the above copyright notice
  and this permission notice appear in all copies, and that any
  documentation, advertising materials, and other materials related to
  such distribution and use acknowledge that the software was developed
  in part by the University of Southern California, Information
  Sciences Institute.  The name of the University may not be used to
  endorse or promote products derived from this software without
  specific prior written permission.

  THE UNIVERSITY OF SOUTHERN CALIFORNIA makes no representations about
  the suitability of this software for any purpose.  THIS SOFTWARE IS
  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  Other copyrights might apply to parts of this software and are so
  noted when applicable.

********************************************************************/

extern char * hop_print(RSVP_HOP *hop);
extern int hop_lih(RSVP_HOP *hop);
extern int hop_eq(RSVP_HOP *hop1,RSVP_HOP *hop2);
extern int hop_addr_eq(RSVP_HOP *hop1,RSVP_HOP *hop2);
extern int hop_addr_lt(RSVP_HOP *hop1,RSVP_HOP *hop2);
extern int hop_if_assign(RSVP_HOP *hop,net_if *inf,int lih);
extern int hop_if_create(RSVP_HOP *hop,net_if *inf,int lih);
extern int hop_confirm_assign(RSVP_HOP *hop,CONFIRM *confirm);
extern int hop_in_scope(RSVP_HOP *hop,SCOPE *scope);
extern net_addr * hop_addr(RSVP_HOP *hop);

extern char * session_print(SESSION *session);
extern int session_multicast(SESSION *session);
extern int session_if(SESSION *session);
extern int session_eq(SESSION *session1,SESSION *session2);
extern int session_eq_except_flags(SESSION *session1,SESSION *session2);
extern int session_eq_except_port(SESSION *session1,SESSION *session2);
extern int session_if_eq(SESSION *session,net_if *inf);
extern u_int16_t session_get_port(SESSION *session);
extern int session_set_port(SESSION *session,u_int16_t port);
extern u_char session_get_flags(SESSION *session);
extern int session_set_flags(SESSION *session,u_char flags);
extern net_addr * session_addr(SESSION *session);
extern int session_create(SESSION *session,net_addr *addr,u_char protid,
	u_char flags,int gpi);


extern int confirm_if(CONFIRM *confirm);
extern int confirm_if_create(CONFIRM *confirm,net_if *inf);

extern u_char errorspec_get_errcode(ERROR_SPEC *errorspec);
extern int errorspec_set_errcode(ERROR_SPEC *errorspec,u_char code);
extern u_char errorspec_get_errflags(ERROR_SPEC *errorspec);
extern int errorspec_set_errflags(ERROR_SPEC *errorspec,u_char flags);
extern ERROR_SPEC * errorspec_create(net_if *inf,u_char code,
	u_int16_t value,u_char flags);

extern int filterspec_eq(FILTER_SPEC *filterspec1,FILTER_SPEC *filterspec2);
extern int filterspec_lt(FILTER_SPEC *filterspec1,FILTER_SPEC *filterspec2);
extern int filterspec_in_scope(FILTER_SPEC *filterspec,SCOPE *scope);
extern net_addr * filterspec_addr(FILTER_SPEC *filterspec);
extern u_int32_t filterspec_port(FILTER_SPEC *filterspec);


#endif	/* __rsvp_objs_h__ */
