
/*
 * @(#) $Id: rsvp_global.h,v 4.5 1997/12/09 23:53:38 lindell Exp $
 */
/****************************************************************************

            RSVPD -- ReSerVation Protocol Daemon

                USC Information Sciences Institute
                Marina del Rey, California

		Original Version: Shai Herzog, Nov. 1993.
		Current Version:  Steven Berson & Bob Braden,  May 1996.

  Copyright (c) 1996 by the University of Southern California
  All rights reserved.

  Permission to use, copy, modify, and distribute this software and its
  documentation in source and binary forms for any purpose and without
  fee is hereby granted, provided that both the above copyright notice
  and this permission notice appear in all copies. and that any
  documentation, advertising materials, and other materials related to
  such distribution and use acknowledge that the software was developed
  in part by the University of Southern California, Information
  Sciences Institute.  The name of the University may not be used to
  endorse or promote products derived from this software without
  specific prior written permission.
	    
  THE UNIVERSITY OF SOUTHERN CALIFORNIA makes no representations about
  the suitability of this software for any purpose.  THIS SOFTWARE IS
  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  Other copyrights might apply to parts of this software and are so
  noted when applicable.

********************************************************************/

#ifndef __rsvp_global_h__
#define __rsvp_global_h__

#ifdef __MAIN__

/*	DEFINE GLOBAL VALUES IN rsvp_main.c
 *
 */

int			 api_num;	/* LIH of the API */
int			 if_num;	/* number of phyints */
if_rec			*if_vec;	/* ptr to table of phyints */
int			 vif_num;	/* number of vifs */
int			local_v4 = -1;
int			local_v6 = -1;

int			 num_sessions;
Session			*session_hash[SESS_HASH_SIZE];
					/* Hash table to locate session */

api_rec			 api_table[API_TABLE_SIZE];
					/* Per-session API state */

int			 rsvp_errno;	/* error code -- used to communicate
					 *	error from kernel interface
					 */
int			 Max_rsvp_msg;	/* Largest RSVP message */
int			 debug;		/* Debug output control bits */
int			 l_debug;	/* Logging severity level */
FILE			*logfp;		/* Log file pointer */
char			*Log_Event_Cause = NULL;
					/* string to identify reason for
					 * initiation of event
					 */
	/* Control flags */
int			NoMroute;
int			NoUnicast;


#else			/* an extern shadow of those vars */

extern int		 vif_num;
extern int		 if_num;
extern int		 api_num;
extern int		local_v4;
extern int		local_v6;
extern if_rec		*if_vec;
extern int		 rsvp_errno;
extern Session		*session_hash[SESS_HASH_SIZE];
extern api_rec		 api_table[API_TABLE_SIZE];
extern int		 num_sessions;
extern int		 Max_rsvp_msg;
extern int		 debug, l_debug;
extern FILE		*logfp;
extern char		*Log_Event_Cause;
extern int		 NoMroute;
extern int		 NoUnicast;

#endif	/* __MAIN__ */

extern u_long   time_now;	/* defined in rsvp_timer.c */
extern net_addr api_addr;
extern KEY_ASSOC	 key_assoc_table[KEY_TABLE_SIZE];
extern int		 Key_Assoc_Max;

#endif	/* __rsvp_global_h__ */
