/*
 *  @(#) $Id: filter.c,v 1.2 1997/09/15 19:47:22 lindell Exp $
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "rsvp_daemon.h"
#include "rapi_lib.h"
#include "rsvp_api.h"	/* To define management interface */
#include "rapi_err.h"	/* for rapi_errlist[] */

extern rapi_sid_t rapi_rsvp_cmd(rapi_cmd_t *, int *);

char *usage = "Usage:\t%s on\n\t%s off\n\t%s [[+/-]address] ...\n";

int
modify_filters(char *ap) {
	rapi_cmd_t	cmd = {2, RAPI_CMD_ADD_FILTER, 0, {0}};
	int err;

	if (*ap == '-') {
		cmd.rapi_cmd_type = RAPI_CMD_DEL_FILTER;
		ap++;
	} else if (*ap == '+')
		ap++;
	if ((cmd.rapi_data[0] = inet_addr(ap)) == -1) {
		printf("Malformed address: %s\n", ap);
		return(-1);
	}
	rapi_rsvp_cmd(&cmd, &err);
	printf("Adding debug filter %s\n", ap);
	if (err != RAPI_ERR_OK) {
		printf("RAPI error: %s\n", rapi_errlist[err]);
		return(-1);
	}
	return(0);
}

int set_filter_status(int code) {
	int	err;
	rapi_cmd_t	cmd = {1, code, 0, {0}};

	rapi_rsvp_cmd(&cmd, &err);
	if (err != RAPI_ERR_OK) {
		printf("RAPI error: %s\n", rapi_errlist[err]);
		return(-1);
	}
	return(0);
}

int
filteron() {
	printf("Changing debug filter to: ON\n");
	set_filter_status(RAPI_CMD_FILTER_ON);
	return(1);
}

int
filteroff() {
	printf("Changing debug filter to: OFF\n");
	set_filter_status(RAPI_CMD_FILTER_OFF);
	return(1);
}

int
main(int argc, char *argv[]) {
	if (argc == 1) {
		printf(usage, *argv, *argv, *argv);
		return(0);
	} else if (argc == 2) {
		if (strcmp(argv[1], "on") == 0) {
			filteron();
			return(0);
		} else if (strcmp(argv[1], "off") == 0) {
			filteroff();
			return(0);
		}
	}
	while (--argc)
		(void) modify_filters(*++argv);
	return(0);
}
