 /*
 * Project       : ipv6calc
 * File          : dbipv4_assignment.h
 * Version       : $Id: dbipv4addr_assignment.h,v 1.52 2012/01/21 14:08:53 peter Exp $
 * Generated     : Sat Jan 21 15:04:21 2012
 * Data copyright: RIPE NCC, APNIC, ARIN, LACNIC, AFRINIC
 *
 * Information:
 *  Additional header file for libipv4addr.c
 */

static const char* dbipv4addr_registry_status = "AFRINIC/20120121 APNIC/20120120 ARIN/20120120 IANA/20110203 LACNIC/20120120 RIPENCC/20120120";

static const s_ipv4addr_assignment dbipv4addr_assignment[] = {
	{ 0x00000000, 0xff000000,  8, "IANA" },
	{ 0x01000000, 0xff000000,  8, "APNIC" },
	{ 0x02000000, 0xff000000,  8, "RIPENCC" },
	{ 0x03000000, 0xff000000,  8, "ARIN" },
	{ 0x04000000, 0xff000000,  8, "ARIN" },
	{ 0x05000000, 0xff000000,  8, "RIPENCC" },
	{ 0x06000000, 0xfe000000,  7, "ARIN" },
	{ 0x08000000, 0xfe000000,  7, "ARIN" },
	{ 0x0a000000, 0xff000000,  8, "IANA" },
	{ 0x0b000000, 0xff000000,  8, "ARIN" },
	{ 0x0c000000, 0xfe000000,  7, "ARIN" },
	{ 0x0e000000, 0xff000000,  8, "APNIC" },
	{ 0x0f000000, 0xff000000,  8, "ARIN" },
	{ 0x10000000, 0xf8000000,  5, "ARIN" },
	{ 0x18000000, 0xfe000000,  7, "ARIN" },
	{ 0x18840000, 0xffff0000, 16, "RIPENCC" },
	{ 0x18e80000, 0xffff0000, 16, "LACNIC" },
	{ 0x19000000, 0xff000000,  8, "RIPENCC" },
	{ 0x1a000000, 0xff000000,  8, "ARIN" },
	{ 0x1b000000, 0xff000000,  8, "APNIC" },
	{ 0x1c000000, 0xfe000000,  7, "ARIN" },
	{ 0x1e000000, 0xff000000,  8, "ARIN" },
	{ 0x1f000000, 0xff000000,  8, "RIPENCC" },
	{ 0x20000000, 0xfc000000,  6, "ARIN" },
	{ 0x24000000, 0xff000000,  8, "APNIC" },
	{ 0x25000000, 0xff000000,  8, "RIPENCC" },
	{ 0x26000000, 0xff000000,  8, "ARIN" },
	{ 0x27000000, 0xff000000,  8, "APNIC" },
	{ 0x28000000, 0xff000000,  8, "ARIN" },
	{ 0x29000000, 0xff000000,  8, "AFRINIC" },
	{ 0x2a000000, 0xff000000,  8, "APNIC" },
	{ 0x2b000000, 0xff000000,  8, "ARIN" },
	{ 0x2b800000, 0xffc00000, 10, "APNIC" },
	{ 0x2bc00000, 0xffe00000, 11, "APNIC" },
	{ 0x2be80000, 0xfffc0000, 14, "APNIC" },
	{ 0x2bf40000, 0xffff0000, 16, "APNIC" },
	{ 0x2bfd0000, 0xffff0000, 16, "APNIC" },
	{ 0x2c000000, 0xfe000000,  7, "ARIN" },
	{ 0x2e000000, 0xff000000,  8, "RIPENCC" },
	{ 0x2f000000, 0xff000000,  8, "ARIN" },
	{ 0x30000000, 0xff000000,  8, "ARIN" },
	{ 0x31000000, 0xff000000,  8, "APNIC" },
	{ 0x32000000, 0xfe000000,  7, "ARIN" },
	{ 0x33000000, 0xff000000,  8, "RIPENCC" },
	{ 0x34000000, 0xfc000000,  6, "ARIN" },
	{ 0x38000000, 0xfe000000,  7, "ARIN" },
	{ 0x3a000000, 0xfe000000,  7, "APNIC" },
	{ 0x3c000000, 0xfe000000,  7, "APNIC" },
	{ 0x3e000000, 0xff000000,  8, "RIPENCC" },
	{ 0x3e084000, 0xffffe000, 19, "AFRINIC" },
	{ 0x3e0c6000, 0xffffe000, 19, "AFRINIC" },
	{ 0x3e186000, 0xffffe000, 19, "AFRINIC" },
	{ 0x3e442000, 0xffffe000, 19, "AFRINIC" },
	{ 0x3e44e000, 0xffffe000, 19, "AFRINIC" },
	{ 0x3e720000, 0xffff0000, 16, "AFRINIC" },
	{ 0x3e752000, 0xffffe000, 19, "AFRINIC" },
	{ 0x3e870000, 0xffff8000, 17, "AFRINIC" },
	{ 0x3e8b0000, 0xffff0000, 16, "AFRINIC" },
	{ 0x3e8c4000, 0xffffc000, 18, "AFRINIC" },
	{ 0x3ead2000, 0xffffe000, 19, "AFRINIC" },
	{ 0x3ec14000, 0xffffc000, 18, "AFRINIC" },
	{ 0x3ec1a000, 0xffffe000, 19, "AFRINIC" },
	{ 0x3ef02000, 0xffffe000, 19, "AFRINIC" },
	{ 0x3ef06000, 0xffffe000, 19, "AFRINIC" },
	{ 0x3ef18000, 0xffffe000, 19, "AFRINIC" },
	{ 0x3efb8000, 0xffff8000, 17, "AFRINIC" },
	{ 0x3f000000, 0xff000000,  8, "ARIN" },
	{ 0x40000000, 0xf8000000,  5, "ARIN" },
	{ 0x401c8000, 0xfffff000, 20, "LACNIC" },
	{ 0x40204000, 0xffffc000, 18, "LACNIC" },
	{ 0x40397000, 0xfffff000, 20, "AFRINIC" },
	{ 0x42080000, 0xffff8000, 17, "AFRINIC" },
	{ 0x42124000, 0xffffe000, 19, "AFRINIC" },
	{ 0x423c0000, 0xffffc000, 18, "LACNIC" },
	{ 0x42620000, 0xffffc000, 18, "LACNIC" },
	{ 0x42624000, 0xffffe000, 19, "LACNIC" },
	{ 0x42e74000, 0xfffff000, 20, "LACNIC" },
	{ 0x453f4000, 0xfffff000, 20, "AFRINIC" },
	{ 0x45432000, 0xfffff000, 20, "AFRINIC" },
	{ 0x48000000, 0xfc000000,  6, "ARIN" },
	{ 0x4c000000, 0xff000000,  8, "ARIN" },
	{ 0x4d000000, 0xff000000,  8, "RIPENCC" },
	{ 0x4ddc0000, 0xffffe000, 19, "AFRINIC" },
	{ 0x4e000000, 0xfe000000,  7, "RIPENCC" },
	{ 0x50000000, 0xf0000000,  4, "RIPENCC" },
	{ 0x50486000, 0xfffff000, 20, "AFRINIC" },
	{ 0x504ba000, 0xffffe000, 19, "AFRINIC" },
	{ 0x50574000, 0xffffe000, 19, "AFRINIC" },
	{ 0x50580c00, 0xfffffc00, 22, "AFRINIC" },
	{ 0x50f0c000, 0xfffff000, 20, "AFRINIC" },
	{ 0x50f60000, 0xfffff000, 20, "AFRINIC" },
	{ 0x50f80000, 0xfffff000, 20, "AFRINIC" },
	{ 0x50f84000, 0xfffff000, 20, "AFRINIC" },
	{ 0x50f94000, 0xfffff000, 20, "AFRINIC" },
	{ 0x50fa2000, 0xfffff000, 20, "AFRINIC" },
	{ 0x51040000, 0xffffc000, 18, "AFRINIC" },
	{ 0x510a0000, 0xffff8000, 17, "AFRINIC" },
	{ 0x51156000, 0xfffff000, 20, "AFRINIC" },
	{ 0x51164000, 0xffffe000, 19, "AFRINIC" },
	{ 0x511a4000, 0xfffff000, 20, "AFRINIC" },
	{ 0x511d6000, 0xfffff000, 20, "AFRINIC" },
	{ 0x515be000, 0xfffff000, 20, "AFRINIC" },
	{ 0x51c00000, 0xffff0000, 16, "AFRINIC" },
	{ 0x52658000, 0xffffc000, 18, "AFRINIC" },
	{ 0x52800000, 0xffff8000, 17, "AFRINIC" },
	{ 0x52818000, 0xffff8000, 17, "AFRINIC" },
	{ 0x52974000, 0xffffe000, 19, "AFRINIC" },
	{ 0x52c98000, 0xffff8000, 17, "AFRINIC" },
	{ 0x538f1800, 0xfffff800, 21, "AFRINIC" },
	{ 0x54240000, 0xffff0000, 16, "AFRINIC" },
	{ 0x54cd6000, 0xffffe000, 19, "AFRINIC" },
	{ 0x54e90000, 0xffff8000, 17, "AFRINIC" },
	{ 0x57ff6000, 0xffffe000, 19, "AFRINIC" },
	{ 0x60000000, 0xfc000000,  6, "ARIN" },
	{ 0x64000000, 0xff000000,  8, "ARIN" },
	{ 0x65000000, 0xff000000,  8, "APNIC" },
	{ 0x66000000, 0xff000000,  8, "AFRINIC" },
	{ 0x67000000, 0xff000000,  8, "APNIC" },
	{ 0x68000000, 0xff000000,  8, "ARIN" },
	{ 0x69000000, 0xff000000,  8, "AFRINIC" },
	{ 0x6a000000, 0xff000000,  8, "APNIC" },
	{ 0x6b000000, 0xff000000,  8, "ARIN" },
	{ 0x6c000000, 0xff000000,  8, "ARIN" },
	{ 0x6d000000, 0xff000000,  8, "RIPENCC" },
	{ 0x6e000000, 0xfe000000,  7, "APNIC" },
	{ 0x70000000, 0xf8000000,  5, "APNIC" },
	{ 0x78000000, 0xfc000000,  6, "APNIC" },
	{ 0x7c000000, 0xfe000000,  7, "APNIC" },
	{ 0x7e000000, 0xff000000,  8, "APNIC" },
	{ 0x7f000000, 0xff000000,  8, "IANA" },
	{ 0x80000000, 0xf8000000,  5, "ARIN" },
	{ 0x80070000, 0xffff0000, 16, "RIPENCC" },
	{ 0x80100000, 0xffff0000, 16, "RIPENCC" },
	{ 0x80270000, 0xffff0000, 16, "RIPENCC" },
	{ 0x80280000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x802d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x80410000, 0xffff0000, 16, "RIPENCC" },
	{ 0x80420000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x80440000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x80480000, 0xfff80000, 13, "RIPENCC" },
	{ 0x80560000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x805d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x80620000, 0xffff0000, 16, "RIPENCC" },
	{ 0x807c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x807f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x80820000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x80860000, 0xffff0000, 16, "APNIC" },
	{ 0x808b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x808c0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x80b00000, 0xffff0000, 16, "RIPENCC" },
	{ 0x80b20000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x80b80000, 0xffff0000, 16, "APNIC" },
	{ 0x80c70000, 0xffff0000, 16, "RIPENCC" },
	{ 0x80cc0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x80d60000, 0xffff0000, 16, "RIPENCC" },
	{ 0x80e80000, 0xffff0000, 16, "RIPENCC" },
	{ 0x80ea0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x80f00000, 0xffff0000, 16, "RIPENCC" },
	{ 0x80f30000, 0xffff0000, 16, "RIPENCC" },
	{ 0x80f60000, 0xffff0000, 16, "RIPENCC" },
	{ 0x80fa0000, 0xffff0000, 16, "APNIC" },
	{ 0x810b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x810c0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x81100000, 0xffff0000, 16, "RIPENCC" },
	{ 0x81140000, 0xffff0000, 16, "RIPENCC" },
	{ 0x811a0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x811f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x813c0000, 0xffff0000, 16, "APNIC" },
	{ 0x81430000, 0xffff0000, 16, "RIPENCC" },
	{ 0x81450000, 0xffff0000, 16, "RIPENCC" },
	{ 0x81460000, 0xffff0000, 16, "RIPENCC" },
	{ 0x81490000, 0xffff0000, 16, "RIPENCC" },
	{ 0x814e0000, 0xffff0000, 16, "APNIC" },
	{ 0x81580000, 0xffff0000, 16, "RIPENCC" },
	{ 0x815a0000, 0xffff0000, 16, "LACNIC" },
	{ 0x815e0000, 0xffff0000, 16, "APNIC" },
	{ 0x81600000, 0xffff0000, 16, "APNIC" },
	{ 0x81660000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x81680000, 0xffff0000, 16, "RIPENCC" },
	{ 0x817d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x817f0000, 0xffff0000, 16, "APNIC" },
	{ 0x81810000, 0xffff0000, 16, "RIPENCC" },
	{ 0x81840000, 0xffff0000, 16, "RIPENCC" },
	{ 0x81880000, 0xffff0000, 16, "APNIC" },
	{ 0x818e0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x81a90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x81af0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x81b10000, 0xffff0000, 16, "RIPENCC" },
	{ 0x81b20000, 0xffff0000, 16, "RIPENCC" },
	{ 0x81b40000, 0xffff0000, 16, "APNIC" },
	{ 0x81b50000, 0xffff0000, 16, "RIPENCC" },
	{ 0x81b60000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x81b80000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x81bb0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x81c20000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x81c70000, 0xffff0000, 16, "RIPENCC" },
	{ 0x81ce0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x81d00000, 0xffff0000, 16, "RIPENCC" },
	{ 0x81d60000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x81d90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x81e90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x81ea0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x81f00000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x81f20000, 0xffff0000, 16, "RIPENCC" },
	{ 0x81f70000, 0xffff0000, 16, "RIPENCC" },
	{ 0x81f90000, 0xffff0000, 16, "APNIC" },
	{ 0x81fe0000, 0xffff0000, 16, "APNIC" },
	{ 0x82000000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82180000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x821a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x821c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82200000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82220000, 0xffff0000, 16, "APNIC" },
	{ 0x82250000, 0xffff0000, 16, "RIPENCC" },
	{ 0x822b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82360000, 0xffff0000, 16, "APNIC" },
	{ 0x82380000, 0xffff0000, 16, "APNIC" },
	{ 0x823b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x823c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82420000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x82450000, 0xffff0000, 16, "APNIC" },
	{ 0x82490000, 0xffff0000, 16, "RIPENCC" },
	{ 0x824b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x824e0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x82520000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x82540000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82570000, 0xffff0000, 16, "APNIC" },
	{ 0x82580000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x825c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x825f0000, 0xffff0000, 16, "APNIC" },
	{ 0x82620000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82640000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82660000, 0xffff0000, 16, "APNIC" },
	{ 0x82680000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82700000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82730000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82740000, 0xffff0000, 16, "APNIC" },
	{ 0x82780000, 0xffff0000, 16, "RIPENCC" },
	{ 0x827b0000, 0xffff0000, 16, "APNIC" },
	{ 0x827d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82820000, 0xffff0000, 16, "APNIC" },
	{ 0x82850000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82880000, 0xffff0000, 16, "RIPENCC" },
	{ 0x828a0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x82900000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x82940000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x82990000, 0xffff0000, 16, "APNIC" },
	{ 0x829b0000, 0xffff0000, 16, "APNIC" },
	{ 0x829e0000, 0xffff0000, 16, "APNIC" },
	{ 0x829f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82a10000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82b40000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82b70000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82b90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82ba0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82bc0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82be0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82c00000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x82c20000, 0xfffe0000, 15, "APNIC" },
	{ 0x82c60000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82cc0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82ce0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82d00000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x82d80000, 0xfffe0000, 15, "APNIC" },
	{ 0x82dc0000, 0xffff0000, 16, "APNIC" },
	{ 0x82df0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82e10000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82e20000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x82e40000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x82e80000, 0xfff80000, 13, "RIPENCC" },
	{ 0x82f00000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x82f40000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82f60000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82fb0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x82ff0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83010000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83610000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83630000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83660000, 0xffff0000, 16, "RIPENCC" },
	{ 0x836f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83700000, 0xfffe0000, 15, "APNIC" },
	{ 0x83720000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x83740000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83750000, 0xffff8000, 17, "RIPENCC" },
	{ 0x83820000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83980000, 0xffff0000, 16, "RIPENCC" },
	{ 0x839a0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x839f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83a00000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83a40000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x83a60000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83a90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83aa0000, 0xffff0000, 16, "APNIC" },
	{ 0x83ac0000, 0xffff0000, 16, "APNIC" },
	{ 0x83ad0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83ae0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x83b00000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x83b20000, 0xffff0000, 16, "LACNIC" },
	{ 0x83b40000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83b50000, 0xffff0000, 16, "APNIC" },
	{ 0x83b90000, 0xffff0000, 16, "APNIC" },
	{ 0x83bc0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83cb0000, 0xffff0000, 16, "APNIC" },
	{ 0x83cd0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83ce0000, 0xffff0000, 16, "APNIC" },
	{ 0x83cf0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83d30000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83d90000, 0xffff0000, 16, "APNIC" },
	{ 0x83dc0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83e00000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83e30000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83e40000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83e70000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83ea0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83ec0000, 0xffff0000, 16, "APNIC" },
	{ 0x83ed0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83f20000, 0xffff0000, 16, "APNIC" },
	{ 0x83f40000, 0xfffe0000, 15, "APNIC" },
	{ 0x83f60000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83f80000, 0xffff0000, 16, "APNIC" },
	{ 0x83fb0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x83fe0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x84400000, 0xfff80000, 13, "RIPENCC" },
	{ 0x84480000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x844c0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x844e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x84920000, 0xffff0000, 16, "RIPENCC" },
	{ 0x84950000, 0xffff0000, 16, "RIPENCC" },
	{ 0x84960000, 0xffff0000, 16, "RIPENCC" },
	{ 0x84990000, 0xffff0000, 16, "RIPENCC" },
	{ 0x849b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x84a50000, 0xffff0000, 16, "RIPENCC" },
	{ 0x84a60000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x84a80000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x84ab0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x84b00000, 0xffff0000, 16, "RIPENCC" },
	{ 0x84b30000, 0xffff0000, 16, "APNIC" },
	{ 0x84b40000, 0xffff0000, 16, "RIPENCC" },
	{ 0x84b50000, 0xffff0000, 16, "APNIC" },
	{ 0x84b60000, 0xffff0000, 16, "APNIC" },
	{ 0x84b90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x84ba0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x84c30000, 0xffff0000, 16, "RIPENCC" },
	{ 0x84c40000, 0xffff0000, 16, "RIPENCC" },
	{ 0x84c70000, 0xffff0000, 16, "RIPENCC" },
	{ 0x84de0000, 0xffff0000, 16, "APNIC" },
	{ 0x84e30000, 0xffff0000, 16, "RIPENCC" },
	{ 0x84e50000, 0xffff0000, 16, "RIPENCC" },
	{ 0x84e60000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x84e80000, 0xffff0000, 16, "RIPENCC" },
	{ 0x84ea0000, 0xffff0000, 16, "APNIC" },
	{ 0x84f40000, 0xffff0000, 16, "RIPENCC" },
	{ 0x84f70000, 0xffff0000, 16, "LACNIC" },
	{ 0x84f80000, 0xffff0000, 16, "LACNIC" },
	{ 0x84fc0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x84fe0000, 0xffff0000, 16, "LACNIC" },
	{ 0x85000000, 0xff000000,  8, "APNIC" },
	{ 0x86000000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x86070000, 0xffff0000, 16, "APNIC" },
	{ 0x86110000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86120000, 0xffff0000, 16, "APNIC" },
	{ 0x86130000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86150000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86190000, 0xffff0000, 16, "RIPENCC" },
	{ 0x861b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x861c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x861e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86220000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86240000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x862f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86360000, 0xffff0000, 16, "RIPENCC" },
	{ 0x863a0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x863c0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x864b0000, 0xffff0000, 16, "APNIC" },
	{ 0x864c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86510000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86530000, 0xffff0000, 16, "RIPENCC" },
	{ 0x865a0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x865c0000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x86600000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x86620000, 0xffff8000, 17, "RIPENCC" },
	{ 0x86628000, 0xffffc000, 18, "RIPENCC" },
	{ 0x86630000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86640000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x86680000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x866c0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x866e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86730000, 0xffff0000, 16, "APNIC" },
	{ 0x86770000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86820000, 0xffff0000, 16, "RIPENCC" },
	{ 0x868a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x868e0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x86900000, 0xffff0000, 16, "APNIC" },
	{ 0x86910000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86920000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x86940000, 0xffff0000, 16, "APNIC" },
	{ 0x86970000, 0xffff0000, 16, "RIPENCC" },
	{ 0x869b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x869d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x869e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x869f0000, 0xffff0000, 16, "APNIC" },
	{ 0x86a00000, 0xffff0000, 16, "APNIC" },
	{ 0x86a90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86ab0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86b00000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86b20000, 0xffff0000, 16, "APNIC" },
	{ 0x86b40000, 0xffff0000, 16, "APNIC" },
	{ 0x86b70000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86b80000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86bc0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86bf0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86c40000, 0xffff0000, 16, "APNIC" },
	{ 0x86cb0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86ce0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86d00000, 0xffff0000, 16, "APNIC" },
	{ 0x86d30000, 0xffff0000, 16, "APNIC" },
	{ 0x86d40000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x86d60000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86db0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86dc0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x86de0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86e10000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86e20000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x86ed0000, 0xffff0000, 16, "APNIC" },
	{ 0x86ef0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86f50000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86f60000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x86f90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x86ff0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x87c40000, 0xffff0000, 16, "RIPENCC" },
	{ 0x88000000, 0xfc000000,  6, "ARIN" },
	{ 0x88940000, 0xffff0000, 16, "RIPENCC" },
	{ 0x88990000, 0xffff0000, 16, "APNIC" },
	{ 0x889a0000, 0xffff0000, 16, "APNIC" },
	{ 0x889b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x889c0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x889e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x88a30000, 0xffff0000, 16, "RIPENCC" },
	{ 0x88a40000, 0xffff0000, 16, "RIPENCC" },
	{ 0x88a90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x88aa0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x88ac0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x88ba0000, 0xfffe0000, 15, "APNIC" },
	{ 0x88c60000, 0xffff0000, 16, "APNIC" },
	{ 0x88c70000, 0xffff0000, 16, "RIPENCC" },
	{ 0x88c90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x88ce0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x88e10000, 0xffff0000, 16, "RIPENCC" },
	{ 0x88e60000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x88f30000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89110000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89210000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89220000, 0xffff0000, 16, "RIPENCC" },
	{ 0x892b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x892c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x892f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89320000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89370000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89380000, 0xffff0000, 16, "RIPENCC" },
	{ 0x893a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x893c0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x893e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89440000, 0xffff0000, 16, "APNIC" },
	{ 0x89490000, 0xffff0000, 16, "RIPENCC" },
	{ 0x894c0000, 0xffff0000, 16, "APNIC" },
	{ 0x895c0000, 0xffff0000, 16, "APNIC" },
	{ 0x895d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89600000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89650000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89690000, 0xffff0000, 16, "RIPENCC" },
	{ 0x896c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x896d0000, 0xffff0000, 16, "APNIC" },
	{ 0x896f0000, 0xffff0000, 16, "APNIC" },
	{ 0x89780000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x89810000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89840000, 0xffff0000, 16, "APNIC" },
	{ 0x89850000, 0xffff0000, 16, "RIPENCC" },
	{ 0x898a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89930000, 0xffff0000, 16, "APNIC" },
	{ 0x89990000, 0xffff0000, 16, "APNIC" },
	{ 0x899a0000, 0xffff0000, 16, "APNIC" },
	{ 0x899c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x899d0000, 0xffff0000, 16, "APNIC" },
	{ 0x899e0000, 0xffff0000, 16, "AFRINIC" },
	{ 0x89a30000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89a60000, 0xffff0000, 16, "APNIC" },
	{ 0x89ac0000, 0xffff0000, 16, "APNIC" },
	{ 0x89ae0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89bd0000, 0xffff0000, 16, "APNIC" },
	{ 0x89bf0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89c10000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89c20000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x89cc0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x89d00000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89d50000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89d60000, 0xfffe0000, 15, "AFRINIC" },
	{ 0x89d90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89da0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89db0000, 0xffff0000, 16, "APNIC" },
	{ 0x89dd0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89de0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x89e00000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89e20000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89f80000, 0xffff0000, 16, "RIPENCC" },
	{ 0x89fa0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x89fd0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8a030000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8a040000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8a060000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8a070000, 0xffff0000, 16, "APNIC" },
	{ 0x8a0e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8a130000, 0xffff0000, 16, "APNIC" },
	{ 0x8a150000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8a160000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8a180000, 0xfffe0000, 15, "APNIC" },
	{ 0x8a1e0000, 0xffff0000, 16, "APNIC" },
	{ 0x8a250000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8a260000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8a280000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x8a2c0000, 0xffff0000, 16, "APNIC" },
	{ 0x8a300000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8a3e0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x8a420000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8a460000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8a470000, 0xffff0000, 16, "APNIC" },
	{ 0x8a4b0000, 0xffff0000, 16, "APNIC" },
	{ 0x8a4d0000, 0xffff0000, 16, "APNIC" },
	{ 0x8a4f0000, 0xffff0000, 16, "APNIC" },
	{ 0x8a500000, 0xffff0000, 16, "APNIC" },
	{ 0x8a510000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8a600000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8a640000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8a650000, 0xffff0000, 16, "APNIC" },
	{ 0x8a660000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x8a680000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8a6a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8a6b0000, 0xffff0000, 16, "APNIC" },
	{ 0x8a7c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8a820000, 0xffff0000, 16, "APNIC" },
	{ 0x8a830000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8a840000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8a860000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8abb0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8abc0000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x8ac20000, 0xffff0000, 16, "APNIC" },
	{ 0x8ac30000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8ac60000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x8ac80000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x8acb0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8acd0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8ace0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8ad30000, 0xffff0000, 16, "APNIC" },
	{ 0x8ad40000, 0xffff0000, 16, "APNIC" },
	{ 0x8ad70000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8ad80000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8ad90000, 0xffff0000, 16, "APNIC" },
	{ 0x8add0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8ae70000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8ae80000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x8aeb0000, 0xffff0000, 16, "APNIC" },
	{ 0x8af30000, 0xffff0000, 16, "APNIC" },
	{ 0x8af40000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x8af60000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8af80000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x8afd0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b000000, 0xffff0000, 16, "APNIC" },
	{ 0x8b010000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b020000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x8b040000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b060000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x8b080000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b090000, 0xffff0000, 16, "APNIC" },
	{ 0x8b0a0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x8b0c0000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x8b100000, 0xfff80000, 13, "RIPENCC" },
	{ 0x8b180000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x8b1b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b1d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b1e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b2c0000, 0xffff0000, 16, "APNIC" },
	{ 0x8b320000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b350000, 0xffff0000, 16, "AFRINIC" },
	{ 0x8b360000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b3a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b3b0000, 0xffff0000, 16, "APNIC" },
	{ 0x8b3f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b420000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b4a0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x8b4f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b500000, 0xffff0000, 16, "APNIC" },
	{ 0x8b520000, 0xffff0000, 16, "LACNIC" },
	{ 0x8b530000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b560000, 0xffff0000, 16, "APNIC" },
	{ 0x8b590000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b5a0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x8b5c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b600000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x8b620000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b640000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b650000, 0xffff0000, 16, "APNIC" },
	{ 0x8b690000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b7a0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x8b7c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b800000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b810000, 0xffff0000, 16, "APNIC" },
	{ 0x8b820000, 0xffff0000, 16, "APNIC" },
	{ 0x8b840000, 0xffff0000, 16, "APNIC" },
	{ 0x8b850000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b860000, 0xffff0000, 16, "APNIC" },
	{ 0x8b8d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b8f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b910000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b940000, 0xffff0000, 16, "APNIC" },
	{ 0x8b950000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b960000, 0xffff0000, 16, "APNIC" },
	{ 0x8b980000, 0xffff0000, 16, "APNIC" },
	{ 0x8b990000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b9a0000, 0xfffe0000, 15, "APNIC" },
	{ 0x8b9c0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x8b9e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8b9f0000, 0xffff0000, 16, "APNIC" },
	{ 0x8ba00000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8ba20000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8ba30000, 0xffff0000, 16, "APNIC" },
	{ 0x8ba40000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x8ba60000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8ba80000, 0xffff0000, 16, "APNIC" },
	{ 0x8baa0000, 0xffff0000, 16, "APNIC" },
	{ 0x8bae0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8baf0000, 0xffff0000, 16, "APNIC" },
	{ 0x8bb00000, 0xffff0000, 16, "APNIC" },
	{ 0x8bb20000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x8bb70000, 0xffff0000, 16, "APNIC" },
	{ 0x8bb80000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8bba0000, 0xffff0000, 16, "APNIC" },
	{ 0x8bbc0000, 0xfffe0000, 15, "APNIC" },
	{ 0x8bbe0000, 0xffff0000, 16, "APNIC" },
	{ 0x8bbf0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8bc00000, 0xfff00000, 12, "APNIC" },
	{ 0x8bd00000, 0xfff80000, 13, "APNIC" },
	{ 0x8bd80000, 0xfffc0000, 14, "APNIC" },
	{ 0x8bdc0000, 0xfffe0000, 15, "APNIC" },
	{ 0x8bde0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8bdf0000, 0xffff0000, 16, "APNIC" },
	{ 0x8be00000, 0xffff0000, 16, "APNIC" },
	{ 0x8be20000, 0xfffe0000, 15, "APNIC" },
	{ 0x8be40000, 0xffff0000, 16, "APNIC" },
	{ 0x8be60000, 0xffff0000, 16, "APNIC" },
	{ 0x8bff0000, 0xffff0000, 16, "APNIC" },
	{ 0x8c000000, 0xff000000,  8, "ARIN" },
	{ 0x8c4b0000, 0xffff0000, 16, "APNIC" },
	{ 0x8c4d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8c4e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8c4f0000, 0xffff0000, 16, "APNIC" },
	{ 0x8c530000, 0xffff0000, 16, "APNIC" },
	{ 0x8c540000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x8c5c0000, 0xffff0000, 16, "APNIC" },
	{ 0x8c5d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8c5e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8c600000, 0xffff0000, 16, "APNIC" },
	{ 0x8c610000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8c690000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8c6d0000, 0xffff0000, 16, "APNIC" },
	{ 0x8c6e0000, 0xfffe0000, 15, "APNIC" },
	{ 0x8c700000, 0xfff00000, 12, "APNIC" },
	{ 0x8c800000, 0xfff80000, 13, "APNIC" },
	{ 0x8c880000, 0xfffe0000, 15, "APNIC" },
	{ 0x8c8a0000, 0xffff0000, 16, "APNIC" },
	{ 0x8c8f0000, 0xffff0000, 16, "APNIC" },
	{ 0x8c940000, 0xffff0000, 16, "LACNIC" },
	{ 0x8c950000, 0xffff0000, 16, "APNIC" },
	{ 0x8c960000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x8c9f0000, 0xffff0000, 16, "APNIC" },
	{ 0x8ca40000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8ca60000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8ca80000, 0xffff0000, 16, "APNIC" },
	{ 0x8cb50000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8cbf0000, 0xffff0000, 16, "LACNIC" },
	{ 0x8cc80000, 0xffff0000, 16, "APNIC" },
	{ 0x8ccb0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8ccd0000, 0xffff0000, 16, "APNIC" },
	{ 0x8cce0000, 0xfffe0000, 15, "APNIC" },
	{ 0x8cd20000, 0xffff0000, 16, "APNIC" },
	{ 0x8cd50000, 0xffff0000, 16, "APNIC" },
	{ 0x8ce00000, 0xffff0000, 16, "APNIC" },
	{ 0x8ce70000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8ced0000, 0xffff0000, 16, "APNIC" },
	{ 0x8cf00000, 0xffff0000, 16, "APNIC" },
	{ 0x8cf30000, 0xffff0000, 16, "APNIC" },
	{ 0x8cf60000, 0xffff0000, 16, "APNIC" },
	{ 0x8cf90000, 0xffff0000, 16, "APNIC" },
	{ 0x8cfa0000, 0xffff0000, 16, "APNIC" },
	{ 0x8cfd0000, 0xffff0000, 16, "APNIC" },
	{ 0x8cff0000, 0xffff0000, 16, "APNIC" },
	{ 0x8d000000, 0xff000000,  8, "RIPENCC" },
	{ 0x8d560000, 0xffff0000, 16, "ARIN" },
	{ 0x8d660000, 0xffff0000, 16, "ARIN" },
	{ 0x8d670000, 0xffff0000, 16, "APNIC" },
	{ 0x8d680000, 0xffff0000, 16, "ARIN" },
	{ 0x8d6a0000, 0xfffe0000, 15, "ARIN" },
	{ 0x8d6d0000, 0xffff0000, 16, "ARIN" },
	{ 0x8d6e0000, 0xfffe0000, 15, "ARIN" },
	{ 0x8d700000, 0xffff0000, 16, "ARIN" },
	{ 0x8d720000, 0xffff0000, 16, "ARIN" },
	{ 0x8d740000, 0xfffc0000, 14, "ARIN" },
	{ 0x8d780000, 0xffff0000, 16, "APNIC" },
	{ 0x8d790000, 0xffff0000, 16, "ARIN" },
	{ 0x8d7a0000, 0xfffe0000, 15, "ARIN" },
	{ 0x8d7d0000, 0xffff0000, 16, "ARIN" },
	{ 0x8d7e0000, 0xfffe0000, 15, "ARIN" },
	{ 0x8d830000, 0xffff0000, 16, "ARIN" },
	{ 0x8d840000, 0xffff0000, 16, "APNIC" },
	{ 0x8d850000, 0xffff0000, 16, "ARIN" },
	{ 0x8d8b0000, 0xffff0000, 16, "ARIN" },
	{ 0x8d8c0000, 0xfffe0000, 15, "ARIN" },
	{ 0x8d8e0000, 0xffff0000, 16, "ARIN" },
	{ 0x8d950000, 0xffff0000, 16, "ARIN" },
	{ 0x8d9f0000, 0xffff0000, 16, "ARIN" },
	{ 0x8da00000, 0xfffe0000, 15, "ARIN" },
	{ 0x8da20000, 0xffff0000, 16, "ARIN" },
	{ 0x8da40000, 0xfffc0000, 14, "ARIN" },
	{ 0x8da80000, 0xffff0000, 16, "APNIC" },
	{ 0x8dad0000, 0xffff0000, 16, "ARIN" },
	{ 0x8dae0000, 0xffff0000, 16, "ARIN" },
	{ 0x8db10000, 0xffff0000, 16, "ARIN" },
	{ 0x8db20000, 0xffff0000, 16, "APNIC" },
	{ 0x8db30000, 0xffff0000, 16, "ARIN" },
	{ 0x8db70000, 0xffff0000, 16, "ARIN" },
	{ 0x8db90000, 0xffff0000, 16, "ARIN" },
	{ 0x8dbc0000, 0xfffc0000, 14, "ARIN" },
	{ 0x8dc10000, 0xffff0000, 16, "ARIN" },
	{ 0x8dc30000, 0xffff0000, 16, "ARIN" },
	{ 0x8dc50000, 0xffff0000, 16, "ARIN" },
	{ 0x8dc60000, 0xfffe0000, 15, "ARIN" },
	{ 0x8dca0000, 0xffff0000, 16, "ARIN" },
	{ 0x8dcc0000, 0xfffc0000, 14, "ARIN" },
	{ 0x8dd10000, 0xffff0000, 16, "ARIN" },
	{ 0x8dd20000, 0xfffe0000, 15, "ARIN" },
	{ 0x8dd40000, 0xfffc0000, 14, "ARIN" },
	{ 0x8dd80000, 0xfffc0000, 14, "ARIN" },
	{ 0x8ddc0000, 0xfffe0000, 15, "ARIN" },
	{ 0x8dde0000, 0xffff0000, 16, "ARIN" },
	{ 0x8ddf0000, 0xffff0000, 16, "APNIC" },
	{ 0x8de00000, 0xfffe0000, 15, "ARIN" },
	{ 0x8de60000, 0xffff0000, 16, "ARIN" },
	{ 0x8de80000, 0xfffc0000, 14, "ARIN" },
	{ 0x8dec0000, 0xffff0000, 16, "ARIN" },
	{ 0x8dee0000, 0xfffe0000, 15, "ARIN" },
	{ 0x8df00000, 0xffff0000, 16, "ARIN" },
	{ 0x8df20000, 0xffff0000, 16, "ARIN" },
	{ 0x8df30000, 0xffff0000, 16, "APNIC" },
	{ 0x8df60000, 0xfffe0000, 15, "ARIN" },
	{ 0x8df80000, 0xffff0000, 16, "ARIN" },
	{ 0x8dfb0000, 0xffff0000, 16, "ARIN" },
	{ 0x8dfe0000, 0xffff0000, 16, "ARIN" },
	{ 0x8e000000, 0xfe000000,  7, "ARIN" },
	{ 0x8f290000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8f2f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8f320000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x8f340000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x8f360000, 0xffff0000, 16, "LACNIC" },
	{ 0x8f410000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8f590000, 0xffff0000, 16, "APNIC" },
	{ 0x8f5a0000, 0xffff0000, 16, "APNIC" },
	{ 0x8f5c0000, 0xffff0000, 16, "APNIC" },
	{ 0x8f5d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8f5e0000, 0xffff0000, 16, "APNIC" },
	{ 0x8f600000, 0xffff0000, 16, "APNIC" },
	{ 0x8f610000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8f630000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8f6a0000, 0xfffe0000, 15, "LACNIC" },
	{ 0x8f6c0000, 0xffff0000, 16, "LACNIC" },
	{ 0x8f750000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8f760000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8f770000, 0xffff0000, 16, "APNIC" },
	{ 0x8f790000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8f7d0000, 0xffff0000, 16, "APNIC" },
	{ 0x8f7e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8f800000, 0xffff0000, 16, "AFRINIC" },
	{ 0x8f810000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8f820000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8f880000, 0xffff0000, 16, "APNIC" },
	{ 0x8fa00000, 0xffff0000, 16, "AFRINIC" },
	{ 0x8fa10000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8fa30000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8fa40000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8fa70000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8fa90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8fae0000, 0xffff0000, 16, "APNIC" },
	{ 0x8fb00000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x8fb40000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8fbc0000, 0xfffe0000, 15, "APNIC" },
	{ 0x8fc40000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8fcd0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8fd20000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8fd80000, 0xffff0000, 16, "APNIC" },
	{ 0x8fd90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8fda0000, 0xffff0000, 16, "APNIC" },
	{ 0x8fdd0000, 0xffff0000, 16, "APNIC" },
	{ 0x8fe00000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x8fe90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8fea0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8fed0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8fee0000, 0xffff0000, 16, "APNIC" },
	{ 0x8fef0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8ff50000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8ff80000, 0xffff0000, 16, "APNIC" },
	{ 0x8ffc0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x8ffd0000, 0xffff0000, 16, "APNIC" },
	{ 0x90000000, 0xff000000,  8, "ARIN" },
	{ 0x90020000, 0xffff0000, 16, "RIPENCC" },
	{ 0x90040000, 0xffff0000, 16, "RIPENCC" },
	{ 0x90060000, 0xfffe0000, 15, "APNIC" },
	{ 0x900c0000, 0xffff0000, 16, "APNIC" },
	{ 0x90100000, 0xffff0000, 16, "APNIC" },
	{ 0x90140000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x90160000, 0xfffe0000, 15, "LACNIC" },
	{ 0x90180000, 0xffff0000, 16, "RIPENCC" },
	{ 0x901b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x90200000, 0xffff0000, 16, "RIPENCC" },
	{ 0x90290000, 0xffff0000, 16, "RIPENCC" },
	{ 0x902b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x902c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x90340000, 0xfffe0000, 15, "APNIC" },
	{ 0x90360000, 0xffff0000, 16, "RIPENCC" },
	{ 0x90370000, 0xffff0000, 16, "APNIC" },
	{ 0x90380000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x903f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x90400000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x90420000, 0xffff0000, 16, "APNIC" },
	{ 0x904c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x90520000, 0xffff0000, 16, "RIPENCC" },
	{ 0x90540000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x90570000, 0xffff0000, 16, "RIPENCC" },
	{ 0x905f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x90610000, 0xffff0000, 16, "APNIC" },
	{ 0x90620000, 0xffff0000, 16, "RIPENCC" },
	{ 0x906e0000, 0xffff0000, 16, "APNIC" },
	{ 0x90770000, 0xffff0000, 16, "RIPENCC" },
	{ 0x90780000, 0xffff0000, 16, "APNIC" },
	{ 0x907a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x907b0000, 0xffff0000, 16, "APNIC" },
	{ 0x907c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x907f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x90820000, 0xfffe0000, 15, "APNIC" },
	{ 0x90840000, 0xfffc0000, 14, "APNIC" },
	{ 0x90880000, 0xfffc0000, 14, "APNIC" },
	{ 0x908c0000, 0xffff0000, 16, "APNIC" },
	{ 0x90910000, 0xffff0000, 16, "RIPENCC" },
	{ 0x90a40000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x90ad0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x90b00000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x90b40000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x90c10000, 0xffff0000, 16, "RIPENCC" },
	{ 0x90c70000, 0xffff0000, 16, "APNIC" },
	{ 0x90c80000, 0xffff0000, 16, "RIPENCC" },
	{ 0x90cc0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x90cd0000, 0xffff0000, 16, "APNIC" },
	{ 0x90ce0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x90d10000, 0xffff0000, 16, "RIPENCC" },
	{ 0x90d50000, 0xffff0000, 16, "APNIC" },
	{ 0x90d60000, 0xffff0000, 16, "APNIC" },
	{ 0x90f80000, 0xffff0000, 16, "RIPENCC" },
	{ 0x90ff0000, 0xffff0000, 16, "APNIC" },
	{ 0x91000000, 0xff000000,  8, "RIPENCC" },
	{ 0x92000000, 0xfe000000,  7, "ARIN" },
	{ 0x92020000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x92040000, 0xffff0000, 16, "RIPENCC" },
	{ 0x920b0000, 0xffff0000, 16, "APNIC" },
	{ 0x92130000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92150000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92300000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92320000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92330000, 0xffff0000, 16, "APNIC" },
	{ 0x92340000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92380000, 0xffff0000, 16, "APNIC" },
	{ 0x923b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x923c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92400000, 0xffff0000, 16, "AFRINIC" },
	{ 0x92420000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x92460000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92480000, 0xffff0000, 16, "RIPENCC" },
	{ 0x924b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x924d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92500000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x92530000, 0xffff0000, 16, "LACNIC" },
	{ 0x92570000, 0xffff0000, 16, "RIPENCC" },
	{ 0x925a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92610000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92640000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x92680000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x926c0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x926e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92700000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92740000, 0xffff0000, 16, "APNIC" },
	{ 0x92760000, 0xffff0000, 16, "APNIC" },
	{ 0x92770000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92780000, 0xffff0000, 16, "RIPENCC" },
	{ 0x927c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92850000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92860000, 0xffff0000, 16, "LACNIC" },
	{ 0x92880000, 0xffff0000, 16, "RIPENCC" },
	{ 0x928c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x928d0000, 0xffff0000, 16, "AFRINIC" },
	{ 0x929b0000, 0xffff0000, 16, "LACNIC" },
	{ 0x929e0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x92a10000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92a20000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92a40000, 0xffff0000, 16, "LACNIC" },
	{ 0x92a90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92ab0000, 0xffff0000, 16, "APNIC" },
	{ 0x92ac0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x92af0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92b00000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x92b20000, 0xffff0000, 16, "APNIC" },
	{ 0x92b30000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92b60000, 0xffff0000, 16, "AFRINIC" },
	{ 0x92b90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92bc0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92bf0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92c00000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x92c20000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92c30000, 0xffff0000, 16, "APNIC" },
	{ 0x92c40000, 0xffffe000, 19, "APNIC" },
	{ 0x92d20000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x92d40000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x92d80000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92db0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92dc0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92dd0000, 0xffff0000, 16, "APNIC" },
	{ 0x92e00000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92e30000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92e40000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92e60000, 0xfffe0000, 15, "AFRINIC" },
	{ 0x92e80000, 0xffff0000, 16, "AFRINIC" },
	{ 0x92ea0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92f70000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92f80000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x92fb0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92fd0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x92fe0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x93060000, 0xffff0000, 16, "APNIC" },
	{ 0x93070000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93080000, 0xffff0000, 16, "APNIC" },
	{ 0x930a0000, 0xffff0000, 16, "APNIC" },
	{ 0x930c0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x930e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x931b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x931d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x931e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93200000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x93290000, 0xffff0000, 16, "APNIC" },
	{ 0x932b0000, 0xffff0000, 16, "APNIC" },
	{ 0x932c0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x932e0000, 0xfffe0000, 15, "APNIC" },
	{ 0x93340000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93360000, 0xffff0000, 16, "RIPENCC" },
	{ 0x933c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93410000, 0xffff0000, 16, "LACNIC" },
	{ 0x93420000, 0xffff0000, 16, "APNIC" },
	{ 0x93430000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93440000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93450000, 0xffff0000, 16, "APNIC" },
	{ 0x934b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x934c0000, 0xffff0000, 16, "APNIC" },
	{ 0x934d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93530000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93540000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93560000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x93580000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x935b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x935d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x935e0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x93600000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93620000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x93640000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93660000, 0xffff0000, 16, "RIPENCC" },
	{ 0x936d0000, 0xffff0000, 16, "APNIC" },
	{ 0x936e0000, 0xffff0000, 16, "AFRINIC" },
	{ 0x936f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93700000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93770000, 0xffff0000, 16, "RIPENCC" },
	{ 0x937a0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x937d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x937f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93840000, 0xffff0000, 16, "APNIC" },
	{ 0x938e0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x93930000, 0xffff0000, 16, "RIPENCC" },
	{ 0x939c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x939d0000, 0xffff0000, 16, "APNIC" },
	{ 0x939e0000, 0xffff0000, 16, "APNIC" },
	{ 0x93a10000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93a20000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x93a70000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93ab0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93ac0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x93af0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93b00000, 0xffff0000, 16, "APNIC" },
	{ 0x93b40000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x93b80000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93ba0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93bc0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x93c10000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93c40000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x93c80000, 0xffff0000, 16, "APNIC" },
	{ 0x93c90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93cc0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93d10000, 0xffff0000, 16, "APNIC" },
	{ 0x93d20000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93d30000, 0xffff0000, 16, "APNIC" },
	{ 0x93d50000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93d60000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x93dc0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93e40000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x93e80000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x93ec0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x93f30000, 0xffff0000, 16, "RIPENCC" },
	{ 0x93fa0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x93fc0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x94000000, 0xfe000000,  7, "ARIN" },
	{ 0x94020000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x94060000, 0xffff0000, 16, "RIPENCC" },
	{ 0x94360000, 0xffff0000, 16, "RIPENCC" },
	{ 0x94380000, 0xffff0000, 16, "RIPENCC" },
	{ 0x943c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x944f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x94510000, 0xffff0000, 16, "RIPENCC" },
	{ 0x94520000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x94580000, 0xffff0000, 16, "RIPENCC" },
	{ 0x946e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x94760000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x94780000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x94870000, 0xffff0000, 16, "RIPENCC" },
	{ 0x94880000, 0xffff0000, 16, "RIPENCC" },
	{ 0x948a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x948c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x948f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x94910000, 0xffff0000, 16, "APNIC" },
	{ 0x94940000, 0xffff0000, 16, "RIPENCC" },
	{ 0x94970000, 0xffff0000, 16, "RIPENCC" },
	{ 0x94a00000, 0xffff0000, 16, "RIPENCC" },
	{ 0x94a10000, 0xffff0000, 16, "APNIC" },
	{ 0x94a90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x94b00000, 0xffff0000, 16, "RIPENCC" },
	{ 0x94b50000, 0xffff0000, 16, "RIPENCC" },
	{ 0x94b60000, 0xffff0000, 16, "APNIC" },
	{ 0x94b90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x94bb0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x94c30000, 0xffff0000, 16, "APNIC" },
	{ 0x94c40000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x94c60000, 0xffff0000, 16, "RIPENCC" },
	{ 0x94c80000, 0xffff0000, 16, "RIPENCC" },
	{ 0x94c90000, 0xffff0000, 16, "LACNIC" },
	{ 0x94ca0000, 0xfffe0000, 15, "LACNIC" },
	{ 0x94cc0000, 0xfffc0000, 14, "LACNIC" },
	{ 0x94d00000, 0xfff00000, 12, "LACNIC" },
	{ 0x94e00000, 0xfff00000, 12, "LACNIC" },
	{ 0x94f00000, 0xfff80000, 13, "LACNIC" },
	{ 0x94f80000, 0xfffe0000, 15, "LACNIC" },
	{ 0x94fa0000, 0xffff0000, 16, "LACNIC" },
	{ 0x94fb0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x94fc0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x95000000, 0xffff0000, 16, "RIPENCC" },
	{ 0x95030000, 0xffff0000, 16, "RIPENCC" },
	{ 0x951b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x95310000, 0xffff0000, 16, "RIPENCC" },
	{ 0x953b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x953e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x957e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x95840000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x95860000, 0xffff0000, 16, "RIPENCC" },
	{ 0x95870000, 0xffff0000, 16, "APNIC" },
	{ 0x958b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x958c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x95900000, 0xffff0000, 16, "APNIC" },
	{ 0x95920000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x95940000, 0xffff0000, 16, "RIPENCC" },
	{ 0x95990000, 0xffff0000, 16, "RIPENCC" },
	{ 0x959a0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x959c0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x95a70000, 0xffff0000, 16, "APNIC" },
	{ 0x95aa0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x95ab0000, 0xffff0000, 16, "APNIC" },
	{ 0x95ac0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x95b00000, 0xffff0000, 16, "APNIC" },
	{ 0x95b10000, 0xffff0000, 16, "RIPENCC" },
	{ 0x95c40000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x95c80000, 0xfff80000, 13, "RIPENCC" },
	{ 0x95d00000, 0xfff00000, 12, "RIPENCC" },
	{ 0x95e00000, 0xfff00000, 12, "RIPENCC" },
	{ 0x95f00000, 0xfff80000, 13, "RIPENCC" },
	{ 0x95f90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x95fa0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x95fe0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x96000000, 0xff000000,  8, "ARIN" },
	{ 0x96400000, 0xffe00000, 11, "APNIC" },
	{ 0x96600000, 0xfffc0000, 14, "APNIC" },
	{ 0x96640000, 0xfffe0000, 15, "APNIC" },
	{ 0x966a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x96730000, 0xffff0000, 16, "APNIC" },
	{ 0x96740000, 0xfffe0000, 15, "APNIC" },
	{ 0x96790000, 0xffff0000, 16, "APNIC" },
	{ 0x967a0000, 0xffff0000, 16, "APNIC" },
	{ 0x96800000, 0xffff0000, 16, "RIPENCC" },
	{ 0x96840000, 0xffff0000, 16, "RIPENCC" },
	{ 0x968a0000, 0xfffe0000, 15, "APNIC" },
	{ 0x968c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x96910000, 0xffff0000, 16, "RIPENCC" },
	{ 0x96920000, 0xffff0000, 16, "RIPENCC" },
	{ 0x96960000, 0xfffe0000, 15, "APNIC" },
	{ 0x969e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x96a10000, 0xffff0000, 16, "LACNIC" },
	{ 0x96a20000, 0xfffe0000, 15, "LACNIC" },
	{ 0x96a40000, 0xfffe0000, 15, "LACNIC" },
	{ 0x96ad0000, 0xffff0000, 16, "APNIC" },
	{ 0x96af0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x96b20000, 0xffff0000, 16, "RIPENCC" },
	{ 0x96b70000, 0xffff0000, 16, "APNIC" },
	{ 0x96b90000, 0xffff0000, 16, "LACNIC" },
	{ 0x96ba0000, 0xfffe0000, 15, "LACNIC" },
	{ 0x96bc0000, 0xfffe0000, 15, "LACNIC" },
	{ 0x96bf0000, 0xffff0000, 16, "APNIC" },
	{ 0x96c50000, 0xffff0000, 16, "APNIC" },
	{ 0x96cb0000, 0xffff0000, 16, "APNIC" },
	{ 0x96cc0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x96ce0000, 0xfffe0000, 15, "APNIC" },
	{ 0x96d50000, 0xffff0000, 16, "RIPENCC" },
	{ 0x96d60000, 0xffff0000, 16, "RIPENCC" },
	{ 0x96d90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x96df0000, 0xffff0000, 16, "APNIC" },
	{ 0x96e30000, 0xffff0000, 16, "RIPENCC" },
	{ 0x96e50000, 0xffff0000, 16, "APNIC" },
	{ 0x96ec0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x96f10000, 0xffff0000, 16, "RIPENCC" },
	{ 0x96f40000, 0xffff0000, 16, "RIPENCC" },
	{ 0x96fb0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x96fe0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x96ff0000, 0xffff0000, 16, "APNIC" },
	{ 0x97000000, 0xff000000,  8, "RIPENCC" },
	{ 0x97650000, 0xffff0000, 16, "ARIN" },
	{ 0x97660000, 0xfffe0000, 15, "ARIN" },
	{ 0x97680000, 0xfff80000, 13, "ARIN" },
	{ 0x97700000, 0xfffe0000, 15, "ARIN" },
	{ 0x97720000, 0xffff0000, 16, "ARIN" },
	{ 0x97740000, 0xfffc0000, 14, "ARIN" },
	{ 0x97790000, 0xffff0000, 16, "ARIN" },
	{ 0x977a0000, 0xfffe0000, 15, "ARIN" },
	{ 0x977c0000, 0xfffe0000, 15, "ARIN" },
	{ 0x977e0000, 0xffff0000, 16, "ARIN" },
	{ 0x97800000, 0xffff0000, 16, "ARIN" },
	{ 0x97820000, 0xffff0000, 16, "APNIC" },
	{ 0x97830000, 0xffff0000, 16, "ARIN" },
	{ 0x97840000, 0xffff0000, 16, "ARIN" },
	{ 0x97860000, 0xffff0000, 16, "ARIN" },
	{ 0x97890000, 0xffff0000, 16, "ARIN" },
	{ 0x978a0000, 0xfffe0000, 15, "ARIN" },
	{ 0x978c0000, 0xfffc0000, 14, "ARIN" },
	{ 0x97900000, 0xfff80000, 13, "ARIN" },
	{ 0x97980000, 0xfffc0000, 14, "ARIN" },
	{ 0x979f0000, 0xffff0000, 16, "ARIN" },
	{ 0x97a00000, 0xfff80000, 13, "ARIN" },
	{ 0x97a80000, 0xfffe0000, 15, "ARIN" },
	{ 0x97ab0000, 0xffff0000, 16, "ARIN" },
	{ 0x97ad0000, 0xffff0000, 16, "ARIN" },
	{ 0x97ae0000, 0xffff0000, 16, "ARIN" },
	{ 0x97b20000, 0xffff0000, 16, "APNIC" },
	{ 0x97b30000, 0xffff0000, 16, "ARIN" },
	{ 0x97b50000, 0xffff0000, 16, "ARIN" },
	{ 0x97b80000, 0xfffe0000, 15, "ARIN" },
	{ 0x97ba0000, 0xffff0000, 16, "ARIN" },
	{ 0x97bc0000, 0xffff0000, 16, "ARIN" },
	{ 0x97be0000, 0xfffe0000, 15, "ARIN" },
	{ 0x97c00000, 0xfff80000, 13, "ARIN" },
	{ 0x97ce0000, 0xfffe0000, 15, "ARIN" },
	{ 0x97d00000, 0xfffe0000, 15, "ARIN" },
	{ 0x97d20000, 0xffff0000, 16, "ARIN" },
	{ 0x97d50000, 0xffff0000, 16, "ARIN" },
	{ 0x97d60000, 0xfffe0000, 15, "ARIN" },
	{ 0x98000000, 0xf8000000,  5, "ARIN" },
	{ 0x98420000, 0xffff0000, 16, "RIPENCC" },
	{ 0x98470000, 0xffff0000, 16, "RIPENCC" },
	{ 0x98490000, 0xffff0000, 16, "RIPENCC" },
	{ 0x984a0000, 0xffff0000, 16, "LACNIC" },
	{ 0x984c0000, 0xffff0000, 16, "APNIC" },
	{ 0x984d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x984e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x98510000, 0xffff0000, 16, "RIPENCC" },
	{ 0x98530000, 0xffff0000, 16, "APNIC" },
	{ 0x98540000, 0xffff0000, 16, "LACNIC" },
	{ 0x98580000, 0xffff0000, 16, "RIPENCC" },
	{ 0x985a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x985b0000, 0xffff0000, 16, "APNIC" },
	{ 0x985c0000, 0xffff0000, 16, "LACNIC" },
	{ 0x985d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x985e0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x98600000, 0xffff0000, 16, "RIPENCC" },
	{ 0x98620000, 0xfffe0000, 15, "APNIC" },
	{ 0x98650000, 0xffff0000, 16, "APNIC" },
	{ 0x98660000, 0xfffe0000, 15, "APNIC" },
	{ 0x98680000, 0xffff0000, 16, "APNIC" },
	{ 0x98690000, 0xffff0000, 16, "RIPENCC" },
	{ 0x986a0000, 0xfffe0000, 15, "AFRINIC" },
	{ 0x986c0000, 0xfffc0000, 14, "AFRINIC" },
	{ 0x98700000, 0xffff0000, 16, "AFRINIC" },
	{ 0x98720000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x98760000, 0xffff0000, 16, "APNIC" },
	{ 0x98860000, 0xffff0000, 16, "RIPENCC" },
	{ 0x988b0000, 0xffff0000, 16, "LACNIC" },
	{ 0x988f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x98930000, 0xffff0000, 16, "APNIC" },
	{ 0x98950000, 0xffff0000, 16, "APNIC" },
	{ 0x98960000, 0xffff0000, 16, "RIPENCC" },
	{ 0x98980000, 0xffff0000, 16, "RIPENCC" },
	{ 0x98e20000, 0xffff0000, 16, "APNIC" },
	{ 0x99000000, 0xffff0000, 16, "APNIC" },
	{ 0x99010000, 0xffff0000, 16, "RIPENCC" },
	{ 0x99030000, 0xffff0000, 16, "APNIC" },
	{ 0x99050000, 0xffff0000, 16, "RIPENCC" },
	{ 0x990f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x99110000, 0xffff0000, 16, "RIPENCC" },
	{ 0x99130000, 0xffff0000, 16, "RIPENCC" },
	{ 0x99140000, 0xffff0000, 16, "APNIC" },
	{ 0x99220000, 0xfffe0000, 15, "APNIC" },
	{ 0x99240000, 0xfffe0000, 15, "APNIC" },
	{ 0x99580000, 0xffff0000, 16, "RIPENCC" },
	{ 0x995c0000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x99600000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x99620000, 0xffff0000, 16, "RIPENCC" },
	{ 0x99630000, 0xffff0000, 16, "APNIC" },
	{ 0x99640000, 0xffff0000, 16, "RIPENCC" },
	{ 0x99650000, 0xffff0000, 16, "APNIC" },
	{ 0x996b0000, 0xffff0000, 16, "APNIC" },
	{ 0x996c0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x996e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x996f0000, 0xffff0000, 16, "APNIC" },
	{ 0x99700000, 0xffff0000, 16, "RIPENCC" },
	{ 0x99760000, 0xfffe0000, 15, "APNIC" },
	{ 0x99780000, 0xfff80000, 13, "APNIC" },
	{ 0x99800000, 0xff800000,  9, "APNIC" },
	{ 0x9a080000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9a0a0000, 0xffff0000, 16, "APNIC" },
	{ 0x9a0e0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9a200000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9a210000, 0xffff0000, 16, "APNIC" },
	{ 0x9a220000, 0xffff0000, 16, "APNIC" },
	{ 0x9b040000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9b200000, 0xffff0000, 16, "APNIC" },
	{ 0x9b2d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9b360000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9b380000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9b3b0000, 0xffff0000, 16, "APNIC" },
	{ 0x9b3c0000, 0xffff0000, 16, "APNIC" },
	{ 0x9b420000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9b450000, 0xffff0000, 16, "APNIC" },
	{ 0x9b470000, 0xffff0000, 16, "APNIC" },
	{ 0x9b490000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9b690000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9b830000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9b840000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9b880000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9b8c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9b8f0000, 0xffff0000, 16, "APNIC" },
	{ 0x9b900000, 0xffff0000, 16, "APNIC" },
	{ 0x9b910000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9b9e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9b9f0000, 0xffff0000, 16, "AFRINIC" },
	{ 0x9ba00000, 0xffff0000, 16, "APNIC" },
	{ 0x9bb90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9bbb0000, 0xffff0000, 16, "APNIC" },
	{ 0x9bc00000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9bc60000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9bca0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9bcc0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9bcd0000, 0xffff0000, 16, "APNIC" },
	{ 0x9bcf0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9bd10000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9bd20000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9bd30000, 0xffff0000, 16, "LACNIC" },
	{ 0x9bdf0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9be30000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9be40000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9be60000, 0xffff0000, 16, "APNIC" },
	{ 0x9be70000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9be80000, 0xfff80000, 13, "AFRINIC" },
	{ 0x9bf00000, 0xffff0000, 16, "AFRINIC" },
	{ 0x9bf50000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9bf90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9bfa0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9bfd0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9c080000, 0xffff0000, 16, "AFRINIC" },
	{ 0x9c0a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9c0d0000, 0xffff0000, 16, "APNIC" },
	{ 0x9c0e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9c110000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9c120000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9c160000, 0xffff0000, 16, "APNIC" },
	{ 0x9c190000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9c1c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9c1f0000, 0xffff0000, 16, "APNIC" },
	{ 0x9c230000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9c2b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9c300000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9c320000, 0xffff0000, 16, "APNIC" },
	{ 0x9c330000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9c340000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9c360000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9c3a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9c3b0000, 0xffff0000, 16, "APNIC" },
	{ 0x9c3d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9c3e0000, 0xffff0000, 16, "APNIC" },
	{ 0x9c430000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9c450000, 0xffff0000, 16, "APNIC" },
	{ 0x9c530000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9c610000, 0xffff0000, 16, "LACNIC" },
	{ 0x9c6a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9c720000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9c740000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9c760000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9c850000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9c870000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9c930000, 0xffff0000, 16, "APNIC" },
	{ 0x9c940000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9c950000, 0xffff0000, 16, "APNIC" },
	{ 0x9c960000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9d000000, 0xfffc0000, 14, "APNIC" },
	{ 0x9d040000, 0xffff0000, 16, "APNIC" },
	{ 0x9d060000, 0xfffe0000, 15, "APNIC" },
	{ 0x9d080000, 0xfff80000, 13, "APNIC" },
	{ 0x9d100000, 0xfffc0000, 14, "APNIC" },
	{ 0x9d140000, 0xffff0000, 16, "APNIC" },
	{ 0x9d170000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9d180000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x9d1c0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9d3d0000, 0xffff0000, 16, "APNIC" },
	{ 0x9d3f0000, 0xffff0000, 16, "APNIC" },
	{ 0x9d400000, 0xfff00000, 12, "APNIC" },
	{ 0x9d500000, 0xffff0000, 16, "APNIC" },
	{ 0x9d520000, 0xffff0000, 16, "APNIC" },
	{ 0x9d530000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9d540000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9d550000, 0xffff0000, 16, "APNIC" },
	{ 0x9d560000, 0xffff0000, 16, "LACNIC" },
	{ 0x9d580000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9d5c0000, 0xffff0000, 16, "LACNIC" },
	{ 0x9d5e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9d600000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9d630000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9d640000, 0xffff0000, 16, "LACNIC" },
	{ 0x9d650000, 0xffff0000, 16, "APNIC" },
	{ 0x9d660000, 0xfffe0000, 15, "APNIC" },
	{ 0x9d680000, 0xfff80000, 13, "APNIC" },
	{ 0x9d700000, 0xfffc0000, 14, "APNIC" },
	{ 0x9d740000, 0xfffe0000, 15, "APNIC" },
	{ 0x9d760000, 0xffff0000, 16, "APNIC" },
	{ 0x9d780000, 0xffff0000, 16, "APNIC" },
	{ 0x9d7a0000, 0xffff0000, 16, "APNIC" },
	{ 0x9d7c0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9d800000, 0xffff0000, 16, "APNIC" },
	{ 0x9d810000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9d880000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9d8a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9d8c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9d900000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9d940000, 0xffff0000, 16, "APNIC" },
	{ 0x9d9b0000, 0xffff0000, 16, "APNIC" },
	{ 0x9d9c0000, 0xffff0000, 16, "APNIC" },
	{ 0x9d9d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9d9e0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9da10000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9da20000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9da40000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9da70000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9da80000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9dab0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9dac0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9db10000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9db30000, 0xffff0000, 16, "APNIC" },
	{ 0x9db40000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9dba0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9dbe0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9dc00000, 0xffff0000, 16, "APNIC" },
	{ 0x9dc10000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9dc50000, 0xffff0000, 16, "APNIC" },
	{ 0x9dc80000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9dcb0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9dcd0000, 0xffff0000, 16, "APNIC" },
	{ 0x9dd30000, 0xffff0000, 16, "APNIC" },
	{ 0x9de30000, 0xffff0000, 16, "APNIC" },
	{ 0x9de40000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9dec0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9df30000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9df70000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9df90000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9dfd0000, 0xffff0000, 16, "LACNIC" },
	{ 0x9dff0000, 0xffff0000, 16, "APNIC" },
	{ 0x9e240000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x9e280000, 0xffff0000, 16, "APNIC" },
	{ 0x9e290000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9e2a0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9e2c0000, 0xfffe0000, 15, "APNIC" },
	{ 0x9e2e0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9e310000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9e320000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9e360000, 0xffff0000, 16, "APNIC" },
	{ 0x9e3a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9e400000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9e420000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9e4b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9e590000, 0xffff0000, 16, "APNIC" },
	{ 0x9e5a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9e5c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9e5e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9e610000, 0xffff0000, 16, "LACNIC" },
	{ 0x9e630000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9e660000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9e690000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9e6c0000, 0xffff0000, 16, "APNIC" },
	{ 0x9e6d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9e6e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9e700000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9e770000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9e7c0000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x9e810000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9e830000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9e840000, 0xffff0000, 16, "APNIC" },
	{ 0x9e850000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9e8f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9e900000, 0xffff0000, 16, "APNIC" },
	{ 0x9e940000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9e960000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9e980000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9e9c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9ea00000, 0xffff0000, 16, "LACNIC" },
	{ 0x9ea10000, 0xffff0000, 16, "APNIC" },
	{ 0x9ea20000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9ea60000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9ea80000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9eaa0000, 0xffff0000, 16, "LACNIC" },
	{ 0x9eac0000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x9eb00000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x9eb40000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9eb60000, 0xffff0000, 16, "APNIC" },
	{ 0x9ebe0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9ec00000, 0xfffc0000, 14, "RIPENCC" },
	{ 0x9ec40000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9ec60000, 0xfffe0000, 15, "APNIC" },
	{ 0x9ec80000, 0xfff80000, 13, "APNIC" },
	{ 0x9ed00000, 0xfff80000, 13, "APNIC" },
	{ 0x9ed80000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9ed90000, 0xffff0000, 16, "APNIC" },
	{ 0x9eda0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9edc0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9edf0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9ee10000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9ee20000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9ee60000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9ee80000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9eea0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9ef80000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9efa0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9efb0000, 0xffff0000, 16, "LACNIC" },
	{ 0x9eff0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f000000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f070000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f080000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f0c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f0d0000, 0xffff0000, 16, "APNIC" },
	{ 0x9f0f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f100000, 0xffff0000, 16, "LACNIC" },
	{ 0x9f140000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f160000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9f190000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f1d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f1e0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9f220000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f260000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f2e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f320000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9f340000, 0xffff0000, 16, "APNIC" },
	{ 0x9f3a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f3c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f480000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f490000, 0xffff0000, 16, "APNIC" },
	{ 0x9f500000, 0xffff0000, 16, "APNIC" },
	{ 0x9f510000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f540000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f560000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f5a0000, 0xffff0000, 16, "LACNIC" },
	{ 0x9f5c0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9f5f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f640000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9f670000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f680000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f6b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f6d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f6f0000, 0xffff0000, 16, "APNIC" },
	{ 0x9f720000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f750000, 0xffff0000, 16, "APNIC" },
	{ 0x9f7a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f820000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f860000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f900000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f920000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9f940000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9f970000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f980000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f9a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9f9c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9fa00000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9fa20000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9fa70000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9fa80000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9faa0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9fad0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9fb30000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9fb40000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9fbe0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9fc10000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9fc20000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9fc40000, 0xffff0000, 16, "APNIC" },
	{ 0x9fc50000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9fc80000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9fcd0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9fcf0000, 0xffff0000, 16, "APNIC" },
	{ 0x9fd20000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9fd30000, 0xffff0000, 16, "APNIC" },
	{ 0x9fd50000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9fd80000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9fdb0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9fe00000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9fe20000, 0xffff0000, 16, "APNIC" },
	{ 0x9fe80000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9fec0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9fef0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9ff10000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9ff40000, 0xfffe0000, 15, "RIPENCC" },
	{ 0x9ff80000, 0xffff0000, 16, "APNIC" },
	{ 0x9ffd0000, 0xffff0000, 16, "RIPENCC" },
	{ 0x9ffe0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xa0000000, 0xf8000000,  5, "ARIN" },
	{ 0xa0040000, 0xffff0000, 16, "APNIC" },
	{ 0xa0050000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa0060000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa0080000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xa00b0000, 0xffff0000, 16, "APNIC" },
	{ 0xa00c0000, 0xfffc0000, 14, "APNIC" },
	{ 0xa0100000, 0xfff80000, 13, "APNIC" },
	{ 0xa0180000, 0xfffc0000, 14, "APNIC" },
	{ 0xa01c0000, 0xfffe0000, 15, "APNIC" },
	{ 0xa01e0000, 0xffff0000, 16, "APNIC" },
	{ 0xa0260000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa0280000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa02c0000, 0xfffc0000, 14, "RIPENCC" },
	{ 0xa0300000, 0xfff00000, 12, "RIPENCC" },
	{ 0xa0400000, 0xffff0000, 16, "APNIC" },
	{ 0xa0420000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xa0440000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa0460000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xa04a0000, 0xffff0000, 16, "APNIC" },
	{ 0xa04b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa04e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa0500000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa0550000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa05c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa0600000, 0xffff0000, 16, "APNIC" },
	{ 0xa0610000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa0620000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xa0640000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa0670000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa0680000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa0720000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa0730000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa0740000, 0xfffe0000, 15, "AFRINIC" },
	{ 0xa0760000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa0790000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa07a0000, 0xfffe0000, 15, "AFRINIC" },
	{ 0xa07c0000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa0b40000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa0b90000, 0xffff0000, 16, "APNIC" },
	{ 0xa0ba0000, 0xfffe0000, 15, "APNIC" },
	{ 0xa0bc0000, 0xfffc0000, 14, "APNIC" },
	{ 0xa0c00000, 0xfff80000, 13, "APNIC" },
	{ 0xa0c80000, 0xfffc0000, 14, "APNIC" },
	{ 0xa0cc0000, 0xffff0000, 16, "APNIC" },
	{ 0xa0ce0000, 0xffff0000, 16, "APNIC" },
	{ 0xa0d20000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xa0d50000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa0d60000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa0d80000, 0xfffc0000, 14, "RIPENCC" },
	{ 0xa0dc0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xa0de0000, 0xffff0000, 16, "APNIC" },
	{ 0xa0e40000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa0e90000, 0xffff0000, 16, "APNIC" },
	{ 0xa0eb0000, 0xffff0000, 16, "APNIC" },
	{ 0xa0ed0000, 0xffff0000, 16, "APNIC" },
	{ 0xa0ee0000, 0xfffe0000, 15, "APNIC" },
	{ 0xa0f00000, 0xfffe0000, 15, "APNIC" },
	{ 0xa0f30000, 0xffff0000, 16, "APNIC" },
	{ 0xa0f40000, 0xfffc0000, 14, "APNIC" },
	{ 0xa0f80000, 0xfffc0000, 14, "APNIC" },
	{ 0xa0fc0000, 0xffff0000, 16, "APNIC" },
	{ 0xa1020000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xa1040000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xa1080000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xa10c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa1110000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa1140000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa1170000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa1180000, 0xfffe0000, 15, "LACNIC" },
	{ 0xa11b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa11d0000, 0xffff0000, 16, "APNIC" },
	{ 0xa11e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa1250000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa1290000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa12a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa12b0000, 0xffff0000, 16, "APNIC" },
	{ 0xa1300000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa1320000, 0xffff0000, 16, "APNIC" },
	{ 0xa1340000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xa1360000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa13b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa13e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa1400000, 0xfffe0000, 15, "APNIC" },
	{ 0xa1420000, 0xffff0000, 16, "APNIC" },
	{ 0xa1430000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa1470000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa1480000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xa14a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa14b0000, 0xffff0000, 16, "APNIC" },
	{ 0xa14c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa14e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa14f0000, 0xffff0000, 16, "LACNIC" },
	{ 0xa1530000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa1590000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa15b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa15d0000, 0xffff0000, 16, "APNIC" },
	{ 0xa15e0000, 0xfffe0000, 15, "APNIC" },
	{ 0xa1600000, 0xffff0000, 16, "APNIC" },
	{ 0xa1680000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xa16a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa16e0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xa1700000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa1740000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa1760000, 0xffff0000, 16, "APNIC" },
	{ 0xa17a0000, 0xffff0000, 16, "APNIC" },
	{ 0xa17e0000, 0xffff0000, 16, "APNIC" },
	{ 0xa1830000, 0xffff0000, 16, "LACNIC" },
	{ 0xa1840000, 0xffff0000, 16, "LACNIC" },
	{ 0xa1860000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa18b0000, 0xffff0000, 16, "APNIC" },
	{ 0xa18e0000, 0xfffe0000, 15, "APNIC" },
	{ 0xa1920000, 0xffff0000, 16, "APNIC" },
	{ 0xa1930000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa1940000, 0xffff0000, 16, "LACNIC" },
	{ 0xa1980000, 0xffff0000, 16, "APNIC" },
	{ 0xa19e0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa1be0000, 0xffff0000, 16, "LACNIC" },
	{ 0xa1c40000, 0xffff0000, 16, "LACNIC" },
	{ 0xa1c80000, 0xffff0000, 16, "APNIC" },
	{ 0xa1ca0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa1cf0000, 0xffff0000, 16, "APNIC" },
	{ 0xa1da0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa1e50000, 0xffff0000, 16, "APNIC" },
	{ 0xa1ee0000, 0xffff0000, 16, "LACNIC" },
	{ 0xa1f60000, 0xffff0000, 16, "APNIC" },
	{ 0xa1f80000, 0xffff0000, 16, "APNIC" },
	{ 0xa1fc0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa20b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa20d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa2150000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa2170000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa2190000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa21a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa2260000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa2560000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa2690000, 0xffff0000, 16, "APNIC" },
	{ 0xa2700000, 0xffff0000, 16, "APNIC" },
	{ 0xa27a0000, 0xffff0000, 16, "LACNIC" },
	{ 0xa2910000, 0xffff0000, 16, "APNIC" },
	{ 0xa2920000, 0xfffe0000, 15, "APNIC" },
	{ 0xa3000000, 0xffff0000, 16, "APNIC" },
	{ 0xa3010000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa3030000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa3050000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa3070000, 0xffff0000, 16, "APNIC" },
	{ 0xa3080000, 0xffff0000, 16, "APNIC" },
	{ 0xa3090000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa30a0000, 0xffff0000, 16, "LACNIC" },
	{ 0xa30d0000, 0xffff0000, 16, "APNIC" },
	{ 0xa30e0000, 0xfffe0000, 15, "APNIC" },
	{ 0xa3100000, 0xfff00000, 12, "APNIC" },
	{ 0xa3200000, 0xffff0000, 16, "APNIC" },
	{ 0xa3220000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa32a0000, 0xfffe0000, 15, "APNIC" },
	{ 0xa32c0000, 0xfffc0000, 14, "APNIC" },
	{ 0xa3300000, 0xfffc0000, 14, "APNIC" },
	{ 0xa3360000, 0xfffe0000, 15, "APNIC" },
	{ 0xa3380000, 0xffff0000, 16, "APNIC" },
	{ 0xa33a0000, 0xfffe0000, 15, "APNIC" },
	{ 0xa33c0000, 0xfffe0000, 15, "APNIC" },
	{ 0xa33e0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xa3750000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa3770000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa3790000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa37a0000, 0xffff0000, 16, "APNIC" },
	{ 0xa37d0000, 0xffff0000, 16, "APNIC" },
	{ 0xa3820000, 0xfffe0000, 15, "APNIC" },
	{ 0xa3840000, 0xfffc0000, 14, "APNIC" },
	{ 0xa3880000, 0xfff80000, 13, "APNIC" },
	{ 0xa3900000, 0xfffc0000, 14, "APNIC" },
	{ 0xa3940000, 0xfffe0000, 15, "APNIC" },
	{ 0xa3980000, 0xffff0000, 16, "APNIC" },
	{ 0xa39c0000, 0xfffc0000, 14, "RIPENCC" },
	{ 0xa3a00000, 0xfffc0000, 14, "RIPENCC" },
	{ 0xa3a40000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa3a50000, 0xffff8000, 17, "RIPENCC" },
	{ 0xa3a5c000, 0xffffc000, 18, "RIPENCC" },
	{ 0xa3a60000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xa3a80000, 0xfff80000, 13, "RIPENCC" },
	{ 0xa3b10000, 0xffff0000, 16, "APNIC" },
	{ 0xa3b20000, 0xffff0000, 16, "LACNIC" },
	{ 0xa3b30000, 0xffff0000, 16, "APNIC" },
	{ 0xa3b40000, 0xffff0000, 16, "APNIC" },
	{ 0xa3bd0000, 0xffff0000, 16, "APNIC" },
	{ 0xa3c30000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa3c40000, 0xfffc0000, 14, "AFRINIC" },
	{ 0xa3c80000, 0xfffc0000, 14, "AFRINIC" },
	{ 0xa3cc0000, 0xffff0000, 16, "APNIC" },
	{ 0xa3d00000, 0xfff80000, 13, "APNIC" },
	{ 0xa3d90000, 0xffff0000, 16, "APNIC" },
	{ 0xa3da0000, 0xfffe0000, 15, "APNIC" },
	{ 0xa3dc0000, 0xfffc0000, 14, "APNIC" },
	{ 0xa3e00000, 0xfffc0000, 14, "APNIC" },
	{ 0xa3e50000, 0xffff0000, 16, "APNIC" },
	{ 0xa3e80000, 0xfffe0000, 15, "APNIC" },
	{ 0xa3ef0000, 0xffff0000, 16, "APNIC" },
	{ 0xa3f20000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa3f70000, 0xffff0000, 16, "LACNIC" },
	{ 0xa3fa0000, 0xffff0000, 16, "LACNIC" },
	{ 0xa3ff0000, 0xffff0000, 16, "APNIC" },
	{ 0xa4000000, 0xffe00000, 11, "RIPENCC" },
	{ 0xa4200000, 0xfff80000, 13, "RIPENCC" },
	{ 0xa4280000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa4290000, 0xffff0000, 16, "LACNIC" },
	{ 0xa42b0000, 0xffff0000, 16, "APNIC" },
	{ 0xa42e0000, 0xffff0000, 16, "APNIC" },
	{ 0xa4300000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa4350000, 0xffff0000, 16, "APNIC" },
	{ 0xa43b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa43c0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xa4450000, 0xffff0000, 16, "APNIC" },
	{ 0xa4460000, 0xfffe0000, 15, "APNIC" },
	{ 0xa4490000, 0xffff0000, 16, "LACNIC" },
	{ 0xa44b0000, 0xffff0000, 16, "APNIC" },
	{ 0xa44d0000, 0xffff0000, 16, "LACNIC" },
	{ 0xa44e0000, 0xffff0000, 16, "APNIC" },
	{ 0xa4500000, 0xffff0000, 16, "APNIC" },
	{ 0xa4510000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa4550000, 0xffff0000, 16, "LACNIC" },
	{ 0xa4580000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa4600000, 0xffff0000, 16, "LACNIC" },
	{ 0xa4610000, 0xffff0000, 16, "APNIC" },
	{ 0xa4620000, 0xffff0000, 16, "LACNIC" },
	{ 0xa4640000, 0xffff0000, 16, "APNIC" },
	{ 0xa46c0000, 0xffff0000, 16, "APNIC" },
	{ 0xa4700000, 0xffff0000, 16, "APNIC" },
	{ 0xa4730000, 0xffff0000, 16, "APNIC" },
	{ 0xa47c0000, 0xfffe0000, 15, "APNIC" },
	{ 0xa47e0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xa4800000, 0xfff80000, 13, "RIPENCC" },
	{ 0xa4880000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xa48b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa48c0000, 0xfffc0000, 14, "RIPENCC" },
	{ 0xa4920000, 0xfffe0000, 15, "AFRINIC" },
	{ 0xa49b0000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa4a10000, 0xffff0000, 16, "APNIC" },
	{ 0xa4a20000, 0xffff0000, 16, "APNIC" },
	{ 0xa4a40000, 0xffff0000, 16, "APNIC" },
	{ 0xa4b10000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa4d70000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa5030000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa5080000, 0xfffc0000, 14, "AFRINIC" },
	{ 0xa50c0000, 0xffff0000, 16, "APNIC" },
	{ 0xa50e0000, 0xffff0000, 16, "APNIC" },
	{ 0xa5150000, 0xffff0000, 16, "APNIC" },
	{ 0xa5190000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa51f0000, 0xffff0000, 16, "APNIC" },
	{ 0xa5450000, 0xffff0000, 16, "APNIC" },
	{ 0xa54c0000, 0xffff0000, 16, "APNIC" },
	{ 0xa5540000, 0xffff0000, 16, "APNIC" },
	{ 0xa5560000, 0xffff0000, 16, "APNIC" },
	{ 0xa55d0000, 0xffff0000, 16, "APNIC" },
	{ 0xa5600000, 0xffff0000, 16, "APNIC" },
	{ 0xa5620000, 0xffff0000, 16, "LACNIC" },
	{ 0xa5630000, 0xffff0000, 16, "APNIC" },
	{ 0xa5640000, 0xfffe0000, 15, "APNIC" },
	{ 0xa5660000, 0xffff0000, 16, "APNIC" },
	{ 0xa56c0000, 0xffff0000, 16, "APNIC" },
	{ 0xa5720000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa5760000, 0xffff0000, 16, "APNIC" },
	{ 0xa5840000, 0xfffe0000, 15, "APNIC" },
	{ 0xa58d0000, 0xffff0000, 16, "APNIC" },
	{ 0xa58e0000, 0xffff0000, 16, "APNIC" },
	{ 0xa58f0000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa5900000, 0xfffc0000, 14, "AFRINIC" },
	{ 0xa5940000, 0xfffe0000, 15, "AFRINIC" },
	{ 0xa5a50000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa5b40000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa5b60000, 0xfffe0000, 15, "LACNIC" },
	{ 0xa5ba0000, 0xfffe0000, 15, "APNIC" },
	{ 0xa5bf0000, 0xffff0000, 16, "APNIC" },
	{ 0xa5c20000, 0xffff0000, 16, "APNIC" },
	{ 0xa5ca0000, 0xffff0000, 16, "APNIC" },
	{ 0xa5cd0000, 0xffff0000, 16, "APNIC" },
	{ 0xa5d10000, 0xffff0000, 16, "APNIC" },
	{ 0xa5d50000, 0xffff0000, 16, "APNIC" },
	{ 0xa5da0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa5dc0000, 0xffff0000, 16, "APNIC" },
	{ 0xa5de0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa5e40000, 0xfffe0000, 15, "APNIC" },
	{ 0xa5e70000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa5e90000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa5f00000, 0xfffc0000, 14, "APNIC" },
	{ 0xa5f40000, 0xffff0000, 16, "APNIC" },
	{ 0xa5f60000, 0xffff0000, 16, "APNIC" },
	{ 0xa6080000, 0xfff80000, 13, "RIPENCC" },
	{ 0xa6318000, 0xffff8000, 17, "RIPENCC" },
	{ 0xa6400000, 0xfffe0000, 15, "APNIC" },
	{ 0xa64b0000, 0xffff0000, 16, "LACNIC" },
	{ 0xa64f0000, 0xffff0000, 16, "APNIC" },
	{ 0xa6530000, 0xffff0000, 16, "APNIC" },
	{ 0xa6550000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa6570000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa6640000, 0xffff0000, 16, "APNIC" },
	{ 0xa6670000, 0xffff0000, 16, "APNIC" },
	{ 0xa6680000, 0xffff0000, 16, "APNIC" },
	{ 0xa66e0000, 0xffff0000, 16, "LACNIC" },
	{ 0xa66f0000, 0xffff0000, 16, "APNIC" },
	{ 0xa6720000, 0xffff0000, 16, "LACNIC" },
	{ 0xa6760000, 0xfffe0000, 15, "APNIC" },
	{ 0xa6780000, 0xfffe0000, 15, "APNIC" },
	{ 0xa67d0000, 0xffff0000, 16, "APNIC" },
	{ 0xa71c0000, 0xffff0000, 16, "LACNIC" },
	{ 0xa71e0000, 0xffff0000, 16, "APNIC" },
	{ 0xa7510000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa7670000, 0xffff0000, 16, "APNIC" },
	{ 0xa76f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa77b0000, 0xffff0000, 16, "APNIC" },
	{ 0xa7820000, 0xffff0000, 16, "APNIC" },
	{ 0xa7860000, 0xffff0000, 16, "LACNIC" },
	{ 0xa78b0000, 0xffff0000, 16, "APNIC" },
	{ 0xa79d0000, 0xffff0000, 16, "LACNIC" },
	{ 0xa7a20000, 0xffff0000, 16, "APNIC" },
	{ 0xa7a80000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa7a90000, 0xffff0000, 16, "APNIC" },
	{ 0xa7ac0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa7af0000, 0xffff0000, 16, "APNIC" },
	{ 0xa7b30000, 0xffff0000, 16, "APNIC" },
	{ 0xa7bd0000, 0xffff0000, 16, "APNIC" },
	{ 0xa7cb0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa7cd0000, 0xffff0000, 16, "APNIC" },
	{ 0xa7fc0000, 0xffff0000, 16, "LACNIC" },
	{ 0xa8000000, 0xfc000000,  6, "ARIN" },
	{ 0xa8010000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa8460000, 0xffff0000, 16, "APNIC" },
	{ 0xa84c0000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa84d0000, 0xffff0000, 16, "LACNIC" },
	{ 0xa84e0000, 0xffff0000, 16, "APNIC" },
	{ 0xa8500000, 0xfffe0000, 15, "AFRINIC" },
	{ 0xa8530000, 0xffff0000, 16, "LACNIC" },
	{ 0xa8590000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa85f0000, 0xffff0000, 16, "APNIC" },
	{ 0xa8600000, 0xffff0000, 16, "LACNIC" },
	{ 0xa8650000, 0xffff0000, 16, "LACNIC" },
	{ 0xa86a0000, 0xffff0000, 16, "APNIC" },
	{ 0xa8730000, 0xffff0000, 16, "APNIC" },
	{ 0xa8780000, 0xffff0000, 16, "APNIC" },
	{ 0xa87e0000, 0xffff0000, 16, "APNIC" },
	{ 0xa8800000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa8820000, 0xfffe0000, 15, "APNIC" },
	{ 0xa8840000, 0xffff0000, 16, "APNIC" },
	{ 0xa8860000, 0xffff0000, 16, "APNIC" },
	{ 0xa88b0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa88c0000, 0xffff0000, 16, "APNIC" },
	{ 0xa88e0000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa8980000, 0xfffe0000, 15, "APNIC" },
	{ 0xa89a0000, 0xffff0000, 16, "APNIC" },
	{ 0xa89b0000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa8a00000, 0xffff0000, 16, "APNIC" },
	{ 0xa8a40000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa8a50000, 0xffff0000, 16, "LACNIC" },
	{ 0xa8a70000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa8ac0000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa8b00000, 0xffff0000, 16, "LACNIC" },
	{ 0xa8ba0000, 0xffff0000, 16, "APNIC" },
	{ 0xa8bb0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xa8bc0000, 0xffff0000, 16, "APNIC" },
	{ 0xa8c60000, 0xffff0000, 16, "APNIC" },
	{ 0xa8ce0000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa8d10000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa8d90000, 0xffff0000, 16, "APNIC" },
	{ 0xa8db0000, 0xffff0000, 16, "APNIC" },
	{ 0xa8e20000, 0xffff0000, 16, "LACNIC" },
	{ 0xa8e70000, 0xffff0000, 16, "LACNIC" },
	{ 0xa8ea0000, 0xffff0000, 16, "LACNIC" },
	{ 0xa8f30000, 0xffff0000, 16, "LACNIC" },
	{ 0xa8f80000, 0xfffe0000, 15, "APNIC" },
	{ 0xa8fc0000, 0xffff0000, 16, "APNIC" },
	{ 0xa8ff0000, 0xffff0000, 16, "LACNIC" },
	{ 0xa9200000, 0xffe00000, 11, "RIPENCC" },
	{ 0xa9810000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa98c0000, 0xffff0000, 16, "APNIC" },
	{ 0xa99e0000, 0xffff0000, 16, "LACNIC" },
	{ 0xa9ca0000, 0xffff0000, 16, "AFRINIC" },
	{ 0xa9d00000, 0xfff00000, 12, "APNIC" },
	{ 0xaa120000, 0xffff0000, 16, "LACNIC" },
	{ 0xaa190000, 0xffff0000, 16, "LACNIC" },
	{ 0xaa260000, 0xffff0000, 16, "APNIC" },
	{ 0xaa330000, 0xffff0000, 16, "LACNIC" },
	{ 0xaa3c0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xaa420000, 0xffff0000, 16, "LACNIC" },
	{ 0xaa460000, 0xffff0000, 16, "LACNIC" },
	{ 0xaa9b0000, 0xffff0000, 16, "LACNIC" },
	{ 0xaa9d0000, 0xffff0000, 16, "APNIC" },
	{ 0xaaa90000, 0xffff0000, 16, "LACNIC" },
	{ 0xaab30000, 0xffff0000, 16, "APNIC" },
	{ 0xaad20000, 0xffff0000, 16, "LACNIC" },
	{ 0xaaec0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xaaff0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xab000000, 0xfff00000, 12, "APNIC" },
	{ 0xab100000, 0xfff80000, 13, "RIPENCC" },
	{ 0xab180000, 0xffff0000, 16, "RIPENCC" },
	{ 0xab190000, 0xffff8000, 17, "RIPENCC" },
	{ 0xab198000, 0xffffe000, 19, "RIPENCC" },
	{ 0xab19a000, 0xfffff000, 20, "RIPENCC" },
	{ 0xab19b000, 0xfffffe00, 23, "RIPENCC" },
	{ 0xab19b300, 0xffffff00, 24, "RIPENCC" },
	{ 0xab19b400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xab19b800, 0xfffff800, 21, "RIPENCC" },
	{ 0xab19c000, 0xfffff000, 20, "RIPENCC" },
	{ 0xab19d000, 0xfffff800, 21, "RIPENCC" },
	{ 0xab19d800, 0xfffffc00, 22, "RIPENCC" },
	{ 0xab19dc00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xab19de00, 0xffffff00, 24, "RIPENCC" },
	{ 0xab19e000, 0xffffe000, 19, "RIPENCC" },
	{ 0xab1a0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xab1c0000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xab1f0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xab200000, 0xffff0000, 16, "RIPENCC" },
	{ 0xab210000, 0xffffc000, 18, "RIPENCC" },
	{ 0xab220000, 0xfffe0000, 15, "APNIC" },
	{ 0xab240000, 0xfffc0000, 14, "APNIC" },
	{ 0xab280000, 0xfff80000, 13, "APNIC" },
	{ 0xab300000, 0xfff00000, 12, "APNIC" },
	{ 0xab4c0000, 0xfffc0000, 14, "APNIC" },
	{ 0xab500000, 0xfff00000, 12, "APNIC" },
	{ 0xab600000, 0xffe00000, 11, "APNIC" },
	{ 0xabcf0000, 0xffff0000, 16, "APNIC" },
	{ 0xabd00000, 0xfff00000, 12, "APNIC" },
	{ 0xabe00000, 0xffe00000, 11, "APNIC" },
	{ 0xac000000, 0xfe000000,  7, "ARIN" },
	{ 0xae000000, 0xff000000,  8, "ARIN" },
	{ 0xaf000000, 0xff000000,  8, "APNIC" },
	{ 0xb0000000, 0xff000000,  8, "RIPENCC" },
	{ 0xb1000000, 0xff000000,  8, "LACNIC" },
	{ 0xb2000000, 0xff000000,  8, "RIPENCC" },
	{ 0xb3000000, 0xff000000,  8, "LACNIC" },
	{ 0xb4000000, 0xff000000,  8, "APNIC" },
	{ 0xb5000000, 0xff000000,  8, "LACNIC" },
	{ 0xb6000000, 0xfe000000,  7, "APNIC" },
	{ 0xb8000000, 0xff000000,  8, "ARIN" },
	{ 0xb9000000, 0xff000000,  8, "RIPENCC" },
	{ 0xba000000, 0xfe000000,  7, "LACNIC" },
	{ 0xbc000000, 0xff000000,  8, "RIPENCC" },
	{ 0xbd000000, 0xff000000,  8, "LACNIC" },
	{ 0xbe000000, 0xff000000,  8, "LACNIC" },
	{ 0xbf000000, 0xff000000,  8, "ARIN" },
	{ 0xc0000000, 0xff000000,  8, "ARIN" },
	{ 0xc0051c00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0051e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0052400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0053200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0053b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0053d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0053e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0055a00, 0xffffff00, 24, "APNIC" },
	{ 0xc0056100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0058e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0059100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc005a200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc005d800, 0xffffff00, 24, "APNIC" },
	{ 0xc005ef00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc005f000, 0xffffff00, 24, "APNIC" },
	{ 0xc005fe00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc00c0100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc00c2f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc00c3600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc00c4800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc00c4c00, 0xffffff00, 24, "APNIC" },
	{ 0xc00c4d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc00c5100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc00c6000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc00c6300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc00cc000, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc00cc200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc00cd900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc00cda00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc00ce700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc00ce800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc00ceb00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc00cf700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0107b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0107c00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0108000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc0108800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0108a00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0108c00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0109000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc0109800, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc010b200, 0xfffffe00, 23, "APNIC" },
	{ 0xc010b400, 0xffffff00, 24, "APNIC" },
	{ 0xc010b700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc010b800, 0xfffff800, 21, "RIPENCC" },
	{ 0xc010c000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc010c800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc010ca00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc012c300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc01a1c00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc01a2d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc01a2e00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc01a5b00, 0xffffff00, 24, "APNIC" },
	{ 0xc01a5d00, 0xffffff00, 24, "APNIC" },
	{ 0xc01a5e00, 0xffffff00, 24, "APNIC" },
	{ 0xc01a6000, 0xffffff00, 24, "APNIC" },
	{ 0xc01a6900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc01a6a00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc01a6c00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc01a7000, 0xfffff000, 20, "RIPENCC" },
	{ 0xc01a8000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc01a8500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc01a8600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc01a9a00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc01aae00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc01ad800, 0xfffff800, 21, "APNIC" },
	{ 0xc01ae000, 0xfffffc00, 22, "APNIC" },
	{ 0xc01ae400, 0xfffffe00, 23, "APNIC" },
	{ 0xc01ae600, 0xffffff00, 24, "APNIC" },
	{ 0xc01ae700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc01ae800, 0xffffff00, 24, "APNIC" },
	{ 0xc01aea00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc01aec00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc01f0e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc01f1700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc01f1a00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc01f1f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc01f2800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc01f3e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc01f6600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc01f7400, 0xfffffc00, 22, "APNIC" },
	{ 0xc01f7800, 0xfffffc00, 22, "APNIC" },
	{ 0xc01f7c00, 0xffffff00, 24, "APNIC" },
	{ 0xc01fa600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc01fa800, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc01fc500, 0xffffff00, 24, "APNIC" },
	{ 0xc01fc600, 0xfffffe00, 23, "APNIC" },
	{ 0xc01fc800, 0xfffffc00, 22, "APNIC" },
	{ 0xc01fcc00, 0xfffffe00, 23, "APNIC" },
	{ 0xc01fce00, 0xffffff00, 24, "APNIC" },
	{ 0xc01fd300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc01fe700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc01ffc00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0210a00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0210f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0211000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0212400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0215700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0215800, 0xfffff800, 21, "RIPENCC" },
	{ 0xc0216000, 0xfffff000, 20, "RIPENCC" },
	{ 0xc0217100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0217200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0217600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0217800, 0xfffff800, 21, "RIPENCC" },
	{ 0xc0218200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0218700, 0xffffff00, 24, "APNIC" },
	{ 0xc0218f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0219000, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0219300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0219400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0219800, 0xfffff800, 21, "RIPENCC" },
	{ 0xc021a000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc021a400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc021a600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc021a900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc021aa00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc021b000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc021b400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc021b600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc021c000, 0xffffe000, 19, "RIPENCC" },
	{ 0xc021fe00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0221300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0223200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0226b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0227400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc022b300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0230000, 0xfffff000, 20, "RIPENCC" },
	{ 0xc0231000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0233b00, 0xffffff00, 24, "APNIC" },
	{ 0xc0233f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0234000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0235a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0235e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0236c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0238a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0239200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0239500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0239600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0239800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc023ac00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc023b700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc023c500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc023c600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc023cd00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc023ce00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc023e500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc023f000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc023f400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc023f600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc023f800, 0xffffff00, 24, "APNIC" },
	{ 0xc0240000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xc0260000, 0xffff0000, 16, "RIPENCC" },
	{ 0xc0284500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0284600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0284800, 0xfffff800, 21, "RIPENCC" },
	{ 0xc0285000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc028e400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0296700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0296800, 0xfffff800, 21, "RIPENCC" },
	{ 0xc0297000, 0xfffff000, 20, "RIPENCC" },
	{ 0xc0298000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc0298c00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0299200, 0xffffff00, 24, "APNIC" },
	{ 0xc0299300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0299500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc029aa00, 0xffffff00, 24, "APNIC" },
	{ 0xc029b200, 0xfffffe00, 23, "APNIC" },
	{ 0xc029b400, 0xfffffc00, 22, "APNIC" },
	{ 0xc029b800, 0xfffff800, 21, "APNIC" },
	{ 0xc029c000, 0xfffffc00, 22, "APNIC" },
	{ 0xc029c400, 0xfffffe00, 23, "APNIC" },
	{ 0xc029cb00, 0xffffff00, 24, "APNIC" },
	{ 0xc029ce00, 0xffffff00, 24, "APNIC" },
	{ 0xc029d200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc029d800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc029da00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc029e300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc02a0100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc02a2a00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc02a3500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc02a3c00, 0xfffffe00, 23, "APNIC" },
	{ 0xc02a3e00, 0xffffff00, 24, "APNIC" },
	{ 0xc02a3f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc02a4000, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc02a5700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc02a6300, 0xffffff00, 24, "AFRINIC" },
	{ 0xc02a6400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc02a6600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc02a6700, 0xffffff00, 24, "APNIC" },
	{ 0xc02a6800, 0xfffffc00, 22, "APNIC" },
	{ 0xc02a7100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc02a7200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc02a7400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc02a7b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc02a7c00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc02a8000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc02a8f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc02a9700, 0xffffff00, 24, "APNIC" },
	{ 0xc02ab400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc02ab800, 0xfffff800, 21, "RIPENCC" },
	{ 0xc02ac000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc02ac800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc02aed00, 0xffffff00, 24, "APNIC" },
	{ 0xc02afd00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc02ba200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc02bb900, 0xffffff00, 24, "APNIC" },
	{ 0xc02bc000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc02bc400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc02bc600, 0xffffff00, 24, "APNIC" },
	{ 0xc02bcf00, 0xffffff00, 24, "APNIC" },
	{ 0xc02bd000, 0xfffffe00, 23, "APNIC" },
	{ 0xc02bd200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc02bd400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc02be200, 0xfffffe00, 23, "APNIC" },
	{ 0xc02be400, 0xfffffe00, 23, "APNIC" },
	{ 0xc02bea00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc02bef00, 0xffffff00, 24, "APNIC" },
	{ 0xc02c0000, 0xffffc000, 18, "RIPENCC" },
	{ 0xc02c4000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc02c4700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc02c4800, 0xfffff800, 21, "RIPENCC" },
	{ 0xc02c5000, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc02cf000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc02cf800, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc02f0000, 0xfffff000, 20, "APNIC" },
	{ 0xc02f1000, 0xfffff800, 21, "APNIC" },
	{ 0xc02f1800, 0xfffffc00, 22, "APNIC" },
	{ 0xc02f1d00, 0xffffff00, 24, "APNIC" },
	{ 0xc02f1e00, 0xfffffe00, 23, "APNIC" },
	{ 0xc02f2000, 0xfffffc00, 22, "APNIC" },
	{ 0xc02f2500, 0xffffff00, 24, "APNIC" },
	{ 0xc02f2600, 0xfffffe00, 23, "APNIC" },
	{ 0xc02f2800, 0xfffff800, 21, "APNIC" },
	{ 0xc02f3000, 0xfffff000, 20, "APNIC" },
	{ 0xc02f4000, 0xffffc000, 18, "APNIC" },
	{ 0xc02f8000, 0xffffc000, 18, "APNIC" },
	{ 0xc02fc000, 0xffffe000, 19, "APNIC" },
	{ 0xc02fe000, 0xfffff000, 20, "APNIC" },
	{ 0xc02ff000, 0xfffffe00, 23, "APNIC" },
	{ 0xc02ff400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0301f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0306b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0306d00, 0xffffff00, 24, "APNIC" },
	{ 0xc0306e00, 0xffffff00, 24, "APNIC" },
	{ 0xc0309100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc030e000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc030e700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc030fd00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0310000, 0xfffff000, 20, "RIPENCC" },
	{ 0xc0311d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0311e00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0314a00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0320000, 0xffff0000, 16, "APNIC" },
	{ 0xc0330000, 0xfffff000, 20, "RIPENCC" },
	{ 0xc0331000, 0xfffff000, 20, "APNIC" },
	{ 0xc0332000, 0xfffff000, 20, "APNIC" },
	{ 0xc0333100, 0xffffff00, 24, "APNIC" },
	{ 0xc0333200, 0xfffffe00, 23, "APNIC" },
	{ 0xc0333400, 0xfffffc00, 22, "APNIC" },
	{ 0xc0333800, 0xfffff800, 21, "APNIC" },
	{ 0xc0334000, 0xffffc000, 18, "APNIC" },
	{ 0xc0338000, 0xffffe000, 19, "APNIC" },
	{ 0xc033a000, 0xfffff000, 20, "APNIC" },
	{ 0xc033b000, 0xfffff800, 21, "APNIC" },
	{ 0xc033b800, 0xfffffc00, 22, "APNIC" },
	{ 0xc033bd00, 0xffffff00, 24, "APNIC" },
	{ 0xc033be00, 0xfffffe00, 23, "APNIC" },
	{ 0xc033c200, 0xfffffe00, 23, "APNIC" },
	{ 0xc033c400, 0xfffffc00, 22, "APNIC" },
	{ 0xc033c800, 0xfffff800, 21, "APNIC" },
	{ 0xc033d000, 0xfffff000, 20, "APNIC" },
	{ 0xc033e000, 0xfffff000, 20, "APNIC" },
	{ 0xc033f100, 0xffffff00, 24, "APNIC" },
	{ 0xc033f200, 0xfffffe00, 23, "APNIC" },
	{ 0xc033f400, 0xfffffc00, 22, "APNIC" },
	{ 0xc033f800, 0xfffff800, 21, "APNIC" },
	{ 0xc0340000, 0xffffe000, 19, "RIPENCC" },
	{ 0xc0344800, 0xfffffe00, 23, "APNIC" },
	{ 0xc0349800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0349f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc034a000, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc034ab00, 0xffffff00, 24, "APNIC" },
	{ 0xc034ac00, 0xfffffc00, 22, "APNIC" },
	{ 0xc034b000, 0xffffff00, 24, "APNIC" },
	{ 0xc034dd00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc034de00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc034e800, 0xffffff00, 24, "AFRINIC" },
	{ 0xc034fd00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc034fe00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0356700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0356800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0361f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0362000, 0xfffff000, 20, "RIPENCC" },
	{ 0xc0363000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0363400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0363600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0363800, 0xfffff800, 21, "RIPENCC" },
	{ 0xc0364000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0364800, 0xfffff800, 21, "RIPENCC" },
	{ 0xc0365000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0366800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0366900, 0xffffff00, 24, "APNIC" },
	{ 0xc0366a00, 0xffffff00, 24, "APNIC" },
	{ 0xc0367100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0367300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0367400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0367800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0367a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0367d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0368200, 0xffffff00, 24, "APNIC" },
	{ 0xc0368400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0368700, 0xffffff00, 24, "APNIC" },
	{ 0xc0368b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0368d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0368e00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0369000, 0xfffff000, 20, "RIPENCC" },
	{ 0xc036a000, 0xffffe000, 19, "RIPENCC" },
	{ 0xc036c000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc036c800, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc036cd00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc036ce00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc036d000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc036d800, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc036dc00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc036e100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc036f400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc036fb00, 0xffffff00, 24, "APNIC" },
	{ 0xc036fe00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0375400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0375900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0376200, 0xfffffe00, 23, "APNIC" },
	{ 0xc0376500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0376900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0377000, 0xffffff00, 24, "APNIC" },
	{ 0xc0377300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0377600, 0xffffff00, 24, "APNIC" },
	{ 0xc0378100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0378400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc037bc00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc037be00, 0xffffff00, 24, "APNIC" },
	{ 0xc037c100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc037c500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc037c600, 0xffffff00, 24, "APNIC" },
	{ 0xc037d400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc037db00, 0xffffff00, 24, "APNIC" },
	{ 0xc037dc00, 0xffffff00, 24, "APNIC" },
	{ 0xc037e800, 0xffffff00, 24, "APNIC" },
	{ 0xc037f400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc03a0900, 0xffffff00, 24, "APNIC" },
	{ 0xc03a0a00, 0xfffffe00, 23, "APNIC" },
	{ 0xc03a0c00, 0xfffffc00, 22, "APNIC" },
	{ 0xc03a1000, 0xfffffe00, 23, "APNIC" },
	{ 0xc03a1200, 0xffffff00, 24, "APNIC" },
	{ 0xc03a1c00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc03a2000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc03a2900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc03a8500, 0xffffff00, 24, "APNIC" },
	{ 0xc03a8600, 0xfffffe00, 23, "APNIC" },
	{ 0xc03a8800, 0xffffff00, 24, "APNIC" },
	{ 0xc03ac500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc03ada00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0401c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0406400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0407d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc040ca00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0413300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0413400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0413800, 0xfffff800, 21, "RIPENCC" },
	{ 0xc0414000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0414400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0414600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0415200, 0xfffffe00, 23, "APNIC" },
	{ 0xc0415400, 0xfffffc00, 22, "APNIC" },
	{ 0xc0415800, 0xfffffc00, 22, "APNIC" },
	{ 0xc0415c00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0415e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0416000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0418200, 0xffffff00, 24, "APNIC" },
	{ 0xc0418300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0418400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0418b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0419000, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0419200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0419800, 0xffffff00, 24, "LACNIC" },
	{ 0xc0419900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc041b600, 0xffffff00, 24, "APNIC" },
	{ 0xc041b700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc041d900, 0xffffff00, 24, "APNIC" },
	{ 0xc041db00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc041dc00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0420000, 0xffff0000, 16, "RIPENCC" },
	{ 0xc0430300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0430400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0430c00, 0xffffff00, 24, "APNIC" },
	{ 0xc0432700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0432b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0432f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0433200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0433400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0433700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0433a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0434c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0434f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0435400, 0xffffff00, 24, "APNIC" },
	{ 0xc0435700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0435e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0436400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0436800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0438700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc043a700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc043aa00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc043ab00, 0xffffff00, 24, "APNIC" },
	{ 0xc043bd00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc043be00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc043c000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc043c500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc043c600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc043c800, 0xfffff800, 21, "RIPENCC" },
	{ 0xc043d000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc043da00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc043dc00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc043df00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc043f800, 0xffffff00, 24, "APNIC" },
	{ 0xc043f900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0440000, 0xfffff000, 20, "RIPENCC" },
	{ 0xc0441000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0441700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0441f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0444c00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0448400, 0xffffff00, 24, "APNIC" },
	{ 0xc0448a00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0449700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0449800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc044a500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc044aa00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc044ab00, 0xffffff00, 24, "APNIC" },
	{ 0xc044ac00, 0xffffff00, 24, "APNIC" },
	{ 0xc044ae00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc044b000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc044b600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc044ba00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc044d100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc044d300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc044d400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc044d800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc044dd00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc044e000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc044e600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc044eb00, 0xffffff00, 24, "APNIC" },
	{ 0xc044ec00, 0xfffffc00, 22, "APNIC" },
	{ 0xc044f000, 0xfffff800, 21, "APNIC" },
	{ 0xc044f800, 0xfffffe00, 23, "APNIC" },
	{ 0xc044fa00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc044fc00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc044fe00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0460000, 0xffffc000, 18, "RIPENCC" },
	{ 0xc0465c00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0466100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0466a00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0467200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0467400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0468500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0468600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0468700, 0xffffff00, 24, "APNIC" },
	{ 0xc0468800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0468c00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0469000, 0xfffff000, 20, "RIPENCC" },
	{ 0xc046ae00, 0xffffff00, 24, "APNIC" },
	{ 0xc046b300, 0xffffff00, 24, "APNIC" },
	{ 0xc046b400, 0xfffffe00, 23, "APNIC" },
	{ 0xc046d800, 0xffffff00, 24, "APNIC" },
	{ 0xc046db00, 0xffffff00, 24, "APNIC" },
	{ 0xc046ed00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc046f200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0470000, 0xffff0000, 16, "RIPENCC" },
	{ 0xc0480300, 0xffffff00, 24, "APNIC" },
	{ 0xc0480400, 0xfffffc00, 22, "APNIC" },
	{ 0xc0480800, 0xfffff800, 21, "APNIC" },
	{ 0xc0481000, 0xfffff000, 20, "APNIC" },
	{ 0xc0482000, 0xffffe000, 19, "APNIC" },
	{ 0xc0484000, 0xffffc000, 18, "APNIC" },
	{ 0xc0488000, 0xffffc000, 18, "APNIC" },
	{ 0xc048c000, 0xffffe000, 19, "APNIC" },
	{ 0xc048e000, 0xfffff000, 20, "APNIC" },
	{ 0xc048f000, 0xfffff800, 21, "APNIC" },
	{ 0xc048f800, 0xfffffc00, 22, "APNIC" },
	{ 0xc048fc00, 0xffffff00, 24, "APNIC" },
	{ 0xc0490c00, 0xffffff00, 24, "APNIC" },
	{ 0xc0491300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0491400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0491500, 0xffffff00, 24, "APNIC" },
	{ 0xc0491600, 0xffffff00, 24, "APNIC" },
	{ 0xc0491800, 0xfffffe00, 23, "APNIC" },
	{ 0xc0492200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0492400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0492800, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0492c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0494200, 0xffffff00, 24, "APNIC" },
	{ 0xc049e200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc049e500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc04a8b00, 0xffffff00, 24, "APNIC" },
	{ 0xc04a8c00, 0xfffffc00, 22, "APNIC" },
	{ 0xc04a9000, 0xfffff000, 20, "APNIC" },
	{ 0xc04aa000, 0xffffe000, 19, "APNIC" },
	{ 0xc04ac000, 0xfffff000, 20, "APNIC" },
	{ 0xc04ad000, 0xffffff00, 24, "APNIC" },
	{ 0xc04c0600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc04c1700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc04c1800, 0xfffff800, 21, "RIPENCC" },
	{ 0xc04c7a00, 0xffffff00, 24, "APNIC" },
	{ 0xc04c7b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc04c7c00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc04c8000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc04c8400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc04c8600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc04c8800, 0xfffff800, 21, "RIPENCC" },
	{ 0xc04c9000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc04c9400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc04c9700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc04c9800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc04cb000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc04cf100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc04cf200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc04cf400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc04cf800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc04d0b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc04d7200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc04d7800, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc04d8400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc04d8c00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0501400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0501800, 0xffffff00, 24, "LACNIC" },
	{ 0xc0501f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0502000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc0502800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0502a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0502e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0503300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc050d100, 0xffffff00, 24, "LACNIC" },
	{ 0xc0513b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0513d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0516d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0517900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0517b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc051a000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc051b600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc051c200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc051e600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc051ea00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0527900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0527c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0527f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0528c00, 0xffffff00, 24, "APNIC" },
	{ 0xc0528e00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0528f00, 0xffffff00, 24, "APNIC" },
	{ 0xc0529900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0529d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0529e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc052a100, 0xffffff00, 24, "APNIC" },
	{ 0xc052d600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc052dc00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc052de00, 0xffffff00, 24, "APNIC" },
	{ 0xc052f100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0530000, 0xffffc000, 18, "RIPENCC" },
	{ 0xc0536600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0537600, 0xfffffe00, 23, "APNIC" },
	{ 0xc0537b00, 0xffffff00, 24, "APNIC" },
	{ 0xc053a000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc053a500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc053a600, 0xfffffe00, 23, "APNIC" },
	{ 0xc053a800, 0xfffff800, 21, "APNIC" },
	{ 0xc053b000, 0xfffff000, 20, "APNIC" },
	{ 0xc053c000, 0xfffffc00, 22, "APNIC" },
	{ 0xc053c400, 0xffffff00, 24, "APNIC" },
	{ 0xc053c600, 0xffffff00, 24, "APNIC" },
	{ 0xc053c800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc053ca00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc053cf00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc053da00, 0xfffffe00, 23, "APNIC" },
	{ 0xc053df00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc053e000, 0xffffff00, 24, "APNIC" },
	{ 0xc053e500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc053e700, 0xffffff00, 24, "APNIC" },
	{ 0xc053ed00, 0xffffff00, 24, "APNIC" },
	{ 0xc053ee00, 0xffffff00, 24, "APNIC" },
	{ 0xc0540500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0540c00, 0xffffff00, 24, "LACNIC" },
	{ 0xc0540d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0540f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0541b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0541e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0542000, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0543e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0544b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0544c00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0545000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0545400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0545700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0545900, 0xffffff00, 24, "APNIC" },
	{ 0xc0545a00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0545c00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0546000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0546500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0546600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0546800, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0546c00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0547f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0548000, 0xfffff000, 20, "RIPENCC" },
	{ 0xc0549000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc0549800, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0549c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc054a600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc054ad00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc054b000, 0xfffff000, 20, "RIPENCC" },
	{ 0xc054cb00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc054cc00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc054d400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc054db00, 0xffffff00, 24, "APNIC" },
	{ 0xc054dc00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc054e200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc054e400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc054e600, 0xffffff00, 24, "APNIC" },
	{ 0xc054ed00, 0xffffff00, 24, "APNIC" },
	{ 0xc054ee00, 0xffffff00, 24, "APNIC" },
	{ 0xc054f200, 0xffffff00, 24, "APNIC" },
	{ 0xc054f400, 0xffffff00, 24, "AFRINIC" },
	{ 0xc054f500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc054f600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc054fd00, 0xffffff00, 24, "APNIC" },
	{ 0xc0560b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0560e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0561200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0561900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0561b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0565900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0567d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0567e00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0568600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0568900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0568a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc056a300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc056a500, 0xffffff00, 24, "APNIC" },
	{ 0xc056a600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc056a900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc056fe00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0570000, 0xffff0000, 16, "RIPENCC" },
	{ 0xc0580100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0580400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0580600, 0xfffffe00, 23, "APNIC" },
	{ 0xc0580900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0580a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0581100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0581700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0581800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0585300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0585400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0585500, 0xffffff00, 24, "APNIC" },
	{ 0xc0585600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0586100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0586200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0586c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0587600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0587b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0588000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0588200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0588500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc058bb00, 0xffffff00, 24, "APNIC" },
	{ 0xc058be00, 0xffffff00, 24, "APNIC" },
	{ 0xc058c400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc058cc00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc058ee00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc058fa00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc058fc00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc058fe00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0590000, 0xffff0000, 16, "RIPENCC" },
	{ 0xc05b8c00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc05bb100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05bb300, 0xffffff00, 24, "APNIC" },
	{ 0xc05bb900, 0xffffff00, 24, "APNIC" },
	{ 0xc05bba00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05bbd00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05bbf00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05bc700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05bc800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc05bd300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05bd600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc05bd800, 0xfffff800, 21, "RIPENCC" },
	{ 0xc05be000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc05be800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc05bec00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc05bf700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05c5600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05c5e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05c6800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc05c6c00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc05c7400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05c7d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05c7e00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc05c8000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc05c8800, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc05c8d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05c8e00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc05c9000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc05c9800, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc05c9c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05cd800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05d0000, 0xffffc000, 18, "RIPENCC" },
	{ 0xc05d6900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05d6e00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc05d7900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05d7a00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc05d9400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc05d9900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05e1800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05e1c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05e2900, 0xffffff00, 24, "APNIC" },
	{ 0xc05e3900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05e3a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05e3d00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc05e3e00, 0xfffffe00, 23, "APNIC" },
	{ 0xc05e4000, 0xffffff00, 24, "APNIC" },
	{ 0xc05e4300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05e4400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05e4c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05e6f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05e7a00, 0xffffff00, 24, "APNIC" },
	{ 0xc05e9c00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc05ea300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05ea900, 0xffffff00, 24, "APNIC" },
	{ 0xc05eac00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05eae00, 0xffffff00, 24, "APNIC" },
	{ 0xc05eaf00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05ed000, 0xfffffe00, 23, "APNIC" },
	{ 0xc05ed200, 0xffffff00, 24, "AFRINIC" },
	{ 0xc05ed400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05edd00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05ee200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05ee300, 0xffffff00, 24, "APNIC" },
	{ 0xc05eeb00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05eef00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc05ef000, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc05ef300, 0xffffff00, 24, "APNIC" },
	{ 0xc05ef400, 0xffffff00, 24, "APNIC" },
	{ 0xc05ef600, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0600100, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0600200, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc0600400, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc0600800, 0xfffff800, 21, "AFRINIC" },
	{ 0xc0601000, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0601300, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0601400, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc0601600, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0601800, 0xfffff800, 21, "AFRINIC" },
	{ 0xc0602000, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc0602500, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0602600, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc0602800, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0602b00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0602d00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0602e00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc0603000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc0603800, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc0603a00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0603c00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc0604400, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc0604800, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0604a00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc0604c00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc0604f00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0605000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc0606000, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc0606400, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc0606600, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0606800, 0xfffff800, 21, "AFRINIC" },
	{ 0xc0607000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc0608000, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc0608400, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc0608600, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0608a00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc0608c00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc0608e00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0609000, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0609200, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc0609400, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc0609800, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc0609e00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc060a400, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc060b100, 0xffffff00, 24, "AFRINIC" },
	{ 0xc060b200, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc060b400, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc060b800, 0xfffff800, 21, "AFRINIC" },
	{ 0xc060c100, 0xffffff00, 24, "AFRINIC" },
	{ 0xc060c200, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc060c400, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc060e000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc060e800, 0xffffff00, 24, "AFRINIC" },
	{ 0xc060ea00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc060ec00, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc060f000, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc060f500, 0xffffff00, 24, "AFRINIC" },
	{ 0xc060f600, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc060f800, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc060fc00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc060fe00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0620000, 0xffff0000, 16, "RIPENCC" },
	{ 0xc0640100, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0640200, 0xffffff00, 24, "APNIC" },
	{ 0xc0641200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0641600, 0xffffff00, 24, "APNIC" },
	{ 0xc0641700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0641800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0643400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0643500, 0xffffff00, 24, "APNIC" },
	{ 0xc0643d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0643f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0644d00, 0xffffff00, 24, "APNIC" },
	{ 0xc0644e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0645000, 0xffffff00, 24, "APNIC" },
	{ 0xc0646000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0646600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0648700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0649000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0649a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0649b00, 0xffffff00, 24, "LACNIC" },
	{ 0xc0649c00, 0xffffff00, 24, "LACNIC" },
	{ 0xc0649e00, 0xfffffe00, 23, "LACNIC" },
	{ 0xc064a000, 0xfffff800, 21, "LACNIC" },
	{ 0xc064a800, 0xfffffe00, 23, "LACNIC" },
	{ 0xc064aa00, 0xffffff00, 24, "LACNIC" },
	{ 0xc064ac00, 0xfffffc00, 22, "LACNIC" },
	{ 0xc064b000, 0xffffff00, 24, "LACNIC" },
	{ 0xc064b200, 0xfffffe00, 23, "LACNIC" },
	{ 0xc064b400, 0xfffffe00, 23, "LACNIC" },
	{ 0xc064b700, 0xffffff00, 24, "LACNIC" },
	{ 0xc064b800, 0xfffffe00, 23, "LACNIC" },
	{ 0xc064bc00, 0xfffffc00, 22, "LACNIC" },
	{ 0xc064c000, 0xfffffc00, 22, "LACNIC" },
	{ 0xc064c400, 0xfffffe00, 23, "LACNIC" },
	{ 0xc064c700, 0xffffff00, 24, "LACNIC" },
	{ 0xc064c800, 0xfffffc00, 22, "LACNIC" },
	{ 0xc064cc00, 0xfffffe00, 23, "LACNIC" },
	{ 0xc064cf00, 0xffffff00, 24, "LACNIC" },
	{ 0xc064d000, 0xfffffc00, 22, "LACNIC" },
	{ 0xc064d400, 0xfffffe00, 23, "LACNIC" },
	{ 0xc064d800, 0xfffff800, 21, "LACNIC" },
	{ 0xc064e000, 0xfffffc00, 22, "LACNIC" },
	{ 0xc064e600, 0xfffffe00, 23, "LACNIC" },
	{ 0xc064e800, 0xfffff800, 21, "LACNIC" },
	{ 0xc064f000, 0xfffffc00, 22, "LACNIC" },
	{ 0xc064f400, 0xfffffe00, 23, "LACNIC" },
	{ 0xc064f600, 0xffffff00, 24, "LACNIC" },
	{ 0xc064f900, 0xffffff00, 24, "LACNIC" },
	{ 0xc064fa00, 0xffffff00, 24, "LACNIC" },
	{ 0xc0650100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0650400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0650800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0650b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0651000, 0xffffff00, 24, "APNIC" },
	{ 0xc0651c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0652200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0654b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0655100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0655200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0655400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0655800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0655a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0655b00, 0xffffff00, 24, "APNIC" },
	{ 0xc0657600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0658600, 0xffffff00, 24, "APNIC" },
	{ 0xc0658900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0658e00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc065a100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc065a200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc065a400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc065a800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc065aa00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc065b000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc065b300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc065b700, 0xffffff00, 24, "APNIC" },
	{ 0xc065c000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc065c500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc065c600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc065fc00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc065fe00, 0xffffff00, 24, "APNIC" },
	{ 0xc0660100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0660600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0660800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0660900, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0661100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0661200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0664000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0665300, 0xffffff00, 24, "APNIC" },
	{ 0xc0665400, 0xffffff00, 24, "LACNIC" },
	{ 0xc0665900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0665c00, 0xffffff00, 24, "APNIC" },
	{ 0xc0665f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0669200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc066d600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc066e000, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc066e300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc066e400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc066ef00, 0xffffff00, 24, "APNIC" },
	{ 0xc066fa00, 0xfffffe00, 23, "APNIC" },
	{ 0xc0670200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0670700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0670e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0671400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0671700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0671b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0671c00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0672800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0672b00, 0xffffff00, 24, "APNIC" },
	{ 0xc0675500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0678200, 0xffffff00, 24, "APNIC" },
	{ 0xc0678900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0678a00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0679300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0680f00, 0xffffff00, 24, "APNIC" },
	{ 0xc0681700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0681c00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0682300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0682400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0682900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0682b00, 0xffffff00, 24, "APNIC" },
	{ 0xc0682c00, 0xfffffe00, 23, "APNIC" },
	{ 0xc0683000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0683500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0683700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0683800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0683a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0684800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0684d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0685200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0688c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0688e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0689300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0689a00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc068a700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc068a800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc068ac00, 0xffffff00, 24, "APNIC" },
	{ 0xc068e800, 0xfffffe00, 23, "APNIC" },
	{ 0xc068ee00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc068f500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc068f600, 0xfffffe00, 23, "APNIC" },
	{ 0xc068f800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc068fb00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0690a00, 0xffffff00, 24, "APNIC" },
	{ 0xc0694b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06a0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xc06b0100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06b0200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06b0400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc06b0900, 0xffffff00, 24, "APNIC" },
	{ 0xc06b0b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06b3300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06b3400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc06b3800, 0xfffff800, 21, "RIPENCC" },
	{ 0xc06b4000, 0xffffe000, 19, "RIPENCC" },
	{ 0xc06b6000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc06b6400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06b6500, 0xffffff00, 24, "APNIC" },
	{ 0xc06b6800, 0xffffff00, 24, "LACNIC" },
	{ 0xc06b6e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06b7100, 0xffffff00, 24, "APNIC" },
	{ 0xc06b7200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06b7a00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc06b7c00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc06b8400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06ba800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06bab00, 0xffffff00, 24, "APNIC" },
	{ 0xc06bac00, 0xffffff00, 24, "APNIC" },
	{ 0xc06bae00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06bb100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06bb200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06bbb00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06bc800, 0xfffff800, 21, "RIPENCC" },
	{ 0xc06be800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc06beb00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06c1700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06c1b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06c1c00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc06c2000, 0xfffff000, 20, "RIPENCC" },
	{ 0xc06c3000, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc06c3300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06c3400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc06c4100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06c4200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc06c4900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06c6300, 0xffffff00, 24, "APNIC" },
	{ 0xc06c6400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc06c6b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06c7200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc06c7800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc06c7d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06c7e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06c8000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc06cc300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06ce600, 0xffffff00, 24, "APNIC" },
	{ 0xc06cea00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06cee00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06d0000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc06d0e00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc06d1c00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc06d1f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06d2000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc06d2700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06d2800, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc06d2c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06d2e00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc06d3000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc06d3500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06d3600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc06d3800, 0xfffff800, 21, "RIPENCC" },
	{ 0xc06d4000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc06d4800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc06d4a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06d4c00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc06d5000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc06d5800, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc06d5e00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc06d6000, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc06d6200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06d6400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc06d6600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06d6900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06d6a00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc06d6c00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc06d7000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc06d7900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06d7a00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc06d7c00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc06d8000, 0xffffe000, 19, "RIPENCC" },
	{ 0xc06da000, 0xfffff000, 20, "RIPENCC" },
	{ 0xc06db000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc06df200, 0xffffff00, 24, "AFRINIC" },
	{ 0xc06df300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06f2000, 0xffffff00, 24, "APNIC" },
	{ 0xc06f2100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06f2700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06f2c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06f2f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06f3000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06f5800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06f6500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06f6600, 0xffffff00, 24, "APNIC" },
	{ 0xc06f6700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06f6800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06f6900, 0xffffff00, 24, "APNIC" },
	{ 0xc06f7c00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc06f7f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc06fe500, 0xffffff00, 24, "LACNIC" },
	{ 0xc06fe600, 0xffffff00, 24, "LACNIC" },
	{ 0xc06ffc00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0701e00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0702000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0702d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0703100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0703d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0704600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0704800, 0xfffff800, 21, "RIPENCC" },
	{ 0xc0706200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0706400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc070cc00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc070ce00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc070d000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc070d500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc070d600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc070d700, 0xffffff00, 24, "APNIC" },
	{ 0xc070f700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc070fe00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0710000, 0xffff0000, 16, "RIPENCC" },
	{ 0xc0720000, 0xffffc000, 18, "RIPENCC" },
	{ 0xc0725400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0725800, 0xfffff800, 21, "RIPENCC" },
	{ 0xc072a000, 0xffffe000, 19, "RIPENCC" },
	{ 0xc072c000, 0xffffc000, 18, "RIPENCC" },
	{ 0xc0730000, 0xffff0000, 16, "RIPENCC" },
	{ 0xc0740000, 0xffff8000, 17, "RIPENCC" },
	{ 0xc074c000, 0xffffc000, 18, "RIPENCC" },
	{ 0xc0750000, 0xffff0000, 16, "RIPENCC" },
	{ 0xc0760000, 0xffff0000, 16, "RIPENCC" },
	{ 0xc0790000, 0xffff0000, 16, "RIPENCC" },
	{ 0xc07a0100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc07a8300, 0xffffff00, 24, "APNIC" },
	{ 0xc07a8400, 0xfffffc00, 22, "APNIC" },
	{ 0xc07a8800, 0xfffffc00, 22, "APNIC" },
	{ 0xc07a8c00, 0xffffff00, 24, "APNIC" },
	{ 0xc07a8d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc07a9700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc07aab00, 0xffffff00, 24, "APNIC" },
	{ 0xc07ab000, 0xffffff00, 24, "APNIC" },
	{ 0xc07ab400, 0xffffff00, 24, "APNIC" },
	{ 0xc07ad600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc07ad800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc07aee00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc07af000, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc07af200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc07afe00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc07c0a00, 0xfffffe00, 23, "APNIC" },
	{ 0xc07c0c00, 0xfffffe00, 23, "APNIC" },
	{ 0xc07c0e00, 0xffffff00, 24, "APNIC" },
	{ 0xc07c1900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc07c2000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc07c2700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc07c2e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc07c7000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc07c7300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc07c7400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc07c7500, 0xffffff00, 24, "APNIC" },
	{ 0xc07c9800, 0xffffff00, 24, "APNIC" },
	{ 0xc07c9a00, 0xffffff00, 24, "APNIC" },
	{ 0xc07c9b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc07caa00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc07ceb00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc07ced00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc07cee00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc07cf000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc07cf400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc07cf700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc07cf800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc07cfa00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc07cfc00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc07cfe00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc07d0000, 0xffff0000, 16, "RIPENCC" },
	{ 0xc07e0100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0810100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0812000, 0xfffff000, 20, "RIPENCC" },
	{ 0xc0815000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0815700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0816200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0820000, 0xffff0000, 16, "RIPENCC" },
	{ 0xc0830d00, 0xffffff00, 24, "APNIC" },
	{ 0xc0831400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0831900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0831b00, 0xffffff00, 24, "APNIC" },
	{ 0xc0831c00, 0xfffffe00, 23, "APNIC" },
	{ 0xc0831e00, 0xffffff00, 24, "APNIC" },
	{ 0xc0834f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0835900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0835a00, 0xfffffe00, 23, "APNIC" },
	{ 0xc0835c00, 0xffffff00, 24, "APNIC" },
	{ 0xc0836000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0836c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0838400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc083fb00, 0xffffff00, 24, "APNIC" },
	{ 0xc083fc00, 0xffffff00, 24, "APNIC" },
	{ 0xc0840900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0840a00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0840f00, 0xffffff00, 24, "APNIC" },
	{ 0xc0841f00, 0xffffff00, 24, "APNIC" },
	{ 0xc0842200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0842300, 0xffffff00, 24, "LACNIC" },
	{ 0xc0842900, 0xffffff00, 24, "APNIC" },
	{ 0xc0843500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0843700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0845d00, 0xffffff00, 24, "APNIC" },
	{ 0xc0846300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc084ef00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc084f400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc084f700, 0xffffff00, 24, "APNIC" },
	{ 0xc084f800, 0xfffffc00, 22, "APNIC" },
	{ 0xc084fc00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc084fd00, 0xffffff00, 24, "APNIC" },
	{ 0xc0850f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0851500, 0xffffff00, 24, "APNIC" },
	{ 0xc0851c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0851f00, 0xffffff00, 24, "APNIC" },
	{ 0xc0852000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0852400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0852900, 0xffffff00, 24, "APNIC" },
	{ 0xc0853500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0853600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0853a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0854000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0854300, 0xffffff00, 24, "APNIC" },
	{ 0xc0856700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0856c00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0857900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0858300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc085f400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc085fa00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0860000, 0xffff0000, 16, "RIPENCC" },
	{ 0xc0870700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0870800, 0xfffff800, 21, "RIPENCC" },
	{ 0xc0871000, 0xfffff000, 20, "RIPENCC" },
	{ 0xc0872000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0872400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0872e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0873300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0873400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0873f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0874200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0874400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0875200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0875900, 0xffffff00, 24, "APNIC" },
	{ 0xc0875c00, 0xffffff00, 24, "APNIC" },
	{ 0xc0875e00, 0xffffff00, 24, "APNIC" },
	{ 0xc0876000, 0xffffff00, 24, "APNIC" },
	{ 0xc0876500, 0xffffff00, 24, "APNIC" },
	{ 0xc0876600, 0xfffffe00, 23, "APNIC" },
	{ 0xc0876800, 0xfffffc00, 22, "APNIC" },
	{ 0xc0876c00, 0xffffff00, 24, "APNIC" },
	{ 0xc0878100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0878500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0878f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0879100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0879200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0879400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0879800, 0xfffff800, 21, "RIPENCC" },
	{ 0xc087a000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc087a800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc087af00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc087b900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc087bb00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc087cf00, 0xffffff00, 24, "APNIC" },
	{ 0xc087d000, 0xffffff00, 24, "APNIC" },
	{ 0xc087db00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc087de00, 0xffffff00, 24, "APNIC" },
	{ 0xc087e100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc087e700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc087e800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc087ea00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc087fd00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc087fe00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0880700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0880900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0881200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0881700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0881d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0881e00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0882700, 0xffffff00, 24, "APNIC" },
	{ 0xc0882800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0882a00, 0xfffffe00, 23, "LACNIC" },
	{ 0xc0882c00, 0xfffffc00, 22, "LACNIC" },
	{ 0xc0883100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0883300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0883400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0883700, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0883800, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc0883b00, 0xffffff00, 24, "APNIC" },
	{ 0xc0883d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0884700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0889a00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0889c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc08a0100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc08a0200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc08a0400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc08a0800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc08a5600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc08a6400, 0xffffff00, 24, "APNIC" },
	{ 0xc08a6900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc08a6a00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc08a6c00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc08a9b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc08a9c00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc08a9e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc08ab700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc08ac000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc08acc00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc08ae400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc08ae800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc08af800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc08afb00, 0xffffff00, 24, "APNIC" },
	{ 0xc08b4e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0904a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0904c00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0927500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0927700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0927b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0927c00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0927e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0928400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0928500, 0xffffff00, 24, "APNIC" },
	{ 0xc0928600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0928800, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0928c00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0929600, 0xffffff00, 24, "APNIC" },
	{ 0xc0929800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0929d00, 0xffffff00, 24, "LACNIC" },
	{ 0xc092a300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc092a400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc092a800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc092aa00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc092ac00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc092b000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc092b400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc092b600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc092b800, 0xffffff00, 24, "APNIC" },
	{ 0xc092b900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc092bb00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc092c100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc092c800, 0xffffff00, 24, "APNIC" },
	{ 0xc092cc00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc092da00, 0xfffffe00, 23, "APNIC" },
	{ 0xc092e300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc092e400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc092e500, 0xffffff00, 24, "LACNIC" },
	{ 0xc092e900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc092ea00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc092ed00, 0xffffff00, 24, "LACNIC" },
	{ 0xc092ee00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc092f200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc092fb00, 0xffffff00, 24, "APNIC" },
	{ 0xc092fc00, 0xfffffe00, 23, "APNIC" },
	{ 0xc0931700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0932200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0932400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0932a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0934c00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0937200, 0xffffff00, 24, "APNIC" },
	{ 0xc0938d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0939600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0939b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc093d200, 0xffffff00, 24, "LACNIC" },
	{ 0xc093d400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc093d700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc093d800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc093da00, 0xffffff00, 24, "LACNIC" },
	{ 0xc093db00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc093e400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc093eb00, 0xffffff00, 24, "APNIC" },
	{ 0xc093f600, 0xffffff00, 24, "APNIC" },
	{ 0xc093f700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc093fb00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0942100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0946700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0947400, 0xfffffc00, 22, "APNIC" },
	{ 0xc0947800, 0xfffff800, 21, "APNIC" },
	{ 0xc0948000, 0xffffe000, 19, "APNIC" },
	{ 0xc094a000, 0xfffffc00, 22, "APNIC" },
	{ 0xc094a400, 0xfffffe00, 23, "APNIC" },
	{ 0xc094a600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc094af00, 0xffffff00, 24, "LACNIC" },
	{ 0xc094b100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc094b200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc094b400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc094b800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc094ba00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc094c000, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc094c200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc094c600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc094c800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc094d800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc094dc00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc094dd00, 0xffffff00, 24, "APNIC" },
	{ 0xc094df00, 0xffffff00, 24, "APNIC" },
	{ 0xc094e000, 0xfffffc00, 22, "APNIC" },
	{ 0xc094e400, 0xfffffe00, 23, "APNIC" },
	{ 0xc094e600, 0xffffff00, 24, "APNIC" },
	{ 0xc0950300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0950500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0950f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0951300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0951400, 0xffffff00, 24, "APNIC" },
	{ 0xc0951b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0951d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0952300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0952400, 0xffffff00, 24, "APNIC" },
	{ 0xc0952900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0953600, 0xffffff00, 24, "APNIC" },
	{ 0xc0953900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0953b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0953c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0954d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0954e00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0956400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0956600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0956e00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0957500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0957600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0957800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0957e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc095d100, 0xffffff00, 24, "APNIC" },
	{ 0xc095e300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc095e800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc095ee00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0963a00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0963c00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0964000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc0964800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0964b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0964c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0964e00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0965000, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0965200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0965400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0965900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0965c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0965e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0966800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0966a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0967c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0967e00, 0xffffff00, 24, "LACNIC" },
	{ 0xc0968100, 0xffffff00, 24, "APNIC" },
	{ 0xc0968200, 0xfffffe00, 23, "APNIC" },
	{ 0xc0968400, 0xfffffc00, 22, "APNIC" },
	{ 0xc0968900, 0xffffff00, 24, "APNIC" },
	{ 0xc0968a00, 0xfffffe00, 23, "APNIC" },
	{ 0xc0968c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0969200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc096b100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc096b200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc096b400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc096b800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc096bc00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc096be00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc096c000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc096c400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc096c600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc096ca00, 0xffffff00, 24, "APNIC" },
	{ 0xc096cb00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc096cc00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc096d000, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc096da00, 0xfffffe00, 23, "APNIC" },
	{ 0xc096df00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc096e300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc096e400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc096e800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc096ea00, 0xfffffe00, 23, "APNIC" },
	{ 0xc096ec00, 0xfffffe00, 23, "APNIC" },
	{ 0xc096ee00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc096f600, 0xffffff00, 24, "APNIC" },
	{ 0xc096f800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc096f900, 0xffffff00, 24, "APNIC" },
	{ 0xc096fa00, 0xfffffe00, 23, "APNIC" },
	{ 0xc096fc00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc096fe00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0980600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0980e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0981100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0981a00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0982a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0982c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0982f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0983000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0983600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0983d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0983e00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0984400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0984500, 0xffffff00, 24, "APNIC" },
	{ 0xc0985200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0986200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0986f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0987000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0987700, 0xffffff00, 24, "APNIC" },
	{ 0xc0987a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0987c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0988d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0989700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0989c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc098a600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc098ae00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc098b800, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc098d400, 0xffffff00, 24, "APNIC" },
	{ 0xc098f100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc098f400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc098fd00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc098fe00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0990200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0990c00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0991200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0995800, 0xffffff00, 24, "LACNIC" },
	{ 0xc0995900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0995d00, 0xffffff00, 24, "APNIC" },
	{ 0xc0995f00, 0xffffff00, 24, "APNIC" },
	{ 0xc0996000, 0xfffff000, 20, "APNIC" },
	{ 0xc0997000, 0xfffffe00, 23, "APNIC" },
	{ 0xc0997200, 0xffffff00, 24, "APNIC" },
	{ 0xc0997400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0997700, 0xffffff00, 24, "LACNIC" },
	{ 0xc0997800, 0xffffff00, 24, "LACNIC" },
	{ 0xc0997f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0999900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0999b00, 0xffffff00, 24, "LACNIC" },
	{ 0xc0999e00, 0xffffff00, 24, "APNIC" },
	{ 0xc099a600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc099a700, 0xffffff00, 24, "LACNIC" },
	{ 0xc099a800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc099ab00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc099ad00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc099ae00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc099b000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc099b400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc099b600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc099bc00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc099c200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc099c400, 0xfffffe00, 23, "APNIC" },
	{ 0xc099d500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc099fb00, 0xffffff00, 24, "APNIC" },
	{ 0xc09a1000, 0xfffff800, 21, "APNIC" },
	{ 0xc09a1800, 0xfffffe00, 23, "APNIC" },
	{ 0xc09b0100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09b0200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc09b0400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc09b0600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09c8400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09c8c00, 0xfffffc00, 22, "APNIC" },
	{ 0xc09c9100, 0xffffff00, 24, "APNIC" },
	{ 0xc09c9200, 0xfffffe00, 23, "APNIC" },
	{ 0xc09c9400, 0xfffffc00, 22, "APNIC" },
	{ 0xc09c9800, 0xfffffe00, 23, "APNIC" },
	{ 0xc09c9a00, 0xffffff00, 24, "APNIC" },
	{ 0xc09c9e00, 0xfffffe00, 23, "APNIC" },
	{ 0xc09ca200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09ca500, 0xffffff00, 24, "APNIC" },
	{ 0xc09ca700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09ccf00, 0xffffff00, 24, "APNIC" },
	{ 0xc09cd200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09cd500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09cd900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09ce100, 0xffffff00, 24, "APNIC" },
	{ 0xc09ce300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09cef00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09cf800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09d0100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09d0200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc09d0800, 0xfffff800, 21, "RIPENCC" },
	{ 0xc09d1000, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc09d8100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09da500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09da900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09daa00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc09dac00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09dae00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09db000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09db900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09dbb00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09dbd00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09dbe00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc09f1000, 0xfffff800, 21, "APNIC" },
	{ 0xc09f1800, 0xfffffc00, 22, "APNIC" },
	{ 0xc09f1c00, 0xfffffe00, 23, "APNIC" },
	{ 0xc09f1e00, 0xffffff00, 24, "APNIC" },
	{ 0xc09f4600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09f4900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09f4d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09f5400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc09f5a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09f5f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09f6300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09f6400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc09f6900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09f6c00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc09f7400, 0xfffffe00, 23, "LACNIC" },
	{ 0xc09f7600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09f7900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc09f7a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a00a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a00f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a01000, 0xffffff00, 24, "APNIC" },
	{ 0xc0a01300, 0xffffff00, 24, "APNIC" },
	{ 0xc0a01500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a01600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0a01b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a02100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a02500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a02d00, 0xffffff00, 24, "LACNIC" },
	{ 0xc0a03200, 0xffffff00, 24, "LACNIC" },
	{ 0xc0a04100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a04300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a04700, 0xffffff00, 24, "APNIC" },
	{ 0xc0a05f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a06000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a06d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a06e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a06f00, 0xffffff00, 24, "LACNIC" },
	{ 0xc0a07b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a07e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a08000, 0xffffff00, 24, "LACNIC" },
	{ 0xc0a08e00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0a09800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a09c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a0a000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a0a100, 0xffffff00, 24, "APNIC" },
	{ 0xc0a0a900, 0xffffff00, 24, "APNIC" },
	{ 0xc0a0aa00, 0xfffffe00, 23, "APNIC" },
	{ 0xc0a0ac00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a0b100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a0b200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0a0bc00, 0xffffff00, 24, "LACNIC" },
	{ 0xc0a0c200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0a0cd00, 0xffffff00, 24, "APNIC" },
	{ 0xc0a0e100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a0e500, 0xffffff00, 24, "APNIC" },
	{ 0xc0a0e700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a0e800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0a0f500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a0f600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0a0f800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0a0fb00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a0fc00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a14000, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0a18000, 0xfffffe00, 23, "APNIC" },
	{ 0xc0a20000, 0xffff0000, 16, "RIPENCC" },
	{ 0xc0a32000, 0xffffe000, 19, "RIPENCC" },
	{ 0xc0a40000, 0xfffe0000, 15, "RIPENCC" },
	{ 0xc0a60000, 0xfffff000, 20, "RIPENCC" },
	{ 0xc0a61000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc0a61c00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0a62000, 0xffffe000, 19, "RIPENCC" },
	{ 0xc0a64000, 0xfffff000, 20, "RIPENCC" },
	{ 0xc0a65100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0a65200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0a65400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0a66000, 0xffffe000, 19, "RIPENCC" },
	{ 0xc0a68000, 0xffffc000, 18, "RIPENCC" },
	{ 0xc0a6c000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc0a6ca00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0a6cc00, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0a6d000, 0xfffff000, 20, "RIPENCC" },
	{ 0xc0a6e000, 0xffffe000, 19, "RIPENCC" },
	{ 0xc0a70000, 0xffff0000, 16, "RIPENCC" },
	{ 0xc0a92000, 0xfffff800, 21, "APNIC" },
	{ 0xc0a92800, 0xfffffe00, 23, "APNIC" },
	{ 0xc0ab0100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0ab0200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0ab0400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0ab8000, 0xffffc000, 18, "RIPENCC" },
	{ 0xc0abc000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc0ace300, 0xffffff00, 24, "APNIC" },
	{ 0xc0ace400, 0xfffffc00, 22, "APNIC" },
	{ 0xc0acea00, 0xfffffe00, 23, "APNIC" },
	{ 0xc0acec00, 0xfffffc00, 22, "APNIC" },
	{ 0xc0acf100, 0xffffff00, 24, "APNIC" },
	{ 0xc0acf200, 0xfffffe00, 23, "APNIC" },
	{ 0xc0acf500, 0xffffff00, 24, "APNIC" },
	{ 0xc0acf600, 0xffffff00, 24, "APNIC" },
	{ 0xc0acfd00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0ad0100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0ad0200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0ad0400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0ad1000, 0xfffff800, 21, "APNIC" },
	{ 0xc0ad1800, 0xffffff00, 24, "APNIC" },
	{ 0xc0ad8000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc0ae4000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0ae4400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0ae8000, 0xffff8000, 17, "APNIC" },
	{ 0xc0af2000, 0xfffff000, 20, "RIPENCC" },
	{ 0xc0b00000, 0xffff0000, 16, "RIPENCC" },
	{ 0xc0bb1000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0bc0a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bc0b00, 0xffffff00, 24, "LACNIC" },
	{ 0xc0bc2b00, 0xffffff00, 24, "APNIC" },
	{ 0xc0bc2c00, 0xfffffc00, 22, "LACNIC" },
	{ 0xc0bc3000, 0xfffff800, 21, "LACNIC" },
	{ 0xc0bc3800, 0xfffffc00, 22, "LACNIC" },
	{ 0xc0bc3c00, 0xffffff00, 24, "LACNIC" },
	{ 0xc0bc3f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bc4000, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0bc4500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bc4700, 0xffffff00, 24, "APNIC" },
	{ 0xc0bc4900, 0xffffff00, 24, "APNIC" },
	{ 0xc0bc4a00, 0xfffffe00, 23, "APNIC" },
	{ 0xc0bc4c00, 0xfffffc00, 22, "APNIC" },
	{ 0xc0bc5000, 0xffffff00, 24, "APNIC" },
	{ 0xc0bc5500, 0xffffff00, 24, "APNIC" },
	{ 0xc0bc5600, 0xfffffe00, 23, "APNIC" },
	{ 0xc0bc5900, 0xffffff00, 24, "APNIC" },
	{ 0xc0bc5a00, 0xffffff00, 24, "APNIC" },
	{ 0xc0bc5c00, 0xffffff00, 24, "APNIC" },
	{ 0xc0bc6000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bc6500, 0xffffff00, 24, "APNIC" },
	{ 0xc0bc6900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bc6b00, 0xffffff00, 24, "APNIC" },
	{ 0xc0bc7300, 0xffffff00, 24, "APNIC" },
	{ 0xc0bc7400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0bc7900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bc7a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bc7d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bc7f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bc8100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bc8400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bc8800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bc9100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bc9700, 0xffffff00, 24, "APNIC" },
	{ 0xc0bc9d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bc9e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bca400, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc0bcaa00, 0xffffff00, 24, "APNIC" },
	{ 0xc0bcae00, 0xfffffe00, 23, "APNIC" },
	{ 0xc0bcb900, 0xffffff00, 24, "APNIC" },
	{ 0xc0bcba00, 0xffffff00, 24, "APNIC" },
	{ 0xc0bcbb00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bcbd00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bcc200, 0xfffffe00, 23, "LACNIC" },
	{ 0xc0bcc400, 0xfffffe00, 23, "LACNIC" },
	{ 0xc0bce900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bcf100, 0xffffff00, 24, "APNIC" },
	{ 0xc0bcf200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0bcf800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bd0100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bd0800, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc0bd0e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bd1700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bd1800, 0xffffff00, 24, "APNIC" },
	{ 0xc0bd2200, 0xffffff00, 24, "APNIC" },
	{ 0xc0bd2900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bd3300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bd3400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bd3600, 0xffffff00, 24, "APNIC" },
	{ 0xc0bd3700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bd4200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bd4500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bd4600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bd4900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bd4b00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0bd4c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bd7700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bd8800, 0xffffff00, 24, "APNIC" },
	{ 0xc0bd8b00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0bd9400, 0xffffff00, 24, "APNIC" },
	{ 0xc0bd9700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bd9a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bd9d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bda000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bda600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0bda800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0bdaa00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bdca00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0bdd000, 0xfffffc00, 22, "APNIC" },
	{ 0xc0bddf00, 0xffffff00, 24, "APNIC" },
	{ 0xc0bde500, 0xffffff00, 24, "APNIC" },
	{ 0xc0bdfb00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0be1e00, 0xfffffe00, 23, "LACNIC" },
	{ 0xc0be2c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0be3a00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0be3d00, 0xffffff00, 24, "APNIC" },
	{ 0xc0be4000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0be4200, 0xffffff00, 24, "APNIC" },
	{ 0xc0be4300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0be4500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0be5f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0be6c00, 0xffffff00, 24, "APNIC" },
	{ 0xc0be8100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0be8200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0be8400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bead00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0beae00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0beb400, 0xfffffe00, 23, "APNIC" },
	{ 0xc0beb600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0bebe00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0bec000, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0bec900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0beca00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0becc00, 0xfffffe00, 23, "APNIC" },
	{ 0xc0bed000, 0xfffff800, 21, "APNIC" },
	{ 0xc0bee900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0beea00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0beec00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bef000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bef200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bef700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0bef800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0c00000, 0xffff0000, 16, "APNIC" },
	{ 0xc0c20000, 0xffff0000, 16, "RIPENCC" },
	{ 0xc0c30100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0c30800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0c30c00, 0xfffffe00, 23, "APNIC" },
	{ 0xc0c30e00, 0xffffff00, 24, "APNIC" },
	{ 0xc0c32200, 0xffffff00, 24, "APNIC" },
	{ 0xc0c32700, 0xffffff00, 24, "APNIC" },
	{ 0xc0c32800, 0xffffff00, 24, "APNIC" },
	{ 0xc0c32a00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0c32c00, 0xfffffc00, 22, "APNIC" },
	{ 0xc0c33000, 0xfffff800, 21, "APNIC" },
	{ 0xc0c34800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0c36200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0c36600, 0xffffff00, 24, "APNIC" },
	{ 0xc0c36900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0c36a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0c36e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0c37000, 0xffffff00, 24, "APNIC" },
	{ 0xc0c37400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0c38600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0c39800, 0xffffff00, 24, "APNIC" },
	{ 0xc0c3aa00, 0xffffff00, 24, "APNIC" },
	{ 0xc0c3b700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0c3b800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0c3c300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0c3c500, 0xffffff00, 24, "APNIC" },
	{ 0xc0c3db00, 0xffffff00, 24, "APNIC" },
	{ 0xc0c3ec00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0c3ed00, 0xffffff00, 24, "LACNIC" },
	{ 0xc0c40100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0c60800, 0xfffff800, 21, "LACNIC" },
	{ 0xc0c71000, 0xfffff000, 20, "RIPENCC" },
	{ 0xc0c72000, 0xfffff000, 20, "APNIC" },
	{ 0xc0c84000, 0xfffff000, 20, "APNIC" },
	{ 0xc0cb5000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0cb6c00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0cb8a00, 0xfffffe00, 23, "APNIC" },
	{ 0xc0cb8c00, 0xfffffc00, 22, "APNIC" },
	{ 0xc0cb9000, 0xfffffe00, 23, "APNIC" },
	{ 0xc0cb9200, 0xffffff00, 24, "APNIC" },
	{ 0xc0cb9a00, 0xffffff00, 24, "APNIC" },
	{ 0xc0cb9e00, 0xffffff00, 24, "LACNIC" },
	{ 0xc0cbb000, 0xffffff00, 24, "APNIC" },
	{ 0xc0cbb100, 0xffffff00, 24, "LACNIC" },
	{ 0xc0cbd500, 0xffffff00, 24, "APNIC" },
	{ 0xc0cbd800, 0xffffff00, 24, "APNIC" },
	{ 0xc0cbe300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0cbe800, 0xffffff00, 24, "APNIC" },
	{ 0xc0cbeb00, 0xffffff00, 24, "APNIC" },
	{ 0xc0cbf700, 0xffffff00, 24, "APNIC" },
	{ 0xc0ce4d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0ce4e00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0ce5000, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0ce5600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0ce9800, 0xfffffc00, 22, "APNIC" },
	{ 0xc0ce9c00, 0xfffffe00, 23, "APNIC" },
	{ 0xc0cede00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0cee000, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0cee200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0cf0e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0cf1f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0cf2100, 0xffffff00, 24, "APNIC" },
	{ 0xc0cf2400, 0xffffff00, 24, "APNIC" },
	{ 0xc0cf2800, 0xfffffe00, 23, "LACNIC" },
	{ 0xc0cf2a00, 0xffffff00, 24, "LACNIC" },
	{ 0xc0cf4000, 0xffffff00, 24, "APNIC" },
	{ 0xc0cf4100, 0xffffff00, 24, "LACNIC" },
	{ 0xc0cf4200, 0xfffffe00, 23, "LACNIC" },
	{ 0xc0cf4400, 0xffffff00, 24, "LACNIC" },
	{ 0xc0cf5b00, 0xffffff00, 24, "APNIC" },
	{ 0xc0cf6000, 0xfffffe00, 23, "APNIC" },
	{ 0xc0cf6200, 0xffffff00, 24, "APNIC" },
	{ 0xc0cf7100, 0xffffff00, 24, "APNIC" },
	{ 0xc0cf7700, 0xffffff00, 24, "APNIC" },
	{ 0xc0cf7800, 0xfffffe00, 23, "APNIC" },
	{ 0xc0cf8d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0cf8e00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0cf8f00, 0xffffff00, 24, "APNIC" },
	{ 0xc0cf9200, 0xffffff00, 24, "LACNIC" },
	{ 0xc0cf9700, 0xffffff00, 24, "APNIC" },
	{ 0xc0cf9800, 0xfffffe00, 23, "APNIC" },
	{ 0xc0cf9c00, 0xfffffe00, 23, "APNIC" },
	{ 0xc0cf9e00, 0xffffff00, 24, "APNIC" },
	{ 0xc0cfa100, 0xffffff00, 24, "APNIC" },
	{ 0xc0cfa500, 0xffffff00, 24, "APNIC" },
	{ 0xc0cfb700, 0xffffff00, 24, "LACNIC" },
	{ 0xc0cfbb00, 0xffffff00, 24, "APNIC" },
	{ 0xc0cfc200, 0xfffffe00, 23, "LACNIC" },
	{ 0xc0cfc400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0cfc500, 0xffffff00, 24, "APNIC" },
	{ 0xc0cfc600, 0xffffff00, 24, "APNIC" },
	{ 0xc0cfc800, 0xfffffc00, 22, "LACNIC" },
	{ 0xc0cfcc00, 0xfffffe00, 23, "LACNIC" },
	{ 0xc0cfce00, 0xffffff00, 24, "LACNIC" },
	{ 0xc0cff200, 0xffffff00, 24, "APNIC" },
	{ 0xc0cff400, 0xffffff00, 24, "LACNIC" },
	{ 0xc0cff800, 0xffffff00, 24, "APNIC" },
	{ 0xc0da0000, 0xffff0000, 16, "APNIC" },
	{ 0xc0df4000, 0xffffc000, 18, "LACNIC" },
	{ 0xc0e30100, 0xffffff00, 24, "APNIC" },
	{ 0xc0e30200, 0xfffffe00, 23, "APNIC" },
	{ 0xc0e30400, 0xfffffc00, 22, "APNIC" },
	{ 0xc0e30800, 0xfffff800, 21, "APNIC" },
	{ 0xc0e48000, 0xffff8000, 17, "APNIC" },
	{ 0xc0e70f00, 0xffffff00, 24, "APNIC" },
	{ 0xc0e72200, 0xffffff00, 24, "APNIC" },
	{ 0xc0e73b00, 0xffffff00, 24, "APNIC" },
	{ 0xc0e74300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0e75200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0e76e00, 0xffffff00, 24, "LACNIC" },
	{ 0xc0e77200, 0xfffffe00, 23, "LACNIC" },
	{ 0xc0e77400, 0xfffffc00, 22, "LACNIC" },
	{ 0xc0e77800, 0xfffffe00, 23, "LACNIC" },
	{ 0xc0e77f00, 0xffffff00, 24, "APNIC" },
	{ 0xc0e78700, 0xffffff00, 24, "APNIC" },
	{ 0xc0e78800, 0xffffff00, 24, "APNIC" },
	{ 0xc0e78c00, 0xffffff00, 24, "LACNIC" },
	{ 0xc0e7a600, 0xfffffe00, 23, "APNIC" },
	{ 0xc0e7a800, 0xfffffe00, 23, "APNIC" },
	{ 0xc0e7aa00, 0xffffff00, 24, "APNIC" },
	{ 0xc0e7af00, 0xffffff00, 24, "LACNIC" },
	{ 0xc0e7b000, 0xffffff00, 24, "LACNIC" },
	{ 0xc0e7c100, 0xffffff00, 24, "APNIC" },
	{ 0xc0e7cb00, 0xffffff00, 24, "APNIC" },
	{ 0xc0e7d400, 0xffffff00, 24, "APNIC" },
	{ 0xc0e7fe00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0e88000, 0xffffe000, 19, "APNIC" },
	{ 0xc0eaf500, 0xffffff00, 24, "APNIC" },
	{ 0xc0ee0100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0f01000, 0xfffff000, 20, "APNIC" },
	{ 0xc0f40000, 0xffff0000, 16, "APNIC" },
	{ 0xc0f50d00, 0xffffff00, 24, "APNIC" },
	{ 0xc0f50e00, 0xffffff00, 24, "APNIC" },
	{ 0xc0f52400, 0xffffff00, 24, "APNIC" },
	{ 0xc0f53a00, 0xfffffe00, 23, "APNIC" },
	{ 0xc0f53c00, 0xffffff00, 24, "LACNIC" },
	{ 0xc0f56900, 0xffffff00, 24, "APNIC" },
	{ 0xc0f56a00, 0xfffffe00, 23, "APNIC" },
	{ 0xc0f56c00, 0xfffffc00, 22, "APNIC" },
	{ 0xc0f57000, 0xffffff00, 24, "APNIC" },
	{ 0xc0f57900, 0xffffff00, 24, "LACNIC" },
	{ 0xc0f59400, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0f59800, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0f5a900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0f5b900, 0xffffff00, 24, "APNIC" },
	{ 0xc0f5c000, 0xffffff00, 24, "APNIC" },
	{ 0xc0f5c400, 0xffffff00, 24, "APNIC" },
	{ 0xc0f5d000, 0xffffff00, 24, "APNIC" },
	{ 0xc0f5d200, 0xfffffe00, 23, "APNIC" },
	{ 0xc0f5d400, 0xfffffc00, 22, "APNIC" },
	{ 0xc0f5d800, 0xfffffe00, 23, "APNIC" },
	{ 0xc0f5e100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0f5f900, 0xffffff00, 24, "APNIC" },
	{ 0xc0f5fa00, 0xfffffe00, 23, "APNIC" },
	{ 0xc0f70100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0f80000, 0xffff8000, 17, "APNIC" },
	{ 0xc0f91000, 0xfffff000, 20, "APNIC" },
	{ 0xc0fb2700, 0xffffff00, 24, "LACNIC" },
	{ 0xc0fb3d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc0fb3e00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0fb4000, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc0fbc300, 0xffffff00, 24, "APNIC" },
	{ 0xc0fbca00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc0fbcd00, 0xffffff00, 24, "APNIC" },
	{ 0xc0fbce00, 0xfffffe00, 23, "APNIC" },
	{ 0xc0fbe200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc1000000, 0xff000000,  8, "RIPENCC" },
	{ 0xc111d700, 0xffffff00, 24, "AFRINIC" },
	{ 0xc113e800, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc1299200, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc15f0000, 0xffff8000, 17, "AFRINIC" },
	{ 0xc16c1700, 0xffffff00, 24, "AFRINIC" },
	{ 0xc16c1c00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc16cd600, 0xffffff00, 24, "AFRINIC" },
	{ 0xc16cfc00, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc16d4200, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc16e6800, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc1bc0700, 0xffffff00, 24, "AFRINIC" },
	{ 0xc1bd0000, 0xffffc000, 18, "AFRINIC" },
	{ 0xc1bd4000, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc1bd8000, 0xffffff00, 24, "AFRINIC" },
	{ 0xc1c20100, 0xffffff00, 24, "AFRINIC" },
	{ 0xc1c20200, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc1c20400, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc1c22000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc1c24000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc1c28000, 0xffffff00, 24, "AFRINIC" },
	{ 0xc1c2a000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc1ddda00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc1e30000, 0xffffc000, 18, "AFRINIC" },
	{ 0xc1e38000, 0xffffff00, 24, "AFRINIC" },
	{ 0xc2000000, 0xfe000000,  7, "RIPENCC" },
	{ 0xc206e000, 0xffffff00, 24, "AFRINIC" },
	{ 0xc2094000, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc2095200, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc24f6000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc2ccc000, 0xffffc000, 18, "AFRINIC" },
	{ 0xc3185000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc318c000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc327da00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc32b0000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc3a6e000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc3ca4000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc3ea7800, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc3eaa800, 0xffffff00, 24, "AFRINIC" },
	{ 0xc3eab900, 0xffffff00, 24, "AFRINIC" },
	{ 0xc3eafc00, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc3f62000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc4000000, 0xffff0000, 16, "AFRINIC" },
	{ 0xc4010000, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4010100, 0xffffff00, 24, "APNIC" },
	{ 0xc4010300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc4010400, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4010500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc4010600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc4010700, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4010800, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc4011000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc4011a00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc4011c00, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc4012000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc4013400, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc4013800, 0xfffff800, 21, "AFRINIC" },
	{ 0xc4014000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc4014400, 0xffffff00, 24, "APNIC" },
	{ 0xc4014500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc4014600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc4014700, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4014a00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc4015100, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4015200, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc4015700, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4015c00, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc4016000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc4016800, 0xfffffe00, 23, "APNIC" },
	{ 0xc4016a00, 0xffffff00, 24, "APNIC" },
	{ 0xc4016d00, 0xffffff00, 24, "APNIC" },
	{ 0xc4016e00, 0xfffffe00, 23, "APNIC" },
	{ 0xc4017000, 0xffffff00, 24, "LACNIC" },
	{ 0xc4017100, 0xffffff00, 24, "APNIC" },
	{ 0xc4017200, 0xffffff00, 24, "APNIC" },
	{ 0xc4017300, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4017400, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc4017800, 0xfffff800, 21, "AFRINIC" },
	{ 0xc4018000, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc4018400, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc4018600, 0xffffff00, 24, "APNIC" },
	{ 0xc4018700, 0xffffff00, 24, "LACNIC" },
	{ 0xc4018900, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4018f00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4019000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc401b000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc401c000, 0xffffc000, 18, "AFRINIC" },
	{ 0xc4020200, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc4020400, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc4020800, 0xfffff800, 21, "AFRINIC" },
	{ 0xc4021000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc4022000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc4024000, 0xffffc000, 18, "AFRINIC" },
	{ 0xc4028000, 0xffffc000, 18, "AFRINIC" },
	{ 0xc402c000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc4030e00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc4031000, 0xfffff000, 20, "LACNIC" },
	{ 0xc4033900, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4033a00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc4033c00, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc4034000, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4034100, 0xffffff00, 24, "APNIC" },
	{ 0xc4034200, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc4034800, 0xffffff00, 24, "APNIC" },
	{ 0xc4034a00, 0xfffffe00, 23, "LACNIC" },
	{ 0xc4034c00, 0xfffffc00, 22, "LACNIC" },
	{ 0xc4035000, 0xfffff800, 21, "LACNIC" },
	{ 0xc4035800, 0xfffffe00, 23, "LACNIC" },
	{ 0xc4035a00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4035b00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc4035c00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc4035e00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4036000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc4036900, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4036a00, 0xffffff00, 24, "LACNIC" },
	{ 0xc4036b00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4036c00, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc4037000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc4037c00, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc4038400, 0xfffffc00, 22, "LACNIC" },
	{ 0xc4038800, 0xfffff800, 21, "LACNIC" },
	{ 0xc4039000, 0xfffffc00, 22, "LACNIC" },
	{ 0xc4039400, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc4039800, 0xffffff00, 24, "LACNIC" },
	{ 0xc4039a00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc4039c00, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc403a000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc403b400, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc403e000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc4040000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc4041400, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc4041e00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc4042400, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc4044700, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4044c00, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc4045000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc4045e00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc4046000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc4049600, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc404a000, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc404a600, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc404a800, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc404ac00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc404bd00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc404be00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc404c800, 0xfffff800, 21, "AFRINIC" },
	{ 0xc404d400, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc404e800, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc404ef00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc404f900, 0xffffff00, 24, "AFRINIC" },
	{ 0xc404fa00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc404fc00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc404ff00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4050000, 0xffff0000, 16, "AFRINIC" },
	{ 0xc4060000, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc4066500, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4066600, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4067900, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4067b00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4068300, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4068500, 0xffffff00, 24, "AFRINIC" },
	{ 0xc406ad00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc406b800, 0xffffff00, 24, "AFRINIC" },
	{ 0xc406c600, 0xffffff00, 24, "AFRINIC" },
	{ 0xc406c900, 0xffffff00, 24, "AFRINIC" },
	{ 0xc406d400, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc406d600, 0xffffff00, 24, "AFRINIC" },
	{ 0xc406dd00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc406de00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc406ed00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc406f000, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc406f300, 0xffffff00, 24, "AFRINIC" },
	{ 0xc406f800, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc406fb00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc406fc00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc406fe00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4070000, 0xffff0000, 16, "AFRINIC" },
	{ 0xc4080000, 0xfffe0000, 15, "AFRINIC" },
	{ 0xc40a0100, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40a3d00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40a6000, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40a6500, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40a6600, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40a6800, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc40a7000, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc40a7600, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40a7900, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40a7c00, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc40a8000, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc40a8e00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40a9500, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40a9600, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40ac800, 0xfffff800, 21, "AFRINIC" },
	{ 0xc40ae000, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc40ae500, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40ae600, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40ae800, 0xfffff800, 21, "AFRINIC" },
	{ 0xc40af600, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40b0000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc40b3800, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc40b3c00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40b4000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc40b5b00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40b5c00, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc40b6200, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40b6900, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40b6d00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40b7300, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40b7400, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40b7a00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40b7c00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40b8800, 0xfffff800, 21, "AFRINIC" },
	{ 0xc40b9200, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40ba000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc40baa00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40bbc00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40bc000, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc40bc500, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40bc600, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40bc800, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40bcd00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40bd000, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40bd500, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40bde00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40be800, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40beb00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40bec00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40bef00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40bf700, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40bf800, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40bfc00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40c0a00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40c0c00, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc40c1000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc40c2000, 0xffffe000, 19, "APNIC" },
	{ 0xc40c8000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc40cc000, 0xffffc000, 18, "AFRINIC" },
	{ 0xc40d0100, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40d1f00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40d5100, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40d7100, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40d7200, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40d7400, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc40d7800, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40d7f00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40d8000, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc40d8400, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40d8a00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40d9300, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40d9400, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc40d9800, 0xfffff800, 21, "AFRINIC" },
	{ 0xc40da000, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40da200, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40da400, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc40da800, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40daa00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40db800, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40dbb00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40dc800, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40dcd00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40dd200, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40dd500, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40dd600, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40dd800, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc40ddc00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40dde00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40de000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc40de800, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc40def00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40df000, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40df600, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40df900, 0xffffff00, 24, "AFRINIC" },
	{ 0xc40dfa00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc40e0000, 0xffff0000, 16, "AFRINIC" },
	{ 0xc40f0000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc40f0800, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc40f1000, 0xfffff000, 20, "APNIC" },
	{ 0xc40f2000, 0xffffe000, 19, "RIPENCC" },
	{ 0xc40f4000, 0xffffc000, 18, "AFRINIC" },
	{ 0xc40f8000, 0xffff8000, 17, "AFRINIC" },
	{ 0xc4100000, 0xfffc0000, 14, "AFRINIC" },
	{ 0xc4140000, 0xfffe0000, 15, "AFRINIC" },
	{ 0xc4160000, 0xffff8000, 17, "AFRINIC" },
	{ 0xc4168000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc4169000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc416a000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc416c000, 0xffffc000, 18, "AFRINIC" },
	{ 0xc4170000, 0xffff0000, 16, "AFRINIC" },
	{ 0xc4180000, 0xfffe0000, 15, "AFRINIC" },
	{ 0xc41a0000, 0xffff0000, 16, "AFRINIC" },
	{ 0xc41b4000, 0xffffc000, 18, "AFRINIC" },
	{ 0xc41b8000, 0xffff8000, 17, "AFRINIC" },
	{ 0xc41c0000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc41c0800, 0xffffff00, 24, "AFRINIC" },
	{ 0xc41c0a00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc41c0c00, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc41c1000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc41c4000, 0xffffc000, 18, "AFRINIC" },
	{ 0xc41c8000, 0xffffc000, 18, "AFRINIC" },
	{ 0xc41ce000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc41d0000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc41d2000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc41d2800, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc41d3000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc41d4000, 0xffffe000, 19, "LACNIC" },
	{ 0xc41d6000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc41d8000, 0xffff8000, 17, "AFRINIC" },
	{ 0xc41e0000, 0xfffe0000, 15, "AFRINIC" },
	{ 0xc4202000, 0xffffe000, 19, "LACNIC" },
	{ 0xc4204000, 0xffffe000, 19, "LACNIC" },
	{ 0xc4206000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc420a000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc420c000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc420e000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc420f000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc4210000, 0xffff0000, 16, "AFRINIC" },
	{ 0xc4220000, 0xfffe0000, 15, "AFRINIC" },
	{ 0xc4240000, 0xfffc0000, 14, "AFRINIC" },
	{ 0xc4280000, 0xffffc000, 18, "LACNIC" },
	{ 0xc4284000, 0xffffe000, 19, "LACNIC" },
	{ 0xc4286000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc4288000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc428c000, 0xffffc000, 18, "AFRINIC" },
	{ 0xc4290000, 0xffffc000, 18, "AFRINIC" },
	{ 0xc4296000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc4298000, 0xffff8000, 17, "AFRINIC" },
	{ 0xc42b0000, 0xffff8000, 17, "AFRINIC" },
	{ 0xc42b8000, 0xffffc000, 18, "AFRINIC" },
	{ 0xc42bc000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc42bd000, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc42bd400, 0xffffff00, 24, "AFRINIC" },
	{ 0xc42bd600, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc42bd800, 0xfffff800, 21, "AFRINIC" },
	{ 0xc42be000, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc42be200, 0xffffff00, 24, "AFRINIC" },
	{ 0xc42bfc00, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc42c0000, 0xfffe0000, 15, "AFRINIC" },
	{ 0xc42e0000, 0xffff0000, 16, "AFRINIC" },
	{ 0xc42f0000, 0xffffc000, 18, "AFRINIC" },
	{ 0xc42f4000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc42f8000, 0xffffc000, 18, "AFRINIC" },
	{ 0xc4340000, 0xfffc0000, 14, "AFRINIC" },
	{ 0xc4380000, 0xfffc0000, 14, "AFRINIC" },
	{ 0xc4c00000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc4c02000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc4c04000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc4c05000, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc4c06000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc4c80000, 0xffff8000, 17, "AFRINIC" },
	{ 0xc4c88000, 0xffffc000, 18, "AFRINIC" },
	{ 0xc4c90100, 0xffffff00, 24, "AFRINIC" },
	{ 0xc4c90200, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc4c90400, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc4c90c00, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc4c91000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc4c92000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc4c94000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc4c98000, 0xffffc000, 18, "AFRINIC" },
	{ 0xc4c9c000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc4c9e000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc4c9f000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc4ca0000, 0xffff8000, 17, "AFRINIC" },
	{ 0xc4ca8000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc4cac000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc4cae800, 0xfffff800, 21, "AFRINIC" },
	{ 0xc4caf000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc4cb0000, 0xffff0000, 16, "AFRINIC" },
	{ 0xc4cc0000, 0xfffe0000, 15, "AFRINIC" },
	{ 0xc4ce0000, 0xffff0000, 16, "AFRINIC" },
	{ 0xc4cf0000, 0xffffc000, 18, "AFRINIC" },
	{ 0xc4cfc000, 0xffffc000, 18, "AFRINIC" },
	{ 0xc4d00000, 0xfff80000, 13, "AFRINIC" },
	{ 0xc4d80200, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc4d80800, 0xfffff800, 21, "AFRINIC" },
	{ 0xc4d81000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc4d82000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc4d84000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc4d88000, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc4d88c00, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc4d89000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc4d8a000, 0xffffe000, 19, "AFRINIC" },
	{ 0xc4d8c000, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc4d8f000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc4d90000, 0xffff0000, 16, "AFRINIC" },
	{ 0xc4da0000, 0xfffe0000, 15, "AFRINIC" },
	{ 0xc4dc0000, 0xffff8000, 17, "AFRINIC" },
	{ 0xc4dcc000, 0xffffc000, 18, "AFRINIC" },
	{ 0xc4dd0000, 0xffff0000, 16, "AFRINIC" },
	{ 0xc4de0000, 0xffff0000, 16, "AFRINIC" },
	{ 0xc4df0000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc4df1000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc4df1800, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc5000000, 0xff000000,  8, "AFRINIC" },
	{ 0xc6000000, 0xfe000000,  7, "ARIN" },
	{ 0xc6021000, 0xfffff000, 20, "LACNIC" },
	{ 0xc60b0000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc60c2000, 0xffffe000, 19, "LACNIC" },
	{ 0xc60f2000, 0xffffe000, 19, "APNIC" },
	{ 0xc6110100, 0xffffff00, 24, "APNIC" },
	{ 0xc6114600, 0xffffff00, 24, "APNIC" },
	{ 0xc6114d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc6117500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc6117600, 0xffffff00, 24, "APNIC" },
	{ 0xc6117800, 0xfffffe00, 23, "LACNIC" },
	{ 0xc611b400, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc611b600, 0xffffff00, 24, "RIPENCC" },
	{ 0xc611e700, 0xffffff00, 24, "LACNIC" },
	{ 0xc611e800, 0xffffff00, 24, "LACNIC" },
	{ 0xc6162f00, 0xffffff00, 24, "APNIC" },
	{ 0xc6163300, 0xffffff00, 24, "RIPENCC" },
	{ 0xc6163d00, 0xffffff00, 24, "APNIC" },
	{ 0xc6165d00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc6165e00, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc6166000, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc616fa00, 0xfffffe00, 23, "LACNIC" },
	{ 0xc61b0400, 0xfffffc00, 22, "APNIC" },
	{ 0xc61b0800, 0xffffff00, 24, "APNIC" },
	{ 0xc6242000, 0xfffff800, 21, "RIPENCC" },
	{ 0xc6292000, 0xfffff800, 21, "LACNIC" },
	{ 0xc6292800, 0xfffffc00, 22, "LACNIC" },
	{ 0xc6292c00, 0xfffffe00, 23, "LACNIC" },
	{ 0xc6292e00, 0xffffff00, 24, "LACNIC" },
	{ 0xc6300000, 0xfffffc00, 22, "APNIC" },
	{ 0xc6317000, 0xfffffe00, 23, "APNIC" },
	{ 0xc6317c00, 0xffffff00, 24, "APNIC" },
	{ 0xc6318000, 0xfffffc00, 22, "LACNIC" },
	{ 0xc6318400, 0xfffffe00, 23, "LACNIC" },
	{ 0xc631a400, 0xffffff00, 24, "LACNIC" },
	{ 0xc6321000, 0xfffff800, 21, "LACNIC" },
	{ 0xc6330c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc6334700, 0xffffff00, 24, "LACNIC" },
	{ 0xc6338f00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc633c300, 0xffffff00, 24, "APNIC" },
	{ 0xc633d200, 0xffffff00, 24, "APNIC" },
	{ 0xc6360100, 0xffffff00, 24, "AFRINIC" },
	{ 0xc6360200, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc6360400, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc6360800, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc6360a00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc6360f00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc6361000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc6362600, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc6362c00, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc6363000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc6363800, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc6363c00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc6364000, 0xfffff000, 20, "AFRINIC" },
	{ 0xc6365000, 0xffffff00, 24, "AFRINIC" },
	{ 0xc6365300, 0xffffff00, 24, "AFRINIC" },
	{ 0xc6365400, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc6365b00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc6366200, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc6368d00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc6368e00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc6369000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc6369a00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc6369c00, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc636a000, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc636a500, 0xffffff00, 24, "AFRINIC" },
	{ 0xc636aa00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc636ad00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc636ae00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc636b000, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc636b400, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc636b700, 0xffffff00, 24, "AFRINIC" },
	{ 0xc636b800, 0xfffff800, 21, "AFRINIC" },
	{ 0xc636c000, 0xfffff800, 21, "AFRINIC" },
	{ 0xc636ca00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc636d200, 0xffffff00, 24, "AFRINIC" },
	{ 0xc636db00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc636dc00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc636df00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc636e100, 0xffffff00, 24, "AFRINIC" },
	{ 0xc636e200, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc636e400, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc636e700, 0xffffff00, 24, "AFRINIC" },
	{ 0xc636e800, 0xffffff00, 24, "AFRINIC" },
	{ 0xc636ea00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc636f700, 0xffffff00, 24, "AFRINIC" },
	{ 0xc636f800, 0xfffffc00, 22, "AFRINIC" },
	{ 0xc636fc00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xc636fe00, 0xffffff00, 24, "AFRINIC" },
	{ 0xc63a0800, 0xfffffc00, 22, "LACNIC" },
	{ 0xc63a0c00, 0xffffff00, 24, "LACNIC" },
	{ 0xc649dc00, 0xffffff00, 24, "APNIC" },
	{ 0xc6639400, 0xffffff00, 24, "RIPENCC" },
	{ 0xc663ad00, 0xffffff00, 24, "APNIC" },
	{ 0xc663de00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc6855000, 0xfffffc00, 22, "RIPENCC" },
	{ 0xc6858c00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc685e200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc6878900, 0xffffff00, 24, "RIPENCC" },
	{ 0xc6878a00, 0xffffff00, 24, "RIPENCC" },
	{ 0xc687a700, 0xffffff00, 24, "RIPENCC" },
	{ 0xc68e0000, 0xffff0000, 16, "APNIC" },
	{ 0xc693a000, 0xffffff00, 24, "RIPENCC" },
	{ 0xc694b100, 0xffffff00, 24, "RIPENCC" },
	{ 0xc694b200, 0xffffff00, 24, "RIPENCC" },
	{ 0xc6978400, 0xffffff00, 24, "LACNIC" },
	{ 0xc6b8a100, 0xffffff00, 24, "LACNIC" },
	{ 0xc6c80000, 0xfffff800, 21, "APNIC" },
	{ 0xc6c80800, 0xfffffe00, 23, "APNIC" },
	{ 0xc6cec500, 0xffffff00, 24, "RIPENCC" },
	{ 0xc6cec800, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc6f08000, 0xffff8000, 17, "RIPENCC" },
	{ 0xc71aea00, 0xffffff00, 24, "LACNIC" },
	{ 0xc72bf600, 0xfffffe00, 23, "RIPENCC" },
	{ 0xc7350000, 0xffff0000, 16, "RIPENCC" },
	{ 0xc75b1000, 0xfffff000, 20, "RIPENCC" },
	{ 0xc7676600, 0xffffff00, 24, "LACNIC" },
	{ 0xc7f89000, 0xffffff00, 24, "LACNIC" },
	{ 0xc8000000, 0xfe000000,  7, "LACNIC" },
	{ 0xc8005e00, 0xffffff00, 24, "ARIN" },
	{ 0xc8008900, 0xffffff00, 24, "ARIN" },
	{ 0xc8008a00, 0xffffff00, 24, "ARIN" },
	{ 0xc800d800, 0xfffff800, 21, "ARIN" },
	{ 0xc801a000, 0xffffff00, 24, "ARIN" },
	{ 0xc8050000, 0xfffff800, 21, "ARIN" },
	{ 0xc8050800, 0xffffff00, 24, "ARIN" },
	{ 0xc8050b00, 0xffffff00, 24, "ARIN" },
	{ 0xc8095200, 0xfffffe00, 23, "ARIN" },
	{ 0xc8097300, 0xffffff00, 24, "ARIN" },
	{ 0xc80a9800, 0xffffff00, 24, "ARIN" },
	{ 0xc80a9b00, 0xffffff00, 24, "ARIN" },
	{ 0xc80aa000, 0xffffff00, 24, "ARIN" },
	{ 0xc80aa500, 0xffffff00, 24, "ARIN" },
	{ 0xc80aa600, 0xffffff00, 24, "ARIN" },
	{ 0xc80ca800, 0xffffff00, 24, "ARIN" },
	{ 0xc80ce000, 0xfffff000, 20, "ARIN" },
	{ 0xc80f0000, 0xffff0000, 16, "ARIN" },
	{ 0xc8100800, 0xfffff800, 21, "AFRINIC" },
	{ 0xc8105800, 0xffffff00, 24, "ARIN" },
	{ 0xc81e0000, 0xffffc000, 18, "ARIN" },
	{ 0xc8320000, 0xffffe000, 19, "ARIN" },
	{ 0xc8324000, 0xffffe000, 19, "ARIN" },
	{ 0xc8328000, 0xfffff000, 20, "ARIN" },
	{ 0xc83a0000, 0xffffc000, 18, "ARIN" },
	{ 0xc83e0000, 0xffffc000, 18, "ARIN" },
	{ 0xca000000, 0xfe000000,  7, "APNIC" },
	{ 0xca7b0000, 0xffffe000, 19, "AFRINIC" },
	{ 0xcc000000, 0xfc000000,  6, "ARIN" },
	{ 0xcc0c8000, 0xfffff000, 20, "AFRINIC" },
	{ 0xcc3a8800, 0xfffffc00, 22, "LACNIC" },
	{ 0xcc508f00, 0xffffff00, 24, "LACNIC" },
	{ 0xcc57a900, 0xffffff00, 24, "LACNIC" },
	{ 0xcc57b300, 0xffffff00, 24, "AFRINIC" },
	{ 0xcc59ce00, 0xffffff00, 24, "LACNIC" },
	{ 0xcc7c6800, 0xfffffc00, 22, "LACNIC" },
	{ 0xcc7e0c00, 0xfffffe00, 23, "LACNIC" },
	{ 0xcc7e8000, 0xfffffe00, 23, "LACNIC" },
	{ 0xcc7e8c00, 0xfffffe00, 23, "LACNIC" },
	{ 0xcc91c900, 0xffffff00, 24, "LACNIC" },
	{ 0xcc980e00, 0xfffffe00, 23, "AFRINIC" },
	{ 0xcc991800, 0xfffffe00, 23, "LACNIC" },
	{ 0xcceb2000, 0xfffff800, 21, "AFRINIC" },
	{ 0xcd9f4f00, 0xffffff00, 24, "AFRINIC" },
	{ 0xcda6fb00, 0xffffff00, 24, "LACNIC" },
	{ 0xcedd5000, 0xfffff000, 20, "LACNIC" },
	{ 0xcedf7c00, 0xffffff00, 24, "LACNIC" },
	{ 0xcedf8200, 0xffffff00, 24, "LACNIC" },
	{ 0xcedf8800, 0xffffff00, 24, "AFRINIC" },
	{ 0xcee02000, 0xffffe000, 19, "LACNIC" },
	{ 0xcff80000, 0xffffc000, 18, "LACNIC" },
	{ 0xcff84000, 0xfffffe00, 23, "LACNIC" },
	{ 0xcff84400, 0xfffffc00, 22, "LACNIC" },
	{ 0xcff84800, 0xfffffe00, 23, "LACNIC" },
	{ 0xcff84e00, 0xfffffe00, 23, "LACNIC" },
	{ 0xcff85200, 0xfffffe00, 23, "LACNIC" },
	{ 0xcff85400, 0xffffff00, 24, "LACNIC" },
	{ 0xcff85800, 0xfffffc00, 22, "LACNIC" },
	{ 0xcff86000, 0xfffffc00, 22, "LACNIC" },
	{ 0xcff86400, 0xffffff00, 24, "LACNIC" },
	{ 0xcff86800, 0xfffffe00, 23, "LACNIC" },
	{ 0xcff87200, 0xfffffe00, 23, "LACNIC" },
	{ 0xcff87600, 0xfffffe00, 23, "LACNIC" },
	{ 0xcff87800, 0xffffff00, 24, "LACNIC" },
	{ 0xcff87a00, 0xffffff00, 24, "LACNIC" },
	{ 0xcff88000, 0xffffc000, 18, "LACNIC" },
	{ 0xcff8e000, 0xffffe000, 19, "LACNIC" },
	{ 0xcff90000, 0xffff0000, 16, "LACNIC" },
	{ 0xd0000000, 0xfe000000,  7, "ARIN" },
	{ 0xd10d0000, 0xffff0000, 16, "LACNIC" },
	{ 0xd12d0000, 0xffff8000, 17, "LACNIC" },
	{ 0xd15ec000, 0xffffe000, 19, "LACNIC" },
	{ 0xd163e000, 0xfffff000, 20, "LACNIC" },
	{ 0xd1cb0000, 0xffffc000, 18, "AFRINIC" },
	{ 0xd1d46000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd2000000, 0xfe000000,  7, "APNIC" },
	{ 0xd4000000, 0xfe000000,  7, "RIPENCC" },
	{ 0xd4008000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd40ce000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd416a000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd4314000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd4348000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd43c4000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd455c000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd4586000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd4600000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd4644000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd467a000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd47ae000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd4d90000, 0xffff8000, 17, "AFRINIC" },
	{ 0xd5374000, 0xffffc000, 18, "AFRINIC" },
	{ 0xd5834000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd5886000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd5934000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd5966000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd596a000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd596c000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd5984000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd59a2000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd59a4000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd59ea000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd5b3a000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd5b5e000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd5c12000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd5d4c000, 0xffffc000, 18, "AFRINIC" },
	{ 0xd5f70000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd5ff8000, 0xffffe000, 19, "AFRINIC" },
	{ 0xd6000000, 0xfe000000,  7, "ARIN" },
	{ 0xd8000000, 0xff000000,  8, "ARIN" },
	{ 0xd898a000, 0xfffff000, 20, "LACNIC" },
	{ 0xd89b4000, 0xffffe000, 19, "LACNIC" },
	{ 0xd8e68000, 0xffffe000, 19, "LACNIC" },
	{ 0xd8ecb000, 0xfffff000, 20, "AFRINIC" },
	{ 0xd8f10000, 0xffffe000, 19, "LACNIC" },
	{ 0xd8f48000, 0xffff8000, 17, "LACNIC" },
	{ 0xd9000000, 0xff000000,  8, "RIPENCC" },
	{ 0xd90e5000, 0xfffff000, 20, "AFRINIC" },
	{ 0xd914e000, 0xfffff000, 20, "AFRINIC" },
	{ 0xd9157000, 0xfffff000, 20, "AFRINIC" },
	{ 0xd91d8000, 0xfffff000, 20, "AFRINIC" },
	{ 0xd9340000, 0xfffc0000, 14, "AFRINIC" },
	{ 0xd9406000, 0xfffff000, 20, "AFRINIC" },
	{ 0xd94d4000, 0xfffff000, 20, "AFRINIC" },
	{ 0xd9750000, 0xfffff000, 20, "AFRINIC" },
	{ 0xd98b0000, 0xffff0000, 16, "AFRINIC" },
	{ 0xd9aa9000, 0xfffff000, 20, "AFRINIC" },
	{ 0xd9c79000, 0xfffff000, 20, "AFRINIC" },
	{ 0xda000000, 0xfe000000,  7, "APNIC" },
	{ 0xdc000000, 0xfc000000,  6, "APNIC" },
	{ 0xe0000000, 0xe0000000,  3, "ARIN" },

};

static const s_ipv4addr_assignment_hint dbipv4addr_assignment_hint[256] = {
	{ 0x00, 0 , 0 },
	{ 0x01, 1 , 1 },
	{ 0x02, 2 , 2 },
	{ 0x03, 3 , 3 },
	{ 0x04, 4 , 4 },
	{ 0x05, 5 , 5 },
	{ 0x06, 6 , 6 },
	{ 0x07, 6 , 6 },
	{ 0x08, 7 , 7 },
	{ 0x09, 7 , 7 },
	{ 0x0a, 8 , 8 },
	{ 0x0b, 9 , 9 },
	{ 0x0c, 10 , 10 },
	{ 0x0d, 10 , 10 },
	{ 0x0e, 11 , 11 },
	{ 0x0f, 12 , 12 },
	{ 0x10, 13 , 13 },
	{ 0x11, 13 , 13 },
	{ 0x12, 13 , 13 },
	{ 0x13, 13 , 13 },
	{ 0x14, 13 , 13 },
	{ 0x15, 13 , 13 },
	{ 0x16, 13 , 13 },
	{ 0x17, 13 , 13 },
	{ 0x18, 14 , 16 },
	{ 0x19, 14 , 17 },
	{ 0x1a, 18 , 18 },
	{ 0x1b, 19 , 19 },
	{ 0x1c, 20 , 20 },
	{ 0x1d, 20 , 20 },
	{ 0x1e, 21 , 21 },
	{ 0x1f, 22 , 22 },
	{ 0x20, 23 , 23 },
	{ 0x21, 23 , 23 },
	{ 0x22, 23 , 23 },
	{ 0x23, 23 , 23 },
	{ 0x24, 24 , 24 },
	{ 0x25, 25 , 25 },
	{ 0x26, 26 , 26 },
	{ 0x27, 27 , 27 },
	{ 0x28, 28 , 28 },
	{ 0x29, 29 , 29 },
	{ 0x2a, 30 , 30 },
	{ 0x2b, 31 , 36 },
	{ 0x2c, 37 , 37 },
	{ 0x2d, 37 , 37 },
	{ 0x2e, 38 , 38 },
	{ 0x2f, 39 , 39 },
	{ 0x30, 40 , 40 },
	{ 0x31, 41 , 41 },
	{ 0x32, 42 , 42 },
	{ 0x33, 42 , 43 },
	{ 0x34, 44 , 44 },
	{ 0x35, 44 , 44 },
	{ 0x36, 44 , 44 },
	{ 0x37, 44 , 44 },
	{ 0x38, 45 , 45 },
	{ 0x39, 45 , 45 },
	{ 0x3a, 46 , 46 },
	{ 0x3b, 46 , 46 },
	{ 0x3c, 47 , 47 },
	{ 0x3d, 47 , 47 },
	{ 0x3e, 48 , 65 },
	{ 0x3f, 66 , 66 },
	{ 0x40, 67 , 70 },
	{ 0x41, 67 , 67 },
	{ 0x42, 67 , 76 },
	{ 0x43, 67 , 67 },
	{ 0x44, 67 , 67 },
	{ 0x45, 67 , 78 },
	{ 0x46, 67 , 67 },
	{ 0x47, 67 , 67 },
	{ 0x48, 79 , 79 },
	{ 0x49, 79 , 79 },
	{ 0x4a, 79 , 79 },
	{ 0x4b, 79 , 79 },
	{ 0x4c, 80 , 80 },
	{ 0x4d, 81 , 82 },
	{ 0x4e, 83 , 83 },
	{ 0x4f, 83 , 83 },
	{ 0x50, 84 , 94 },
	{ 0x51, 84 , 102 },
	{ 0x52, 84 , 107 },
	{ 0x53, 84 , 108 },
	{ 0x54, 84 , 111 },
	{ 0x55, 84 , 84 },
	{ 0x56, 84 , 84 },
	{ 0x57, 84 , 112 },
	{ 0x58, 84 , 84 },
	{ 0x59, 84 , 84 },
	{ 0x5a, 84 , 84 },
	{ 0x5b, 84 , 84 },
	{ 0x5c, 84 , 84 },
	{ 0x5d, 84 , 84 },
	{ 0x5e, 84 , 84 },
	{ 0x5f, 84 , 84 },
	{ 0x60, 113 , 113 },
	{ 0x61, 113 , 113 },
	{ 0x62, 113 , 113 },
	{ 0x63, 113 , 113 },
	{ 0x64, 114 , 114 },
	{ 0x65, 115 , 115 },
	{ 0x66, 116 , 116 },
	{ 0x67, 117 , 117 },
	{ 0x68, 118 , 118 },
	{ 0x69, 119 , 119 },
	{ 0x6a, 120 , 120 },
	{ 0x6b, 121 , 121 },
	{ 0x6c, 122 , 122 },
	{ 0x6d, 123 , 123 },
	{ 0x6e, 124 , 124 },
	{ 0x6f, 124 , 124 },
	{ 0x70, 125 , 125 },
	{ 0x71, 125 , 125 },
	{ 0x72, 125 , 125 },
	{ 0x73, 125 , 125 },
	{ 0x74, 125 , 125 },
	{ 0x75, 125 , 125 },
	{ 0x76, 125 , 125 },
	{ 0x77, 125 , 125 },
	{ 0x78, 126 , 126 },
	{ 0x79, 126 , 126 },
	{ 0x7a, 126 , 126 },
	{ 0x7b, 126 , 126 },
	{ 0x7c, 127 , 127 },
	{ 0x7d, 127 , 127 },
	{ 0x7e, 128 , 128 },
	{ 0x7f, 129 , 129 },
	{ 0x80, 130 , 160 },
	{ 0x81, 130 , 206 },
	{ 0x82, 130 , 274 },
	{ 0x83, 130 , 321 },
	{ 0x84, 130 , 355 },
	{ 0x85, 130 , 356 },
	{ 0x86, 130 , 428 },
	{ 0x87, 130 , 429 },
	{ 0x88, 430 , 449 },
	{ 0x89, 430 , 505 },
	{ 0x8a, 430 , 564 },
	{ 0x8b, 430 , 648 },
	{ 0x8c, 649 , 693 },
	{ 0x8d, 694 , 754 },
	{ 0x8e, 755 , 755 },
	{ 0x8f, 755 , 808 },
	{ 0x90, 809 , 863 },
	{ 0x91, 864 , 864 },
	{ 0x92, 865 , 940 },
	{ 0x93, 865 , 1018 },
	{ 0x94, 1019 , 1061 },
	{ 0x95, 1019 , 1093 },
	{ 0x96, 1094 , 1137 },
	{ 0x97, 1138 , 1177 },
	{ 0x98, 1178 , 1213 },
	{ 0x99, 1178 , 1238 },
	{ 0x9a, 1178 , 1244 },
	{ 0x9b, 1178 , 1288 },
	{ 0x9c, 1178 , 1323 },
	{ 0x9d, 1178 , 1394 },
	{ 0x9e, 1178 , 1461 },
	{ 0x9f, 1178 , 1538 },
	{ 0xa0, 1539 , 1600 },
	{ 0xa1, 1539 , 1666 },
	{ 0xa2, 1539 , 1679 },
	{ 0xa3, 1539 , 1739 },
	{ 0xa4, 1539 , 1779 },
	{ 0xa5, 1539 , 1824 },
	{ 0xa6, 1539 , 1841 },
	{ 0xa7, 1539 , 1861 },
	{ 0xa8, 1862 , 1908 },
	{ 0xa9, 1862 , 1914 },
	{ 0xaa, 1862 , 1928 },
	{ 0xab, 1862 , 1959 },
	{ 0xac, 1960 , 1960 },
	{ 0xad, 1960 , 1960 },
	{ 0xae, 1961 , 1961 },
	{ 0xaf, 1962 , 1962 },
	{ 0xb0, 1963 , 1963 },
	{ 0xb1, 1964 , 1964 },
	{ 0xb2, 1965 , 1965 },
	{ 0xb3, 1966 , 1966 },
	{ 0xb4, 1967 , 1967 },
	{ 0xb5, 1968 , 1968 },
	{ 0xb6, 1969 , 1969 },
	{ 0xb7, 1969 , 1969 },
	{ 0xb8, 1970 , 1970 },
	{ 0xb9, 1971 , 1971 },
	{ 0xba, 1972 , 1972 },
	{ 0xbb, 1972 , 1972 },
	{ 0xbc, 1973 , 1973 },
	{ 0xbd, 1974 , 1974 },
	{ 0xbe, 1975 , 1975 },
	{ 0xbf, 1976 , 1976 },
	{ 0xc0, 1977 , 3897 },
	{ 0xc1, 3898 , 3922 },
	{ 0xc2, 3923 , 3928 },
	{ 0xc3, 3923 , 3939 },
	{ 0xc4, 3940 , 4289 },
	{ 0xc5, 4290 , 4290 },
	{ 0xc6, 4291 , 4402 },
	{ 0xc7, 4291 , 4408 },
	{ 0xc8, 4409 , 4435 },
	{ 0xc9, 4409 , 4409 },
	{ 0xca, 4436 , 4437 },
	{ 0xcb, 4436 , 4436 },
	{ 0xcc, 4438 , 4452 },
	{ 0xcd, 4438 , 4454 },
	{ 0xce, 4438 , 4459 },
	{ 0xcf, 4438 , 4477 },
	{ 0xd0, 4478 , 4478 },
	{ 0xd1, 4478 , 4484 },
	{ 0xd2, 4485 , 4485 },
	{ 0xd3, 4485 , 4485 },
	{ 0xd4, 4486 , 4499 },
	{ 0xd5, 4486 , 4516 },
	{ 0xd6, 4517 , 4517 },
	{ 0xd7, 4517 , 4517 },
	{ 0xd8, 4518 , 4524 },
	{ 0xd9, 4525 , 4536 },
	{ 0xda, 4537 , 4537 },
	{ 0xdb, 4537 , 4537 },
	{ 0xdc, 4538 , 4538 },
	{ 0xdd, 4538 , 4538 },
	{ 0xde, 4538 , 4538 },
	{ 0xdf, 4538 , 4538 },
	{ 0xe0, 4539 , 4539 },
	{ 0xe1, 4539 , 4539 },
	{ 0xe2, 4539 , 4539 },
	{ 0xe3, 4539 , 4539 },
	{ 0xe4, 4539 , 4539 },
	{ 0xe5, 4539 , 4539 },
	{ 0xe6, 4539 , 4539 },
	{ 0xe7, 4539 , 4539 },
	{ 0xe8, 4539 , 4539 },
	{ 0xe9, 4539 , 4539 },
	{ 0xea, 4539 , 4539 },
	{ 0xeb, 4539 , 4539 },
	{ 0xec, 4539 , 4539 },
	{ 0xed, 4539 , 4539 },
	{ 0xee, 4539 , 4539 },
	{ 0xef, 4539 , 4539 },
	{ 0xf0, 4539 , 4539 },
	{ 0xf1, 4539 , 4539 },
	{ 0xf2, 4539 , 4539 },
	{ 0xf3, 4539 , 4539 },
	{ 0xf4, 4539 , 4539 },
	{ 0xf5, 4539 , 4539 },
	{ 0xf6, 4539 , 4539 },
	{ 0xf7, 4539 , 4539 },
	{ 0xf8, 4539 , 4539 },
	{ 0xf9, 4539 , 4539 },
	{ 0xfa, 4539 , 4539 },
	{ 0xfb, 4539 , 4539 },
	{ 0xfc, 4539 , 4539 },
	{ 0xfd, 4539 , 4539 },
	{ 0xfe, 4539 , 4539 },
	{ 0xff, 4539 , 4539 },

};
