/*
 * Project    : ipv6calc
 * File       : ipv6calc.h[.in]
 * Version    : $Id: ipv6calc.h.in,v 1.6 2002/02/25 22:55:54 peter Exp $
 * Copyright  : 2001-2002 by Peter Bieringer <pb (at) bieringer.de>
 *
 * Information:
 *  Main header file
 */ 


#ifndef _ipv6calc_h_

#define _ipv6calc_h_

/* global program related definitions */
#define PROGRAM_NAME "ipv6calc"
#define PROGRAM_VERSION "0.38"
#define PROGRAM_COPYRIGHT "(P) & (C) 2001-2002 by Peter Bieringer <pb (at) bieringer.de>\n published under GNU GPL"

/* global includes */
#include <netinet/in.h>

/*** global definitions ***/
/* max length of a string for storage in a char array */
#define NI_MAXHOST 1024

/* debug switches */
/* #define DEBUG_addr_to_compressed */
/* #define DEBUG_addr_to_uncompressed */
/* #define DEBUG_addr_to_fulluncompressed */
/* #define DEBUG_ifinet6_to_compressed */

/* debug switches for libaries */
/* #define DEBUG_librfc1924 */
/* #define DEBUG_libipv6calc */
/* #define DEBUG_libmac */
/* #define DEBUG_libeui64 */


/* command values */
#define CMD_MINOR_MASK          0x0000Fl
#define CMD_FORMAT_MASK         0x00FF0l
#define CMD_printhelp           0x00001l
#define CMD_printversion        0x00002l
#define CMD_printlowercase      0x00004l
#define CMD_printuppercase      0x00008l
#define CMD_printprefix         0x00010l
#define CMD_printsuffix         0x00020l
#define CMD_maskprefix        	0x00040l
#define CMD_masksuffix         	0x00080l
#define CMD_printstart     	0x00100l
#define CMD_printend     	0x00200l
#define CMD_showtypes   	0x00400l
#define CMD_machinereadable   	0x00800l

#define CMD_MAJOR_MASK			0xFFFF000l

#define CMD_MAJOR_ADDR_INPUT		0x0FFF000l		
#define CMD_addr_to_ip6int		0x0001000l
#define CMD_addr_to_compressed		0x0002000l
#define CMD_addr_to_uncompressed	0x0004000l
#define CMD_addr_to_fulluncompressed	0x0008000l
#define CMD_addr_to_ifinet6		0x0010000l
#define CMD_addr_to_base85		0x0020000l
#define CMD_addr_to_ip6arpa		0x0040000l
#define CMD_addr_to_bitstring		0x0080000l
#define CMD_showinfo			0x0100000l

#define CMD_base85_to_addr		0x1000000l
#define CMD_mac_to_eui64		0x2000000l
#define CMD_eui64_to_privacy		0x4000000l
#define CMD_ifinet6_to_compressed	0x8000000l



/* debug values */
#define DEBUG_eui64_to_privacy		CMD_eui64_to_privacy
#define DEBUG_showinfo			CMD_showinfo
#define DEBUG_addr_to_ifinet6		CMD_addr_to_ifinet6
#define DEBUG_base85_to_addr		CMD_base85_to_addr
#define DEBUG_addr_to_base85		CMD_addr_to_base85
#define DEBUG_addr_to_ip6int 		CMD_addr_to_ip6int
#define DEBUG_addr_to_bitstring		CMD_addr_to_bitstring
#define DEBUG_mac_to_eui64		CMD_mac_to_eui64 
#define DEBUG_ifinet6_to_compressed	CMD_ifinet6_to_compressed

#define DEBUG_libipv6calc		0x000001l
#define DEBUG_librfc3041		0x000002l
#define DEBUG_librfc1884		0x000004l
#define DEBUG_librfc2874		0x000008l
#define DEBUG_librfc1886		0x000010l

/* structures */
typedef struct {
	unsigned int addr[6];		/* MAC address in 6x 8 bit */
} ipv6calc_macaddr;

typedef struct {
	struct in6_addr in6_addr;	/* in6_addr structure */
	unsigned short prefixlength;	/* prefix length (0-128) 8 bit*/
	int flag_prefixuse;		/* =1 prefix length in use */
	unsigned int scope;		/* address scope value 16 bit*/
	unsigned short bit_start;	/* start of bit */
	unsigned short bit_end;		/* end of bit */
	int flag_startend_use;		/* =1 start or end of bit in use */
} ipv6calc_ipv6addr;

/* global debug value */
extern long int ipv6calc_debug;

#endif
