/*
 * libeui64: Function libary for conversions
 *            defined in EUI-64
 * 
 * Version:		$Id: libeui64.c,v 0.15 2001/03/12 $
 * 
 * Author:		Peter Bieringer <pb@bieringer.de>
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "ipv6calc.h"

/* function MAC address to EUI format
 *
 * in : macaddrp
 * out: ipv6addrp
 * ret: ==0: ok, !=0: error
 */

int create_eui64_from_mac(ipv6calc_ipv6addr *ipv6addrp, ipv6calc_macaddr *macaddrp) {
	int retval = 1, i;

	/* clear IPv6 structure */
	for (i = 0; i <= 7; i++ )  {
		ipv6addrp->addr6[i] = 0;
	};

	/* create EUI-64 from MAC-48 */
	ipv6addrp->addr6[7] = ( macaddrp->addr[4] << 8 ) | macaddrp->addr[5];
	ipv6addrp->addr6[6] = ( 0xfe << 8 ) | macaddrp->addr[3];
	ipv6addrp->addr6[5] = ( macaddrp->addr[2] << 8 ) | 0xff;
	ipv6addrp->addr6[4] = ( ( macaddrp->addr[0] ^ 0x02 ) << 8 ) | macaddrp->addr[1];
	
	ipv6addrp->prefixlength = 64;
	ipv6addrp->flag_prefixuse = 0;
	ipv6addrp->scope = 0;
	
   	retval = 0;	
	return (retval);
};
