/*
 * Version:     $Id: ipv6calc.h,v 0.13 2001/03/10 $
 *
 * Author:      Peter Bieringer <pb@bieringer.de>
 *
 */ 

/* global definitions */
#define PROGRAM_NAME "ipv6calc"
#define PROGRAM_VERSION "0.13"
#define PROGRAM_COPYRIGHT "(P) & (C) 2001 by Peter Bieringer <pb@bieringer.de>\n published under GNU GPL"

/* external functions */
extern int  addr_to_ip6int(char *addrstring, char *resultstring);
extern void addr_to_ip6int_printhelp();
extern void addr_to_ip6int_printhelplong();

extern int  addr_to_compressed(char *addrstring, char *resultstring);
extern void addr_to_compressed_printhelp();
extern void addr_to_compressed_printhelplong();

extern int  addr_to_uncompressed(char *addrstring, char *resultstring, unsigned int formatselector);
extern void addr_to_uncompressed_printhelp();
extern void addr_to_uncompressed_printhelplong();

extern int  addr_to_fulluncompressed(char *addrstring, char *resultstring, unsigned int formatselector);
extern void addr_to_fulluncompressed_printhelp();
extern void addr_to_fulluncompressed_printhelplong();

extern int  addr_to_ifinet6(char *addrstring, char *resultstring);
extern void addr_to_ifinet6_printhelp();
extern void addr_to_ifinet6_printhelplong();

extern int  ifinet6_to_compressed(char *addrstring, char *resultstring);
extern int  ifinet6_to_compressedwithprefixlength(char *addrstring, char *prefixlengthstring, char *resultstring);
extern void ifinet6_to_compressed_printhelp();
extern void ifinet6_to_compressed_printhelplong();

extern int  addr_to_base85(char *addrstring, char *resultstring);
extern void addr_to_base85_printhelp();
extern void addr_to_base85_printhelplong();

extern int  base85_to_addr(char *addrstring, char *resultstring);
extern void base85_to_addr_printhelp();
extern void base85_to_addr_printhelplong();

/* debug switches */
//#define DEBUG_addr_to_ip6int
//#define DEBUG_addr_to_compressed
//#define DEBUG_addr_to_uncompressed
//#define DEBUG_addr_to_fulluncompressed
//#define DEBUG_addr_to_ifinet6
//#define DEBUG_addr_to_ifinet6
//#define DEBUG_ifinet6_to_compressed
//#define DEBUG_addr_to_base85
//#define DEBUG_base85_to_addr

/* debug switches for libaries */
//#define DEBUG_librfc1884
//#define DEBUG_librfc1924
//#define DEBUG_libipv6calc


/* command values */
#define CMD_MINOR_MASK          0x000F
#define CMD_FORMAT_MASK         0x00F0
#define CMD_MAJOR_MASK          0xFF00
#define CMD_printhelp           0x0001
#define CMD_printversion        0x0002
#define CMD_printprefix         0x0010
#define CMD_printsuffix         0x0020
#define CMD_maskprefix          0x0040
#define CMD_masksuffix          0x0080
#define CMD_addr_to_ip6int           0x0100
#define CMD_addr_to_compressed       0x0200
#define CMD_addr_to_uncompressed     0x0400
#define CMD_addr_to_fulluncompressed 0x0800
#define CMD_addr_to_ifinet6          0x1000
#define CMD_ifinet6_to_compressed    0x2000
#define CMD_addr_to_base85           0x4000
#define CMD_base85_to_addr           0x8000

/* structures */
typedef struct {
	unsigned int addr6[8];		/* IPv6 address in 8x 16 bit */
	unsigned int prefixlength;	/* prefix length (0-128) */
	int flag_prefixuse;			/* =1 prefix length in use */
	int scope;					/* address scope value */
} ipv6calc_ipv6addr;

/* libipv6calc */
extern int addr_to_ipv6addrstruct(char *addrstring, char *resultstring, ipv6calc_ipv6addr *ipv6addrp);

extern int ipv6addrstruct_to_uncompaddr(ipv6calc_ipv6addr *ipv6addrp, char *resultstring);

extern int ipv6addrstruct_to_fulluncompaddr(ipv6calc_ipv6addr *ipv6addrp, char *resultstring);

extern void ipv6addrstruct_maskprefix(ipv6calc_ipv6addr *ipv6addrp);
extern void ipv6addrstruct_masksuffix(ipv6calc_ipv6addr *ipv6addrp);


/* librfc1884 */
extern int compaddr_to_uncompaddr(char *addrstring, char *resultstring);
extern int ipv6addrstruct_to_compaddr(ipv6calc_ipv6addr *ipv6addr, char *resultstring);

/* librfc1924 */
extern int ipv6addrstruct_to_base85(ipv6calc_ipv6addr *ipv6addrp, char *resultstring);
extern int base85_to_ipv6addrstruct(char *addrstring, char *resultstring, ipv6calc_ipv6addr *ipv6addrp);
