/* Split away from original by Peter Bieringer <pb@bieringer.de> for ipv6calc
 *  remove byteorder functions
 *
 *
 * Original header:
 */

/* $USAGI: addrconf.c,v 1.13 2001/01/18 18:42:25 yoshfuji Exp $ */

/*
 *	IPv6 Address [auto]configuration
 *	Linux INET6 implementation
 *
 *	Authors:
 *	Pedro Roque		<roque@di.fc.ul.pt>	
 *
 *	$Id: addrconf.c,v 1.48.2.2 1999/12/14 10:32:53 davem Exp $
 *
 *	This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version
 *      2 of the License, or (at your option) any later version.
 */

typedef unsigned int u32;

int ipv6_addr_type(struct in6_addr *addr)
{
	u32 st;

	st = addr->s6_addr32[0];

	/* Consider all addresses with the first three bits different of
	   000 and 111 as unicasts.
	 */
	if ((st & (0xE0000000)) != (0x00000000) &&
	    (st & (0xE0000000)) != (0xE0000000))
		return IPV6_ADDR_UNICAST;

	if ((st & (0xFF000000)) == (0xFF000000)) {
		int type = IPV6_ADDR_MULTICAST;

		switch((st & (0x00FF0000))) {
			case (0x00010000):
				type |= IPV6_ADDR_LOOPBACK;
				break;

			case (0x00020000):
				type |= IPV6_ADDR_LINKLOCAL;
				break;

			case (0x00050000):
				type |= IPV6_ADDR_SITELOCAL;
				break;
		};
		return type;
	}
	
	if ((st & (0xFFC00000)) == (0xFE800000))
		return (IPV6_ADDR_LINKLOCAL | IPV6_ADDR_UNICAST);

	if ((st & (0xFFC00000)) == (0xFEC00000))
		return (IPV6_ADDR_SITELOCAL | IPV6_ADDR_UNICAST);

	if ((addr->s6_addr32[0] | addr->s6_addr32[1]) == 0) {
		if (addr->s6_addr32[2] == 0) {
			if (addr->in6_u.u6_addr32[3] == 0)
				return IPV6_ADDR_ANY;

			if (addr->s6_addr32[3] == (0x00000001))
				return (IPV6_ADDR_LOOPBACK | IPV6_ADDR_UNICAST);

			return (IPV6_ADDR_COMPATv4 | IPV6_ADDR_UNICAST);
		}

		if (addr->s6_addr32[2] == (0x0000ffff))
			return IPV6_ADDR_MAPPED;
	}

	return IPV6_ADDR_RESERVED;
}

