/*
 * addr_to_base85:
 *  A function to format a given IPv6 address to a
 *   base85 one (RFC 1924)
 *
 * Version:		$Id: addr_to_base85.c,v 0.13 2001/03/10 $
 * 
 * Author:		Peter Bieringer <pb@bieringer.de>
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include "ipv6calc.h"

void addr_to_base85_printhelp() {
	fprintf(stderr, " %s --addr_to_base85 ipv6addr[/prefixlength]\n", PROGRAM_NAME);
};

void addr_to_base85_printhelplong() {
	addr_to_base85_printhelp();
	fprintf(stderr, "  Converts given IPv6 address to a base85 one (RFC 1924)\n");
	fprintf(stderr, "   e.g. 1080:0:0:0:8:800:200c:417a -> 4)+k&C#VzJ4br>0wv%%Yp \n");
};

/* function formats an given IPv6 address to a compact one
 *  
 * examples:
 *  3ffe:400:100:f101::1 -> 
 *
 * in : *addrstring = IPv6 address, unsigned int formatselector
 * out: *resultstring = result
 * ret: ==0: ok, !=0: error
 */
int addr_to_base85(char *addrstring, char *resultstring) {
	int retval = 1, result;
	ipv6calc_ipv6addr ipv6addr;

#ifdef DEBUG_addr_to_base85
	fprintf(stderr, "addr_to_base85: Got input %s\n", addrstring);
#endif

	result = addr_to_ipv6addrstruct(addrstring, resultstring, &ipv6addr);
#ifdef DEBUG_addr_to_base85
	fprintf(stderr, "addr_to_base85: result of uncomp2ipv6calc_ipv6addr: %d\n", result);
#endif

	if ( result != 0 ) {
		retval = 1;
		return (retval);
	};

	result = ipv6addrstruct_to_base85(&ipv6addr, resultstring);
   
	retval = 0;
	return (retval);
};
