/*
 * Version:     $Id: ipv6calc.h,v 0.10 2001/03/03 $
 *
 * Author:      Peter Bieringer <pb@bieringer.de>
 *
 */ 

/* global definitions */
#define PROGRAM_NAME "ipv6calc"
#define PROGRAM_VERSION "0.10"
#define PROGRAM_COPYRIGHT "(P) & (C) 2001 by Peter Bieringer <pb@bieringer.de>\n published under GNU GPL"

/* external functions */
extern int addr2compaddr(char *addrstring, char *resultstring);
extern int addr2uncompaddr(char *addrstring, char *resultstring, unsigned int formatselector);
extern int addr2fulluncompaddr(char *addrstring, char *resultstring, unsigned int formatselector);
extern int addr2if_inet6(char *addrstring, char *resultstring);
extern int addr2ip6_int(char *addrstring, char *resultstring);
extern int if_inet62addr(char *addrstring, char *resultstring);
extern int if_inet62addr_withprefixlength(char *addrstring, char *prefixlengthstring, char *resultstring);

extern void printhelp_addr2ip6_int();
extern void printhelplong_addr2ip6_int();
extern void printhelp_addr2compaddr();
extern void printhelplong_addr2compaddr();
extern void printhelp_addr2uncompaddr();
extern void printhelplong_addr2uncompaddr();
extern void printhelp_addr2fulluncompaddr();
extern void printhelplong_addr2fulluncompaddr();
extern void printhelp_addr2if_inet6();
extern void printhelplong_addr2if_inet6();
extern void printhelp_if_inet62addr();
extern void printhelplong_if_inet62addr();


/* debug switches */
//#define DEBUG_addr2fulluncompaddr
//#define DEBUG_addr2uncompaddr
//#define DEBUG_addr2if_inet6
//#define DEBUG_addr2ip6_int
//#define DEBUG_if_inet62addr
//#define DEBUG_libipv6calc


/* command values */
#define CMD_MINOR_MASK          0x000F
#define CMD_FORMAT_MASK         0x00F0
#define CMD_MAJOR_MASK          0xFF00
#define CMD_printhelp           0x0001
#define CMD_printversion        0x0002
#define CMD_printprefix         0x0010
#define CMD_printsuffix         0x0020
#define CMD_maskprefix          0x0040
#define CMD_masksuffix          0x0080
#define CMD_addr2ip6_int        0x0100
#define CMD_addr2compaddr       0x0200
#define CMD_addr2uncompaddr     0x0400
#define CMD_addr2fulluncompaddr 0x0800
#define CMD_addr2if_inet6       0x1000
#define CMD_if_inet62addr       0x2000

/* structures */
typedef struct {
	unsigned int addr6[8];		/* IPv6 address in 8x 16 bit */
	unsigned int prefixlength;	/* prefix length (0-128) */
	int flag_prefixuse;			/* =1 prefix length in use */
	int scope;					/* address scope value */
} ipv6calc_ipv6addr;

/* libary functions */
extern int addr2ipv6calc_ipv6addr(char *addrstring, char *resultstring, ipv6calc_ipv6addr *ipv6addrp);
extern int ipv6calc_ipv6addr2uncompaddr(ipv6calc_ipv6addr *ipv6addrp, char *resultstring);
extern int ipv6calc_ipv6addr2fulluncompaddr(ipv6calc_ipv6addr *ipv6addrp, char *resultstring);
extern int ipv6calc_ipv6addr2compaddr(ipv6calc_ipv6addr *ipv6addr, char *resultstring);
extern void ipv6calc_ipv6addr_maskprefix(ipv6calc_ipv6addr *ipv6addrp);
extern void ipv6calc_ipv6addr_masksuffix(ipv6calc_ipv6addr *ipv6addrp);
extern int compaddr2uncompaddr(char *addrstring, char *resultstring);

                                            
