/*
 * ipv6calc	This program print out different formats of an given IPv6 address
 *
 * Version:     $Id: ipv6calc.c,v 0.10 2001/03/03 $
 * 
 * Author:      Peter Bieringer <pb@bieringer.de>
 * 
 */

#include <stdio.h>
#include <string.h>
#include <netdb.h>
#include <stdlib.h> 
#include <getopt.h> 
#include "ipv6calc.h"

/* display info */
void printversion()  {
	fprintf(stderr, "%s  version: %s\n", PROGRAM_NAME, PROGRAM_VERSION);
}

void printinfo()  {
	printversion();
	fprintf(stderr, "%s\n", PROGRAM_COPYRIGHT);
	fprintf(stderr, "This program formats and calculates IPv6 addresses\n");
	fprintf(stderr, "See '%s -?' for more details\n\n", PROGRAM_NAME);
}

/* display help */
void printhelp() {
	fprintf(stderr, "Usage: (see '%s --command -?' for more help)\n", PROGRAM_NAME);

	printhelp_addr2ip6_int();
	printhelp_addr2compaddr();
	printhelp_addr2uncompaddr();
	printhelp_addr2fulluncompaddr();
	printhelp_addr2if_inet6();
	printhelp_if_inet62addr();

	return;
}

/**************************************************/
/* main */

int main(int argc,char *argv[]) {
	char resultstring[NI_MAXHOST];
	int retval = 1, i, lop;
	unsigned int command = 0;

	/* defined options */
	char *shortopts = "vh?r";

    struct option longopts[] = {
		{"version", 0, 0, 'v'},
		{"help", 0, 0, 'h'},
		{"addr2ip6_int", 0, 0, CMD_addr2ip6_int},
		{"addr2compaddr", 0, 0, CMD_addr2compaddr},
		{"addr2uncompaddr", 0, 0, CMD_addr2uncompaddr},
		{"addr2fulluncompaddr", 0, 0, CMD_addr2fulluncompaddr},
		{"addr2if_inet6", 0, 0, CMD_addr2if_inet6},
		{"if_inet62addr", 0, 0, CMD_if_inet62addr},
		{"printprefix", 0, 0, CMD_printprefix},
		{"printsuffix", 0, 0, CMD_printsuffix},
		{"maskprefix", 0, 0, CMD_maskprefix},
		{"masksuffix", 0, 0, CMD_masksuffix},
		{NULL, 0, 0, 0}
	};                

	if (argc <= 1) {
		printinfo();
		exit(1);
	};

    /* Fetch the command-line arguments. */
    while ((i = getopt_long(argc, argv, shortopts, longopts, &lop)) != EOF) {
		switch (i) {
			case -1:
				break;
			case 'v':
				command |= CMD_printversion;
				break;
			case 'h':
			case '?':
				command |= CMD_printhelp;
				break;
			case 'r':
			case CMD_addr2ip6_int:
				command |= CMD_addr2ip6_int;
				break;
			case CMD_addr2compaddr:
				command |= CMD_addr2compaddr;
				break;
			case CMD_addr2uncompaddr:
				command |= CMD_addr2uncompaddr;
				break;
			case CMD_addr2fulluncompaddr:
				command |= CMD_addr2fulluncompaddr;
				break;
			case CMD_addr2if_inet6:
				command |= CMD_addr2if_inet6;
				break;
			case CMD_if_inet62addr:
				command |= CMD_if_inet62addr;
				break;
			case CMD_printprefix:
				command |= CMD_printprefix;
				break;
			case CMD_printsuffix:
				command |= CMD_printsuffix;
				break;
			case CMD_maskprefix:
				command |= CMD_maskprefix;
				break;
			case CMD_masksuffix:
				command |= CMD_masksuffix;
				break;
			default:
				fprintf(stderr, "Don't understandUsage: (see '%s --command -?' for more help)\n", PROGRAM_NAME);
				printhelp();
				break;
		};
	};
	argv += optind;
	argc -= optind;

/*	fprintf(stderr, "Command value: %x\n", command); */
	
	/* do work depending on selection */
	if (command & CMD_printversion) {
		printversion();
		exit(1);
	}

	if (command & CMD_MAJOR_MASK) {	
		switch (command & CMD_MAJOR_MASK) {
			case CMD_addr2ip6_int:
				if ((argc < 1) || (command & CMD_printhelp)) {
					if ((argc < 1) && ! (command & CMD_printhelp)) {
						fprintf(stderr, "missing argument!\n\n");
					};
					printhelplong_addr2ip6_int();
					exit(1);
				}
				retval = addr2ip6_int(argv[0], resultstring);
				fprintf(stdout, "%s\n", resultstring);
				break;
			case CMD_addr2compaddr:
				if ((argc < 1) || (command & CMD_printhelp)) {
					if ((argc < 1) && ! (command & CMD_printhelp)) {
						fprintf(stderr, "missing argument!\n\n");
					};
					printhelplong_addr2compaddr();
					exit(1);
				}
				retval = addr2compaddr(argv[0], resultstring);
				fprintf(stdout, "%s\n", resultstring);
				break;
			case CMD_addr2uncompaddr:
				if ((argc < 1) || (command & CMD_printhelp)) {
					if ((argc < 1) && ! (command & CMD_printhelp)) {
						fprintf(stderr, "missing argument!\n\n");
					};
					printhelplong_addr2uncompaddr();
					exit(1);
				}
				retval = addr2uncompaddr(argv[0], resultstring, command & CMD_FORMAT_MASK);
				fprintf(stdout, "%s\n", resultstring);
				break;
			case CMD_addr2fulluncompaddr:
				if ((argc < 1) || (command & CMD_printhelp)) {
					if ((argc < 1) && ! (command & CMD_printhelp)) {
						fprintf(stderr, "missing argument!\n\n");
					};
					printhelplong_addr2fulluncompaddr();
					exit(1);
				}
				retval = addr2fulluncompaddr(argv[0], resultstring, command & CMD_FORMAT_MASK);
				fprintf(stdout, "%s\n", resultstring);
				break;
			case CMD_addr2if_inet6:
				if ((argc < 1) || (command & CMD_printhelp)) {
					if ((argc < 1) && ! (command & CMD_printhelp)) {
						fprintf(stderr, "missing argument!\n\n");
					};
					printhelplong_addr2if_inet6();
					exit(1);
				}
				retval = addr2if_inet6(argv[0], resultstring);
				fprintf(stdout, "%s\n", resultstring);
				break;
			case CMD_if_inet62addr:
				if ((argc < 1) || (command & CMD_printhelp)) {
					if ((argc < 1) && ! (command & CMD_printhelp)) {
						fprintf(stderr, "missing argument!\n\n");
					};
					printhelplong_if_inet62addr();
					exit(1);
				}
				if (argc < 2) {
					retval = if_inet62addr(argv[0], resultstring);
				} else {
					/* additional prefixlength conversion */
					retval = if_inet62addr_withprefixlength(argv[0], argv[1], resultstring);
				}	
				fprintf(stdout, "%s\n", resultstring);
				break;
		}; /* end switch */
	} else {
		if (command & CMD_printhelp) {
			printhelp();
		}
	} /* end else */
	
	exit(retval);
};
