/*
 * addr2if_inet6: Function to format a given address to a /proc/net/if_inet6 format
 *
 * Version:		$Id: addr2if_inet6.c,v 0.10 2001/03/03 $
 * 
 * Author:		Peter Bieringer <pb@bieringer.de>
 *
 * some hints taken from ifconfig.c (net-tools)
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include "ipv6calc.h"

void printhelp_addr2if_inet6() {
	fprintf(stderr, " %s --addr2if_inet6 ipv6addr[/prefixlength]\n", PROGRAM_NAME);
};

void printhelplong_addr2if_inet6() {
	printhelp_addr2if_inet6();
	fprintf(stderr, "  Converts given IPv6 address to similar format shown in /proc/net/if_inet6:\n    addr scope [prefixlength]\n");
	fprintf(stderr, "   e.g. 3ffe:400:100:f101::1 -> 3ffe04000100f1010000000000000001 00\n");
	fprintf(stderr, "   e.g. 3ffe:400:100:f101::1/64 -> 3ffe04000100f1010000000000000001 00 40\n\n");
}; 

/* function formats an given IPv6 address to /proc/net/if_inet6 format
 * examples: addr scope [prefixlength]
 *  3ffe:400:100:f101::1 -> 3ffe04000100f1010000000000000001 00
 *  3ffe:400:100:f101::1/64 -> 3ffe04000100f1010000000000000001 00 40
 *
 * in : *addrstring = IPv6 address
 * out: *resultstring = result
 * ret: ==0: ok, !=0: error
 */
int addr2if_inet6(char *addrstring, char *resultstring) {
	int retval = 1, result;
	ipv6calc_ipv6addr ipv6addr; 

#ifdef DEBUG_addr2if_inet6
	fprintf(stderr, "addr2if_inet6: got input: %s\n", addrstring);
#endif

    result = addr2ipv6calc_ipv6addr(addrstring, resultstring, &ipv6addr);
#ifdef DEBUG_addr2uncompaddr
    fprintf(stderr, "addr2if_inet6: result of uncomp2ipv6calc_ipv6addr: %d\n", result);
#endif
   
	if ( result != 0 ) {
		retval = 1;
		return (retval);
	}

	/* print out array */	
	if ( ipv6addr.flag_prefixuse == 1 ) {
	    sprintf(resultstring, "%04x%04x%04x%04x%04x%04x%04x%04x %02x %02x", ipv6addr.addr6[0], ipv6addr.addr6[1],  ipv6addr.addr6[2],  ipv6addr.addr6[3],  ipv6addr.addr6[4],  ipv6addr.addr6[5],  ipv6addr.addr6[6],  ipv6addr.addr6[7],  ipv6addr.scope,  ipv6addr.prefixlength);
	} else {
	    sprintf(resultstring, "%04x%04x%04x%04x%04x%04x%04x%04x %02x",  ipv6addr.addr6[0],  ipv6addr.addr6[1],  ipv6addr.addr6[2],  ipv6addr.addr6[3],  ipv6addr.addr6[4],  ipv6addr.addr6[5],  ipv6addr.addr6[6],  ipv6addr.addr6[7],  ipv6addr.scope);
	}

#ifdef DEBUG_addr2if_inet6
	fprintf(stderr, "addr2if_inet6: Print out: %s\n", resultstring);
#endif

	retval = 0;
	return (retval);
}

