/*
 * addr2fulluncompaddr: Support a function to format a given address to a
 *                       full uncompressed one
 *                      (anti RFC 1884)
 *
 * Version:		$Id: addr2fulluncompaddr.c,v 0.10 2001/03/03 $
 * 
 * Author:		Peter Bieringer <pb@bieringer.de>
 *
 * some hints taken from ifconfig.c (net-tools)
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include "ipv6calc.h"

void printhelp_addr2fulluncompaddr() {
	fprintf(stderr, " %s --addr2fulluncompaddr [--maskprefix|--masksuffix] ipv6addr[/prefixlength]\n", PROGRAM_NAME);
};

void printhelplong_addr2fulluncompaddr() {
	printhelp_addr2fulluncompaddr();
	fprintf(stderr, "  Converts given IPv6 address to a full uncompressed one\n");
	fprintf(stderr, "   e.g. 3ffe:400:100:f101::1 -> 3ffe:0400:0100:f101:0000:0000:0000:0001\n\n");
};

/* function formats an given IPv6 address to a full uncompressed format
 * examples:
 *  3ffe:400:100:f101::1 -> 3ffe:0400:0100:f101:0000:0000:0000:0001
 *
 * in : *addrstring = IPv6 address, unsigned int formatselector
 * out: *resultstring = result
 * ret: ==0: ok, !=0: error
 */
int addr2fulluncompaddr(char *addrstring, char *resultstring, unsigned int formatselector) {
	int retval = 1, result;
	ipv6calc_ipv6addr ipv6addr;

#ifdef DEBUG_addr2fulluncompaddr
	fprintf(stderr, "addr2fulluncompaddr: Got input %s\n", addrstring);
#endif

	result = addr2ipv6calc_ipv6addr(addrstring, resultstring, &ipv6addr);
#ifdef DEBUG_addr2fulluncompaddr
	fprintf(stderr, "addr2fulluncompaddr: result of uncomp2ipv6calc_ipv6addr: %d\n", result);
#endif

	if ( result != 0 ) {
		retval = 1;
		return (retval);
	}  

	if (formatselector & CMD_maskprefix) {
		ipv6calc_ipv6addr_maskprefix(&ipv6addr);
	} else if (formatselector & CMD_masksuffix) {
		ipv6calc_ipv6addr_masksuffix(&ipv6addr);
	}
	result = ipv6calc_ipv6addr2fulluncompaddr(&ipv6addr, resultstring);
   
	retval = 0;
	return (retval);
}
