/*
 * addr2comp:	Support a function to format a given address to the compressed one
 *               (RFC 1884)
 * Version:		$Id: addr2comp.c,v 0.10 2001/03/03 $
 * 
 * Author:		Peter Bieringer <pb@bieringer.de>
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include "ipv6calc.h"

void printhelp_addr2compaddr() {
	fprintf(stderr, " %s --addr2compaddr ipv6addr[/prefixlength]\n", PROGRAM_NAME);
};                                                                                     
void printhelplong_addr2compaddr() {
	printhelp_addr2compaddr();
	fprintf(stderr, "  Converts given IPv6 address to a compressed one\n");
	fprintf(stderr, "   e.g. 3ffe:0400:0100:f101:0000:0000:0000:0001 -> 3ffe:400:100:f101::1\n\n");
};                                                                                     
/* function IPv6addr to compressed format
 * examples:
 *
 * in : *addrstring = IPv6 address
 * out: *resultstring = result
 * ret: ==0: ok, !=0: error
 */
int addr2compaddr(char *addrstring, char *resultstring) {
	int retval = 1, result;
	ipv6calc_ipv6addr ipv6addr;

	result = addr2ipv6calc_ipv6addr(addrstring, resultstring, &ipv6addr);
#ifdef DEBUG_addr2uncompaddr
	fprintf(stderr, "addr2uncompaddr: result of uncomp2ipv6calc_ipv6addr: %d\n", result);
#endif
		 
	if ( result != 0 ) {
		retval = 1;
		return (retval);
	};

	result = ipv6calc_ipv6addr2compaddr(&ipv6addr, resultstring); 
	retval = 0;
	return (retval);
}

