/*
 * addr2comp:	Support a function to format a given address to the compressed one
 *               (RFC 1884)
 * Version:		$Id: addr2comp.c,v 0.05 2001/02/27 $
 * 
 * Author:		Peter Bieringer <pb@bieringer.de>
 *
 * based on "host-all.c" by Arkadiusz Mikiewicz <misiek@pld.org.pl>
 *  http://www.t17.ds.pwr.wroc.pl/~misiek/ipv6/Utils/host-all.c.gz
 * some hints taken from ifconfig.c (net-tools)
 * 
 * Credits to:
 *	Arkadiusz Miskiewicz <misiek@pld.ORG.PL>
 *	 for the original starting point and also for his hints
 *
 *	Jun-ichiro itojun Hagino <itojun@iijlab.net>
 *   for similar hints
 *
 *  Horacio J. Pea <horape@compendium.com.ar>
 *     for similar hints
 *
 *	net-tools authors
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <string.h>
#include <stdlib.h>
#include "ipv6calc.h"

void printhelp_addr2compaddr() {
	fprintf(stderr, " %s --addr2compaddr ipv6addr[/prefixlength]\n", PROGRAM_NAME);
	fprintf(stderr, "  Converts given IPv6 address to a compressed one\n");
	fprintf(stderr, "   e.g. 3ffe:0400:0100:f101:0000:0000:0000:0001 -> 3ffe:400:100:f101::1\n\n");
};                                                                                     

/* function IPv6addr to compressed format
 * examples:
 *
 * in : *addrstring = IPv6 address
 * out: *resultstring = result
 * ret: ==0: ok, !=0: error
 */
int addr2compaddr(char *addrstring, char *resultstring) {
	struct addrinfo hints, *aitop;
	int gaierr, prefixlength = 0, flag_prefixlength = 0;
	char addrip[NI_MAXHOST], *addronlystring, *tmpstr;
	int retval = 1;

	/* save prefix length first, if available */
	addronlystring = strtok (addrstring, "/");
	tmpstr = strtok (NULL, "/");
	if ( tmpstr != NULL ) {
		prefixlength = atol(tmpstr);
		if (prefixlength < 0 || prefixlength > 128 ) {
			sprintf(resultstring, "%s", "illegal prefix length");
			retval = 1;
			return (retval);
		}
		flag_prefixlength = 1;
	}
	

	memset(&hints, 0, sizeof(hints));
	hints.ai_family = AF_INET6;
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_flags = AI_NUMERICHOST;

	gaierr = getaddrinfo(addronlystring, NULL, &hints, &aitop);

	if (gaierr) {
		sprintf(resultstring, "%s: %s", addrstring, gai_strerror(gaierr));
		retval = 1;
		return (retval);
	}
   
	if (getnameinfo(aitop->ai_addr, aitop->ai_addrlen, addrip, sizeof(addrip), NULL, 0, NI_NUMERICHOST)) {
		sprintf(resultstring, "%s", "unknown");
		retval = 1;
	} else {
		if ( flag_prefixlength == 1 ) {
			sprintf(resultstring, "%s/%d", addrip, prefixlength);
		} else {
			sprintf(resultstring, "%s", addrip);
		}
		retval = 0;
	}

	freeaddrinfo(aitop);
	return (retval);
}

