/*
 * ipv6calc	This program print out different formats of an given IPv6 address
 *
 * Version:     $Id: ipv6calc.c,v 0.06 2001/02/27 $
 * 
 * Author:      Peter Bieringer <pb@bieringer.de>
 * 
 */

#include <stdio.h>
#include <string.h>
#include <netdb.h>
#include <stdlib.h> 
#include "ipv6calc.h"

/* display info */
void printversion()  {
	fprintf(stderr, "%s  version: %s\n", PROGRAM_NAME, PROGRAM_VERSION);
}

void printinfo()  {
	printversion();
	fprintf(stderr, "%s\n", PROGRAM_COPYRIGHT);
	fprintf(stderr, "This program formats and calculates IPv6 addresses\n");
	fprintf(stderr, "See '%s -?' for more details\n\n", PROGRAM_NAME);
}

/* display help */
void printhelp() {
	fprintf(stderr, "Usage:\n\n");

	printhelp_addr2ip6_int();
	printhelp_addr2compaddr();
	printhelp_addr2uncompaddr();
	printhelp_addr2fulluncompaddr();
	printhelp_addr2if_inet6();
	printhelp_if_inet62addr();

	return;
}

/**************************************************/
/* main */

int main(int argc,char *argv[]) {
	char resultstring[NI_MAXHOST];
	int retval = 1;


	if (argc <= 1) {
		printinfo();
		exit(1);
	}

	/* do work depending on selection */
	if ( !strcmp(argv[1], "--help") || !strcmp(argv[1], "-h") || !strcmp(argv[1], "-?")) {
		printhelp();
		exit(1);
	} else if ( !strcmp(argv[1], "--version")  || !strcmp(argv[1], "-v")  ) {
		printversion();
		exit(1);

	} else if ( !strcmp(argv[1], "--addr2ip6_int") ) {
		if (argc <= 2) {
			fprintf(stderr, "missing argument!\n\n");
			printhelp_addr2ip6_int();
			exit(1);
		}
		retval = addr2ip6_int(argv[2], resultstring);
		fprintf(stdout, "%s\n", resultstring);
		
	} else if ( !strcmp(argv[1], "--addr2compaddr")	) {
		if (argc <= 2) {
			fprintf(stderr, "missing argument!\n\n");
			printhelp_addr2compaddr();
			exit(1);
		}
		retval = addr2compaddr(argv[2], resultstring);
		fprintf(stdout, "%s\n", resultstring);
		
	} else if ( !strcmp(argv[1], "--addr2uncompaddr")	) {
		if (argc <= 2) {
			fprintf(stderr, "missing argument!\n");
			printhelp_addr2uncompaddr();
			exit(1);
		}
		retval = addr2uncompaddr(argv[2], resultstring);
		fprintf(stdout, "%s\n", resultstring);
		
	} else if ( !strcmp(argv[1], "--addr2fulluncompaddr")	) {
		if (argc <= 2) {
			fprintf(stderr, "missing argument!\n\n");
			printhelp_addr2fulluncompaddr();
			exit(1);
		}
		retval = addr2fulluncompaddr(argv[2], resultstring);
		fprintf(stdout, "%s\n", resultstring);
		
	} else if ( !strcmp(argv[1], "--addr2if_inet6") ) {
		if (argc <= 2) {
			fprintf(stderr, "missing argument!\n\n");
			printhelp_addr2if_inet6();
			exit(1);
		}
		retval = addr2if_inet6(argv[2], resultstring);
		fprintf(stdout, "%s\n", resultstring);
		
	} else if ( !strcmp(argv[1], "--if_inet62addr") ) {
		if (argc <= 2) {
			fprintf(stderr, "missing argument!\n\n");
			printhelp_if_inet62addr();
			exit(1);
		}
		if (argc <= 3) {
			retval = if_inet62addr(argv[2], resultstring);
		} else {
			/* additional prefixlength conversion */
			retval = if_inet62addr_withprefixlength(argv[2], argv[3], resultstring);
		}
		fprintf(stdout, "%s\n", resultstring);
		
	} else {
		fprintf(stderr, "unknown selection: %s\n\n", argv[1]);
		printhelp();
		exit(1);
	}

	exit(retval);
}
