/*
   ipv6calc  This file contains an implementation of the command
                    that shorten an IPv6 address
 
   Version:     $Id: ipv6addrshorter.c,v 0.01 2001/02/25 $
 
   Author:      Peter Bieringer <pb@bieringer.de>

 
	based on "host-all.c" by Arkadiusz Mikiewicz <misiek@pld.org.pl>
	 http://www.t17.ds.pwr.wroc.pl/~misiek/ipv6/Utils/host-all.c.gz
	some hints taken from ifconfig.c (net-tools)
   
   Credits to:
     Arkadiusz Miskiewicz <misiek@pld.ORG.PL>
      for the original starting point and also for his hints
  
     Jun-ichiro itojun Hagino <itojun@iijlab.net>
      for similar hints

     Horacio J. Pea <horape@compendium.com.ar>
      for similar hints

	net-tools authors
 */


#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <string.h>
#include <stdlib.h>

#define PROGRAM_NAME "ipv6calc"
#define PROGRAM_VERSION "0.02"

/* display help */
void help() {
	fprintf(stderr, "%s  version: %s\n", PROGRAM_NAME, PROGRAM_VERSION);
	fprintf(stderr, "\nUsage:\n");
	fprintf(stderr, "\n %s --addr2ip6_int  ipv6addr[/prefixlength]\n", PROGRAM_NAME);
	fprintf(stderr, "  Converts given IPv6 address to a dot separated reverse nibble format\n");
	fprintf(stderr, "\n %s --addr2compaddr ipv6addr[/prefixlength]\n", PROGRAM_NAME);
	fprintf(stderr, "  Converts given IPv6 address to a compressed one\n");
	fprintf(stderr, "   e.g. 3ffe:0400:0100:f101:0000:0000:0000:0001 -> 3ffe:400:100:f101::1\n");
	fprintf(stderr, "\n %s --addr2if_inet6 ipv6addr[/prefixlength]\n", PROGRAM_NAME);
	fprintf(stderr, "  Converts given IPv6 address to the format shown in /proc/net/if_inet6\n");

	fprintf(stderr, "\n");

	return;
}

/* function IPv6addr to reverse nibble format for ip6.int */
/* examples:
 *
 *
 */
int addr2ip6_int(char *addrstring) {
	int retval = 1;
	return (retval);
}


/* function IPv6addr to compressed format
 * examples:
 *
 * in : *addrstring = IPv6 address
 * out: *resultstring = result
 * ret: ==0: ok, !=0: error
 */
int addr2compaddr(char *addrstring, char *resultstring) {
	struct addrinfo hints, *aitop;
	int gaierr, prefixlength = 0, flag_prefixlength = 0;
	char addrip[NI_MAXHOST], *addronly, *tmpstr;
	int retval = 1;

	/* save prefix length first, if available */
	addronly = strtok (addrstring, "/");
	tmpstr = strtok (NULL, "/");
	if ( tmpstr != NULL ) {
		prefixlength = atol(tmpstr);
		if (prefixlength < 0 || prefixlength > 128 ) {
			sprintf(resultstring, "%s", "illegal prefix length");
			retval = 1;
			return (retval);
		}
		flag_prefixlength = 1;
	}
	

	memset(&hints, 0, sizeof(hints));
	hints.ai_family = AF_INET6;
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_flags = AI_NUMERICHOST;

	gaierr = getaddrinfo(addronly, NULL, &hints, &aitop);

	if (gaierr) {
		sprintf(resultstring, "%s: %s", addrstring, gai_strerror(gaierr));
		retval = 1;
		return (retval);
	}
   
	if (getnameinfo(aitop->ai_addr, aitop->ai_addrlen, addrip, sizeof(addrip), NULL, 0, NI_NUMERICHOST)) {
		sprintf(resultstring, "%s", "unknown");
		retval = 1;
	} else {
		if ( flag_prefixlength == 1 ) {
			sprintf(resultstring, "%s/%d", addrip, prefixlength);
		} else {
			sprintf(resultstring, "%s", addrip);
		}
		retval = 0;
	}

	freeaddrinfo(aitop);
	return (retval);
}


/* function IPv6addr to format of /proc/net/if_inet6 */
/* examples:
 *
 */
int addr2if_inet6() {
	int retval = 1;
	return (retval);
}



/**************************************************/
/* main */

int main(int argc,char *argv[]) {
	char resultstring[NI_MAXHOST];
	int retval = 1;


	if (argc <= 1) {
		fprintf(stderr, "missing selection!\n\n");
		help();
		exit(1);
	}

	/* do work depending on selection */
	if ( !strcmp(argv[1], "--help") || !strcmp(argv[1], "-h") ) {
		help();
		exit(1);
	} else if ( !strcmp(argv[1], "--addr2ip6_int") ) {
		if (argc <= 2) {
			fprintf(stderr, "missing argument!\n\n");
			help();
			exit(1);
		}

	} else if ( !strcmp(argv[1], "--addr2compaddr")	) {
		if (argc <= 2) {
			fprintf(stderr, "missing argument!\n\n");
			help();
			exit(1);
		}
		retval = addr2compaddr(argv[2], resultstring);
		fprintf(stdout, "%s\n", resultstring);
	} else if ( !strcmp(argv[1], "--addr2if_inet6") ) {
		if (argc <= 2) {
			fprintf(stderr, "missing argument!\n\n");
			help();
			exit(1);
		}
	} else {
		fprintf(stderr, "unknown selection: %s\n\n", argv[1]);
		help();
		exit(1);
	}

	exit(retval);
}
