#!/usr/bin/perl
#
# Strips away various tagged lines
#
# (P) & (C) 2002 by Peter Bieringer <pb@bieringer.de>
#
# Version: 2002-01-20
#
# Changes:
#  20020120: initial rewrite from the old bash program

my $TAG_REMOVE_DEBUG = '#@-DEB@#';
my $TAG_REMOVE_RH7 = '#@-RH7@#';
my $TAG_REMOVE_RH7_START = '#@-RH7@start#';
my $TAG_REMOVE_RH7_END = '#@-RH7@end#';
my $TAG_INSERT_RH7 = '#@\+RH7@#';
my $TAG_REMOVE_INFO = '#@-INF@#';

# Strip functions
sub stripfunction ($*) {
	my $file = shift;
	my $flag_rh7 = 0;
	my $skip_rh7 = 0;
	my $strip_debug = 0;
	my $strip_info = 0;

	my $tokens = shift;
	foreach my $o (split / /, $tokens) {
		print STDERR "Got option: $o\n";
		if (! defined $o) { last; };
		
		if ($o eq "rh7") {
			print STDERR "Hit rh7\n";
			$flag_rh7 = 1;
		};
		if ($o eq "debug") {
			print STDERR "Hit debug\n";
			$strip_debug = 1;
		};
		if ($o eq "info") {
			print STDERR "Hit info\n";
			$strip_info = 1;
		};

	};

	#print STDERR "INFO : File '$file' has lines: `wc -l $file | awk '{ print $1 }'`\n";

	open (FILE, "$file") || die "Cannot open file";

	my $line;
	while (<FILE>) {
		$line = $_;
		if ($strip_debug == 1) {	
			if ($line =~ /$TAG_REMOVE_DEBUG/) {
				next;
			};
		};
		if ($flag_rh7) {	
			if ($line =~ /$TAG_REMOVE_RH7/) {
				next;
			};
			if ($line =~ /$TAG_INSERT_RH7/) {
				#print STDERR "Hit RH insert\n";
				$line =~ s/$TAG_INSERT_RH7//g;
			};
			if ($line =~ /$TAG_REMOVE_RH7_START/) {
				$skip_rh7 = 1;
				next;
			};
			if ($line =~ /$TAG_REMOVE_RH7_END/) {
				$skip_rh7 = 0;
				next;
			};
			if ($skip_rh7) {
				next;
			};
		};
		if ($strip_info) {	
			if ($line =~ /$TAG_REMOVE_INFO/) {
				next;
			};
		};
		print $line;
	};
};


sub help() {
	print qq|
This simple tool strips away lines with special tags or remove only tags

Usage ./striptool4ipv6scripts filename tag1 [tag2 [tag3 ...] ]

I.e. for RH7/rawhide you can use
  ./striptool4ipv6scripts filename rh7 info debug >filename.stripped
 This will do
  * remove all lines with given "-rh7" tag
  * remove only tag with given "+rh7" tag
  * remove all lines with given "-info" tag
  * remove all lines with given "-debug" tag

 Currently supported tags:
  rh7 info debug
|;
};


# Main
print STDERR "Options: " . @ARGV . "\n";

my $file = $ARGV[0];
my $options;

if (defined $file) {
	my $i = 1;
	while (1) {
		if (defined $ARGV[$i]) {
			$options .= " " . $ARGV[$i];
		} else {
			last;
		};
		$i++;
	};
};
print STDERR "Options: " . $options . "\n";

if (! defined $file) {
	print "Missing filename}\n";
	help;
	exit 1;
};

if (! defined @ARGV) {
	print "Missing strip options\n";
	help;
	exit 1;
};

stripfunction $file, $options;

