/*
 *  Application interface library for the ALSA driver
 *  Copyright (c) by Jaroslav Kysela <perex@jcu.cz>
 *
 *
 *   This library is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as
 *   published by the Free Software Foundation; either version 2 of
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __ASOUNDLIB_H
#define __ASOUNDLIB_H

#include <linux/asound.h>
#include <linux/asequencer.h>
#include <unistd.h>
#include <fcntl.h>

/*
 *  version.h
 */

#define SND_LIB_MAJOR		0
#define SND_LIB_MINOR		3
#define SND_LIB_SUBMINOR	0a
#define SND_LIB_VERSION		((SND_LIB_MAJOR<<16)|\
				 (SND_LIB_MINOR<<8)|\
				  SND_LIB_SUBMINOR)
#define SND_LIB_VERSION_STR	"0.3.0pre3a"

/* OBSOLETE DEFINES WHICH WILLN'T BE IN 0.3.0 FINAL!!! */
#define SOUNDLIB_VERSION_MAJOR		SND_LIB_MAJOR
#define SOUNDLIB_VERSION_MINOR		SND_LIB_MINOR
#define SOUNDLIB_VERSION_SUBMINOR	SND_LIB_SUBMINOR

/*
 *  error.h
 */

#define SND_ERROR_BEGIN				500000
#define SND_ERROR_UNCOMPATIBLE_VERSION		(SND_ERROR_BEGIN+0)

#ifdef __cplusplus
extern "C" {
#endif

const char *snd_strerror( int errnum );

#ifdef __cplusplus
}
#endif

/****************************************************************************
 *                                                                          *
 *                              control.h                                   *
 *                          Control Interface                               *
 *                                                                          *
 ****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

int snd_card_load(int card);
int snd_cards(void);
unsigned int snd_cards_mask(void);
int snd_card_name(const char *name);

int snd_ctl_open(void **handle, int card);
int snd_ctl_close(void *handle);
int snd_ctl_file_descriptor(void *handle);
int snd_ctl_hw_info(void *handle, struct snd_ctl_hw_info *info);
int snd_ctl_switches(void *handle);
int snd_ctl_switch(void *handle, const char *switch_id);
int snd_ctl_switch_read(void *handle, int switchn, snd_ctl_switch_t * data);
int snd_ctl_switch_write(void *handle, int switchn, snd_ctl_switch_t * data);
int snd_ctl_pcm_info(void *handle, int dev, snd_pcm_info_t * info);
int snd_ctl_pcm_playback_info(void *handle, int dev, snd_pcm_playback_info_t * info);
int snd_ctl_pcm_record_info(void *handle, int dev, snd_pcm_record_info_t * info);
int snd_ctl_pcm_playback_switches(void *handle, int dev);
int snd_ctl_pcm_playback_switch(void *handle, int dev, const char *switch_id);
int snd_ctl_pcm_playback_switch_read(void *handle, int dev, int switchn, snd_pcm_switch_t * data);
int snd_ctl_pcm_playback_switch_write(void *handle, int dev, int switchn, snd_pcm_switch_t * data);
int snd_ctl_pcm_record_switches(void *handle, int dev);
int snd_ctl_pcm_record_switch(void *handle, int dev, const char *switch_id);
int snd_ctl_pcm_record_switch_read(void *handle, int dev, int switchn, snd_pcm_switch_t * data);
int snd_ctl_pcm_record_switch_write(void *handle, int dev, int switchn, snd_pcm_switch_t * data);
int snd_ctl_mixer_info(void *handle, int dev, snd_mixer_info_t * info);
int snd_ctl_mixer_switches(void *handle, int dev);
int snd_ctl_mixer_switch(void *handle, int dev, const char *switch_id);
int snd_ctl_mixer_switch_read(void *handle, int dev, int switchn, snd_mixer_switch_t * data);
int snd_ctl_mixer_switch_write(void *handle, int dev, int switchn, snd_mixer_switch_t * data);
int snd_ctl_rawmidi_info(void *handle, int dev, snd_rawmidi_info_t * info);
int snd_ctl_rawmidi_output_info(void *handle, int dev, snd_rawmidi_output_info_t * info);
int snd_ctl_rawmidi_input_info(void *handle, int dev, snd_rawmidi_input_info_t * info);
int snd_ctl_rawmidi_output_switches(void *handle, int dev);
int snd_ctl_rawmidi_output_switch(void *handle, int dev, const char *switch_id);
int snd_ctl_rawmidi_output_switch_read(void *handle, int dev, int switchn, snd_rawmidi_switch_t * data);
int snd_ctl_rawmidi_output_switch_write(void *handle, int dev, int switchn, snd_rawmidi_switch_t * data);
int snd_ctl_rawmidi_input_switches(void *handle, int dev);
int snd_ctl_rawmidi_input_switch(void *handle, int dev, const char *switch_id);
int snd_ctl_rawmidi_input_switch_read(void *handle, int dev, int switchn, snd_rawmidi_switch_t * data);
int snd_ctl_rawmidi_input_switch_write(void *handle, int dev, int switchn, snd_rawmidi_switch_t * data);

#ifdef __cplusplus
}
#endif

/****************************************************************************
 *                                                                          *
 *                               mixer.h                                    *
 *                           Mixer Interface                                *
 *                                                                          *
 ****************************************************************************/

typedef struct snd_mixer_callbacks {
	void *private_data;	/* should be used by application */
	void (*channel_was_changed) (void *private_data, int channel);
	void (*switch_was_changed) (void *private_data, int switchn);
	void *reserved[14];	/* reserved for future use - must be NULL!!! */
} snd_mixer_callbacks_t;

#ifdef __cplusplus
extern "C" {
#endif

int snd_mixer_open(void **handle, int card, int device);
int snd_mixer_close(void *handle);
int snd_mixer_file_descriptor(void *handle);
int snd_mixer_channels(void *handle);
int snd_mixer_info(void *handle, snd_mixer_info_t * info);
int snd_mixer_exact_mode(void *handle, int enable);
int snd_mixer_channel(void *handle, const char *channel_id);
int snd_mixer_channel_info(void *handle, int channel, snd_mixer_channel_info_t * info);
int snd_mixer_channel_read(void *handle, int channel, snd_mixer_channel_t * data);
int snd_mixer_channel_write(void *handle, int channel, snd_mixer_channel_t * data);
int snd_mixer_channel_record_read(void *handle, int channel, snd_mixer_channel_t * data);
int snd_mixer_channel_record_write(void *handle, int channel, snd_mixer_channel_t * data);
int snd_mixer_switches(void *handle);
int snd_mixer_switch_read(void *handle, int switchn, snd_mixer_switch_t * data);
int snd_mixer_switch_write(void *handle, int switchn, snd_mixer_switch_t * data);
int snd_mixer_read(void *handle, snd_mixer_callbacks_t * callbacks);

#ifdef __cplusplus
}
#endif

/****************************************************************************
 *                                                                          *
 *                                pcm.h                                     *
 *                        Digital Audio Interface                           *
 *                                                                          *
 ****************************************************************************/

#define SND_PCM_OPEN_PLAYBACK	(O_WRONLY)
#define SND_PCM_OPEN_RECORD	(O_RDONLY)
#define SND_PCM_OPEN_DUPLEX	(O_RDWR)

#ifdef __cplusplus
extern "C" {
#endif

int snd_pcm_open(void **handle, int card, int device, int mode);
int snd_pcm_close(void *handle);
int snd_pcm_file_descriptor(void *handle);
int snd_pcm_block_mode(void *handle, int enable);
int snd_pcm_info(void *handle, snd_pcm_info_t * info);
int snd_pcm_playback_info(void *handle, snd_pcm_playback_info_t * info);
int snd_pcm_record_info(void *handle, snd_pcm_record_info_t * info);
int snd_pcm_playback_switches(void *handle);
int snd_pcm_playback_switch(void *handle, const char *switch_id);
int snd_pcm_playback_switch_read(void *handle, int switchn, snd_pcm_switch_t * data);
int snd_pcm_playback_switch_write(void *handle, int switchn, snd_pcm_switch_t * data);
int snd_pcm_record_switches(void *handle);
int snd_pcm_record_switch(void *handle, const char *switch_id);
int snd_pcm_record_switch_read(void *handle, int switchn, snd_pcm_switch_t * data);
int snd_pcm_record_switch_write(void *handle, int switchn, snd_pcm_switch_t * data);
int snd_pcm_playback_format(void *handle, snd_pcm_format_t * format);
int snd_pcm_record_format(void *handle, snd_pcm_format_t * format);
int snd_pcm_playback_params(void *handle, snd_pcm_playback_params_t * params);
int snd_pcm_record_params(void *handle, snd_pcm_record_params_t * params);
int snd_pcm_playback_status(void *handle, snd_pcm_playback_status_t * status);
int snd_pcm_record_status(void *handle, snd_pcm_record_status_t * status);
int snd_pcm_drain_playback(void *handle);
int snd_pcm_flush_playback(void *handle);
int snd_pcm_flush_record(void *handle);
int snd_pcm_playback_pause(void *handle, int enable);
int snd_pcm_playback_time(void *handle, int enable);
int snd_pcm_record_time(void *handle, int enable);
ssize_t snd_pcm_write(void *handle, const void *buffer, size_t size);
ssize_t snd_pcm_read(void *handle, void *buffer, size_t size);

#ifdef __cplusplus
}
#endif

#define SND_PCM_LB_OPEN_PLAYBACK	0
#define SND_PCM_LB_OPEN_RECORD		1

#ifdef __cplusplus
extern "C" {
#endif

int snd_pcm_loopback_open(void **handle, int card, int device, int mode);
int snd_pcm_loopback_close(void *handle);
int snd_pcm_loopback_file_descriptor(void *handle);
int snd_pcm_loopback_block_mode(void *handle, int enable);
int snd_pcm_loopback_stream_mode(void *handle, int mode);
int snd_pcm_loopback_format(void *handle, snd_pcm_format_t * format);
ssize_t snd_pcm_loopback_read(void *handle, void *buffer, size_t size);

#ifdef __cplusplus
}
#endif

/****************************************************************************
 *                                                                          *
 *                              rawmidi.h                                   *
 *                          RawMIDI interface                               *
 *                                                                          *
 ****************************************************************************/

#define SND_RAWMIDI_OPEN_OUTPUT		(O_WRONLY)
#define SND_RAWMIDI_OPEN_INPUT		(O_RDONLY)
#define SND_RAWMIDI_OPEN_DUPLEX		(O_RDWR)

#ifdef __cplusplus
extern "C" {
#endif

int snd_rawmidi_open(void **handle, int card, int device, int mode);
int snd_rawmidi_close(void *handle);
int snd_rawmidi_file_descriptor(void *handle);
int snd_rawmidi_block_mode(void *handle, int enable);
int snd_rawmidi_info(void *handle, snd_rawmidi_info_t * info);
int snd_rawmidi_output_switches(void *handle);
int snd_rawmidi_output_switch(void *handle, const char *switch_id);
int snd_rawmidi_output_switch_read(void *handle, int switchn, snd_rawmidi_switch_t * data);
int snd_rawmidi_output_switch_write(void *handle, int switchn, snd_rawmidi_switch_t * data);
int snd_rawmidi_input_switches(void *handle);
int snd_rawmidi_input_switch(void *handle, const char *switch_id);
int snd_rawmidi_input_switch_read(void *handle, int switchn, snd_rawmidi_switch_t * data);
int snd_rawmidi_input_switch_write(void *handle, int switchn, snd_rawmidi_switch_t * data);
int snd_rawmidi_output_params(void *handle, snd_rawmidi_output_params_t * params);
int snd_rawmidi_input_params(void *handle, snd_rawmidi_input_params_t * params);
int snd_rawmidi_output_status(void *handle, snd_rawmidi_output_status_t * status);
int snd_rawmidi_input_status(void *handle, snd_rawmidi_input_status_t * status);
int snd_rawmidi_drain_output(void *handle);
int snd_rawmidi_flush_output(void *handle);
int snd_rawmidi_flush_input(void *handle);
ssize_t snd_rawmidi_write(void *handle, const void *buffer, size_t size);
ssize_t snd_rawmidi_read(void *handle, void *buffer, size_t size);

#ifdef __cplusplus
}
#endif

/****************************************************************************
 *                                                                          *
 *                                seq.h                                     *
 *                              Sequencer                                   *
 *                                                                          *
 ****************************************************************************/

#define SND_SEQ_OPEN_OUT	(O_WRONLY)
#define SND_SEQ_OPEN_IN		(O_RDONLY)
#define SND_SEQ_OPEN		(O_RDWR)

#ifdef __cplusplus
extern "C" {
#endif

int snd_seq_open(void **handle, int mode);
int snd_seq_close(void *handle);
int snd_seq_file_descriptor(void *handle);
int snd_seq_block_mode(void *handle, int enable);
int snd_seq_client_id(void *handle);
int snd_seq_system_info(void *handle, snd_seq_system_info_t *info);
int snd_seq_get_client_info(void *handle, snd_seq_client_info_t *info);
int snd_seq_get_any_client_info(void *handle, int client, snd_seq_client_info_t *info);
int snd_seq_set_client_info(void *handle, snd_seq_client_info_t *info);
int snd_seq_create_port(void *handle, snd_seq_port_info_t *info);
int snd_seq_delete_port(void *handle, snd_seq_port_info_t *info);
int snd_seq_get_port_info(void *handle, int port, snd_seq_port_info_t *info);
int snd_seq_get_any_port_info(void *handle, int client, int port, snd_seq_port_info_t *info);
int snd_seq_set_port_info(void *handle, int port, snd_seq_port_info_t *info);
int snd_seq_subscribe_port(void *handle, snd_seq_port_subscribe_t *sub);
int snd_seq_unsubscribe_port(void *handle, snd_seq_port_subscribe_t *sub);
int snd_seq_get_queue_info(void *handle, int q, snd_seq_queue_info_t *queue);
int snd_seq_set_queue_info(void *handle, int q, snd_seq_queue_info_t *queue);
int snd_seq_get_queue_client(void *handle, int q, snd_seq_queue_client_t *queue);
int snd_seq_set_queue_client(void *handle, int q, snd_seq_queue_client_t *queue);
int snd_seq_alloc_queue(void *handle, snd_seq_queue_info_t *queue);
int snd_seq_free_queue(void *handle, int q);
/* event routines */
snd_seq_event_t *snd_seq_create_event(void);
int snd_seq_free_event(snd_seq_event_t *ev);
int snd_seq_event_length(snd_seq_event_t *ev);
int snd_seq_event_output(void *handle, snd_seq_event_t *ev);
int snd_seq_event_input(void *handle, snd_seq_event_t **ev);
int snd_seq_flush_output(void *handle);
int snd_seq_drain_output(void *handle);
int snd_seq_drain_input(void *handle);
/* misc */
void snd_seq_set_bit(int nr, void *array);
int snd_seq_change_bit(int nr, void *array);
int snd_seq_get_bit(int nr, void *array);

#ifdef __cplusplus
}
#endif

/*
 *
 */
 
#endif /* __ASOUNDLIB_H */
