/*
 *   ALSA sequencer Client Manager
 *   Copyright (c) 1998 by Frank van de Pol <F.K.W.van.de.Pol@inter.nl.net>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __SND_SEQ_CLIENTMGR_H
#define __SND_SEQ_CLIENTMGR_H

#include "seq.h"
#include "seq_fifo.h"
#include "seq_ports.h"



/* client manager */


typedef struct {
	char name[SND_SEQ_MAX_CLIENT_NAME];		/* client name */	

	int index;		/* index into client table */
	struct file *file;	/* file struct of client */
	
	fifo_t outqueue;	/* queue for outgoing (to client) data */
	
	client_port_t *ports;	/* exported ports */
	/* ... */
	/* masks */
	/* filters */
	
	
	/* locks */
	snd_spin_define(register);
	snd_spin_define(input_sleep);
} user_client_t;


typedef struct {
	char name[SND_SEQ_MAX_CLIENT_NAME];	/* client name */	
	
	/* pointer to client functions */	
	snd_seq_kernel_client_input_t *input;	/* function for outgoing (to client) data */		
	void *private_data;	/* private data for client */
	
	fifo_t outqueue;	/* queue for outgoing (to client) data */

	client_port_t *ports;	/* exported ports */
	/* ... */
	/* masks */
	/* filters */
} kernel_client_t;


typedef enum {
	NO_CLIENT 	= 0,
	USER_CLIENT 	= 1,
	KERNEL_CLIENT 	= 2
} client_type_t;

typedef struct {
	client_type_t type;
	union {
		user_client_t *user;
		kernel_client_t *kernel;
	} ptr;
} client_t;


/* usage statistics */
typedef struct {
	int cur;
	int peak;
} usage_t;


extern void init_data(void);
extern int snd_sequencer_device_init(void);
extern void snd_sequencer_device_done(void);


/* dispatch event to client(s) */
extern void snd_seq_dispatch_event(snd_seq_event_cell_t *cell);


/* exported to other modules */
extern int snd_seq_register_kernel_client(snd_seq_client_callback_t *callback, void *private_data);
extern int snd_seq_unregister_kernel_client(int client);
extern int snd_seq_kernel_client_enqueue(int client, snd_seq_event_t *ev);

#endif
