/*
 *  Misc things
 *  Copyright (c) by Jaroslav Kysela <perex@jcu.cz>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "driver.h"
#include <asm/pgtable.h>

static unsigned long get_phys_addr(struct task_struct * p, unsigned long ptr)
{
        pgd_t *page_dir;
        pmd_t *page_middle;
        pte_t pte;

        if (!p || !p->mm || ptr >= TASK_SIZE)
                return 0;
        page_dir = pgd_offset(p->mm,ptr);
        if (pgd_none(*page_dir))
                return 0;
        if (pgd_bad(*page_dir)) {
                printk("bad page directory entry %08lx\n", pgd_val(*page_dir));
                pgd_clear(page_dir);
                return 0;
        }
        page_middle = pmd_offset(page_dir,ptr);
        if (pmd_none(*page_middle))
                return 0;
        if (pmd_bad(*page_middle)) {
                printk("bad page middle entry %08lx\n", pmd_val(*page_middle));
                pmd_clear(page_middle);
                return 0;
        }
        pte = *pte_offset(page_middle,ptr);
        if (!pte_present(pte))
                return 0;
        return pte_page(pte) + (ptr & ~PAGE_MASK);
}

int snd_task_name( struct task_struct *task, char *name, int size )
{
  unsigned long addr, start, end;
  int c, idx;

  start = current -> mm -> arg_start;
  end = current -> mm -> arg_end;
  while ( start < end ) {
    addr = get_phys_addr( current, start );
    if ( !addr ) return -EINVAL;
    idx = 0;
    do {
      c = *(char *)addr++; start++;
      name[ idx++ ] = c;
      if ( !c ) return 0;
      if ( idx > size - 1 ) {
        name[ idx ] = 0;
        return 0;
      }
    } while ( start < end );
  }
  return -EINVAL;
}
