#ifndef __ES1688_H
#define __ES1688_H

/*
 *  Header file for ES488/ES1688
 *  Copyright (c) by Jaroslav Kysela <perex@jcu.cz>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "pcm1.h"
#include "mixer.h"

#define ES1688_HW_AUTO		0x0000
#define ES1688_HW_688		0x0001
#define ES1688_HW_1688		0x0002
#define ES1688_HW_1688_GUS	0x0003	/* GUS Extreme */

struct snd_stru_es1688 {
  unsigned short port;		/* port of ESS chip */
  unsigned short mpu_port;	/* MPU-401 port of ESS chip */
  unsigned short irq;		/* IRQ number of ESS chip */
  unsigned short mpu_irq;	/* MPU IRQ */
  unsigned short irqnum;	/* IRQ number (index) */
  unsigned short mpu_irqnum;	/* MPU IRQ number (index) */
  unsigned short dma8;		/* 8-bit DMA */
  unsigned short dma8num;	/* 8-bit DMA index */
  unsigned short version;	/* version of ESS chip */
  unsigned short hardware;	/* see to ES1688_HW_XXXX */

  unsigned short trigger_value;

  snd_card_t *card;
  snd_pcm_t *pcm;

  snd_spin_define( reg );
  snd_spin_define( mixer );
};

typedef struct snd_stru_es1688 es1688_t;
                        
/* I/O ports */

#define ES1688P( codec, x ) ( (codec) -> port + e_s_s_ESS1688##x )

#define e_s_s_ESS1688RESET	0x6
#define e_s_s_ESS1688READ	0xa
#define e_s_s_ESS1688WRITE	0xc
#define e_s_s_ESS1688COMMAND	0xc
#define e_s_s_ESS1688STATUS	0xc
#define e_s_s_ESS1688DATA_AVAIL	0xe
#define e_s_s_ESS1688DATA_AVAIL_16 0xf
#define e_s_s_ESS1688MIXER_ADDR	0x4
#define e_s_s_ESS1688MIXER_DATA	0x5
#define e_s_s_ESS1688OPL3_LEFT	0x0
#define e_s_s_ESS1688OPL3_RIGHT	0x2
#define e_s_s_ESS1688OPL3_BOTH	0x8
#define e_s_s_ESS1688ENABLE0	0x0
#define e_s_s_ESS1688ENABLE1	0x9
#define e_s_s_ESS1688ENABLE2	0xb
#define e_s_s_ESS1688INIT1	0x7

#define ES1688_DSP_CMD_SPKON	0xd1
#define ES1688_DSP_CMD_SPKOFF	0xd3
#define ES1688_DSP_CMD_DMAON	0xd0
#define ES1688_DSP_CMD_DMAOFF	0xd4

#define ES1688_PCM_DEV		0x14 
#define ES1688_MIC_DEV		0x1a
#define ES1688_MASTER_DEV	0x32
#define ES1688_FM_DEV		0x36
#define ES1688_CD_DEV		0x38
#define ES1688_AUX_DEV		0x3a
#define ES1688_SPEAKER_DEV	0x3c
#define ES1688_LINE_DEV		0x3e

#define ES1688_RECORD_SOURCE	0x0c
#define ES1688_MIXS_NONE	0x00
#define ES1688_MIXS_MIC		0x01
#define ES1688_MIXS_CD		0x03
#define ES1688_MIXS_LINE	0x07

/*
 *
 */

extern void snd_es1688_interrupt( snd_pcm_t *pcm );
 
extern snd_pcm_t *snd_es1688_new_device( snd_card_t *card,
                                         unsigned short port,
                                         unsigned short mpu_port,
                                         unsigned short irqnum,
                                         unsigned short mpu_irqnum,
                                         unsigned short dma8num,
                                         unsigned short hardware );                                                                                                                                                        
extern int snd_es1688_init( snd_pcm_t *pcm, int enable );
extern snd_kmixer_t *snd_es1688_new_mixer( snd_pcm_t *pcm );

#endif /* __ES1688_H */
