/*
 *   ALSA sequencer Ports 
 *   Copyright (c) 1998 by Frank van de Pol <F.K.W.van.de.Pol@inter.nl.net>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __SND_SEQ_PORTS_H
#define __SND_SEQ_PORTS_H

#include "seq.h"

/* list of 'exported' ports */

/* Client ports that are not exported are still accessible, but are
 anonymous ports. 
 
 If a port supports SUBSCRIPTION, that port can send events to all
 subscribersto a special address, with address
 (queue==SND_SEQ_ADDRESS_SUBSCRIBERS). The message is then send to all
 recipients that are registered in the subscription list. A typical
 application for these SUBSCRIPTION events is handling of incoming MIDI
 data. The port doesn't 'know' what other clients are interested in this
 message. If for instance a MIDI recording application would like to receive
 the events from that port, it will first have to subscribe.
 
*/


typedef struct subscription_t {
	struct subscription_t *next;	/* ptr to next subscription entry */
	snd_seq_addr_t	dest;		/* destination address */
} subscription_t;


typedef struct client_port_t {
	struct client_port_t *next;	/* ptr to next port definition */
	
	int  port;				/* port number */
	char name[SND_SEQ_MAX_PORT_NAME];	/* port name */
	subscription_t *subscribers;		/* list of subscribed ports */
	
	/* capability, inport, output, sync */
	unsigned int capability;		/* port capability bits */
	unsigned int port_type;			/* port type bits */
	
	/* supported channels */
	/*....*/
	
} client_port_t;


/* return pointer to port structure */
extern client_port_t *snd_seq_get_port_ptr(client_port_t **ports, int num);

/* create a port, port number is returned (-1 on failure) */
extern int snd_seq_create_port(client_port_t **ports);

/* set port info fields */
extern int snd_seq_set_port_info(client_port_t *port, snd_seq_port_info_t *info);

/* get port info fields */
extern int snd_seq_get_port_info(client_port_t *port, snd_seq_port_info_t *info);

/* add subscriber to subscription list */
extern int snd_seq_port_add_subscriber(client_port_t *port, snd_seq_addr_t *dest);

/* remove subscriber from subscription list */ 
extern int snd_seq_port_remove_subscriber(client_port_t *port, snd_seq_addr_t *dest);

#endif
