/*
 *  Test module
 *  Copyright (c) by Jaroslav Kysela <perex@jcu.cz>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#define SND_MAIN_OBJECT_FILE
#include "driver.h"
#include "minors.h"
#include "timer.h"
#include "midi.h"

struct snd_test {
  snd_sleep_define( sleeper );
};

static struct snd_test t;

static void snd_test_timer_handler( snd_timer_t *timer, void *data )
{
  snd_printk( "timer tick!!! timer '%s' is ok, jiffies = %li\n", timer -> name, jiffies );
  snd_wakeup( &t, sleeper );
}

static void snd_midi_command( snd_rawmidi_t *rmidi, void *cmd_private_data, unsigned char *command, int count )
{
  snd_printk( "rx command '%s': ", rmidi -> name );
  while ( count-- > 0 )
    printk( "%02x:", *command++ );
  printk( "\n" );
}

int init_module( void )
{
#if 1
  static int resolutions[] = { 0, 1000, 80000, 320000, -1 };
  snd_timer_t *timer;
  int idx;
  unsigned int resolution;
  
  memset( &t, 0, sizeof( t ) );
  for ( idx = 0; resolutions[ idx ] >= 0; idx++ ) {
    if ( resolutions[ idx ] == 0 ) {
      if ( (timer = snd_timer_open_system( "test" )) == NULL ) {
        snd_printk( "system timer open failed!!!\n" );
        continue;
      }      
    } else {
      if ( (timer = snd_timer_open_always( "test", resolutions[ idx ] )) == NULL ) {
        snd_printk( "timer open failed for resolution %i!!!\n", resolutions[ idx ] );
        continue;
      }
    }
    resolution = snd_timer_resolution( timer );
    snd_printk( "timer open ok: %s (resolution = %u.%u), jiffies = %li\n", timer -> name, resolution / 1000, resolution % 1000, jiffies );
    timer -> callback = snd_test_timer_handler;
    snd_timer_start( timer, idx == 0 ? 256 : 50 * 256 );
    snd_sleep( &t, sleeper, HZ * 60 );
    snd_timer_stop( timer );		/* only for sure */
    snd_timer_close_always( timer );
  }
#endif
#if 0
  snd_rawmidi_t *rmidi;
  char buf[16];
  
  if ( (snd_midi_open( 0, 0, SND_RAWMIDI_LFLG_OUTPUT | SND_RAWMIDI_LFLG_INPUT, &rmidi )) < 0 ) {
    snd_printk( "midi open failed!!!\n" );
    return -EINVAL;
  }
  buf[0] = 0x90;
  buf[1] = 0x40;
  buf[2] = 0x7f;
  snd_midi_transmit( rmidi, buf, 3 );
  snd_midi_flush_output( rmidi );
  rmidi -> input.u.p.command = snd_midi_command;
  snd_midi_start_input( rmidi );
  snd_sleep( &t, sleeper, HZ * 2 );
  snd_midi_close( 0, 0, SND_RAWMIDI_LFLG_OUTPUT | SND_RAWMIDI_LFLG_INPUT );
#endif
  return -EBUSY;
}

void cleanup_module( void )
{
}
