/*
 *  ALSA sequencer main module
 *  Copyright (c) 1998 by Frank van de Pol <F.K.W.van.de.Pol@inter.nl.net>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#define SND_MAIN_OBJECT_FILE
#include "driver.h"

#include "seq.h"
#include "seq_clientmgr.h"
#include "seq_memory.h"
#include "seq_queue.h"
#include "seq_timer.h"
#include "seq_system.h"
#include "seq_info.h"


/*
 *  INIT PART
 */


#ifndef LINUX_2_1
extern struct symbol_table snd_symbol_table_seq_export;
#endif

int init_module(void)
{
#ifndef LINUX_2_1
	if (register_symtab(&snd_symbol_table_seq_export) < 0)
		return -ENOMEM;
#endif
	/*snd_control_register_ioctl( snd_seq_control_ioctl ); */


	init_data();

	/* init memory, room for 1000 events */
	snd_sequencer_memory_init(1000);

	/* init event queues */
	snd_seq_queue_init();

	/* register sequencer device */
	snd_sequencer_device_init();

	/* register proc interface */
	snd_seq_info_init();

	/* register our internal client */
	snd_seq_system_client_init();

	/* announce ourself */
	snd_printk("ALSA Sequencer prototype. Compiled %s %s\n", __DATE__, __TIME__);
	snd_printk("Copyright (c) 1998 by Frank van de Pol <F.K.W.van.de.Pol@inter.nl.net>\n");

	return 0;
}


void cleanup_module(void)
{

	/* unregister our internal client */
	snd_seq_system_client_done();

	/* unregister proc interface */
	snd_seq_info_done();

	/* unregister sequencer device */
	snd_sequencer_device_done();

	/* release event memory */
	snd_sequencer_memory_done();
}

#ifdef MODULE_PARM		/* hey - we have new 2.1.18+ kernel... */
MODULE_AUTHOR("Frank van de Pol <F.K.W.van.de.Pol@inter.nl.net>");
MODULE_DESCRIPTION("Advanced Linux Sound Architecture sequencer.");
MODULE_SUPPORTED_DEVICE("sound");

#ifdef 0
	/* FIXME: should add parameters for number of clients, queues, memory etc. */
MODULE_PARM(snd_major, "i");
MODULE_PARM_DESC(snd_major, "Major # for sound driver. (14 by default)");
MODULE_PARM(snd_cards_limit, "1-" __MODULE_STRING(SND_CARDS) "i");
MODULE_PARM_DESC(snd_cards_limit, "Count of soundcards installed in the system.");
MODULE_PARM(snd_soundman_path, "64s");
MODULE_PARM_DESC(snd_soundman_path, "Path for sound manager program.");
#endif

#endif

