/*
 *  ALSA sequencer Timer
 *  Copyright (c) 1998 by Frank van de Pol <F.K.W.van.de.Pol@inter.nl.net>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __SND_SEQ_TIMER_H
#define __SND_SEQ_TIMER_H

#include "seq.h"

typedef struct {
	/* ... tempo / offset / running state */

	//	
	//
	//	   Different sync types (for slave operation):
	//	   
	//		midi <- seq. clock
	//		  "  <- midi clock  (adjust tempo)
	//		
	//		seq. clock <- hw timer
	//		     "     <- MTC
	//		     "     <- SMPTE
	//
	
	int			running;	/* running state of queue */	
	
	unsigned int		tempo;		/* current tempo, us/tick */
	int			ppq;		/* time resolution, ticks/quarter */
	
	snd_seq_tick_time_t	tempo_tick;	/* tick of last tempo change */
	snd_seq_real_time_t	tempo_time;	/* time of last tempo change */
	
	snd_seq_tick_time_t	cur_tick;	/* current tick */
	snd_seq_real_time_t	cur_time;	/* current time */
	
	snd_seq_tick_time_t	sync_tmp;	/* tmp var for sync */
	
} timer_t;


/* compare timestamp between events */
/* return 1 if a >= b; otherwise return 0 */
static inline int snd_seq_compare_tick_time(snd_seq_tick_time_t *a, snd_seq_tick_time_t *b)
{
	/* compare ticks */
	return (*a >= *b);
}

static inline int snd_seq_compare_real_time(snd_seq_real_time_t *a, snd_seq_real_time_t *b)
{
	/* compare real time */
	if (a->sec > b->sec)
		return 1;
	if ((a->sec == b->sec) && (a->nsec >= b->nsec))
		return 1;
	return 0;
}


/* increment timestamp */
static inline void snd_seq_inc_real_time(snd_seq_real_time_t *tm, snd_seq_real_time_t *inc)
{
	tm->sec  += inc->sec;
	tm->nsec += inc->nsec;
	if (tm->nsec >= 1E9) {
		/* roll-over */
		tm->nsec-=1E9;
                tm->sec++;
        }
}


extern int snd_seq_timer_interrupt(snd_seq_real_time_t *period);
extern void snd_seq_timer_init(timer_t *tmr);

extern void snd_seq_timer_stop(timer_t *tmr);
extern void snd_seq_timer_start(timer_t *tmr);
extern void snd_seq_timer_continue(timer_t *tmr);
extern void snd_seq_timer_set_tempo(timer_t *tmr, int tempo);
extern void snd_seq_timer_set_ppq(timer_t *tmr, int ppq);
                        
#endif
