/*
 *   ALSA sequencer System services Client
 *   Copyright (c) 1998 by Frank van de Pol <F.K.W.van.de.Pol@inter.nl.net>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "driver.h"
#include "seq_system.h"
#include "seq_timer.h"
#include "seq_queue.h"

/* internal client that provide system services, access to timer etc. */


/* client id of our system client */
static int sysclient;

static int timer_port;




/* call-back function for event input */
static int event_input(snd_seq_event_t * ev, void *private_data)
{
	//snd_printk("Call...\n");
	//snd_printk(".......Event %d\n",ev->type);

	/* for testing, bounce the event to the next client */
	//ev->dest.client += 1;

	/*... after 2 seconds */
	//ev->flags = SND_SEQ_TIME_STAMP_REAL | SND_SEQ_TIME_MODE_REL;
	//ev->time.real.sec  = 2;
	//ev->time.real.nsec = 0; 

	//snd_seq_kernel_client_enqueue(sysclient, ev);

	//snd_printk(".......Back!\n");

	if (ev) {
		if (ev->dest.port == timer_port) {
			/* handle Timer events */
			switch (ev->type) {
					/* timer stuff */
				case SND_SEQ_EVENT_START:
					snd_printk("start playing!\n");
					snd_seq_queue_timer_start(ev->dest.queue);
					break;

				case SND_SEQ_EVENT_CONTINUE:
					snd_printk("continue playing!\n");
					snd_seq_queue_timer_continue(ev->dest.queue);
					break;

				case SND_SEQ_EVENT_STOP:
					snd_printk("stop playing!\n");
					snd_seq_queue_timer_stop(ev->dest.queue);
					break;

				case SND_SEQ_EVENT_TEMPO:
					snd_printk("tempo change!\n");
					snd_seq_queue_timer_set_tempo(ev->dest.queue, ev->data.control.value);
					break;
			}
		}
	}
	return 1;		/* success */
}
/* register our internal client */
void snd_seq_system_client_init(void)
{

	snd_seq_client_callback_t callbacks;
	snd_seq_port_info_t port;

	/* register client */
	callbacks.input = event_input;
	sysclient = snd_seq_register_kernel_client(&callbacks, NULL);

	/* set our name */
	snd_seq_kernel_client_ctl(sysclient, SND_SEQ_IOCTL_SET_CLIENT_NAME, "System");

	/* register timer */
	strcpy(port.name, "Timer");
	snd_seq_kernel_client_ctl(sysclient, SND_SEQ_IOCTL_CREATE_PORT, &port);
	timer_port = port.port;

	snd_printk("Registered %s as port %d\n", port.name, timer_port);
}


/* unregister our internal client */
void snd_seq_system_client_done(void)
{
	snd_seq_unregister_kernel_client(sysclient);
}
