/*
 *  PCI support
 *  Copyright (c) 1994-98 by Jaroslav Kysela <perex@jcu.cz>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __SNDPCI_H__
#define __SNDPCI_H__

#ifdef CONFIG_PCI	/* can't be used without PCI support in kernel */

struct snd_pci_dev {
  /* private variables */
#ifdef LINUX_2_1
  struct pci_dev *pci_dev;
#else
  unsigned int bus;		/* bus number */
#endif
  /* public variables */
  unsigned int devfn;		/* encoded device & function index */
  unsigned short vendor;
  unsigned short device;
  unsigned int class;		/* 3 bytes: (base, sub, prog-if) */
  unsigned int master: 1;	/* set if device is master capable */
  unsigned int irq;		/* irq generated by this device */
  unsigned long base_address[6];  
};

extern int snd_pci_find_device( unsigned int vendor, unsigned int device, unsigned int index, struct snd_pci_dev *dev );

#ifdef LINUX_2_1

#define snd_pci_read_config_byte( dev, where, val ) pci_read_config_byte( ((dev)->pci_dev), where, val )
#define snd_pci_read_config_word( dev, where, val ) pci_read_config_word( ((dev)->pci_dev), where, val )
#define snd_pci_read_config_dword( dev, where, val ) pci_read_config_dword( ((dev)->pci_dev), where, val )
#define snd_pci_write_config_byte( dev, where, val ) pci_write_config_byte( ((dev)->pci_dev), where, val )
#define snd_pci_write_config_word( dev, where, val ) pci_write_config_word( ((dev)->pci_dev), where, val )
#define snd_pci_write_config_dword( dev, where, val ) pci_write_config_dword( ((dev)->pci_dev), where, val )

#else

#define snd_pci_read_config_byte( dev, where, val ) pcibios_read_config_byte( dev->bus, dev->devfn, where, val )
#define snd_pci_read_config_word( dev, where, val ) pcibios_read_config_word( dev->bus, dev->devfn, where, val )
#define snd_pci_read_config_dword( dev, where, val ) pcibios_read_config_dword( dev->bus, dev->devfn, where, val )
#define snd_pci_write_config_byte( dev, where, val ) pcibios_write_config_byte( dev->bus, dev->devfn, where, val )
#define snd_pci_write_config_word( dev, where, val ) pcibios_write_config_word( dev->bus, dev->devfn, where, val )
#define snd_pci_write_config_dword( dev, where, val ) pcibios_write_config_dword( dev->bus, dev->devfn, where, val )

#endif

#endif /* CONFIG_PCI */

#endif /* __SND_PCI_H__ */
