/*
 *  Digital Audio (PCM) abstract layer
 *  Copyright (c) by Jaroslav Kysela <perex@jcu.cz>
 */

#define SND_PCM_DEVICES		4

#define SND_PCM_TYPE_1		1

typedef struct snd_stru_pcm_channel snd_pcm_channel_t;

struct snd_stru_pcm_channel {
  /* -- /proc interface -- */
  void *proc_entry;
  void *proc_private;
  snd_mutex_define( proc );
};

struct snd_stru_pcm {
  snd_card_t *card;
  unsigned int device;		/* device number */
  unsigned int info_flags;
  int type;			/* PCM type */
  char id[32];
  char name[80];
  struct snd_stru_pcm_channel playback;
  struct snd_stru_pcm_channel record;
  snd_minor_t *reg;
  void *private_data;
  void (*private_free)( void *private_data );
};

struct snd_stru_pcm_notify {
  int (*n_register)( unsigned short minor, snd_pcm_t *pcm );
  int (*n_unregister)( unsigned short minor, snd_pcm_t *pcm );
  struct snd_stru_pcm_notify *next;
};

/*
 *  Registering
 */

extern snd_pcm_t *snd_pcm_devices[];

extern void snd_pcm_lock( void );
extern void snd_pcm_unlock( void );

extern snd_pcm_t *snd_pcm_new_device( snd_card_t *card, char *id, snd_minor_t *reg );
extern int snd_pcm_free( snd_pcm_t *pcm );
extern int snd_pcm_register( snd_pcm_t *pcm, int pcm_device );
extern int snd_pcm_unregister( snd_pcm_t *pcm );

extern int snd_pcm_notify( struct snd_stru_pcm_notify *notify, int nfree );

/*
 *  /proc interface
 */
 
extern void snd_pcm_proc_init( snd_pcm_t *pcm );
extern void snd_pcm_proc_done( snd_pcm_t *pcm );
extern void snd_pcm_proc_write( snd_pcm_channel_t *pchn, const void *buffer, unsigned int count );
