/*
 *   ALSA sequencer Timer
 *   Copyright (c) by Frank van de Pol <F.K.W.van.de.Pol@inter.nl.net>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "driver.h"
#include "seq_timer.h"
#include "seq_queue.h"

snd_seq_real_time_t loc_time;
int seq_timer_running;


/* called by timer interrupt routine. the period time since previous invocation is passed */
int snd_seq_timer_interrupt(snd_seq_real_time_t * period)
{
	if (seq_timer_running) {
		/* update timer */
		snd_seq_inc_real_time(&loc_time, period);

		/* check queues and dispatch events */
		snd_seq_check_queues();
	}
	return 0;
}

/* kludge to reset timer */
void seq_reset_timer(void)
{
	snd_printk("Timer RESET\n");

	loc_time.sec = 0;
	loc_time.nsec = 0;
}

void seq_timer_stop(void)
{
	seq_timer_running = 0;
}

void seq_timer_start(void)
{
	seq_reset_timer();
	seq_timer_running = 1;
}

void seq_timer_continue(void)
{
	seq_timer_running = 1;
}
