/*
 *   ALSA sequencer Queue handling
 *   Copyright (c) by Frank van de Pol <F.K.W.van.de.Pol@inter.nl.net>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __SND_SEQ_QUEUE_H
#define __SND_SEQ_QUEUE_H

#include "seq_memory.h"
#include "seq_prioq.h"

#define SND_SEQ_MAX_QUEUES 4


typedef struct {
	prioq_t	tickq;	/* midi tick event queue */
	prioq_t	timeq;	/* real-time event queue */	
	
	/* ... tempo / offset / running state */
	
	int	ppq;
	snd_seq_tick_time_t	cur_tick;
	snd_seq_real_time_t	cur_time;
} queue_t;



/* enqueue a event received from one the clients */
extern void snd_seq_enqueue_event(snd_seq_event_cell_t *cell);

/* init queue structure */
void snd_seq_queue_init(void);

/* check queues and dispatch events */
void snd_seq_check_queues(void);



#endif