/*
 *   ALSA sequencer Ports 
 *   Copyright (c) by Frank van de Pol <F.K.W.van.de.Pol@inter.nl.net>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __SND_SEQ_PORTS_H
#define __SND_SEQ_PORTS_H

#include "seq.h"

/* list of 'exported' ports */

/* client ports that are not exported are still accessible, but are anonymous ports */




typedef struct client_port_t {
	struct client_port_t *next;	/* ptr to next port definition */
	
	int  port;				/* port number */
	char name[SND_SEQ_MAX_PORT_NAME];	/* port name */
	
	/* capability, inport, output, sync */
	unsigned int capability;		/* port capability bits */
	unsigned int port_type;			/* port type bits */
	
	/* supported channels */
	
} client_port_t;


/* return pointer to port structure */
extern client_port_t *snd_seq_get_port_ptr(client_port_t **ports, int num);

/* create a port, port number is returned (-1 on failure) */
extern int snd_seq_create_port(client_port_t **ports);

/* set port info fields */
extern int snd_seq_set_port_info(client_port_t *port, snd_seq_port_info_t *info);

/* get port info fields */
extern int snd_seq_get_port_info(client_port_t *port, snd_seq_port_info_t *info);
 


#endif